/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "repinfo.h"
#include "replace.h"


/******************************************************************************
*                                                                             *
* ja:置換情報ダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/* ja:ボタンが押された */
static void
repinfo_dialog_clicked (GtkWidget *widget,
                        GtkWidget *dialog)
{
  *(gint *)g_object_get_data (G_OBJECT (dialog), "user_data")
                    = (gint)g_object_get_data (G_OBJECT (widget), "user_data");
  gtk_widget_destroy(dialog);
}


/* ja:ESCが押された */
static gboolean
repinfo_dialog_key_press (GtkWidget   *widget,
                          GdkEventKey *event,
                          gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:置換情報ダイアログ表示
     ri,置換情報
    RET,REPLACE_OK,REPLACE_NEXT,REPLACE_ALL,REPLACE_CANCEL                  */
gint
repinfo_dialog (ReplaceInfo *ri)
{
  gchar *text;
  gint result = REPLACE_CANCEL;
  GtkWidget *dialog, *button0, *button1, *button2, *button3;
  GtkWidget *frame0, *frame1, *hbox, *tbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Replace Information"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (repinfo_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  g_object_set_data (G_OBJECT (dialog), "user_data", &result);
  /* ja:ボタン */
  button0 = gtk_button_new_with_mnemonic (_("_Replace"));
  button1 = gtk_button_new_with_mnemonic (_("_Next"));
  button2 = gtk_button_new_with_mnemonic (_("_All"));
  button3=gtk_button_new_with_label(_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                                G_CALLBACK (repinfo_dialog_clicked), dialog);
  g_signal_connect (G_OBJECT (button1), "clicked",
                                G_CALLBACK (repinfo_dialog_clicked), dialog);
  g_signal_connect (G_OBJECT (button2), "clicked",
                                G_CALLBACK (repinfo_dialog_clicked), dialog);
  g_signal_connect_swapped (G_OBJECT (button3), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  g_object_set_data (G_OBJECT (button0), "user_data", (gpointer)REPLACE_OK);
  g_object_set_data (G_OBJECT (button1), "user_data", (gpointer)REPLACE_NEXT);
  g_object_set_data (G_OBJECT (button2), "user_data", (gpointer)REPLACE_ALL);
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);
  /* ja:フレームとボックス */
  tbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (tbox), SPACING);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Find String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (ri->src ? ri->src : ""), TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Replace String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (ri->dst ? ri->dst : ""), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start(GTK_BOX(hbox),
                         gtk_label_new (_("Replace Range")), FALSE, FALSE, 0);
  text = g_strdup_printf (_("(%d,%d)-(%d,%d)"),
            ri->start.x + 1, ri->start.y + 1, ri->end.x + 1, ri->end.y + 1);
  gtk_box_pack_start (GTK_BOX (hbox), gtk_label_new (text), TRUE, TRUE, 0);
  g_free (text);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);

  frame0 = gtk_frame_new (_("Option"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), gtk_label_new (ri->ignorecase
                    ? _("Enable Case") : _("Ignore Case")), FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame0), vbox);

  frame1 = gtk_frame_new (_("Direction"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox),
            gtk_label_new (ri->arrow ? _("Up") : _("Down")), FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), vbox);

  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox), frame0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), frame1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button3, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button2, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), tbox);

  /* ja:表示 */
  gtk_widget_grab_focus (button1);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();

  return result;
}
