/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __JUMP_H__
#define __JUMP_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct JumpDialog_Tag
{
  gint cursor,max;
} JumpDialog;


/******************************************************************************
*                                                                             *
* ja:ジャンプ関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:指定行へ移動
    tmaid,ウインドウ情報
     line,新しい行(1...)                                                    */
void
jump_operation (TmaidWindow *tmaid,
                const gint   line);


/******************************************************************************
*                                                                             *
* ja:ジャンプダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ジャンプダイアログ表示
    jmp,ジャンプ情報
    RET,TRUE:OK,FALSE:Cancel                                                */
gboolean jump_dialog(JumpDialog *jmp);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
