/*
    orzcharlist
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __ORZ_CHARLIST_H__
#define __ORZ_CHARLIST_H__


#include "common.h"
#include "orzcharset.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ORZ_TYPE_CHARLIST            (orz_charlist_get_type ())
#define ORZ_CHARLIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_CHARLIST, OrzCharlist))
#define ORZ_CHARLIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_CHARLIST, OrzCharlistClass))
#define ORZ_IS_CHARLIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_CHARLIST))
#define ORZ_IS_CHARLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_CHARLIST))
#define ORZ_CHARLIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_CHARLIST, OrzCharlistClass))


typedef struct _OrzCharlist      OrzCharlist;
typedef struct _OrzCharlistClass OrzCharlistClass;

struct _OrzCharlist
{
  /*< private >*/
  GtkDialog parent_instance;

  /*< public >*/
  GtkWidget *ok_button;     /* ja:了解 */
  GtkWidget *cancel_button; /* ja:取消 */

  /*< private >*/
  GtkWidget *new_button;    /* ja:新規 */
  GtkWidget *remove_button; /* ja:削除 */
  GtkWidget *up_button;     /* ja:上へ */
  GtkWidget *down_button;   /* ja:下へ */
  GtkWidget *charset;       /* ja:文字符号化方式 */
  GtkWidget *tview;         /* ja:リスト */
  GtkListStore *store;      /* ja:リスト */
  GtkTreeSelection *select; /* ja:リスト */
};

struct _OrzCharlistClass
{
  GtkDialogClass parent_class;

  /* -- signals -- */
  void (*escape) (OrzCharlist *charlist);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_charlist_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:文字符号化方式リスト関数群                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
orz_charlist_new (void);


/*  ja:文字符号化方式のリストを取得する
    charlist,ウィジェット
         RET,文字符号化方式のリスト                                         */
gchar *
orz_charlist_get_charlist (OrzCharlist *charlist);


/*  ja:文字符号化方式のリストを設定する
    charlist,ウィジェット
         RET,TRUE:正しい文字符号化方式,FALSE:不正な文字符号化方式           */
gboolean
orz_charlist_set_charlist (OrzCharlist *charlist,
                           const gchar *list);


/*  ja:文字符号化方式を取得する
    charlist,ウィジェット
         RET,文字符号化方式                                                 */
#define orz_charlist_get_charset(charlist)                                  \
    ((charlist)?orz_charset_get_charset(ORZ_CHARLIST(charlist)->charset):NULL)


/*  ja:文字符号化方式を設定する
    charlist,ウィジェット
         RET,TRUE:正しい文字符号化方式,FALSE:不正な文字符号化方式           */
gboolean
orz_charlist_set_charset (OrzCharlist *charlist,
                          const gchar *charset);


/*  ja:文字符号化方式の候補を取得する
    charlist,ウィジェット
         RET,文字符号化方式の候補                                           */
#define orz_charlist_get_candidate(charlist)                                \
((charlist)?orz_charset_get_candidate                                       \
                        (ORZ_CHARSET(ORZ_CHARLIST(charlist)->charset)):NULL)


/*  ja:文字符号化方式の候補を追加する
     charlist,ウィジェット
    candidate,文字符号化方式の候補
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
orz_charlist_add_candidate (OrzCharlist *charlist,
                            const gchar *candidate);


/*  ja:文字符号化方式の候補を削除する
     charlist,ウィジェット
    candidate,文字符号化方式の候補,NULL:すべて削除
          RET,TRUE:正常終了,FALSE:エラー                                    */
#define orz_charlist_remove_candidate(charlist,candidate)                   \
((charlist)?orz_charset_remove_candidate                                    \
                (ORZ_CHARSET(ORZ_CHARLIST(charlist)->charset),candidate):FALSE)


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ORZ_CHARLIST_H__ */
