/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "edit.h"
#include "general.h"
#include "jump.h"
#include "sigfile.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:ジャンプ関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:指定行へ移動
    tmaid,TXTウインドウ情報
     line,新しい行(1...)                                                    */
void
jump_operation (TmaidWindow *tmaid,
                const gint   line)
{
  gint sx, sy;
  GdkPoint cursor, select, top;

  cursor = tmaid->cursor;
  select = tmaid->select;
  top = tmaid->top;
  sx = MAX( tmaid->drawing->allocation.width / tmaid->font_width, 1);
  sy = MAX (tmaid->drawing->allocation.height / tmaid->font_height, 1);
  tmaid->cursor.y = line < 0 ? tmaid->max + line : line - 1;
  if (tmaid->cursor.y < 0)
    tmaid->cursor.y = 0;
  else if (tmaid->cursor.y > tmaid->max - 1)
    tmaid->cursor.y = tmaid->max - 1;
  if (tmaid->cursor.x < tmaid->top.x)
    tmaid->top.x = tmaid->cursor.x;
  else if (tmaid->cursor.x - sx + 1 > tmaid->top.x)
    tmaid->top.x = tmaid->cursor.x - sx + 1;
  if (tmaid->cursor.y < tmaid->top.y)
    tmaid->top.y = tmaid->cursor.y;
  else if (tmaid->cursor.y - sy + 1 > tmaid->top.y)
    tmaid->top.y = tmaid->cursor.y - sy + 1;
  move_edit_window (tmaid, &top);
  misc_set_scroll_bar (tmaid->hscroll,
                        G_CALLBACK (signal_value_changed_hscroll), tmaid,
                        0, edit_get_width_max (tmaid) + 1, sx, tmaid->top.x);
  misc_set_scroll_bar (tmaid->vscroll,
                        G_CALLBACK (signal_value_changed_vscroll), tmaid,
                        0, tmaid->max, sy, tmaid->top.y);
  if (tmaid->select.x >= 0)
    {
      if (tmaid->select.y == tmaid->cursor.y
                            && tmaid->select.x == edit_get_align_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE))
        {
          tmaid->select.x = -1;
          clear_sel (tmaid, &select, &cursor);
          set_menu_bar (tmaid);
        }
      else
        {
          clear_sel (tmaid, &tmaid->cursor, &cursor);
        }
    }
  draw_caret (tmaid, &cursor);
}


/******************************************************************************
*                                                                             *
* ja:ジャンプダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/* ja:エントリーでリターンが押された */
static void
jump_dialog_activate (GtkWidget *widget,
                      GtkWidget *dialog)
{
  gint value;
  JumpConfig *jmpcfg;

  jmpcfg = g_object_get_data (G_OBJECT (dialog), "user_data");
  if (misc_str_to_val (&value,
                            gtk_entry_get_text (GTK_ENTRY (widget)), 10, FALSE)
            && jmpcfg->cursor != value && 1 <= value && value <= jmpcfg->max)
    gtk_dialog_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
}


/* ja:エントリーが変更された */
static void
jump_dialog_changed (GtkWidget *widget,
                     GtkWidget *dialog)
{
  gint value;
  JumpConfig *jmpcfg;

  jmpcfg = g_object_get_data (G_OBJECT (dialog), "user_data");
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK,
                            misc_str_to_val (&value,
                            gtk_entry_get_text (GTK_ENTRY (widget)), 10, FALSE)
            && jmpcfg->cursor != value && 1 <= value && value <= jmpcfg->max);
}


/* ja:ESCが押された */
static gboolean
jump_dialog_key_press (GtkWidget   *widget,
                       GdkEventKey *event,
                       gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_dialog_response (GTK_DIALOG (widget), GTK_RESPONSE_NONE);
  return FALSE;
}


/*  ja:ジャンプダイアログ表示
    jmp,ジャンプ情報
    RET,TRUE:OK,FALSE:Cancel                                                */
gboolean
jump_dialog (JumpConfig *jmpcfg)
{
  gboolean result;
  gchar *text;
  GtkWidget *dialog, *entry, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("Jump"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            NULL);
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (jump_dialog_key_press), NULL);
  g_object_set_data (G_OBJECT (dialog), "user_data", jmpcfg);
  /* ja:エントリー */
  entry = gtk_entry_new ();
  text = misc_str_from_val (jmpcfg->cursor, 10, 0, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry), text);
  g_free (text);
  g_signal_connect (G_OBJECT (entry), "activate",
                                    G_CALLBACK (jump_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (entry), "changed",
                                    G_CALLBACK (jump_dialog_changed), dialog);
  gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), entry, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog),
                                                    GTK_RESPONSE_OK, FALSE);
  gtk_widget_grab_focus (entry);
  gtk_widget_show_all (vbox);

  result = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK;
  if (result)
    misc_str_to_val (&jmpcfg->cursor,
                            gtk_entry_get_text (GTK_ENTRY (entry)), 10, FALSE);
  gtk_widget_destroy (dialog);

  return result;
}
