/*
    winmain
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <windows.h>
#include "common.h"


int
main (int, char **);


int WINAPI
WinMain (HINSTANCE hInstance,
         HINSTANCE hPrevInstance,
         LPSTR     lpszCmdLine,
         int       nCmdShow)
{
#if GLIB_CHECK_VERSION(2,6,0)
  char **argv;
  int i, argc, ret = -1;

  if (G_WIN32_HAVE_WIDECHAR_API())
    {
      int nArgc;
      LPWSTR *lpszArgv;

      lpszArgv = CommandLineToArgvW (GetCommandLineW (), &nArgc);
      argc = nArgc;
      argv = g_malloc ((argc + 1) * sizeof (char *));
      for (i = 0; i < argc; i++)
        argv[i] = g_utf16_to_utf8  (lpszArgv[i], -1, NULL, NULL, NULL);
      argv[i] = NULL;
      GlobalFree (lpszArgv);
    }
  else
    {
      argc = __argc;
      argv = g_malloc ((argc + 1) * sizeof (char *));
      for (i = 0; i < argc; i++)
        argv[i] = g_locale_to_utf8 (__argv[i], -1, NULL, NULL, NULL);
      argv[i] = NULL;
    }
  ret = main (argc, argv);
  for (i = 0; i < argc; i++)
    g_free (argv[i]);
  g_free (argv);
  return ret;
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  return main (__argc, __argv);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
}
