/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <gdk/gdkkeysyms.h>
#include "repinfo.h"
#include "replace.h"


/******************************************************************************
*                                                                             *
* ja:置換情報ダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/* ja:ESCが押された */
static gboolean
repinfo_dialog_key_press (GtkWidget   *widget,
                          GdkEventKey *event,
                          gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_dialog_response (GTK_DIALOG (widget), GTK_RESPONSE_NONE);
  return FALSE;
}


/*  ja:置換情報ダイアログ表示
     ri,置換情報
    RET,REPLACE_OK,REPLACE_NEXT,REPLACE_ALL,REPLACE_CANCEL                  */
gint
repinfo_dialog (ReplaceInfo *ri)
{
  gchar *text;
  gint result;
  GtkWidget *dialog, *frame0, *frame1, *hbox, *tbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("Replace Information"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_FIND_AND_REPLACE, REPLACE_OK,
                            _("_Next"), REPLACE_NEXT,
                            _("_All Replace"), REPLACE_ALL,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            NULL);
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (repinfo_dialog_key_press), NULL);
  /* ja:フレームとボックス */
  tbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (tbox), SPACING);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Find String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (ri->src ? ri->src : ""), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Replace String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (ri->dst ? ri->dst : ""), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox),
                         gtk_label_new (_("Replace Range")), FALSE, FALSE, 0);
  text = g_strdup_printf (_("(%d,%d)-(%d,%d)"),
            ri->start.x + 1, ri->start.y + 1, ri->end.x + 1, ri->end.y + 1);
  gtk_box_pack_start (GTK_BOX (hbox), gtk_label_new (text), TRUE, TRUE, 0);
  g_free (text);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);

  frame0 = gtk_frame_new (_("Option"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), gtk_label_new (ri->ignorecase
                    ? _("Enable Case") : _("Ignore Case")), FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame0), vbox);

  frame1 = gtk_frame_new (_("Direction"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox),
            gtk_label_new (ri->arrow ? _("Down") : _("Up")), FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), vbox);

  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox), frame0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), frame1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), tbox);

  /* ja:表示 */
  gtk_widget_show_all (tbox);

  result = gtk_dialog_run (GTK_DIALOG (dialog));
  if (result != REPLACE_OK && result != REPLACE_NEXT && result != REPLACE_ALL)
    result = REPLACE_CANCEL;
  gtk_widget_destroy (dialog);

  return result;
}
