/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <gdk/gdkkeysyms.h>
#include "find.h"
#include "replace.h"


gboolean replace_arrow = TRUE;              /* ja:置換の設定 */
gboolean replace_ignorecase = FALSE;        /* ja:置換の設定 */
gchar *replace_text[32];                    /* ja:置換する文字列 */
gint replace_num = 0;                       /* ja:登録されている置換文字列 */


/******************************************************************************
*                                                                             *
* ja:置換ダイアログ関数群                                                     *
*                                                                             *
******************************************************************************/
/* ja:エントリーでリターンが押された */
static void
replace_dialog_activate (GtkWidget *widget,
                         GtkWidget *dialog)
{
  GtkWidget *combo;

  combo = g_object_get_data (G_OBJECT (dialog), "user_data");
#if GTK_CHECK_VERSION(2,4,0)
  if (g_strlen (gtk_entry_get_text (GTK_ENTRY (GTK_BIN (combo)->child))) > 0)
#else /* not GTK_CHECK_VERSION(2,4,0) */
  if (g_strlen (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry))) > 0)
#endif /* not GTK_CHECK_VERSION(2,4,0) */
    gtk_dialog_response (GTK_DIALOG (dialog), REPLACE_OK);
}


/* ja:エントリーが変更された */
static void
replace_dialog_changed (GtkWidget *widget,
                        GtkWidget *dialog)
{
  gboolean sensitive;

  sensitive = g_strlen (gtk_entry_get_text (GTK_ENTRY (widget))) > 0;
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), REPLACE_OK,
                                                                    sensitive);
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), REPLACE_ALL,
                                                                    sensitive);
}


/* ja:ESCが押された */
static gboolean
replace_dialog_key_press (GtkWidget   *widget,
                          GdkEventKey *event,
                          gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_dialog_response (GTK_DIALOG (widget), GTK_RESPONSE_NONE);
  return FALSE;
}


/*  ja:置換ダイアログ表示
     rp,置換情報
    RET,REPLACE_OK,REPLACE_NEXT,REPLACE_ALL,REPLACE_CANCEL                  */
gint
replace_dialog (ReplaceString *rp)
{
  gboolean sensitive;
  gint i, result;
#if ! GTK_CHECK_VERSION(2,4,0)
  GList *glist = NULL;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  GtkWidget *dialog, *check, *combo0, *combo1, *radio0, *radio1;
  GtkWidget *frame0, *frame1, *hbox, *tbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("Replace"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_FIND_AND_REPLACE, REPLACE_OK,
                            _("_All Replace"), REPLACE_ALL,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            NULL);
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (replace_dialog_key_press), NULL);
  /* ja:チェックボタン */
  check = gtk_check_button_new_with_mnemonic (_("Enable _Case"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), rp->ignorecase);
  /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
  combo0 = gtk_combo_box_entry_new_text ();
  combo1 = gtk_combo_box_entry_new_text ();
  for (i = 0; i < find_num; i++)
    gtk_combo_box_append_text (GTK_COMBO_BOX (combo0), find_text[i]);
  for (i = 0; i < replace_num; i++)
    gtk_combo_box_append_text (GTK_COMBO_BOX (combo1), replace_text[i]);
  if (find_num > 0)
    {
      gtk_combo_box_set_active (GTK_COMBO_BOX (combo0), 0);
      gtk_editable_select_region
                            (GTK_EDITABLE (GTK_BIN (combo0)->child), 0, -1);
    }
  if (replace_num > 0)
    {
      gtk_combo_box_set_active (GTK_COMBO_BOX (combo1), 0);
      gtk_editable_select_region (GTK_EDITABLE (GTK_BIN (combo1)->child),
                                                                        0, -1);
    }
  g_signal_connect (G_OBJECT (GTK_BIN (combo0)->child), "activate",
                                G_CALLBACK (replace_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (GTK_BIN (combo1)->child), "activate",
                                G_CALLBACK (replace_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (GTK_BIN (combo0)->child), "changed",
                                G_CALLBACK (replace_dialog_changed), dialog);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  for (i = 0; i < find_num; i++)
    glist = g_list_append (glist, find_text[i]);
  combo0 = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (combo0), FALSE, TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo0), TRUE);
  if (find_num > 0)
    {
      gtk_combo_set_popdown_strings (GTK_COMBO (combo0), glist);
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo0)->entry), find_text[0]);
      gtk_editable_select_region
                            (GTK_EDITABLE (GTK_COMBO (combo0)->entry), 0,-1);
      g_list_free (glist);
    }
  g_signal_connect (G_OBJECT (GTK_COMBO (combo0)->entry), "activate",
                                G_CALLBACK (replace_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo0)->entry), "changed",
                                G_CALLBACK (replace_dialog_changed), dialog);
  glist = NULL;
  for (i = 0; i < replace_num; i++)
    glist = g_list_append (glist, replace_text[i]);
  combo1 = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (combo1), FALSE, TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo1), TRUE);
  if (replace_num > 0)
    {
      gtk_combo_set_popdown_strings (GTK_COMBO (combo1), glist);
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo1)->entry),
                                                            replace_text[0]);
      g_list_free (glist);
    }
  g_signal_connect (G_OBJECT (GTK_COMBO (combo1)->entry), "activate",
                                G_CALLBACK (replace_dialog_activate), dialog);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  /* ja:ラジオボタン */
  radio0 = gtk_radio_button_new_with_mnemonic (NULL, _("_Up"));
  radio1 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio0), _("_Down"));
  gtk_toggle_button_set_active
                    (GTK_TOGGLE_BUTTON (rp->arrow ? radio1 : radio0), TRUE);
  /* ja:フレームとボックス */
  tbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (tbox), SPACING);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Find String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), combo0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Replace String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), combo1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);

  frame0 = gtk_frame_new (_("Option"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), check, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame0), vbox);

  frame1 = gtk_frame_new (_("Direction"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), radio0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), radio1, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), vbox);

  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox), frame0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), frame1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), tbox);

  /* ja:表示 */
#if GTK_CHECK_VERSION(2,4,0)
  sensitive = g_strlen (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_BIN (combo0)->child))) > 0;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  sensitive = g_strlen (gtk_entry_get_text
                                (GTK_ENTRY (GTK_COMBO (combo0)->entry))) > 0;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), REPLACE_OK,
                                                                    sensitive);
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), REPLACE_ALL,
                                                                    sensitive);
#if GTK_CHECK_VERSION(2,4,0)
  gtk_widget_grab_focus (GTK_BIN (combo0)->child);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_widget_grab_focus (GTK_COMBO (combo0)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_widget_show_all (tbox);

  result = gtk_dialog_run (GTK_DIALOG (dialog));
  if (result == REPLACE_OK || result == REPLACE_ALL)
    {
#if GTK_CHECK_VERSION(2,4,0)
      rp->src = g_strdup (gtk_entry_get_text
                                        (GTK_ENTRY (GTK_BIN (combo0)->child)));
      rp->dst = g_strdup (gtk_entry_get_text
                                        (GTK_ENTRY (GTK_BIN (combo1)->child)));
#else /* not GTK_CHECK_VERSION(2,4,0) */
      rp->src = g_strdup (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_COMBO (combo0)->entry)));
      rp->dst = g_strdup (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_COMBO (combo1)->entry)));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      rp->ignorecase = gtk_toggle_button_get_active
                                                (GTK_TOGGLE_BUTTON (check));
      rp->arrow = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radio1));
    }
  else
    {
      result = REPLACE_CANCEL;
    }
  gtk_widget_destroy (dialog);

  return result;
}
