/*
    charuty
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __CHARUTY_H__
#define __CHARUTY_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:文字符号化方式関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:文字符号化方式が正しいか判定する
    charset,文字符号化方式
        RET,TRUE:正しい,FALSE:不正                                          */
gboolean
charuty_is_valid (const gchar *charset);


/*  ja:文字符号化方式のリストを整形する
    charlist,文字符号化方式のリスト
         RET,整形された文字符号化方式のリスト                               */
gchar *
charuty_strip (const gchar *charlist);


/*  ja:文字符号化方式を置換する
    charlist0,文字符号化方式のリスト
    charlist1,置換する文字符号化方式のリスト
         RET,置換された文字符号化方式のリスト                               */
gchar *
charuty_rename (const gchar *charlist0,
                 const gchar *charlist1);


/*  ja:文字符号化方式のリストを追加する
    charlist0,文字符号化方式のリスト
    charlist1,追加する文字符号化方式のリスト
          RET,追加された文字符号化方式のリスト                              */
gchar *
charuty_append (const gchar *charlist0,
                const gchar *charlist1);


/*  ja:文字符号化方式を削除する
    charlist,文字符号化方式のリスト
     charset,削除する文字符号化方式
         RET,削除された文字符号化方式のリスト                               */
gchar *
charuty_remove (const gchar *charlist, 
                const gchar *charset);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __CHARUTY_H__ */
