/*
    fndir
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __FNDIR_H__
#define __FNDIR_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:t@C͊֐                                                       *
*                                                                             *
******************************************************************************/
#define MAXDRIVE 3
#define MAXDIR 1024
#define MAXFILE 1024
#define MAXEXT 1024
#define MAXPATH (MAXDRIVE+MAXDIR+MAXFILE+MAXEXT)


typedef struct _FNDIR
{
  TCHAR szDrive[MAXDRIVE];
  TCHAR szDir[MAXDIR];
  TCHAR szName[MAXFILE];
  TCHAR szExt[MAXEXT];
} FNDIR, *LPFNDIR;


/*  ja:t@Č
    lpszFIle,ꂽt@C
         pfd,t@C̊evf
         RET,TRUE:I,FALSE:G[                                     */
BOOL WINAPI
MergeFileName (LPTSTR  lpszFIle,
               LPFNDIR pfd);


/*  ja:t@C̕
    lpszFile,t@C
         pfd,t@C̊evf
         RET,TRUE:I,FALSE:G[                                     */
BOOL WINAPI
SplitFileName (LPCTSTR lpszFile,
               LPFNDIR pfd);


/*  ja:Ot@C擾
     lpszLongName,Ot@C
    lpszShortName,t@C                                                */
VOID WINAPI
GetLongFile (LPTSTR  lpszLongName,
             LPCTSTR lpszShortName);


/*  ja:t@C̑݊mF
    lpszFile,t@C
         RET,TRUE:݂,FALSE:݂Ȃ                                 */
BOOL WINAPI
IsFile (LPCTSTR lpszFile);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __FNDIR_H__ */
