/*
    valstr
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <limits.h>
#include <tchar.h>
#include "memapi.h"
#include "valstr.h"


/******************************************************************************
*                                                                             *
* ja:֐                                                               *
*                                                                             *
******************************************************************************/
static TCHAR cHex[16] = {'0', '1', '2', '3', '4', '5', '6', '7',
                         '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};


/*  ja:Rg[R[hł邩ǂ𔻒f
     ch,
    RET,TRUE:Rg[R[h,FALSE:̑                                */
BOOL WINAPI
IsCharControl (CHAR ch)
{
  WORD ct;

  return !GetStringTypeExA (LOCALE_USER_DEFAULT, CT_CTYPE1, &ch, 1, &ct)
                                            || (ct & C1_CNTRL) != 0 || ct == 0;
}


/*  ja:l
        nValue,l
    lpszString,
        nRadix,
         nWide,
       fSigned,TRUE:,FALSE:Ȃ                                 */
VOID WINAPI
ValStr (int    nValue,
        LPTSTR lpszString,
        int    nRadix,
        int    nWide,
        BOOL   fSigned)
{
  int i = 0, j, t;

  t = nValue;
  if (nValue == 0)
    {
      lpszString[i++] = cHex[0];
    }
  else
    {
      if (fSigned && nValue < 0)
        {
          while (t != 0)
            {
              lpszString[i++] = cHex[abs (t % nRadix)];
              t /= nRadix;
            }
        }
      else
        {
          while (t != 0)
            {
              lpszString[i++] = cHex[(unsigned)t % nRadix];
              t = (unsigned)t / nRadix;
            }
        }
    }
  lpszString[i] = '\0';
  for (j = 0; j < i / 2; j++)
    {
      TCHAR c;

      c = lpszString[j];
      lpszString[j] = lpszString[i - j - 1];
      lpszString[i - j - 1] = c;
    }
  if (fSigned && nValue < 0)
    {
      for (j = i; j >= 0; j--)
        lpszString[j + 1] = lpszString[j];
      lpszString[0] = '-';
      i++;
    }
  if (i < abs (nWide))
    {
      for (j = i; j >= 0; j--)
        lpszString[j + abs (nWide) - i] = lpszString[j];
      if (nWide > 0)
        {
          for (j = 0; j < nWide - i; j++)
            lpszString[j] = ' ';
        }
      else
        {
          for (j = 0; j < -nWide - i; j++)
            lpszString[j] = cHex[0];
          if (lpszString[j] == '-')
            {
              lpszString[0] = '-';
              lpszString[j] = cHex[0];
            }
        }
    }
}


/*  ja:񁨐l
        nValue,l
    lpszString,
        nRadix,
       fSigned,TRUE:,FALSE:Ȃ
           RET,TRUE:I,FALSE:G[                                   */
BOOL WINAPI
StrVal (int     *nValue,
        LPCTSTR  lpszString,
        int      nRadix,
        BOOL     fSigned)
{
  int i, j, t;
  TCHAR c;

  *nValue = 0;
  for (i = 0; lpszString[i] != '\0' && lpszString[i] == ' '; i++);
  if (lpszString[i] == '\0')
    return FALSE;
  if (fSigned && lpszString[i] == '-')
    {
      i++;
      while (lpszString[i] != '\0')
        {
          t = *nValue;
          *nValue *= nRadix;
          c = (TCHAR)CharUpper ((LPTSTR)lpszString[i]);
          for (j = 0; j < nRadix; j++)
            if (cHex[j] == c)
              break;
          *nValue += j;
          if (j == nRadix || *nValue < t)
            {
              *nValue = t;
              return FALSE;
            }
          i++;
        }
      if (*nValue & 0x80000000)
        {
          *nValue = 0;
          return FALSE;
        }
      *nValue = -*nValue;
    }
  else
    {
      while (lpszString[i] != '\0')
        {
          t = *nValue;
          *nValue *= nRadix;
          c = (TCHAR)CharUpper ((LPTSTR)lpszString[i]);
          for (j = 0; j < nRadix; j++)
            if (cHex[j] == c)
              break;
          *nValue += j;
          if (j == nRadix || *nValue < t)
            {
              *nValue = t;
              return FALSE;
            }
          i++;
        }
    }
  return TRUE;
}


/*  ja:l
        nValue,l
       nDivide,Zl
    lpszString,                                                       */
VOID WINAPI
FloatStr (int    nValue,
          int    nDivide,
          LPTSTR lpszString)
{
  int i = 0, j, n, t;

  n = t = MulDiv (nValue, 100000, nDivide);
  if (t == 0)
    {
      lpszString[i++] = cHex[0];
    }
  else
    {
      while (t != 0)
        {
          lpszString[i++] = cHex[abs (t % 10)];
          t /= 10;
        }
    }
  lpszString[i] = '\0';
  for (j = 0; j < i / 2; j++)
    {
      TCHAR c;

      c = lpszString[j];
      lpszString[j] = lpszString[i - j - 1];
      lpszString[i - j - 1] = c;
    }
  if (lstrlen (lpszString) < 6)
    {
      for (j = i; j >= 0; j--)
        lpszString[j + 2] = lpszString[j];
      lpszString[0] = '0';
      lpszString[1] = '.';
      i++;
    }
  else
    {
      for (j = 0; j < 6; j++)
        lpszString[i - j + 1] = lpszString[i - j];
      lpszString[i - 5] = '.';
    }
  while (lpszString[i] == '0')
    lpszString[i--] = '\0';
  if (lpszString[i] == '.')
    lpszString[i--] = '\0';
  if (n < 0)
    {
      for (j = i; j >= 0; j--)
        lpszString[j + 1] = lpszString[j];
      lpszString[0] = '-';
    }
}


/*  ja:񁨐l
      lpnValue,l
     lpnDivide,Zl
    lpszString,
           RET,TRUE:I,FALSE:G[                                   */
BOOL WINAPI
StrFloat (int     *lpnValue,
          int     *lpnDivide,
          LPCTSTR  lpszString)
{
  int i, j, t;
  LPTSTR p;

  *lpnValue = 0;
  for (i = 0; lpszString[i] != '\0' && lpszString[i] == ' '; i++);
  if (lpszString[i] == '\0'
    || !(p = MemoryAlloc ((lstrlen (lpszString) - i + 1) * sizeof (TCHAR))))
    {
      *lpnDivide = 1;
      return FALSE;
    }
  lstrcpy (p, lpszString + i);
  for (i = 0; p[i] != '\0'; i++)
    if (p[i] == '.')
      break;
  *lpnDivide = 1;
  while (p[i] != '\0')
    {
      p[i] = p[i + 1];
      *lpnDivide *= 10;
      i++;
    }
  *lpnDivide = max (*lpnDivide / 10, 1);
  i = 0;
  if (p[0] == '-')
    {
      i++;
      while (p[i] != '\0')
        {
          t = *lpnValue;
          *lpnValue *= 10;
          for (j = 0; j < 10; j++)
            if (cHex[j] == p[i])
              break;
          *lpnValue += j;
          if (j == 10 || *lpnValue < t)
            {
              *lpnValue = t;
              MemoryFree (p);
              return FALSE;
            }
          i++;
        }
      if (*lpnValue & 0x80000000)
        {
          *lpnValue = 0;
          MemoryFree (p);
          return FALSE;
        }
      *lpnValue = -(*lpnValue);
    }
  else
    {
      while (p[i] != '\0')
        {
          t = *lpnValue;
          *lpnValue *= 10;
          for (j = 0; j < 10; j++)
            if (cHex[j] == p[i])
              break;
          *lpnValue += j;
          if (j == 10 || *lpnValue < t)
            {
              *lpnValue = t;
              MemoryFree (p);
              return FALSE;
            }
          i++;
        }
    }
  MemoryFree (p);
  return TRUE;
}


/*  ja:񁨕
      lpbArray,
    lpszString,
        nRadix,
         nWide,
       fSigned,TRUE:,FALSE:Ȃ                                 */
VOID WINAPI
ArrayStr (LPBYTE lpbArray,
          LPTSTR lpszString,
          int    nRadix,
          int    nWide,
          BOOL   fSigned)
{
  int i;
  LPTSTR p;

  if (*(int *)lpbArray <= 0)
    {
      lpszString[0] = '\0';
      return;
    }
  p = lpszString;
  for (i = 0; i < *(int *)lpbArray; i++)
    {
      if (fSigned)
        ValStr ((char)lpbArray[i + sizeof (int)], p, nRadix, nWide, fSigned);
      else
        ValStr (lpbArray[i + sizeof (int)], p, nRadix, nWide, fSigned);
      p += lstrlen (p);
      if (i < *(int *)lpbArray - 1)
        *p++ = ' ';
    }
}


/*  ja:񁨐
      lpbArray,
    lpszString,
        nRadix,
       fSigned,TRUE:,FALSE:Ȃ
           RET,TRUE:I,FALSE:G[                                   */
BOOL WINAPI
StrArray (LPBYTE  lpbArray,
          LPCTSTR lpszString,
          int     nRadix,
          BOOL    fSigned)
{
  int i, j, nValue;
  LPTSTR lpszText;

  *(int *)lpbArray = 0;
  lpszText = MemoryAlloc ((lstrlen (lpszString) + 2) * sizeof (TCHAR));
  if (!lpszText)
    return -1;
  lstrcpy (lpszText, lpszString);
  for (i = 0; lpszText[i] != '\0'; i++)
    {
      for (j = 0; j < nRadix; j++)
        if (lpszText[i] == cHex[j])
          break;
      if (j >= nRadix)
        lpszText[i] = '\0';
    }
  i = 0;
  while (lpszText[i] != '\0')
    {
      if (!StrVal (&nValue, lpszText + i, nRadix, fSigned))
        {
          *(int *)lpbArray = 0;
          MemoryFree (lpszText);
          return FALSE;
        }
      if (fSigned ? nValue < SCHAR_MIN || SCHAR_MAX < nValue
                                                : (unsigned)nValue > UCHAR_MAX)
        {
          *(int *)lpbArray = 0;
          MemoryFree (lpszText);
          return FALSE;
        }
      lpbArray[*(int *)lpbArray + sizeof (int)] = nValue;
      (*(int *)lpbArray)++;
      i += lstrlen (lpszText) + 1;
    }
  MemoryFree (lpszText);
  return TRUE;
}
