/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "print.h"
#include <commctrl.h>
#include "abort.h"
#include "dialog.h"
#include "edit.h"
#include "memapi.h"
#include "other.h"
#include "resource.h"
#include "valstr.h"


typedef struct _MARGIN
{
  int sx, sy, nMargin;
} MARGIN, *LPMARGIN;


/******************************************************************************
*                                                                             *
* ja:֐Q                                                               *
*                                                                             *
******************************************************************************/
static BOOL CALLBACK
MarginDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  static int nMin, nMax;
  static LPMARGIN mr = NULL;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        mr = (LPMARGIN)lParam;
        /* ja:E}[W̍ŏlƍőlvZ */
        nMin = max (mr->sx * 2 / mr->sy, 2);
        nMax = min (max (mr->sx / 2, nMin), 512);
        /* ja:GfBgRg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_EDIT31, EM_LIMITTEXT, 12, 0);
        if (!SetDlgItemInt (hDlg, IDC_EDIT31, mr->nMargin, TRUE))
          {
            MessageBox (hDlg, _T("SetDlgItemInt"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
            return TRUE;
          }
        /* ja:Abv_ERg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_UPDOWN31,
                                    UDM_SETRANGE, 0, MAKELPARAM (nMax, nMin));
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              mr->nMargin = GetDlgItemInt (hDlg, IDC_EDIT31, NULL, TRUE);
            case IDCANCEL:
              mr = NULL;
              if (!EndDialog (hDlg,  LOWORD(wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                return TRUE;
            case IDC_EDIT31:
              {
                int nMargin, nFontSize;
                TCHAR szText[4082];

                if (HIWORD (wParam) != EN_CHANGE || !mr)
                  return TRUE;
                nMargin = GetDlgItemInt (hDlg, IDC_EDIT31, NULL, TRUE);
                if (nMin <= nMargin && nMargin <= nMax)
                  {
                    nFontSize = (mr->sx / nMargin * 2 + 1) / 2;
                    wsprintf (szText, LoadText (hInst, IDS_OTHER_LINE),
                                nFontSize > 0 ? mr->sy / (nFontSize * 2) : 0);
                  }
                else
                  {
                    nFontSize = 0;
                    szText[0] = '\0';
                  }
                /* ja:X^eBbNRg[̐ݒ */
                if (!SetDlgItemText (hDlg, IDC_STATIC31, szText))
                  {
                    MessageBox (hDlg, _T("SetDlgItemText"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:Rg[̕\ */
                if (!EnableDlgItem (hDlg, IDOK, nFontSize > 0))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}


BOOL CALLBACK
PrintProc (HDC hdc,
           int nError)
{
  MSG msg;

  while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
    if (!hDlgCancel || !IsDialogMessage (hDlgCancel, &msg))
      {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
      }
  return fUserBreak;
}


/*  ja:v^֏o͂
    hWnd,EChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
PrintOut (HWND hWnd)
{
  int i, nFontSize, nLength, nWidth;
  COLORREF crText, crCtrl;
  DOCINFO di;
  HFONT hFont, hFontsm;
  LOGFONT logfont;
  LPTEXTWND ptw;
  MARGIN mr;
  POINT ptStart, ptEnd;
  PRINTDLG pd;
  TCHAR szText[MAXPATH];

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  GetWindowText (hWnd, szText, MAXPATH);
  MemorySet (&di, 0, sizeof (DOCINFO));
  MemorySet (&pd, 0, sizeof (PRINTDLG));
  di.cbSize =  sizeof(DOCINFO);
  di.lpszDocName = szText;
  pd.lStructSize = sizeof(PRINTDLG);
  pd.hwndOwner = hWnd;
  pd.Flags = PD_COLLATE | PD_HIDEPRINTTOFILE | PD_RETURNDC;
  pd.nCopies = 1;
  pd.Flags |= ptw->ptSelect.x < 0 ? PD_NOSELECTION : PD_SELECTION;
  if (!PrintDlg (&pd))
    return TRUE;
  /* ja:E}[W */
  mr.sx = GetDeviceCaps (pd.hDC, HORZRES);
  mr.sy = GetDeviceCaps (pd.hDC, VERTRES) * 24 / 25;
  mr.nMargin = ptw->nMargin;
  if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_3),
                                    hWnd, MarginDlgProc, (LPARAM)&mr) != IDOK)
    return TRUE;
  /* ja:tHg쐬 */
  logfont = ptw->lf;
  logfont.lfHeight = mr.sx / mr.nMargin * 2;
  nFontSize = (logfont.lfHeight + 1) / 2;
  hFont = CreateFontIndirect (&logfont);
  if (!hFont)
    {
      MessageBox (hWnd, _T("CreateFontIndirect"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  logfont.lfHeight /= 2;
  hFontsm = CreateFontIndirect (&logfont);
  if (!hFontsm)
    {
      MessageBox (hWnd, _T("CreateFontIndirect"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      DeleteObject (hFont);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  /* ja:As߂ */
  if (mr.sy < nFontSize * 2)
    {
      MessageBox (hWnd, LoadText (hInst, IDS_OTHER_MARGIN),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      DeleteObject (hFont);
      DeleteObject (hFontsm);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  if (ptw->ptSelect.x < 0 || !(pd.Flags & PD_SELECTION))
    {
      /* ja:I͈͂ȂAׂĈ */
      ptStart.x = ptStart.y = 0;
      ptEnd.x = GetWidth (&ptw->lpStart, &ptw->nOff, ptw->nMax - 1, ptw->nTab);
      ptEnd.y = ptw->nMax - 1;
    }
  else if (ptw->ptSelect.y < ptw->ptCursor.y
                                        || ptw->ptSelect.y == ptw->ptCursor.y
                                        && ptw->ptSelect.x < ptw->ptCursor.x)
    {
      ptStart = ptw->ptSelect;
      ptEnd = ptw->ptCursor;
    }
  else
    {
      ptStart = ptw->ptCursor;
      ptEnd = ptw->ptSelect;
    }
  if (ptw->fSysColor)
    {
      /* ja:VXeF */
      crText = RGB (  0,   0,   0);
      crCtrl = RGB (128, 128, 128);
    }
  else
    {
      /* ja:[U[ݒ */
      crText = ptw->crColor[10];
      crCtrl = ptw->crColor[11];
    }
  fUserBreak = TRUE;
  EnableWindow (hWndMain, FALSE);
  hDlgCancel = CreateDialogParamGUI (hInst, MAKEINTRESOURCE (DIALOG_G),
                                    hWndClient, AbortDlgProc,
                                    (LPARAM)LoadText (hInst, IDS_JOB_PRINT));
  if (!hDlgCancel)
    {
      MessageBox (hWnd, _T("CreateDialogParamGUI"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      EnableWindow (hWndMain, TRUE);
      DeleteObject (hFont);
      DeleteObject (hFontsm);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  if (SetAbortProc (pd.hDC, PrintProc) <= 0)
    {
      MessageBox (hWnd, _T("SetAbortProc"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      DestroyWindow (hDlgCancel);
      EnableWindow (hWndMain, TRUE);
      DeleteObject (hFont);
      DeleteObject (hFontsm);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  if (StartDoc (pd.hDC, &di) <= 0)
    {
      MessageBox (hWnd, _T("StartDoc"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      DestroyWindow (hDlgCancel);
      EnableWindow (hWndMain, TRUE);
      DeleteObject (hFont);
      DeleteObject (hFontsm);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  for (i = 0; i< (pd.Flags & PD_COLLATE ? pd.nCopies : 1); i++)
    {
      int nDataPos, nEndPos, nLine;
      LPLINEBUF p;

      p = GetLineBuffer (&ptw->lpStart, &ptw->nOff, ptStart.y);
      nEndPos = GetDataPos (&ptw->lpStart, &ptw->nOff,
                                        ptEnd.x, ptEnd.y, ptw->nTab, FALSE);
      nLine = ptStart.y;
      nDataPos = GetDataPos (&ptw->lpStart, &ptw->nOff,
                                    ptStart.x, ptStart.y, ptw->nTab, FALSE);
      while (nLine <= ptEnd.y)
        {
          /* ja:y[WX^[g */
          int x = 0, y = 0, nBkMode;
          COLORREF crTextColor;

          if (StartPage (pd.hDC) <= 0)
            {
              MessageBox (hWnd, _T("StartPage"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              goto loop;
            }
          crTextColor = SetTextColor (pd.hDC, crText);
          nBkMode = SetBkMode (pd.hDC, TRANSPARENT);
          hFont = SelectObject (pd.hDC, hFont);
          while (y + nFontSize * 2 < mr.sy && nLine <= ptEnd.y)
            {
              while (x < mr.sx)
                {
                  int nWidth;

                  if (nDataPos >= (nLine == ptEnd.y ? nEndPos : p->nLength))
                    {
                      /* ja:s̏I */
                      nDataPos = 0;
                      nLine++;
                      p = p->next;
                      if (p || !p->fMargin)
                        break;
                    }
                  if (p->lpszText[nDataPos] == '\t')
                    nWidth = (x / nFontSize / ptw->nTab + 1)
                                                * ptw->nTab * nFontSize - x;
                  else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
                    nWidth = nFontSize;
                  else
                    nWidth = nFontSize * 2;
                  if (x > 0 && mr.sx < x + nWidth)
                    break;
                  if (p->lpszText[nDataPos] == '\t')
                    {
                      /* ja:^u */
                      nDataPos++;
                    }
                  else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
                    {
                      /* ja:1oCg */
                      if (!IsCharControl (p->lpszText[nDataPos]))
                        {
                          /* ja:ʏ1 */
                          TextOutA (pd.hDC, x, y, p->lpszText + nDataPos, 1);
                        }
                      else
                        {
                          int nLength;

                          nLength = lstrlenA (lpszCode[(BYTE)
                                                    p->lpszText[nDataPos]]);
                          if (nLength == 1)
                            {
                              /* en:ANK */
                              TextOutA (pd.hDC, x, y,
                                    lpszCode[(BYTE)p->lpszText[nDataPos]], 1);
                            }
                          else
                            {
                              SetTextColor (pd.hDC, crCtrl);/* ja:DF */
                              hFontsm = SelectObject (pd.hDC, hFontsm);
                              if (nLength == 2)
                                {
                                  if (IsDBCSLeadByteEx (CP_SJIS,
                                            *lpszCode[(BYTE)
                                                    p->lpszText[nDataPos]]))
                                    {
                                      /* ja:Sp1 */
                                      TextOutA (pd.hDC, x, y + nFontSize / 2,
                                            lpszCode[(BYTE)
                                                    p->lpszText[nDataPos]], 2);
                                    }
                                  else
                                    {
                                      /* ja:p2 */
                                      TextOutA (pd.hDC, x, y,
                                            lpszCode[(BYTE)
                                                    p->lpszText[nDataPos]], 1);
                                      TextOutA (pd.hDC,
                                            x + nFontSize / 2, y + nFontSize,
                                            lpszCode[(BYTE)
                                                p->lpszText[nDataPos]] + 1, 1);
                                    }
                                }
                              else if (nLength == 3)
                                {
                                  /* ja:1oCg3 */
                                  if (!IsDBCSLeadByteEx (CP_SJIS,
                                        *lpszCode[(BYTE)p->lpszText[nDataPos]])
                                    && IsDBCSLeadByteEx (CP_SJIS,
                                        *(lpszCode[(BYTE)
                                                p->lpszText[nDataPos]] + 1)))
                                    {
                                      /* ja:p+Sp */
                                      TextOutA (pd.hDC, x, y, lpszCode[(BYTE)
                                                    p->lpszText[nDataPos]], 2);
                                      TextOutA (pd.hDC, x, y + nFontSize,
                                            lpszCode[(BYTE)
                                                p->lpszText[nDataPos]] + 2, 2);
                                    }
                                  else
                                    {
                                      /* ja:Sp+p p3 */
                                      TextOutA (pd.hDC, x, y, lpszCode[(BYTE)
                                                    p->lpszText[nDataPos]], 2);
                                      TextOutA (pd.hDC,
                                            x + nFontSize / 2, y + nFontSize,
                                            lpszCode[(BYTE)
                                                p->lpszText[nDataPos]] + 2, 1);
                                    }
                                }
                              else
                                {
                                  /* ja:Sp2 p4 */
                                  TextOutA (pd.hDC, x, y, lpszCode[(BYTE)
                                                    p->lpszText[nDataPos]], 2);
                                  TextOutA (pd.hDC, x, y + nFontSize, 
                                                lpszCode[(BYTE)
                                                p->lpszText[nDataPos]] + 2, 2);
                                }
                              SetTextColor (pd.hDC, crText);
                              hFontsm = SelectObject (pd.hDC, hFontsm);
                            }
                        }
                        nDataPos++;
                    }
                  else
                    {
                      /* ja:Sp */
                      TextOutA (pd.hDC, x, y, p->lpszText + nDataPos, 2);
                      nDataPos += 2;
                    }
                  x += nWidth;
                }
              x = 0;
              y += nFontSize * 2;
            }
          SetTextColor (pd.hDC, crTextColor);
          SetBkMode (pd.hDC, nBkMode);
          hFont = SelectObject (pd.hDC, hFont);
          if (EndPage (pd.hDC) <= 0)
            {
              MessageBox (hWnd, _T("EndPage"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              goto loop;
            }
          if (!fUserBreak)
            goto loop;
        }
    }
  loop:
  if (EndDoc (pd.hDC) <= 0)
    {
      MessageBox (hWnd, _T("EndDoc"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      DestroyWindow (hDlgCancel);
      EnableWindow (hWndMain, TRUE);
      DeleteObject (hFont);
      DeleteObject (hFontsm);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  EnableWindow (hWndMain, TRUE);
  if (!DestroyWindow (hDlgCancel))
    {
      MessageBox (hWnd, _T("DestroyWindow"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      DeleteObject (hFont);
      DeleteObject (hFontsm);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  if (!DeleteObject (hFont) | !DeleteObject (hFontsm))
    {
      MessageBox (hWnd, _T("DeleteObject"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      DeleteDC (pd.hDC);
      return FALSE;
    }
  if (!DeleteDC (pd.hDC))
    {
      MessageBox (hWnd, _T("DeleteDC"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      return FALSE;
    }
  return TRUE;
}
