/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "format.h"
#include <commctrl.h>
#include "dialog.h"
#include "general.h"
#include "memapi.h"
#include "other.h"
#include "prop.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:t@C^Cv֐Q                                                     *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
AutoDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  static LPDWORD lpdwAuto;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i = 0, j = 1;
          BYTE bBit = 0;
          DWORD dwAuto;
          LPTSTR lpszMessage[7];
          TCHAR szMessage[4096];

          lpdwAuto = (LPDWORD)lParam;
          /* ja:Xg{bNX̐ݒ */
          LoadString (hInst, IDS_FTYPE_CHARSET, szMessage, 4096);
          lpszMessage[0] = szMessage;
          while (szMessage[i] != '\0' && j < 7)
#ifndef UNICODE
            if (IsDBCSLeadByteEx (CP_SJIS, szMessage[i]))
              {
                i += 2;
              }
            else
#endif /* not UNICODE */
              {
                if (szMessage[i] == ',')
                  {
                    lpszMessage[j++] = szMessage + i + 1;
                    szMessage[i] = '\0';
                  }
                i++;
              }
          for (dwAuto = *lpdwAuto; dwAuto & 15; dwAuto >>= 4)
            {
              SendDlgItemMessage (hDlg, IDC_LISTBOXC2, LB_SETITEMDATA,
                        SendDlgItemMessage (hDlg, IDC_LISTBOXC2, LB_ADDSTRING,
                    0, (LPARAM)lpszMessage[(dwAuto & 15) - 1]), dwAuto & 15);
              bBit |= 1 << (dwAuto & 15) - 1;
            }
          for (i = 0; i < 7; i++)
            if (!(bBit >> i & 1))
              SendDlgItemMessage (hDlg, IDC_LISTBOXC1, LB_SETITEMDATA,
                        SendDlgItemMessage (hDlg, IDC_LISTBOXC1, LB_ADDSTRING,
                                            0, (LPARAM)lpszMessage[i]), i + 1);
        }
        goto loop;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int i;

                *lpdwAuto = 0;
                for (i = SendDlgItemMessage (hDlg, IDC_LISTBOXC2,
                                        LB_GETCOUNT, 0, 0) - 1; i >= 0; i--)
                  *lpdwAuto = *lpdwAuto << 4 | SendDlgItemMessage (hDlg,
                                        IDC_LISTBOXC2, LB_GETITEMDATA, i, 0);
              }
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              return TRUE;
            case IDC_LISTBOXC1:
            case IDC_LISTBOXC2:
              if (HIWORD (wParam) == LBN_SELCHANGE
                    && !EnableDlgItem (hDlg, LOWORD (wParam) == IDC_LISTBOXC1
                                        ? IDC_PUSHBUTTONC1 : IDC_PUSHBUTTONC2,
                SendDlgItemMessage (hDlg, LOWORD (wParam),
                                                    LB_GETSELCOUNT, 0, 0) > 0))
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            case IDC_PUSHBUTTONC1:
            case IDC_PUSHBUTTONC2:
            case IDC_PUSHBUTTONC3:
            case IDC_PUSHBUTTONC4:
              {
                int i, *p, nCount, nIDSrc, nIDDst;
                TCHAR szName[4096];

                if (LOWORD (wParam) == IDC_PUSHBUTTONC1
                                        || LOWORD (wParam) == IDC_PUSHBUTTONC3)
                  {
                    nIDSrc = IDC_LISTBOXC1;
                    nIDDst = IDC_LISTBOXC2;
                  }
                else
                  {
                    nIDSrc = IDC_LISTBOXC2;
                    nIDDst = IDC_LISTBOXC1;
                  }
                nCount = SendDlgItemMessage (hDlg, nIDSrc,
                                            LOWORD (wParam) <= IDC_PUSHBUTTONC2
                                        ? LB_GETSELCOUNT : LB_GETCOUNT, 0, 0);
                if (nCount <= 0)
                  return TRUE;
                p = MemoryAlloc (nCount * sizeof (int));
                if (LOWORD (wParam) <= IDC_PUSHBUTTONC2)
                  SendDlgItemMessage (hDlg, nIDSrc,
                                            LB_GETSELITEMS, nCount, (LPARAM)p);
                else
                  for (i = 0; i < nCount; i++)
                    p[i] = i;
                for (i = 0; i < nCount; i++)
                  {
                    SendDlgItemMessage (hDlg, nIDSrc, LB_GETTEXT, p[i],
                                                            (LPARAM)szName);
                    SendDlgItemMessage (hDlg, nIDDst, LB_SETITEMDATA,
                    SendDlgItemMessage (hDlg, nIDDst, LB_ADDSTRING,
                                                            0, (LPARAM)szName),
                    SendDlgItemMessage (hDlg, nIDSrc, LB_GETITEMDATA,
                                                                    p[i], 0));
                  }
                for (i = nCount - 1; i >= 0; i--)
                  SendDlgItemMessage (hDlg, nIDSrc, LB_DELETESTRING, p[i], 0);
                MemoryFree (p);
                if (!EnableDlgItem (hDlg, IDOK, TRUE))
                  {
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              loop:
              if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONC1,
                                    SendDlgItemMessage (hDlg, IDC_LISTBOXC1,
                                                    LB_GETSELCOUNT, 0, 0) > 0)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTONC2,
                                    SendDlgItemMessage (hDlg, IDC_LISTBOXC2,
                                                    LB_GETSELCOUNT, 0, 0) > 0)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTONC3,
                                    SendDlgItemMessage (hDlg, IDC_LISTBOXC1,
                                                    LB_GETCOUNT, 0, 0) > 0)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTONC4,
                                    SendDlgItemMessage (hDlg, IDC_LISTBOXC2,
                                                    LB_GETCOUNT, 0, 0) > 0))
                EndDialog (hDlg, IDCANCEL);
          }
        return TRUE;
    }
  return FALSE;
}


BOOL CALLBACK
FiletypeDlgProc (HWND   hDlg,
                 UINT   uMsg,
                 WPARAM wParam,
                 LPARAM lParam)
{
  static DWORD dwAuto;
  static LPFILETYPE lpFType;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        lpFType = (LPFILETYPE)lParam;
        dwAuto = lpFType->dwAuto;
        /* ja:`FbN{bNX̐ݒ */
        if (!CheckDlgButton (hDlg, IDC_CHECKBOXD1,
                            lpFType->fAssociate ? BST_CHECKED : BST_UNCHECKED))
          {
            MessageBox (hDlg, _T("CheckDlgButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
            return TRUE;
          }
        /* ja:R{{bNX̐ݒ */
        SendDlgItemMessage (hDlg, IDC_COMBOBOX51, CB_SETITEMDATA,
                        SendDlgItemMessage (hDlg, IDC_COMBOBOX51, CB_ADDSTRING,
                            0, (LPARAM)LoadText (hInst, IDS_FTYPE_AUTO)), 0);
        SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_SETITEMDATA,
                        SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_ADDSTRING,
                            0, (LPARAM)LoadText (hInst, IDS_FTYPE_AUTO)), 0);
        /* ja:GfBgRg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_EDITD1, EM_LIMITTEXT, MAXPATH, 0);
        SendDlgItemMessage (hDlg, IDC_EDITD2, EM_LIMITTEXT, MAXPATH, 0);
        if (!SetDlgItemText (hDlg, IDC_EDITD1, lpFType->szText)
                        || !SetDlgItemText (hDlg, IDC_EDITD2, lpFType->szExt))
          {
            MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
            return TRUE;
          }
        /* ja:Rg[̕\ */
        if (!EnableDlgItem (hDlg, IDC_PUSHBUTTOND1, lpFType->uCharSet == 0))
          {
            MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION,MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
            return TRUE;
          }
        break;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              lpFType->fAssociate = IsDlgButtonChecked (hDlg, IDC_CHECKBOXD1)
                                                                == BST_CHECKED;
              GetDlgItemText (hDlg, IDC_EDITD1, lpFType->szText, MAXPATH);
              GetDlgItemText (hDlg, IDC_EDITD2, lpFType->szExt, MAXPATH);
              lpFType->dwAuto = dwAuto;
              break;
            case IDC_COMBOBOX52:
              if (HIWORD (wParam) == CBN_SELCHANGE
                && !EnableDlgItem (hDlg, IDC_PUSHBUTTOND1,
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_GETITEMDATA,
                                    SendDlgItemMessage (hDlg, IDC_COMBOBOX52,
                                                CB_GETCURSEL, 0, 0), 0) == 0))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              break;
            case IDC_EDITD1:
            case IDC_EDITD2:
              if (HIWORD (wParam) != EN_CHANGE)
                return TRUE;
              goto loop;
            case IDC_PUSHBUTTOND1:
              if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_C), hDlg,
                                        AutoDlgProc, (LPARAM)&dwAuto) != IDOK)
                return TRUE;
            case IDC_CHECKBOXD1:
            loop:
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDOK,
                            GetDlgItemInt (hDlg, IDC_EDIT51, NULL, TRUE) > 0
                        && GetDlgItemInt (hDlg, IDC_EDIT52, NULL, TRUE) > 0))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
              return TRUE;
          }
    }
  return PropertyDlgProc (hDlg, uMsg, wParam, lParam);
}


BOOL CALLBACK
FormatDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  static int nPos;

  if (uMsg == uDlMsg)
    {
      switch (((LPDRAGLISTINFO)lParam)->uNotification)
        {
          case DL_DRAGGING:
            return 0;
          case DL_DROPPED:
            {
              int nItem;
              FILETYPE stFType;

              nItem = LBItemFromPt (((LPDRAGLISTINFO)lParam)->hWnd,
                                    ((LPDRAGLISTINFO)lParam)->ptCursor, TRUE);
              if (nItem == -1 || nPos == nItem)
                break;
              stFType = lpFileType[nPos];
              if (nItem < nPos)
                MemoryCopy (&lpFileType[nItem + 1], &lpFileType[nItem],
                                        (nPos - nItem) * sizeof (FILETYPE));
              else
                MemoryCopy (&lpFileType[nPos], &lpFileType[nPos + 1],
                                        (nItem - nPos) * sizeof (FILETYPE));
              lpFileType[nItem] = stFType;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                    nPos, 0);
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                                nItem, (LPARAM)stFType.szText);
              nPos = nItem;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL, nItem, 0);
              dwFilter = 0;
            }
        }
      return TRUE;
    }
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          HWND hWnd;

          nPos = dwFilter;
          if (nPos >= nFileType)
            nPos = 0;
          /* ja:Xg{bNXݒ肷 */
          for (i = 0; i < nFileType; i++)
            SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_ADDSTRING,
                                            0, (LPARAM)lpFileType[i].szText);
          SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL, nPos, 0);
          hWnd = GetDlgItem (hDlg, IDC_LISTBOXE1);
          if (!hWnd)
            {
              MessageBox (hDlg, _T("GetDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!MakeDragList (hWnd))
            {
              MessageBox (hDlg, _T("MakeDragList"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Rg[̕\ */
          if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, nFileType > 1)
            || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0)
            || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, nPos < nFileType - 1))
            {
              MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_PUSHBUTTONE1:/* ja:VK */
              lpFileType = MemoryReAlloc (lpFileType,
                                            ++nFileType * sizeof (FILETYPE));
              MemoryCopy (&lpFileType[nPos + 2], &lpFileType[nPos + 1],
                                (nFileType - nPos - 2) * sizeof (FILETYPE));
              lpFileType[nPos + 1] = lpFileType[nPos];
              lpFileType[nPos + 1].nID = nTypeCount++;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                    nPos + 1, (LPARAM)lpFileType[nPos].szText);
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, TRUE)
                            || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, TRUE))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
              return TRUE;
            case IDC_PUSHBUTTONE2:/* ja:폜 */
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                    nPos, 0);
              MemoryCopy (&lpFileType[nPos], &lpFileType[nPos + 1],
                                (nFileType - nPos - 1) * sizeof (FILETYPE));
              lpFileType = MemoryReAlloc (lpFileType,
                                            --nFileType * sizeof (FILETYPE));
              if (nPos > nFileType - 1)
                nPos = nFileType - 1;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL, nPos, 0);
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, nFileType > 1)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE4,
                                                        nPos < nFileType - 1))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
              dwFilter = 0;
              return TRUE;
            case IDC_PUSHBUTTONE3:/* ja: */
              {
                FILETYPE stFType;

                stFType = lpFileType[nPos];
                lpFileType[nPos] = lpFileType[nPos - 1];
                lpFileType[nPos - 1] = stFType;
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                    nPos, 0);
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                            --nPos, (LPARAM)stFType.szText);
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL,
                                                                    nPos, 0);
                dwFilter = 0;
              }
              return TRUE;
            case IDC_PUSHBUTTONE4:/* ja: */
              {
                FILETYPE stFType;

                stFType = lpFileType[nPos];
                lpFileType[nPos] = lpFileType[nPos + 1];
                lpFileType[nPos + 1] = stFType;
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                    nPos, 0);
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                            ++nPos, (LPARAM)stFType.szText);
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL,
                                                                    nPos, 0);
                dwFilter = 0;
              }
              return TRUE;
            case IDC_LISTBOXE1:/* ja:ҏW */
              if (HIWORD (wParam) == LBN_SELCHANGE)
                {
                  nPos = SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_GETCURSEL,
                                                                        0, 0);
                  /* ja:Rg[̕\ */
                  if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0)
                                    || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE4,
                                                        nPos < nFileType - 1))
                    {
                      MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                    }
                  return TRUE;
                }
              else if (HIWORD (wParam) != LBN_DBLCLK)
                {
                  return 1;
                }
            case IDC_PUSHBUTTONE5:
              if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_D), hDlg,
                        FiletypeDlgProc, (LPARAM)&lpFileType[nPos]) != IDOK)
                return TRUE;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                        nPos, (LPARAM)lpFileType[nPos].szText);
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                nPos + 1, 0);
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL, nPos, 0);
              EnumChildWindows (hWndClient, PropertyEnumProc,
                                                    (LPARAM)&lpFileType[nPos]);
          }
        return TRUE;
    }
  return FALSE;
}
