/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "ftype.h"
#include "other.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:t@C^Cv̑I֐Q                                               *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
AssociateDlgProc (HWND   hDlg,
                  UINT   uMsg,
                  WPARAM wParam,
                  LPARAM lParam)
{
  static int *lpnPos;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;

          lpnPos = (int *)lParam;
          if (*lpnPos > nFileType)
            *lpnPos = 0;
          for (i = 0; i < nFileType; i++)
            SendDlgItemMessage (hDlg, IDC_LISTBOX41, LB_ADDSTRING,
                                            0, (LPARAM)lpFileType[i].szText);
          SendDlgItemMessage (hDlg, IDC_LISTBOX41, LB_ADDSTRING,
                                0, (LPARAM)LoadText (hInst, IDS_FTYPE_NOTYPE));
          SendDlgItemMessage (hDlg, IDC_LISTBOX41, LB_SETCURSEL, *lpnPos, 0);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDC_LISTBOX41:
              if (HIWORD (wParam) != LBN_DBLCLK)
                return TRUE;
            case IDOK:
              *lpnPos = SendDlgItemMessage (hDlg, IDC_LISTBOX41, LB_GETCURSEL,
                                                                        0, 0);
              if (*lpnPos != LB_ERR)
                {
                  if (*lpnPos >= nFileType)
                    *lpnPos = -1;
                  if (!EndDialog (hDlg, IDOK))
                    MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  return TRUE;
                }
            case IDCANCEL:
              if (!EndDialog (hDlg, IDCANCEL))
                MessageBox (hDlg, _T("EndDialog"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                return TRUE;
          }
    }
  return FALSE;
}
