/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "general.h"
#include <commctrl.h>
#include "edit.h"
#include "find.h"
#include "imectrl.h"
#include "memapi.h"
#include "other.h"
#include "replace.h"
#include "resource.h"
#include "valchr.h"


/******************************************************************************
*                                                                             *
* ja:ʊ֐Q                                                               *
*                                                                             *
******************************************************************************/
/*  ja:Lbg̕`
    hWnd,EChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
DrawCaret (HWND hWnd)
{
  int x, y;
  LPTEXTWND ptw;
  TCHAR szText[512];

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  if (!ptw)
    {
      SetCaretPos (-128, -128);
      return FALSE;
    }
  x = GetAlignPos( &ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
  y = ptw->ptCursor.y;
  wsprintf (szText, LoadText (hInst,
                ptw->ptSelect.x < 0 ? IDS_STATUS_NOSEL : IDS_STATUS_SELECT),
        x + 1, y + 1, ptw->ptSelect.x + 1, ptw->ptSelect.y + 1, x + 1, y + 1);
  if (!SendMessage (hWndStat, SB_SETTEXT, 0, (LPARAM)szText))
    {
      MessageBox (hWndClient, _T("SB_SETTEXT"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  x = (x - ptw->ptTop.x) * ptw->nFontSize;
  y = (y - ptw->ptTop.y) * ptw->nFontSize * 2;
  if (x < 0 || ptw->siWnd.cx <= x || y < 0 || ptw->siWnd.cy <= y)
    x = y = -128;
  SetCaretPos (x, y);
  SetImePos (hWnd, x, y);
  return TRUE;
}


/*  ja:j[ݒ肷
    ptw,TXTEChE
    RET,TRUE:I,FALSE:G[                                          */
BOOL
SetMenuBar (LPTEXTWND ptw)
{
  int nMenu;
  HMENU hMenu;

  hMenu = GetMenu (hWndMain);
  if (!hMenu)
    {
      MessageBox (hWndClient, _T("GetMenu"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  nMenu = (GetMenuItemCount (hMenu) != MENUTOP);
  if (ptw)
    {
      if (EnableMenuItem (hMenu, nMenu + 1,
                                    MF_BYPOSITION | MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, nMenu + 2,
                                    MF_BYPOSITION | MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, nMenu + 4,
                                    MF_BYPOSITION | MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_CLOSE, MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_SAVE, MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_SAVEAS, MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_RELOAD, ptw->fCreate
                                        ? MF_GRAYED : MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_PRINT, MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_PROPERTY, MF_ENABLED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_UNDO, ptw->lpUndo
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_REDO, ptw->lpRedo
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_CUT, ptw->ptSelect.x >= 0
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_COPY, ptw->ptSelect.x >= 0
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_PASTE, fClipBoard
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_DELETE, ptw->ptSelect.x >= 0
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_NEXT, lpszFind[0]
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff)
        {
          MessageBox (hWndClient, _T("EnableMenuItem"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return FALSE;
        }
      if (!SendMessage (hWndTool, TB_ENABLEBUTTON, CM_SAVE, TRUE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PRINT, TRUE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PROPERTY, TRUE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_UNDO,
                                                        ptw->lpUndo != NULL)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_REDO,
                                                        ptw->lpRedo != NULL)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_CUT,
                                                        ptw->ptSelect.x >= 0)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_COPY,
                                                        ptw->ptSelect.x >= 0)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PASTE, fClipBoard)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_DELETE,
                                                        ptw->ptSelect.x >= 0)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_FIND, TRUE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_REPLACE, TRUE))
        {
          MessageBox (hWndClient, _T("TB_ENABLEBUTTON"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return FALSE;
        }
    }
  else
    {
      if (EnableMenuItem (hMenu, nMenu + 1,
                                    MF_BYPOSITION | MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, nMenu + 2,
                                    MF_BYPOSITION | MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, nMenu + 4,
                                    MF_BYPOSITION | MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_CLOSE, MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_SAVE, MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_SAVEAS, MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_RELOAD, MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_PRINT, MF_GRAYED) == 0xffffffff
            || EnableMenuItem (hMenu, CM_PROPERTY, MF_GRAYED) == 0xffffffff)
        {
          MessageBox (hWndClient, _T("EnableMenuItem"),
                                    APPLICATION,MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return FALSE;
        }
      if (!SendMessage (hWndTool, TB_ENABLEBUTTON, CM_SAVE, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PRINT, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PROPERTY, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_UNDO, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_REDO, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_CUT, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_COPY, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PASTE, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_DELETE, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_FIND, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_REPLACE, FALSE))
        {
          MessageBox (hWndClient, _T("TB_ENABLEBUTTON"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return FALSE;
        }
    }
  if (!DrawMenuBar (hWndMain))
    {
      MessageBox (hWndClient, _T("DrawMenuBar"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  return TRUE;
}


/*  ja:w͈͂ĕ`悷
         hWnd,EChE
    lpptStart,Jn
      lpptEnd,I
          RET,TRUE:I,FALSE:G[                                    */
BOOL
ClearSel (HWND    hWnd,
          LPPOINT lpptStart,
          LPPOINT lpptEnd)
{
  RECT rc;
  LPTEXTWND ptw;

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  if (lpptStart->y == lpptEnd->y)
    {
      /* ja:s */
      int nStart, nEnd;

      nStart = GetAlignPos (&ptw->lpStart, &ptw->nOff,
            min (lpptStart->x, lpptEnd->x), lpptStart->y, ptw->nTab, FALSE);
      nEnd = GetAlignPos (&ptw->lpStart, &ptw->nOff,
            max (lpptStart->x, lpptEnd->x), lpptStart->y, ptw->nTab, TRUE);
      rc.left = (nStart - ptw->ptTop.x) * ptw->nFontSize;
      rc.top = (lpptStart->y - ptw->ptTop.y) * ptw->nFontSize * 2;
      rc.right = (nEnd - ptw->ptTop.x + 1) * ptw->nFontSize;
      rc.bottom = rc.top + ptw->nFontSize * 2;
    }
  else
    {
      /* ja:Ⴄs */
      rc.left = 0;
      rc.top = (min (lpptStart->y, lpptEnd->y) - ptw->ptTop.y)
                                                        * ptw->nFontSize * 2;
      rc.right = ptw->siWnd.cx;
      rc.bottom = (max (lpptStart->y, lpptEnd->y) - ptw->ptTop.y + 1)
                                                        * ptw->nFontSize * 2;
    }
  if (rc.left < 0)
    rc.left = 0;
  if (rc.top < 0)
    rc.top = 0;
  if (rc.right > ptw->siWnd.cx)
    rc.right = ptw->siWnd.cx;
  if (rc.bottom > ptw->siWnd.cy)
    rc.bottom = ptw->siWnd.cy;
  if (rc.left < rc.right && rc.top < rc.bottom
                                        && !InvalidateRect (hWnd, &rc, TRUE))
    {
      MessageBox (hWnd, _T("InvalidateRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  return TRUE;
}


/*  ja:ړ
       hWnd,EChE
    lpptTop,Â̍W
        RET,TRUE:I,FALSE:G[                                      */
BOOL
MoveTextWindow (HWND    hWnd,
                LPPOINT lpptTop)
{
  LPTEXTWND ptw;

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  if (ptw->ptTop.x != lpptTop->x || ptw->ptTop.y != lpptTop->y)
    {
      int sx, sy;

      sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
      sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
      SetScrollBar (hWnd, SB_HORZ, 0, GetWidthMax (ptw), sx, ptw->ptTop.x);
      SetScrollBar (hWnd, SB_VERT, 0, ptw->nMax - 1, sy, ptw->ptTop.y);
      if (abs (ptw->ptTop.x - lpptTop->x) * ptw->nFontSize >= ptw->siWnd.cx
        || abs (ptw->ptTop.y - lpptTop->y) * ptw->nFontSize * 2
                                                            >= ptw->siWnd.cy)
        {
          /* ja:1ʂ𒴂ړ */
          if (!InvalidateRect (hWnd, NULL, TRUE))
            {
              MessageBox (hWnd, _T("InvalidateRect"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return FALSE;
            }
        }
      else
        {
          /* ja:1ʈȓ̈ړ */
          RECT rc;

          rc.left = rc.top = 0;
          rc.right = ptw->siWnd.cx;
          rc.bottom = ptw->siWnd.cy;
          ScrollWindowEx (hWnd, (lpptTop->x - ptw->ptTop.x) * ptw->nFontSize,
                            (lpptTop->y - ptw->ptTop.y) * ptw->nFontSize * 2,
                            NULL, &rc, NULL, NULL, SW_ERASE | SW_INVALIDATE);
        }
    }
  return TRUE;
}


/*  ja:LbgʒuɃf[^}/㏑
        hWnd,EChE
    lpszText,f[^i[|C^
     nLength,f[^̃oCg
      fCaret,TRUE:ړ,FALSE:ړȂ
     fSelect,TRUE:I,FALSE:IȂ
         RET,t̑sDOING\,NULL:G[                          */
LPDOING
EditOperation (HWND  hWnd,
               LPSTR lpszText,
               int   nLength,
               BOOL  fCaret,
               BOOL  fSelect)
{
  int sx, sy, nMax;
  LPDOING d;
  POINT ptTop;
  LPTEXTWND ptw;

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
  ptTop = ptw->ptTop;
  sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
  sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
  d = MemoryAlloc (sizeof (DOING));
  HideCaret (hWnd);
  if (ptw->ptSelect.x < 0)
    {
      d->lpszText = NULL;
      d->nLength = 0;
      d->fCaret = FALSE;
    }
  else
    {
      /* ja:폜 */
      int i, nDelete;
      LPLINEBUF p;
      POINT ptCursor;
      RECT rc1;

      d->nLength = GetSelByte (&ptw->lpStart, &ptw->nOff,
                                    &ptw->ptCursor, &ptw->ptSelect, ptw->nTab);
      d->lpszText = MemoryAlloc (d->nLength * sizeof (CHAR));
      CpySelMem (&ptw->lpStart, &ptw->nOff,
                    &ptw->ptCursor, &ptw->ptSelect, ptw->nTab, d->lpszText);
      nDelete = DelSelMem (&ptw->lpStart, &ptw->nOff,
                                    &ptw->ptCursor, &ptw->ptSelect, ptw->nTab,
                                            ptw->fLimit ? ptw->nMargin : 0);
      if (ptw->ptSelect.y < ptw->ptCursor.y
                                        || ptw->ptSelect.y == ptw->ptCursor.y
                                        && ptw->ptSelect.x < ptw->ptCursor.x)
        {
          ptCursor = ptw->ptSelect;
          d->fCaret = TRUE;
        }
      else
        {
          ptCursor = ptw->ptCursor;
          d->fCaret = FALSE;
        }
      /* ja:폜s̍폜E(E}[Ŵ߂1) */
      rc1.left = (ptCursor.x - ptw->ptTop.x - 1) * ptw->nFontSize;
      rc1.top = (ptCursor.y - ptw->ptTop.y) * ptw->nFontSize * 2;
      rc1.right = ptw->siWnd.cx;
      rc1.bottom = rc1.top + ptw->nFontSize * 2;
      if (!InvalidateRect (hWnd, &rc1, TRUE))
        {
          MessageBox (hWnd, _T("InvalidateRect"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          MemoryFree (d->lpszText);
          MemoryFree (d);
          DestroyWindow (hWndMain);
          return NULL;
        }
      /* ja:sXN[ */
      if (nDelete > 0)
        if (nDelete * ptw->nFontSize * 2 >= ptw->siWnd.cy)
          {
            if (!InvalidateRect (hWnd, NULL, TRUE))
              {
                MessageBox (hWnd, _T("InvalidateRect"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                MemoryFree (d->lpszText);
                MemoryFree (d);
                DestroyWindow (hWndMain);
                return NULL;
              }
          }
        else
          {
            RECT rc2;

            rc1.left = 0;
            rc1.top = (ptCursor.y - ptw->ptTop.y + 1) * ptw->nFontSize * 2;
            rc1.right = ptw->siWnd.cx;
            rc1.bottom = ptw->siWnd.cy;
            rc2 = rc1;
            ScrollWindowEx (hWnd, 0, -nDelete * ptw->nFontSize * 2,
                            &rc1, &rc2, NULL, NULL, SW_ERASE | SW_INVALIDATE);
          }
      ptw->nMax -= nDelete;/* ja:s */
      /* ja:I͈͉ƃLbgړ */
      ptw->ptCursor = ptCursor;
      ptw->ptSelect.x = -1;
      /* ja:폜IʒuE}[W̉ês */
      for (i = 0, p = GetLineBuffer (&ptw->lpStart, &ptw->nOff,
                                        ptw->ptCursor.y); p; i++, p = p->next)
        if (!p->fMargin)
          break;
      if (i > 0)
        {
          rc1.left = 0;
          rc1.top = (ptw->ptCursor.y - ptw->ptTop.y + 1) * ptw->nFontSize * 2;
          rc1.right = ptw->siWnd.cx;
          rc1.bottom = rc1.top + i * ptw->nFontSize * 2;
          if (!InvalidateRect (hWnd, &rc1, TRUE))
            {
              MessageBox (hWnd, _T("InvalidateRect"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              MemoryFree (d->lpszText);
              MemoryFree (d);
              DestroyWindow (hWndMain);
              return NULL;
            }
        }
    }
  if (nLength <= 0 || !lpszText)
    {
      d->ptCursor = ptw->ptCursor;
      d->ptSelect.x = -1;
    }
  else
    {
      /* ja:} */
      int i, j, nPut;
      LPLINEBUF p, q;
      POINT ptCursor;
      RECT rc1;

      ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
      nPut = PutMem (&ptw->lpStart, &ptw->nOff, &ptw->ptCursor, &ptCursor,
                ptw->nTab, lpszText, nLength, ptw->fLimit ? ptw->nMargin : 0);
      if (nPut < 0)
        {
          MessageBox (hWnd, _T("PutMem"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          MemoryFree (d->lpszText);
          MemoryFree (d);
          DestroyWindow (hWndMain);
          return NULL;
        }
      /* ja:}s̑}E */
      rc1.left = (ptw->ptCursor.x - ptw->ptTop.x) * ptw->nFontSize;
      rc1.top = (ptw->ptCursor.y - ptw->ptTop.y) * ptw->nFontSize * 2;
      rc1.right = ptw->siWnd.cx;
      rc1.bottom = rc1.top + ptw->nFontSize * 2;
      if (!InvalidateRect (hWnd, &rc1, TRUE))
        {
          MessageBox (hWnd, _T("InvalidateRect"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          MemoryFree (d->lpszText);
          MemoryFree (d);
          DestroyWindow (hWndMain);
          return NULL;
        }
      /* ja:sXN[ */
      if (nPut > 0)
        if (nPut * ptw->nFontSize * 2 >= ptw->siWnd.cy)
          {
            if (!InvalidateRect (hWnd, NULL, TRUE))
              {
                MessageBox (hWnd, _T("InvalidateRect"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                MemoryFree (d->lpszText);
                MemoryFree (d);
                DestroyWindow (hWndMain);
                return NULL;
              }
          }
        else
          {
            RECT rc2;

            rc1.left = 0;
            rc1.top = (ptw->ptCursor.y - ptw->ptTop.y + 1)
                                                        * ptw->nFontSize * 2;
            rc1.right = ptw->siWnd.cx;
            rc1.bottom = ptw->siWnd.cy;
            rc2 = rc1;
            ScrollWindowEx (hWnd, 0, nPut * ptw->nFontSize * 2,
                            &rc1, &rc2, NULL, NULL, SW_ERASE | SW_INVALIDATE);
          }
      /* ja:}IʒuE}[W̉ês */
      p = q = GetLineBuffer (&ptw->lpStart, &ptw->nOff, ptCursor.y);
      for (i = ptCursor.y, j = 0;
                            p->prev && p->prev->fMargin && ptw->ptCursor.y < i;
                                                        i--, j++, p = p->prev);
      while (q->next && q->fMargin)
        j++, q = q->next;
      if (j > 0)
        {
          rc1.left = 0;
          rc1.top = (i - ptw->ptTop.y + 1) * ptw->nFontSize * 2;
          rc1.right = ptw->siWnd.cx;
          rc1.bottom = rc1.top + j * ptw->nFontSize * 2;
          if (!InvalidateRect (hWnd, &rc1, TRUE))
            {
              MessageBox (hWnd, _T("InvalidateRect"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              MemoryFree (d->lpszText);
              MemoryFree (d);
              DestroyWindow (hWndMain);
              return NULL;
            }
        }
      ptw->nMax += nPut;/* ja:s */
      if (fCaret)
        {
          /* ja:Lbgړ */
          d->ptCursor = ptCursor;
          d->ptSelect = ptw->ptCursor;
          ptw->ptCursor = ptCursor;
        }
      else
        {
          /* ja:LbgړȂ */
          d->ptCursor = ptw->ptCursor;
          d->ptSelect = ptCursor;
        }
      if (fSelect)/* ja:I */
        ptw->ptSelect = d->ptSelect;
    }
  if (ptw->ptCursor.x < ptw->ptTop.x)
    ptw->ptTop.x = ptw->ptCursor.x;
  else if (ptw->ptCursor.x - sx + 1 > ptw->ptTop.x)
    ptw->ptTop.x = ptw->ptCursor.x - sx + 1;
  if (ptw->ptCursor.y < ptw->ptTop.y)
    ptw->ptTop.y = ptw->ptCursor.y;
  else if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
    ptw->ptTop.y = ptw->ptCursor.y - sy + 1;
  if (ptw->ptTop.y > ptw->nMax - sy)
    ptw->ptTop.y = max (ptw->nMax - sy, 0);
  nMax = GetWidthMax (ptw);
  if (ptw->ptTop.x > nMax - sx + 1)
    ptw->ptTop.x = max (nMax - sx + 1, 0);
  if (!DrawCaret (hWnd))
    {
      MemoryFree (d->lpszText);
      MemoryFree (d);
      return NULL;
    }
  SetScrollBar (hWnd, SB_HORZ, 0, nMax, sx, ptw->ptTop.x);
  SetScrollBar (hWnd, SB_VERT, 0, ptw->nMax - 1, sy, ptw->ptTop.y);
  if (!MoveTextWindow (hWnd, &ptTop))
    {
      MemoryFree (d->lpszText);
      MemoryFree (d);
      return NULL;
    }
  ShowCaret (hWnd);
  return d;
}


/*  ja:Xg폜
    lpDo,Xg̐擪
     RET,폜Xg̐                                                 */
int
DeleteList (DOING **lpDo)
{
  int nCount = 0;
  LPDOING d0, d1;

  for (d0 = *lpDo; d0; d0 = d1)
    {
      MemoryFree (d0->lpszText);
      d1 = d0->next;
      MemoryFree (d0);
      nCount++;
    }
  *lpDo = NULL;
  return nCount;
}


/*  ja:E}[WŐ܂Ԃ
    ptw,TXTEChE
    RET,TRUE:I,FALSE:G[                                          */
BOOL
ModifyMargin (LPTEXTWND ptw)
{
  LPLINEBUF p;

  /* ja:Cobt@̐擪ֈړ */
  while (ptw->lpStart->prev)
    ptw->lpStart = ptw->lpStart->prev;
  ptw->nOff = 0;
  p = ptw->lpStart;
  if (ptw->fLimit)
    /* ja:E}[Wɂs */
    while (p)
      {
        int nDataPos = 0, nScreenPos = 0;

        while (nDataPos < p->nLength)
          if (p->lpszText[nDataPos] == '\t')
            {
              nScreenPos = (nScreenPos / ptw->nTab + 1) * ptw->nTab;
              if (ptw->nMargin < nScreenPos)
                break;
              nDataPos++;
            }
          else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
            {
              nScreenPos++;
              if (ptw->nMargin < nScreenPos)
                break;
              nDataPos++;
            }
          else
            {
              nScreenPos += 2;
              if (ptw->nMargin < nScreenPos)
                break;
              nDataPos += 2;
            }
        if (ptw->nMargin < nScreenPos)
          {
            /* ja:E}[W𒴂ĂƂA[s */
            LPLINEBUF q;

            q = MemoryAlloc (sizeof (LINEBUF));
            q->nLength = p->nLength - nDataPos;
            q->fMargin = p->fMargin;
            q->lpszText = MemoryAlloc (q->nLength * sizeof (CHAR));
            q->prev = p;
            q->next = p->next;
            p->next = q;
            if (q->next)
              q->next->prev = q;
            MemoryCopy (q->lpszText, p->lpszText + nDataPos,
                                                q->nLength * sizeof (CHAR));
            p->nLength = nDataPos;
            p->fMargin = TRUE;
            p->lpszText = MemoryReAlloc (p->lpszText,
                                                p->nLength * sizeof (CHAR));
            p = q;
            ptw->nMax++;
          }
        else if (nScreenPos < ptw->nMargin && p->fMargin && p->next)
          {
            /* ja:E}[W[ŝƂA̍sƂ킹 */
            LPLINEBUF q;

            nDataPos = p->nLength;
            q = p->next;
            if (q->next)
              q->next->prev = p;
            p->next = q->next;
            p->nLength += q->nLength;
            p->fMargin = q->fMargin;
            p->lpszText = MemoryReAlloc (p->lpszText,
                                                p->nLength * sizeof (CHAR));
            MemoryCopy (p->lpszText + nDataPos, q->lpszText,
                                                q->nLength * sizeof (CHAR));
            MemoryFree (q->lpszText);
            MemoryFree (q);
            ptw->nMax--;
          }
        else
          {
            p = p->next;
          }
      }
  else
    /* ja:E}[WɂsȂ */
    while (p)
      if (p->fMargin)
        {
          /* ja:[ŝƂA̍sƂ킹 */
          int nDataPos;
          LPLINEBUF q;

          nDataPos = p->nLength;
          q = p->next;
          if (q->next)
            q->next->prev = p;
          p->next = q->next;
          p->nLength += q->nLength;
          p->fMargin = q->fMargin;
          p->lpszText = MemoryReAlloc (p->lpszText,
                                                p->nLength * sizeof (CHAR));
          MemoryCopy (p->lpszText + nDataPos, q->lpszText,
                                                q->nLength * sizeof (CHAR));
          MemoryFree (q->lpszText);
          MemoryFree (q);
          ptw->nMax--;
        }
      else
        {
          p = p->next;
        }
  return TRUE;
}


/*  ja:vpeBύX
       hWnd,EChE
    lpFType,t@C^Cv
        RET,TRUE:I,FALSE:G[                                      */
BOOL
ChangeProperty (HWND       hWnd,
                LPFILETYPE lpFType)
{
  int sx, sy, nMax, nMargin, nTab;
  BOOL fLimit;
  HDC hDC;
  LOGFONT logfont;
  LPTEXTWND ptw;
  TEXTMETRIC tm;

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  if (ptw->fLimit != lpFType->fLimit || ptw->nTab != lpFType->nTab
                            || ptw->fLimit && ptw->nMargin != lpFType->nMargin)
    {
      /* ja:܂Ԃ̐ݒύXA^uύX */
      DeleteList (&ptw->lpUndo);
      DeleteList (&ptw->lpRedo);
    }
  fLimit = ptw->fLimit;
  nMargin = ptw->nMargin;
  nTab = ptw->nTab;
  ptw->nID = lpFType->nID;
  ptw->nMargin = lpFType->nMargin;
  ptw->nTab = lpFType->nTab;
  ptw->fAssociate = lpFType->fAssociate;
  ptw->fAutoIndent = lpFType->fAutoIndent;
  ptw->fCode = lpFType->fCode;
  ptw->fCRLF = lpFType->fCRLF;
  ptw->fEOF = lpFType->fEOF;
  ptw->fLimit = lpFType->fLimit;
  ptw->fOverWrite = lpFType->fOverWrite;
  ptw->fRecycle = lpFType->fRecycle;
  ptw->fSpace = lpFType->fSpace;
  ptw->fSysColor = lpFType->fSysColor;
  ptw->fTabConv = lpFType->fTabConv;
  ptw->fGline = lpFType->fGline;
  ptw->fMline = lpFType->fMline;
  ptw->fUline = lpFType->fUline;
  ptw->fVline = lpFType->fVline;
  if (lpFType->uRetCode > 0)
    ptw->uRetCode = lpFType->uRetCode;
  if (lpFType->uCharSet > 0)
    ptw->uCharSet = lpFType->uCharSet;
  MemoryCopy (ptw->crColor, lpFType->crColor, sizeof (COLORREF) * 12);
  ptw->lf = lpFType->lf;
  if (fLimit != ptw->fLimit || fLimit
                    && (nTab != lpFType->nTab || nMargin != lpFType->nMargin))
    {
      /* ja:܂Ԃ̐ݒύXA܂ԂLŃ^uύX */
      ptw->ptCursor.x = ptw->ptCursor.y = ptw->ptTop.x = ptw->ptTop.y = 0;
      if (!ModifyMargin (ptw))
        {
          MessageBox (hWnd, _T("ModifyMargin"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return FALSE;
        }
    }
  ptw->ptSelect.x = -1;
  if ((ptw->hBrushWindow && !DeleteObject (ptw->hBrushWindow))
        | (ptw->hBrushSpace && !DeleteObject (ptw->hBrushSpace))
        | (ptw->hBrushCrlf && !DeleteObject (ptw->hBrushCrlf))
        | (ptw->hBrushHighLight && !DeleteObject (ptw->hBrushHighLight))
        | (ptw->hPenTab && !DeleteObject (ptw->hPenTab))
        | (ptw->hPenMargin && !DeleteObject (ptw->hPenMargin))
        | (ptw->hPenGrid && !DeleteObject (ptw->hPenGrid))
        | (ptw->hFont && !DeleteObject (ptw->hFont))
        | (ptw->hFontsm && !DeleteObject (ptw->hFontsm)))
    {
      MessageBox (hWnd, _T("DeleteObject"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      ptw->hBrushWindow = ptw->hBrushSpace = ptw->hBrushHighLight = NULL;
      ptw->hPenTab = ptw->hPenMargin = ptw->hPenGrid = NULL;
      ptw->hFont = ptw->hFontsm = NULL;
      DestroyWindow (hWndMain);
      return FALSE;
    }
  ptw->hBrushWindow = ptw->hBrushSpace = ptw->hBrushHighLight = NULL;
  ptw->hPenTab = ptw->hPenMargin = ptw->hPenGrid = NULL;
  ptw->hFont = ptw->hFontsm = NULL;
  if (!ptw->fSysColor)
    {
      ptw->hBrushWindow = CreateSolidBrush (ptw->crColor[1]);
      ptw->hBrushSpace = CreateSolidBrush (ptw->crColor[3]);
      ptw->hBrushCrlf = CreateSolidBrush (ptw->crColor[4]);
      ptw->hBrushHighLight = CreateSolidBrush (ptw->crColor[9]);
      if (!ptw->hBrushWindow || !ptw->hBrushSpace
                                || !ptw->hBrushCrlf || !ptw->hBrushHighLight)
        {
          MessageBox (hWnd, _T("CreateSolidBrush"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return FALSE;
        }
      ptw->hPenTab = CreatePen (PS_SOLID, 0, ptw->crColor[5]);
      ptw->hPenMargin = CreatePen (PS_SOLID, 0, ptw->crColor[6]);
      ptw->hPenGrid = CreatePen (PS_SOLID, 0, ptw->crColor[7]);
      if (!ptw->hPenTab || !ptw->hPenMargin || !ptw->hPenGrid)
        {
          MessageBox (hWnd, _T("CreatePen"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return FALSE;
        }
    }
  logfont = ptw->lf;
  logfont.lfHeight /= 2;
  ptw->hFont = CreateFontIndirect (&ptw->lf);
  ptw->hFontsm = CreateFontIndirect (&logfont);
  if (!ptw->hFont || !ptw->hFontsm)
    {
      MessageBox (hWnd, _T("CreateFontIndirect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  hDC = GetDC (hWnd);
  if (!hDC)
    {
      MessageBox (hWnd, _T("GetDC"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  ptw->hFont = SelectObject (hDC, ptw->hFont);
  if (!GetTextMetrics (hDC, &tm))
    {
      MessageBox (hWnd, _T("GetTextMetrics"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      SelectObject (hDC, ptw->hFont);
      ReleaseDC (hWnd, hDC);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  ptw->hFont = SelectObject (hDC, ptw->hFont);
  if (ReleaseDC (hWnd, hDC) != 1)
    {
      MessageBox (hWnd, _T("ReleaseDC"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  ptw->nFontSize = (tm.tmHeight + 1) / 2;
  sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
  sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
  if (ptw->ptTop.y > ptw->nMax - sy)
    ptw->ptTop.y = max (ptw->nMax - sy, 0);
  nMax = GetWidthMax (ptw);
  if (ptw->ptTop.x > nMax - sx + 1)
    ptw->ptTop.x = max (nMax - sx + 1, 0);
  SetScrollBar (hWnd, SB_HORZ, 0, nMax, sx, ptw->ptTop.x);
  SetScrollBar (hWnd, SB_VERT, 0, ptw->nMax - 1, sy, ptw->ptTop.y);
  SetImeFont (hWnd, &ptw->lf);
  if (!SetMenuBar (ptw))
    return FALSE;
  CreateCaret (hWnd, (HBITMAP)0,
                        uIns != 0 ? ptw->nFontSize : 2, ptw->nFontSize * 2);
  if (!DrawCaret (hWnd))
    return FALSE;
  if (!InvalidateRect (hWnd, NULL, TRUE))
    {
      MessageBox (hWnd, _T("InvalidateRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  ShowCaret (hWnd);
  return TRUE;
}


BOOL CALLBACK
PropertyEnumProc (HWND hWnd, LPARAM lParam)
{
  TCHAR szText[MAXPATH + 2];

  GetClassName (hWnd, szText, MAXPATH - 1);
  return lstrcmp (szText, TEXTCLASS) == 0
    && ((LPFILETYPE)lParam)->nID == ((LPTEXTWND)GetWindowLong (hWnd, 0))->nID
                            ? ChangeProperty (hWnd, (LPFILETYPE)lParam) : TRUE;
}


/*  ja:WXg֏                                                 */
VOID
RegWrite (VOID)
{
  int i, nMenu;
  DWORD dwResult;
  FILETIME filetime;
  HKEY hKey, hKeySub;
  HMENU hMenu;
  TCHAR szName[MAXPATH];
  WINDOWPLACEMENT wndpl;

  if (!(nRegStat & 2))
    return;
  wndpl.length = sizeof (WINDOWPLACEMENT);
  if (!GetWindowPlacement (hWndMain, &wndpl))
    {
      MessageBox (hWndMain, _T("GetWindowPlacement"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      return;
    }
  if (RegOpenKeyEx (HKEY_CURRENT_USER, _T("Software\\maid.org\\Text maid"),
                                    0, KEY_ALL_ACCESS, &hKey) != ERROR_SUCCESS)
    {
      if (!(nRegStat & 4) && MessageBox (hWndMain,
            LoadText (hInst, IDS_OTHER_REG), APPLICATION, MB_OKCANCEL) != IDOK)
        return;
      if (RegCreateKeyEx (HKEY_CURRENT_USER,
                            _T("Software\\maid.org\\Text maid"),
                            0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                                    NULL, &hKey, &dwResult) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegCreateKeyEx"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          return;
        }
    }
  /* ja:TuL[폜 */
  while (dwResult = MAXPATH, RegEnumKeyEx (hKey, 0, szName, &dwResult,
                                NULL, NULL, NULL, &filetime) == ERROR_SUCCESS)
    if (RegDeleteKey (hKey, szName) != ERROR_SUCCESS)
      {
        MessageBox (NULL, _T("RegDeleteKey"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        RegCloseKey (hKey);
        return;
      }
  /* ja:L[̒l폜 */
  while (dwResult = MAXPATH, RegEnumValue (hKey, 0, szName, &dwResult,
                                    NULL, NULL, NULL, NULL) == ERROR_SUCCESS)
    if (RegDeleteValue (hKey, szName) != ERROR_SUCCESS)
      {
        MessageBox (NULL, _T("RegDeleteValue"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        RegCloseKey (hKey);
        return;
      }
  if (RegSetValueEx (hKey, _T("CodeDef"), 0, REG_DWORD,
                            (LPBYTE)&nCodeDef, sizeof (int)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("Filter"), 0 ,REG_DWORD,
                            (LPBYTE)&dwFilter, sizeof (DWORD)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("History"), 0, REG_DWORD,
                            (LPBYTE)&nHistory, sizeof (int)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("Zoomed"), 0, REG_DWORD,
                            (LPBYTE)&fZoomed, sizeof (BOOL)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("OpenPath"), 0, REG_SZ,
                                                            (LPBYTE)szOpenPath,
                (lstrlen (szOpenPath) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("SavePath"), 0, REG_SZ,
                                                            (LPBYTE)szSavePath,
                (lstrlen (szSavePath) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("Rect"), 0, REG_BINARY,
                                            (LPBYTE)&wndpl.rcNormalPosition,
                                            sizeof (RECT)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("FileType"), 0, REG_DWORD,
                            (LPBYTE)&nFileType, sizeof (int)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("FindNum"), 0, REG_DWORD,
                        (LPBYTE)&nFind, sizeof (int)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("FindArrow"), 0, REG_DWORD,
                        (LPBYTE)&bFindArrow, sizeof (BOOL)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("FindCase"), 0, REG_DWORD,
                        (LPBYTE)&bFindCase, sizeof (BOOL)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("FindWidth"), 0, REG_DWORD,
                        (LPBYTE)&bFindWidth, sizeof (BOOL)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("ReplaceNum"), 0, REG_DWORD,
                        (LPBYTE)&nReplace, sizeof (int)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("ReplaceArrow"), 0, REG_DWORD,
                        (LPBYTE)&bReplaceArrow, sizeof (BOOL)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("ReplaceCase"), 0, REG_DWORD,
                        (LPBYTE)&bReplaceCase, sizeof (BOOL)) != ERROR_SUCCESS
            || RegSetValueEx (hKey, _T("ReplaceWidth"), 0, REG_DWORD,
                    (LPBYTE)&bReplaceWidth, sizeof (BOOL)) != ERROR_SUCCESS)
    {
      MessageBox (NULL, _T("RegSetValueEx"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      RegCloseKey (hKey);
      return;
    }
  /* ja:t@C^Cv */
  for (i = 0; i < nFileType; i++)
    {
      wsprintf (szName, _T("FileType%04d"), i);
      if (RegCreateKeyEx (hKey, szName, 0, _T(""), REG_OPTION_NON_VOLATILE,
                KEY_ALL_ACCESS, NULL, &hKeySub, &dwResult) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegCreateKeyEx"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          RegCloseKey (hKey);
          return;
        }
      if (RegSetValueEx (hKeySub, _T("Text"), 0, REG_SZ,
                                                (LPBYTE)lpFileType[i].szText,
        (lstrlen (lpFileType[i].szText) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Ext"), 0, REG_SZ,
                                                (LPBYTE)lpFileType[i].szExt,
        (lstrlen (lpFileType[i].szExt) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Margin"), 0, REG_DWORD,
                (LPBYTE)&lpFileType[i].nMargin, sizeof (int)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Tab"), 0, REG_DWORD,
                (LPBYTE)&lpFileType[i].nTab, sizeof (int)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Auto"), 0, REG_DWORD,
                (LPBYTE)&lpFileType[i].dwAuto, sizeof (DWORD)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("LogFont"), 0, REG_BINARY,
                (LPBYTE)&lpFileType[i].lf, sizeof (LOGFONT)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Color"), 0, REG_BINARY,
                                    (LPBYTE)lpFileType[i].crColor,
                                    sizeof (COLORREF) * 12) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Associate"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fAssociate, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("AutoIndent"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fAutoIndent, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Code"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fCode, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("CRLF"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fCRLF, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("EOF"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fEOF, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Limit"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fLimit, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("OverWrite"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fOverWrite, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Recycle"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fRecycle, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Space"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fSpace, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("SysColor"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fSysColor, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("TabConv"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fTabConv, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Gline"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fGline, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Mline"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fMline, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Uline"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fUline, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Vline"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].fVline, sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("RetCode"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].uRetCode, sizeof (UINT)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("CharSet"), 0, REG_DWORD,
            (LPBYTE)&lpFileType[i].uCharSet, sizeof (UINT)) != ERROR_SUCCESS)
          {
            MessageBox (NULL, _T("RegSetValueEx"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            RegCloseKey( hKeySub);
            RegCloseKey (hKey);
            return;
          }
      if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegCreateKeyEx"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          RegCloseKey (hKey);
          return;
        }
    }
  /* ja: */
  if (RegCreateKeyEx (hKey, _T("Find"), 0, _T(""), REG_OPTION_NON_VOLATILE,
                KEY_ALL_ACCESS, NULL, &hKeySub, &dwResult) != ERROR_SUCCESS)
    {
      MessageBox (NULL, _T("RegCreateKeyEx"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      RegCloseKey (hKey);
      return;
    }
  for (i = 0; i < nFind; i++)
    {
      wsprintf (szName, _T("Find%02d"), i);
      if (RegSetValueEx (hKeySub, szName, 0, REG_SZ, (LPBYTE)lpszFind[i],
                (lstrlen (lpszFind[i]) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegSetValueEx"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          RegCloseKey (hKeySub);
          RegCloseKey (hKey);
          return;
        }
    }
  if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
    {
      MessageBox (NULL, _T("RegCloseKey"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      RegCloseKey (hKey);
      return;
    }
  /* ja:u */
  if (RegCreateKeyEx (hKey, _T("Replace"), 0, _T(""), REG_OPTION_NON_VOLATILE,
                KEY_ALL_ACCESS, NULL, &hKeySub, &dwResult) != ERROR_SUCCESS)
    {
      MessageBox (NULL, _T("RegCreateKeyEx"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      RegCloseKey (hKey);
      return;
    }
  for (i = 0; i < nReplace; i++)
    {
      wsprintf (szName, _T("Replace%02d"), i);
      if (RegSetValueEx (hKeySub, szName, 0, REG_SZ, (LPBYTE)lpszReplace[i],
            (lstrlen (lpszReplace[i]) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegSetValueEx"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          RegCloseKey (hKeySub);
          RegCloseKey (hKey);
          return;
        }
    }
  if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
    {
      MessageBox (NULL, _T("RegCloseKey"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      RegCloseKey (hKey);
      return;
    }
  /* ja: */
  hMenu = GetMenu (hWndMain);
  if (!hMenu)
    {
      MessageBox (NULL, _T("GetMenu"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      RegCloseKey (hKey);
      return;
    }
  hMenu = GetSubMenu (hMenu, GetMenuItemCount (hMenu) != MENUTOP);
  if (!hMenu)
    {
      MessageBox (NULL, _T("GetSubMenu"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      RegCloseKey (hKey);
      return;
    }
  nMenu = GetMenuItemCount (hMenu);
  for (i = 0; i < nMenu - MENUFILE - 1; i++)
    {
      TCHAR szHistory[MAXPATH + 3];

      GetMenuString (hMenu, i + MENUFILE - 1,
                                        szHistory, MAXPATH + 2, MF_BYPOSITION);
      wsprintf (szName, _T("History%d"), i);
      if (RegSetValueEx (hKey, szName, 0, REG_SZ, (LPBYTE)(szHistory + 3),
            (lstrlen (szHistory + 3) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegSetValueEx"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          RegCloseKey (hKey);
          return;
        }
    }
  if (RegCloseKey (hKey) != ERROR_SUCCESS)
    MessageBox (NULL, _T("RegCreateKeyEx"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
}


/******************************************************************************
*                                                                             *
* ja:x֐Q                                                           *
*                                                                             *
******************************************************************************/
/*  ja:ҏW𑀍
     hWnd,EChE
    fKind,TRUE:redo,FALSE:undo
      RET,TRUE:I,FALSE:G[                                        */
BOOL
HistoryOperation (HWND hWnd,
                  BOOL fKind)
{
  LPDOING d0, d1;
  LPTEXTWND ptw;

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  if (fKind)
    {
      d0 = ptw->lpRedo;
      ptw->lpRedo = d0->next;
    }
  else
    {
      d0 = ptw->lpUndo;
      ptw->lpUndo = d0->next;
    }
  if (ptw->ptSelect.x >= 0 && !ClearSel (hWnd, &ptw->ptSelect, &ptw->ptCursor))
    return FALSE;
  ptw->ptCursor = d0->ptCursor;
  ptw->ptSelect = d0->ptSelect;
  d1 = EditOperation (hWnd, d0->lpszText, d0->nLength, d0->fCaret, TRUE);
  if (!d1)
    return FALSE;
  if (fKind)
    {
      d1->next = ptw->lpUndo;
      ptw->lpUndo = d1;
    }
  else
    {
      d1->next = ptw->lpRedo;
      ptw->lpRedo = d1;
    }
  MemoryFree (d0->lpszText);
  MemoryFree (d0);
  HideCaret (hWnd);
  if (!SetMenuBar (ptw))
    return FALSE;
  ShowCaret (hWnd);
  return TRUE;
}


/*  ja:E}[Wŉs
    hWnd,EChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
MarginOperation (HWND hWnd)
{
  BOOL fLimit;
  LPTEXTWND ptw;
  LPLINEBUF p;

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  DeleteList (&ptw->lpUndo);
  DeleteList (&ptw->lpRedo);
  fLimit = ptw->fLimit;
  ptw->fLimit = TRUE;
  if (!ModifyMargin (ptw))
    {
      MessageBox (hWnd, _T("ModifyMargin"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  for (p = ptw->lpStart; p->prev; p = p->prev);
  while (p)
    {
      p->fMargin = FALSE;
      p = p->next;
    }
  ptw->fLimit = fLimit;
  ptw->fEdit = TRUE;
  ptw->ptCursor.x = ptw->ptCursor.y = ptw->ptTop.x = ptw->ptTop.y = 0;
  ptw->ptSelect.x = -1;
  SetScrollBar (hWnd, SB_HORZ, 0, GetWidthMax (ptw),
                max (ptw->siWnd.cx / ptw->nFontSize, 1), ptw->ptTop.x);
  SetScrollBar (hWnd, SB_VERT, 0, ptw->nMax - 1,
                max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1), ptw->ptTop.y);
  if (!SetMenuBar (ptw) || !DrawCaret (hWnd))
    return FALSE;
  if (!InvalidateRect (hWnd, NULL, TRUE))
    {
      MessageBox (hWnd, _T("InvalidateRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  ShowCaret (hWnd);
  return TRUE;
}


/*  ja:^uXy[Xɕϊ
    hWnd,EChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
TabOperation (HWND hWnd)
{
  LPTEXTWND ptw;
  LPLINEBUF p;

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  DeleteList (&ptw->lpUndo);
  DeleteList (&ptw->lpRedo);
  for (p = ptw->lpStart; p->prev; p = p->prev);
  while (p)
    {
      int nDataPos = 0, nScreenPos = 0;
      BOOL fTab = FALSE;

      while (nDataPos < p->nLength)
        if (p->lpszText[nDataPos] == '\t')
          {
            nScreenPos = (nScreenPos / ptw->nTab + 1) * ptw->nTab;
            nDataPos++;
            fTab = TRUE;
          }
        else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
          {
            nScreenPos++;
            nDataPos++;
          }
        else
          {
            nScreenPos += 2;
            nDataPos += 2;
          }
      if (fTab)
        {
          LPSTR lpszTemp;

          lpszTemp = MemoryAlloc (nScreenPos * sizeof (CHAR));
          MemorySet (lpszTemp, ' ', nScreenPos * sizeof (CHAR));
          nDataPos = nScreenPos = 0;
          while (nDataPos < p->nLength)
            if (p->lpszText[nDataPos] == '\t')
              {
                nScreenPos = (nScreenPos / ptw->nTab + 1) * ptw->nTab;
                nDataPos++;
              }
            else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
              {
                lpszTemp[nScreenPos] = p->lpszText[nDataPos];
                nScreenPos++;
                nDataPos++;
              }
            else
              {
                lpszTemp[nScreenPos] = p->lpszText[nDataPos];
                nScreenPos++;
                nDataPos++;
                lpszTemp[nScreenPos] = p->lpszText[nDataPos];
                nScreenPos++;
                nDataPos++;
              }
            MemoryFree (p->lpszText);
            p->nLength = nScreenPos;
            p->lpszText = lpszTemp;
        }
      p = p->next;
    }
  ptw->fEdit = TRUE;
  ptw->ptSelect.x = -1;
  if (!SetMenuBar (ptw) || !DrawCaret (hWnd))
    return FALSE;
  if (!InvalidateRect (hWnd, NULL, TRUE))
    {
      MessageBox (hWnd, _T("InvalidateRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return FALSE;
    }
  return TRUE;
}
