/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "abort.h"
#include "orz/orzmdi.h"


gboolean abort_break;


/******************************************************************************
*                                                                             *
* ja:中断関数群                                                               *
*                                                                             *
******************************************************************************/
static GtkWidget *hbox = NULL;


/* ja:中断ボタンが押された */
static void
abort_box_clicked (GtkWidget *widget,
                   gpointer   user_data)
{
  abort_break = FALSE;
}


/*  ja:中断ボタン取得 */
GtkWidget *
abort_box_get_widget (void)
{
  if (!hbox)
    {
      GtkWidget *button;

      button = gtk_button_new_from_stock (GTK_STOCK_STOP);
      g_signal_connect (G_OBJECT (button), "clicked",
                                        G_CALLBACK (abort_box_clicked), NULL);
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
    }
  return hbox;
}


/*  ja:中断ボタン開始 */
void
abort_box_start (void)
{
  gtk_widget_set_sensitive (main_box, FALSE);
  gtk_widget_show (hbox);
  abort_break = TRUE;
}


/*  ja:中断ボタン終了 */
void
abort_box_end (void)
{
  TmaidWindow *tmaid;

  gtk_widget_set_sensitive (main_box, TRUE);
  gtk_widget_hide (hbox);
  tmaid = orz_mdi_get_data (ORZ_MDI (mdi), -1);
  if (tmaid)
    gtk_widget_grab_focus (tmaid->drawing);
}
