/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "repinfo.h"
#include "replace.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:置換情報ダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ja:置換情報ダイアログ表示
     ri,置換情報
    RET,REPLACE_OK,REPLACE_NEXT,REPLACE_ALL,REPLACE_CANCEL                  */
gint
repinfo_dialog (ReplaceInfo *ri)
{
  gchar *text, *title;
  gint result;
  GtkStockItem stock_item;
  GtkWidget *dialog, *frame0, *frame1, *hbox, *tbox, *vbox;

  /* ja:メインウインドウ */
  gtk_stock_lookup (GTK_STOCK_FIND_AND_REPLACE, &stock_item);
  title = misc_mnemonic_to_text (stock_item.label);
  dialog = gtk_dialog_new_with_buttons
                            (title,
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
#ifdef G_OS_WIN32
                            GTK_STOCK_FIND_AND_REPLACE, REPLACE_OK,
                            _("_All Replace"), REPLACE_ALL,
                            _("_Next"), REPLACE_NEXT,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
#else /* not G_OS_WIN32 */
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            _("_Next"), REPLACE_NEXT,
                            _("_All Replace"), REPLACE_ALL,
                            GTK_STOCK_FIND_AND_REPLACE, REPLACE_OK,
#endif /* not G_OS_WIN32 */
                            NULL);
  g_free (title);
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:フレームとボックス */
  tbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (tbox), SPACING);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Find String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (ri->src ? ri->src : ""), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Replace String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (ri->dst ? ri->dst : ""), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox),
                         gtk_label_new (_("Replace Range")), FALSE, FALSE, 0);
  text = g_strdup_printf (_("(%d,%d)-(%d,%d)"),
            ri->start.x + 1, ri->start.y + 1, ri->end.x + 1, ri->end.y + 1);
  gtk_box_pack_start (GTK_BOX (hbox), gtk_label_new (text), TRUE, TRUE, 0);
  g_free (text);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);

  frame0 = gtk_frame_new (_("Option"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), gtk_label_new (ri->ignorecase
                    ? _("Enable Case") : _("Ignore Case")), FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame0), vbox);

  frame1 = gtk_frame_new (_("Direction"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox),
            gtk_label_new (ri->arrow ? _("Down") : _("Up")), FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), vbox);

  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox), frame0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), frame1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), tbox);

  /* ja:表示 */
  gtk_widget_show_all (tbox);

  result = gtk_dialog_run (GTK_DIALOG (dialog));
  if (result != REPLACE_OK && result != REPLACE_NEXT && result != REPLACE_ALL)
    result = REPLACE_CANCEL;
  gtk_widget_destroy (dialog);

  return result;
}
