/*
    orzcharlist
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __ORZ_CHARLIST_H__
#define __ORZ_CHARLIST_H__


#include "gcommon.h"


G_BEGIN_DECLS


#define ORZ_TYPE_CHARLIST            (orz_charlist_get_type ())
#define ORZ_CHARLIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_CHARLIST, OrzCharlist))
#define ORZ_CHARLIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_CHARLIST, OrzCharlistClass))
#define ORZ_IS_CHARLIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_CHARLIST))
#define ORZ_IS_CHARLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_CHARLIST))
#define ORZ_CHARLIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_CHARLIST, OrzCharlistClass))


typedef struct _OrzCharlist      OrzCharlist;
typedef struct _OrzCharlistClass OrzCharlistClass;

struct _OrzCharlist
{
  /*< private >*/
  GtkDialog parent_instance;

  /*< public >*/
  GtkWidget *ok_button;     /* ja:了解 */
  GtkWidget *cancel_button; /* ja:取消 */

  /*< private >*/
  GtkWidget *add_button;    /* ja:追加 */
  GtkWidget *remove_button; /* ja:削除 */
  GtkWidget *up_button;     /* ja:上へ */
  GtkWidget *down_button;   /* ja:下へ */
  GtkWidget *charset;       /* ja:文字符号化方式 */
  GtkWidget *tview;         /* ja:リスト */
};

struct _OrzCharlistClass
{
  GtkDialogClass parent_class;

  /* -- signals -- */
  void (*escape) (OrzCharlist *charlist);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_charlist_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:文字符号化方式リスト関数群                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
orz_charlist_new (void);


/*  ja:文字符号化方式のリストを取得する
    charlist,ウィジェット
         RET,文字符号化方式のリスト                                         */
gchar *
orz_charlist_get_charlist (OrzCharlist *charlist);


/*  ja:文字符号化方式のリストを設定する
    charlist,ウィジェット
         RET,TRUE:正しい文字符号化方式,FALSE:不正な文字符号化方式           */
gboolean
orz_charlist_set_charlist (OrzCharlist *charlist,
                           const gchar *list);


/*  ja:文字符号化方式を取得する
    charlist,ウィジェット
         RET,文字符号化方式                                                 */
gchar *
orz_charlist_get_charset (OrzCharlist *charlist);


/*  ja:文字符号化方式を設定する
    charlist,ウィジェット
         RET,TRUE:正しい文字符号化方式,FALSE:不正な文字符号化方式           */
gboolean
orz_charlist_set_charset (OrzCharlist *charlist,
                          const gchar *charset);


/*  ja:文字符号化方式の候補を取得する
    charlist,ウィジェット
         RET,文字符号化方式の候補                                           */
gchar *
orz_charlist_get_candidate (OrzCharlist *charlist);


/*  ja:文字符号化方式の候補を追加する
     charlist,ウィジェット
    candidate,文字符号化方式の候補
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
orz_charlist_add_candidate (OrzCharlist *charlist,
                            const gchar *candidate);


/*  ja:文字符号化方式の候補を削除する
     charlist,ウィジェット
    candidate,文字符号化方式の候補,NULL:すべて削除
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
orz_charlist_remove_candidate (OrzCharlist *charlist,
                               const gchar *candidate);


G_END_DECLS


#endif /* __ORZ_CHARLIST_H__ */
