/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "abort.h"
#include "panel.h"
#include "repinfo.h"
#include "misc/misc.h"
#include <gdk/gdkkeysyms.h>


GtkWidget *repinfo_box = NULL;


/******************************************************************************
*                                                                             *
* ja:置換情報ボックス関数群                                                   *
*                                                                             *
******************************************************************************/
static gint response;
static GtkWidget *repinfo_label0;
static GtkWidget *repinfo_label1;
static GtkWidget *repinfo_label2;
static GtkWidget *repinfo_label3;


/* ja:ボタンが押された */
static void
repinfo_box_clicked (GtkWidget *widget,
                     gpointer   user_data)
{
  response = GPOINTER_TO_INT (user_data);
  gtk_main_quit ();
}


/* ja:ESCが押されたとき */
static gboolean
repinfo_key_press (GtkWidget   *widget,
                   GdkEventKey *event,
                   gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    repinfo_box_clicked (widget, GINT_TO_POINTER (REPLACE_CANCEL));
  return FALSE;
}


/*  ja:置換情報ボックス取得
    RET,置換情報ボックス                                                    */
GtkWidget *
repinfo_box_get_widget (void)
{
  if (!repinfo_box)
    {
      GtkWidget *button_cancel, *button_next, *button_all, *button_ok;
      GtkWidget *frame, *hbox, *vbox;

      repinfo_box = gtk_hbox_new (FALSE, SPACING);
      g_signal_connect (G_OBJECT (repinfo_box), "key-press-event",
                                        G_CALLBACK (repinfo_key_press), NULL);
      /* ja:ボタン */
      button_cancel = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
      g_signal_connect (G_OBJECT (button_cancel), "clicked",
                                            G_CALLBACK (repinfo_box_clicked),
                                            GINT_TO_POINTER (REPLACE_CANCEL));
      button_next = gtk_button_new_with_mnemonic (_("_Next"));
      g_signal_connect (G_OBJECT (button_next), "clicked",
                                            G_CALLBACK (repinfo_box_clicked),
                                            GINT_TO_POINTER (REPLACE_NEXT));
      button_all = gtk_button_new_with_mnemonic (_("_All Replace"));
      g_signal_connect (G_OBJECT (button_all), "clicked",
                                            G_CALLBACK (repinfo_box_clicked),
                                            GINT_TO_POINTER (REPLACE_ALL));
      button_ok = gtk_button_new_from_stock (GTK_STOCK_FIND_AND_REPLACE);
      g_signal_connect (G_OBJECT (button_ok), "clicked",
                                            G_CALLBACK (repinfo_box_clicked),
                                            GINT_TO_POINTER (REPLACE_OK));
      /* ja:ラベル */
      repinfo_label0 = gtk_label_new ("");
      repinfo_label1 = gtk_label_new ("");
      repinfo_label2 = gtk_label_new ("");
      repinfo_label3 = gtk_label_new ("");

      /* ja:フレームとボックス */
      vbox = gtk_vbox_new (FALSE, SPACING);
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Find String")), FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), repinfo_label0, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, FALSE, 0);
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Replace String")), FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), repinfo_label1, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (repinfo_box), vbox, TRUE, TRUE, 0);

      frame = gtk_frame_new (_("Option"));
      vbox = gtk_vbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
      gtk_box_pack_start (GTK_BOX (vbox), repinfo_label2, FALSE, FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_box_pack_start (GTK_BOX (repinfo_box), frame, FALSE, FALSE, 0);

      frame = gtk_frame_new (_("Direction"));
      vbox = gtk_vbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
      gtk_box_pack_start (GTK_BOX (vbox), repinfo_label3, FALSE, FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_box_pack_start (GTK_BOX (repinfo_box), frame, FALSE, FALSE, 0);

      vbox = gtk_vbox_new (FALSE, SPACING);
      hbox = gtk_hbox_new (FALSE, SPACING);
#ifdef G_OS_WIN32
      gtk_box_pack_start (GTK_BOX (hbox), button_ok, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), button_all, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), button_next, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), button_cancel, FALSE, FALSE, 0);
#else /* not G_OS_WIN32 */
      gtk_box_pack_start (GTK_BOX (hbox), button_cancel, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), button_next, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), button_all, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), button_ok, FALSE, FALSE, 0);
#endif /* not G_OS_WIN32 */
      gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (repinfo_box), vbox, FALSE, FALSE, 0);
    }
  return repinfo_box;
}


/*  ja:置換情報ボックス表示
     ri,置換情報
    RET,REPLACE_OK,REPLACE_NEXT,REPLACE_ALL,REPLACE_CANCEL                  */
gint
repinfo_run (ReplaceInfo *ri)
{
  gtk_widget_set_sensitive (main_box, FALSE);
  gtk_widget_hide (abort_box);
  gtk_widget_hide (find_box);
  gtk_widget_show (repinfo_box);
  gtk_label_set_text (GTK_LABEL (repinfo_label0), ri->src ? ri->src : "");
  gtk_label_set_text (GTK_LABEL (repinfo_label1), ri->dst ? ri->dst : "");
  gtk_label_set_text (GTK_LABEL (repinfo_label2), ri->ignorecase
                                        ? _("Enable Case") : _("Ignore Case"));
  gtk_label_set_text (GTK_LABEL (repinfo_label3), ri->arrow
                                        ? _("Down") : _("Up"));
  gtk_main ();
  gtk_widget_set_sensitive (main_box, TRUE);
  gtk_widget_show (abort_box);
  gtk_widget_show (find_box);
  gtk_widget_hide (repinfo_box);
  return response;
}
