/*
    gcommon
    copyright (c) 1998-2009 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GCOMMON_H__
#define __GCOMMON_H__


#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */


#include <stdio.h>
#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#elif HAVE_STRINGS_H
# include <strings.h>
#endif /* HAVE_STRINGS_H */
#include <gtk/gtk.h>


#ifndef SPACING
# define SPACING 5
#endif /* not SPACING */


#if defined (USE_THREAD) && ! defined (G_THREADS_ENABLED)
# undef USE_THREAD
#endif /* defined (USE_THREAD) && ! defined (G_THREADS_ENABLED) */


#if ! GLIB_CHECK_VERSION(2,14,0)
typedef gint64 goffset;
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
typedef gint64 glonglong;
typedef guint64 gulonglong;
#if ! GLIB_CHECK_VERSION(2,18,0)
typedef glong gintptr;
typedef gulong guintptr;
#endif /* not GLIB_CHECK_VERSION(2,18,0) */


#ifndef G_GUINT64_CONSTANT
# ifdef _MSC_VER
#  define G_GUINT64_CONSTANT(val) (val##Ui64)
# else /* not _MSC_VER */
#  define G_GUINT64_CONSTANT(val) (G_GNUC_EXTENSION(val##ULL))
# endif /* not _MSC_VER */
#endif /* not G_GUINT64_CONSTANT */
#ifndef G_GOFFSET_CONSTANT
# define G_GOFFSET_CONSTANT(val) G_GINT64_CONSTANT(val)
#endif /* not G_GOFFSET_CONSTANT */


#ifndef G_MININT8
# define G_MININT8 ((gint8)0x80)
#endif /* not G_MININT8 */
#ifndef G_MAXINT8
# define G_MAXINT8 ((gint8)0x7f)
#endif /* not G_MAXINT8 */
#ifndef G_MAXUINT8
# define G_MAXUINT8 ((guint8)0xff)
#endif /* not G_MAXUINT8 */
#ifndef G_MININT16
# define G_MININT16 ((gint16)0x8000)
#endif /* not G_MININT16 */
#ifndef G_MAXINT16
# define G_MAXINT16 ((gint16)0x7fff)
#endif /* not G_MAXINT16 */
#ifndef G_MAXUINT16
# define G_MAXUINT16 ((guint16)0xffff)
#endif /* not G_MAXUINT16 */
#ifndef G_MININT32
# define G_MININT32 ((gint32)0x80000000)
#endif /* not G_MININT32 */
#ifndef G_MAXINT32
# define G_MAXINT32 ((gint32)0x7fffffff)
#endif /* not G_MAXINT32 */
#ifndef G_MAXUINT32
# define G_MAXUINT32 ((guint32)0xffffffff)
#endif /* not G_MAXUINT32 */
#ifndef G_MAXSIZE
# define G_MAXSIZE G_MAXUINT
#endif /* not G_MAXSIZE */
#ifndef G_MINSSIZE
# define G_MINSSIZE G_MININT
#endif /* not G_MINSSIZE */
#ifndef G_MAXSSIZE
# define G_MAXSSIZE G_MAXINT
#endif /* not G_MAXSSIZE */
#ifndef G_MINOFFSET
# define G_MINOFFSET G_MININT64
#endif /* not G_MINOFFSET */
#ifndef G_MAXOFFSET
# define G_MAXOFFSET G_MAXINT64
#endif /* not G_MAXOFFSET */


#ifndef G_IS_DIR_SEPARATOR
# ifdef G_OS_WIN32
#  define G_IS_DIR_SEPARATOR(c) ((c)==G_DIR_SEPARATOR||(c)=='/')
# else /* not G_OS_WIN32 */
#  define G_IS_DIR_SEPARATOR(c) ((c)==G_DIR_SEPARATOR)
# endif /* not G_OS_WIN32 */
#endif /* not G_IS_DIR_SEPARATOR */


#ifndef G_PASTE
# define G_PASTE(identifier1,identifier2) G_PASTE_ARGS(identifier1,identifier2)
#endif /* not G_PASTE */
#ifndef G_PASTE_ARGS
# define G_PASTE_ARGS(identifier1,identifier2) identifier1##identifier2
#endif /* not G_PASTE_ARGS */
#ifndef G_STATIC_ASSERT
# define G_STATIC_ASSERT(expr) typedef struct { char Compile_Time_Assertion[(expr) ? 1 : -1]; } G_PASTE (_GStaticAssert_, __LINE__)
#endif /* not G_STATIC_ASSERT */


#ifndef G_GNUC_MALLOC
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 96)
#  define G_GNUC_MALLOC __attribute__((__malloc__))
# else
#  define G_GNUC_MALLOC
# endif
#endif /* not G_GNUC_MALLOC */
#ifndef G_GNUC_ALLOC_SIZE
# if (__GNUC__ > 4) || (__GNUC__ == 4 && __GNUC_MINOR__ >= 3)
#  define G_GNUC_ALLOC_SIZE(x) __attribute__((__alloc_size__(x)))
# else
#  define G_GNUC_ALLOC_SIZE(x)
# endif
#endif /* not G_GNUC_ALLOC_SIZE */
#ifndef G_GNUC_ALLOC_SIZE2
# if (__GNUC__ > 4) || (__GNUC__ == 4 && __GNUC_MINOR__ >= 3)
#  define G_GNUC_ALLOC_SIZE2(x,y) __attribute__((__alloc_size__(x,y)))
# else
#  define G_GNUC_ALLOC_SIZE2(x,y)
# endif
#endif /* not G_GNUC_ALLOC_SIZE2 */
#ifndef G_GNUC_DEPRECATED
# if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1)
#  define G_GNUC_DEPRECATED __attribute__((__deprecated__))
# else
#  define G_GNUC_DEPRECATED
# endif
#endif /* not G_GNUC_DEPRECATED */
#ifndef G_GNUC_NULL_TERMINATED
# if __GNUC__ >= 4
#  define G_GNUC_NULL_TERMINATED __attribute__((__sentinel__))
# else
#  define G_GNUC_NULL_TERMINATED
# endif
#endif /* not G_GNUC_NULL_TERMINATED */
#ifndef G_GNUC_WARN_UNUSED_RESULT
# if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  define G_GNUC_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define G_GNUC_WARN_UNUSED_RESULT
# endif
#endif /* not G_GNUC_WARN_UNUSED_RESULT */
#ifndef G_GNUC_INTERNAL
# if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#  define G_GNUC_INTERNAL __attribute__((visibility("hidden")))
# elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#  define G_GNUC_INTERNAL __hidden
# elif defined (__GNUC__) && defined (G_HAVE_GNUC_VISIBILITY)
#  define G_GNUC_INTERNAL __attribute__((visibility("hidden")))
# else
#  define G_GNUC_INTERNAL
# endif 
#endif /* not G_GNUC_INTERNAL */
#ifndef G_GNUC_MAY_ALIAS
# if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 3)
#  define G_GNUC_MAY_ALIAS __attribute__((may_alias))
# else
#  define G_GNUC_MAY_ALIAS
# endif
#endif /* not G_GNUC_MAY_ALIAS */

#if ! defined (G_LIKELY) || ! defined (G_UNLIKELY)
# if defined (__GNUC__) && __GNUC__ > 2 && defined (__OPTIMIZE__)
#  define _G_BOOLEAN_EXPR(expr) \
   __extension__ ({             \
     int _g_boolean_var_;       \
     if (expr)                  \
       _g_boolean_var_ = 1;     \
     else                       \
       _g_boolean_var_ = 0;     \
     _g_boolean_var_;           \
   })
#  ifndef G_LIKELY
#   define G_LIKELY(expr) (__builtin_expect(_G_BOOLEAN_EXPR(expr),1))
#  endif /* not G_LIKELY */
#  ifndef G_UNLIKELY
#   define G_UNLIKELY(expr) (__builtin_expect(_G_BOOLEAN_EXPR(expr),0))
#  endif /* not G_UNLIKELY */
# else /* not defined (__GNUC__) && __GNUC__ > 2 && defined (__OPTIMIZE__) */
#  ifndef G_LIKELY
#   define G_LIKELY(expr) (expr)
#  endif /* not G_LIKELY */
#  ifndef G_UNLIKELY
#   define G_UNLIKELY(expr) (expr)
#  endif /* not G_UNLIKELY */
# endif /* not defined (__GNUC__) && __GNUC__ > 2 && defined (__OPTIMIZE__) */
#endif /* ! defined (G_LIKELY) || ! defined (G_UNLIKELY) */


#ifndef G_STRFUNC
# if defined (__GNUC__)
#  define G_STRFUNC ((const char*) (__PRETTY_FUNCTION__))
# elif defined (G_HAVE_ISO_VARARGS)
#  define G_STRFUNC ((const char*) (__func__))
# else
#  define G_STRFUNC ((const char*) ("???"))
# endif
#endif /* not G_STRFUNC */


#ifndef G_GINT16_MODIFIER
# define G_GINT16_MODIFIER "h"
#endif /* not G_GINT16_MODIFIER */
#ifndef G_GINT32_MODIFIER
# define G_GINT32_MODIFIER ""
#endif /* not G_GINT32_MODIFIER */
#ifndef G_GINT64_MODIFIER
# define G_GINT64_MODIFIER "ll"
#endif /* not G_GINT64_MODIFIER */
#ifndef G_GSIZE_MODIFIER
# define G_GSIZE_MODIFIER ""
#endif /* not G_GSIZE_MODIFIER */
#ifndef G_GSIZE_FORMAT
# define G_GSIZE_FORMAT "u"
#endif /* not G_GSIZE_FORMAT */
#ifndef G_GSSIZE_FORMAT
# define G_GSSIZE_FORMAT "i"
#endif /* not G_GSSIZE_FORMAT */
#ifndef G_GOFFSET_MODIFIER
# define G_GOFFSET_MODIFIER G_GINT64_MODIFIER
#endif /* not G_GOFFSET_MODIFIER */
#ifndef G_GOFFSET_FORMAT
# define G_GOFFSET_FORMAT G_GINT64_FORMAT
#endif /* not G_GOFFSET_FORMAT */
#ifndef G_GINTPTR_MODIFIER
# define G_GINTPTR_MODIFIER "l"
#endif /* not G_GINTPTR_MODIFIER */
#ifndef G_GINTPTR_FORMAT
# define G_GINTPTR_FORMAT "li"
#endif /* not G_GINTPTR_FORMAT */
#ifndef G_GUINTPTR_FORMAT
# define G_GUINTPTR_FORMAT "lu"
#endif /* not G_GUINTPTR_FORMAT */


#define g_strcpy(dest,src) g_strlcpy(dest,src,G_MAXSIZE)
#define g_strncpy(dest,src,n) ((dest)&&(src)?strncpy(dest,src,n):(dest))
#define g_strcat(dest,src) g_strlcat(dest,src,G_MAXSIZE)
#define g_strncat(dest,src,n) ((dest)&&(src)?strncat(dest,src,n):(dest))
#if GLIB_CHECK_VERSION(2,16,0)
# define g_strcmp g_strcmp0
#else /* not GLIB_CHECK_VERSION(2,16,0) */
# define g_strcmp(s1,s2) ((s1)&&(s2)?strcmp(s1,s2):0)
#endif /* not GLIB_CHECK_VERSION(2,16,0) */
#define g_strncmp(s1,s2,n) ((s1)&&(s2)?strncmp(s1,s2,n):0)
#define g_strchr(s,c) ((s)?strchr(s,c):NULL)
#define g_strrchr(s,c) ((s)?strrchr(s,c):NULL)
#define g_strspn(s1,s2) ((s1)&&(s2)?strspn(s1,s2):0)
#define g_strcspn(s1,s2) ((s1)&&(s2)?strcspn(s1,s2):0)
#define g_strpbrk(s1,s2) ((s1)&&(s2)?strpbrk(s1,s2):NULL)
#define g_strstr(haystack,needle) g_strstr_len(haystack,g_strlen(haystack),needle)
#define g_strlen(s) ((s)?strlen(s):0)
#define g_strtok(s,delim) ((delim)?strtok(s,delim):NULL)
#define g_memcmp(s1,s2,n) ((s1)&&(s2)?memcmp(s1,s2,n):0)
#define g_memchr(s,c,n) ((s)?memchr(s,c,n):NULL)
#define g_memset(s,c,n) ((s)?memset(s,c,n):(s))
#if ! GLIB_CHECK_VERSION(2,2,0)
# define g_str_has_prefix(str,prefix) ((str)&&(prefix)&&(strncmp(str,prefix,strlen(prefix))==0))
# define g_str_has_suffix(str,suffix) ((str)&&(suffix)&&(strlen(str)>strlen(suffix))&&(strcmp((str)+strlen(str)-strlen(suffix),suffix)==0))
# define g_printf printf
# define g_vprintf vprintf
# define g_fprintf fprintf
# define g_vfprintf vfprintf
# define g_sprintf sprintf
# define g_vsprintf vsprintf
# define g_vasprintf vasprintf
# define g_ascii_strtoull strtoul
#endif /* not GLIB_CHECK_VERSION(2,2,0) */
#if ! GLIB_CHECK_VERSION(2,12,0)
# define g_ascii_strtoll strtol
#endif /* not GLIB_CHECK_VERSION(2,12,0) */
#if ! GLIB_CHECK_VERSION(2,22,0)
# define g_mapped_file_unref g_mapped_file_free
#endif /* not GLIB_CHECK_VERSION(2,22,0) */
#ifdef G_OS_WIN32
# define g_strfilecmp g_ascii_strcasecmp
# define g_strfilencmp g_ascii_strncasecmp
#else /* not G_OS_WIN32 */
# define g_strfilecmp g_strcmp
# define g_strfilencmp g_strncmp
#endif /* not G_OS_WIN32 */


#if GLIB_CHECK_VERSION(2,4,0)
# include <glib/gi18n.h>
#else /* not GLIB_CHECK_VERSION(2,4,0) */
# ifdef ENABLE_NLS
#  include <libintl.h>
#  define _(String) dgettext(PACKAGE,String)
#  ifdef gettext_noop
#   define N_(String) gettext_noop(String)
#  else /* not gettext_noop */
#   define N_(String) (String)
#  endif /* not gettext_noop */
#  define Q_(String) g_strip_context((String),gettext(String))
# else /* not ENABLE_NLS */
#  define _(String) (String)
#  define N_(String) (String)
#  define Q_(String) (String)
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,String) (String)
#  define dcgettext(Domain,String,Type) (String)
#  define bindtextdomain(Domain,Directory) (Domain)
# endif /* not ENABLE_NLS */
#endif /* not GLIB_CHECK_VERSION(2,4,0) */


#if ! GLIB_CHECK_VERSION(2,10,0)
# define g_intern_string(s) (s)
# define g_intern_static_string(s) (s)
#endif /* not GLIB_CHECK_VERSION(2,10,0) */


#ifndef G_DEFINE_TYPE
# define G_DEFINE_TYPE(TypeName,type_name,TYPE_PARENT)                         G_DEFINE_TYPE_EXTENDED(TypeName,type_name,TYPE_PARENT,0,{})
#endif /* not G_DEFINE_TYPE */
#ifndef G_DEFINE_TYPE_WITH_CODE
# define G_DEFINE_TYPE_WITH_CODE(TypeName,type_name,TYPE_PARENT,CODE)          _G_DEFINE_TYPE_EXTENDED_BEGIN(TypeName,type_name,TYPE_PARENT,0) {CODE;} _G_DEFINE_TYPE_EXTENDED_END()
#endif /* not G_DEFINE_TYPE_WITH_CODE */
#ifndef G_DEFINE_ABSTRACT_TYPE
# define G_DEFINE_ABSTRACT_TYPE(TypeName,type_name,TYPE_PARENT)                G_DEFINE_TYPE_EXTENDED(TypeName,type_name,TYPE_PARENT,G_TYPE_FLAG_ABSTRACT,{})
#endif /* not G_DEFINE_ABSTRACT_TYPE */
#ifndef G_DEFINE_ABSTRACT_TYPE_WITH_CODE
# define G_DEFINE_ABSTRACT_TYPE_WITH_CODE(TypeName,type_name,TYPE_PARENT,CODE) _G_DEFINE_TYPE_EXTENDED_BEGIN(TypeName,type_name,TYPE_PARENT,G_TYPE_FLAG_ABSTRACT) {CODE;} _G_DEFINE_TYPE_EXTENDED_END()
#endif /* not G_DEFINE_ABSTRACT_TYPE_WITH_CODE */
#ifndef G_DEFINE_TYPE_EXTENDED
# define G_DEFINE_TYPE_EXTENDED(TypeName,type_name,TYPE_PARENT,flags,CODE)     _G_DEFINE_TYPE_EXTENDED_BEGIN(TypeName,type_name,TYPE_PARENT,flags) {CODE;} _G_DEFINE_TYPE_EXTENDED_END()
#endif /* not G_DEFINE_TYPE_EXTENDED */


#ifndef G_IMPLEMENT_INTERFACE
# define G_IMPLEMENT_INTERFACE(TYPE_IFACE,iface_init)
  { \
    const GInterfaceInfo g_implement_interface_info = { \
      (GInterfaceInitFunc) iface_init, NULL, NULL \
    }; \
    g_type_add_interface_static (g_define_type_id, TYPE_IFACE, &g_implement_interface_info); \
  }
#endif /* not G_IMPLEMENT_INTERFACE */


#ifndef _G_DEFINE_TYPE_EXTENDED_BEGIN
# define _G_DEFINE_TYPE_EXTENDED_BEGIN(TypeName,type_name,TYPE_PARENT,flags) \
                                                                             \
static void     type_name##_init              (TypeName        *self);       \
static void     type_name##_class_init        (TypeName##Class *klass);      \
static gpointer type_name##_parent_class = NULL;                             \
static void     type_name##_class_intern_init (gpointer klass)               \
{                                                                            \
  type_name##_parent_class = g_type_class_peek_parent (klass);               \
  type_name##_class_init ((TypeName##Class*) klass);                         \
}                                                                            \
                                                                             \
GType                                                                        \
type_name##_get_type (void)                                                  \
{                                                                            \
  static GType g_define_type_id = 0;                                         \
  if (G_UNLIKELY (g_define_type_id == 0))                                    \
    {                                                                        \
      static const GTypeInfo g_define_type_info = {                          \
        sizeof (TypeName##Class),                                            \
        NULL,                                                                \
        NULL,                                                                \
        (GClassInitFunc) type_name##_class_intern_init,                      \
        NULL,                                                                \
        NULL,                                                                \
        sizeof (TypeName),                                                   \
        0,                                                                   \
        (GInstanceInitFunc) type_name##_init,                                \
        NULL                                                                 \
      };                                                                     \
                                                                             \
      g_define_type_id = g_type_register_static (TYPE_PARENT,                \
                                        g_intern_static_string (#TypeName),  \
                                        &g_define_type_info,                 \
                                        (GTypeFlags)flags);                  \
      {
#endif /* not _G_DEFINE_TYPE_EXTENDED_BEGIN */
#ifndef _G_DEFINE_TYPE_EXTENDED_END
# define _G_DEFINE_TYPE_EXTENDED_END()                                       \
      }                                                                      \
    }                                                                        \
  return g_define_type_id;                                                   \
}
#endif /* not _G_DEFINE_TYPE_EXTENDED_END */


#endif /* __GCOMMON_H__ */
