/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __REPINFO_H__
#define __REPINFO_H__


#include "tmaid.h"


G_BEGIN_DECLS


#define REPLACE_CANCEL -1
#define REPLACE_OK 1
#define REPLACE_ALL 2
#define REPLACE_NEXT 0


typedef struct _ReplaceInfo
{
  gboolean arrow;
  gboolean ignorecase;
  gchar *src, *dst;
} ReplaceInfo;


extern GtkWidget *repinfo_box;


/******************************************************************************
*                                                                             *
* ja:置換情報ボックス関数群                                                   *
*                                                                             *
******************************************************************************/
/*  ja:置換情報ボックス取得
    RET,置換情報ボックス                                                    */
GtkWidget *
repinfo_box_get_widget (void);


/*  ja:置換情報ボックス表示
     ri,置換情報
    RET,REPLACE_OK,REPLACE_NEXT,REPLACE_ALL,REPLACE_CANCEL                  */
gint
repinfo_run (ReplaceInfo *ri);


G_END_DECLS


#endif /* __REPINFO_H__ */
