/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GCOMMON_H__
#define __GCOMMON_H__


#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */


#ifndef _GNU_SOURCE
# define _GNU_SOURCE 1
#endif /* not _GNU_SOURCE */
#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <float.h>
#include <limits.h>
#include <locale.h>
#include <math.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef USE_GTK_EMULATE
# ifdef HAVE_STDBOOL_H
#  include <stdbool.h>
# else /* not HAVE_STDBOOL_H */
#  ifndef __bool_true_false_are_defined
#   if ! HAVE__BOOL
#    ifdef __cplusplus
typedef bool _Bool;
#    else /* not __cplusplus */
typedef unsigned char _Bool;
#    endif /* not __cplusplus */
#   endif /* not HAVE__BOOL */
#   define bool _Bool
#   define false 0
#   define true 1
#   define __bool_true_false_are_defined 1
#  endif /* __bool_true_false_are_defined */
# endif /* not HAVE_STDBOOL_H */
#else /* not USE_GTK_EMULATE */
# include <gtk/gtk.h>
#endif /* not USE_GTK_EMULATE */


/******************************************************************************
* Version Information                                                         *
******************************************************************************/
#ifndef GLIB_MAJOR_VERSION
# define GLIB_MAJOR_VERSION 2
#endif /* not GLIB_MAJOR_VERSION */
#ifndef GLIB_MINOR_VERSION
# define GLIB_MINOR_VERSION 0
#endif /* not GLIB_MINOR_VERSION */
#ifndef GLIB_MICRO_VERSION
# define GLIB_MICRO_VERSION 0
#endif /* not GLIB_MICRO_VERSION */
#ifndef GLIB_CHECK_VERSION
# define GLIB_CHECK_VERSION(major,minor,micro)                         \
    (GLIB_MAJOR_VERSION > (major) ||                                   \
    (GLIB_MAJOR_VERSION == (major) && GLIB_MINOR_VERSION > (minor)) || \
    (GLIB_MAJOR_VERSION == (major) && GLIB_MINOR_VERSION == (minor) && \
     GLIB_MICRO_VERSION >= (micro)))
#endif /* not GLIB_CHECK_VERSION */


/******************************************************************************
* Basic Types                                                                 *
******************************************************************************/
#ifdef USE_GTK_EMULATE
typedef bool gboolean;
typedef void *gpointer;
typedef const void *gconstpointer;
typedef char gchar;
typedef unsigned char guchar;
typedef int gint;
typedef unsigned guint;
typedef short gshort;
typedef unsigned short gushort;
typedef long glong;
typedef unsigned long gulong;
# ifdef HAVE_STDINT_H
#  include <stdint.h>
typedef int8_t gint8;
typedef uint8_t guint8;
typedef int16_t gint16;
typedef uint16_t guint16;
typedef int32_t gint32;
typedef uint32_t guint32;
typedef int64_t gint64;
typedef uint64_t guint64;
# else /* not HAVE_STDINT_H */
typedef char gint8;
typedef unsigned char guint8;
typedef short gint16;
typedef unsigned short guint16;
typedef int gint32;
typedef unsigned guint32;
#  ifdef _MSC_VER
typedef __int64 gint64;
typedef unsigned __int64 guint64;
#  else /* not _MSC_VER */
typedef long long gint64;
typedef unsigned long long guint64;
#  endif /* not _MSC_VER */
# endif /* not HAVE_STDINT_H */
typedef float gfloat;
typedef double gdouble;
# if defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64)
typedef guint64 gsize;
typedef gint64 gssize;
# else /* not defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64) */
typedef guint32 gsize;
typedef gint32 gssize;
# endif /* not defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64) */
typedef guint16 gunichar2;
typedef guint32 gunichar;
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,14,0)
typedef gint64 goffset;
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
#if ! GLIB_CHECK_VERSION(2,18,0)
# ifdef _WIN64
typedef gint64 gintptr;
typedef guint64 guintptr;
# else /* not _WIN64 */
typedef gint32 gintptr;
typedef guint32 guintptr;
# endif /* not _WIN64 */
#endif /* not GLIB_CHECK_VERSION(2,18,0) */
#ifndef G_HAVE_GINT64
# define G_HAVE_GINT64 1
#endif /* not G_HAVE_GINT64 */
#ifndef G_GINT64_CONSTANT
# ifdef _MSC_VER
#  define G_GINT64_CONSTANT(val) (val##i64)
# else /* not _MSC_VER */
#  define G_GINT64_CONSTANT(val) (G_GNUC_EXTENSION(val##LL))
# endif /* not _MSC_VER */
#endif /* not G_GINT64_CONSTANT */
#ifndef G_GUINT64_CONSTANT
# ifdef _MSC_VER
#  define G_GUINT64_CONSTANT(val) (val##Ui64)
# else /* not _MSC_VER */
#  define G_GUINT64_CONSTANT(val) (G_GNUC_EXTENSION(val##ULL))
# endif /* not _MSC_VER */
#endif /* not G_GUINT64_CONSTANT */
#ifndef G_GOFFSET_CONSTANT
# define G_GOFFSET_CONSTANT(val) G_GINT64_CONSTANT(val)
#endif /* not G_GOFFSET_CONSTANT */


/******************************************************************************
* Limits of Basic Types                                                       *
******************************************************************************/
#ifndef G_MININT
# define G_MININT INT_MIN
#endif /* not G_MININT */
#ifndef G_MAXINT
# define G_MAXINT INT_MAX
#endif /* not G_MAXINT */
#ifndef G_MAXUINT
# define G_MAXUINT UINT_MAX
#endif /* not G_MAXUINT */
#ifndef G_MINSHORT
# define G_MINSHORT SHRT_MIN
#endif /* not G_MINSHORT */
#ifndef G_MAXSHORT
# define G_MAXSHORT SHRT_MAX
#endif /* not G_MAXSHORT */
#ifndef G_MAXUSHORT
# define G_MAXUSHORT USHRT_MAX
#endif /* not G_MAXUSHORT */
#ifndef G_MINLONG
# define G_MINLONG LONG_MIN
#endif /* not G_MINLONG */
#ifndef G_MAXLONG
# define G_MAXLONG LONG_MAX
#endif /* not G_MAXLONG */
#ifndef G_MAXULONG
# define G_MAXULONG ULONG_MAX
#endif /* not G_MAXULONG */
#ifndef G_MININT8
# define G_MININT8 ((gint8)0x80)
#endif /* not G_MININT8 */
#ifndef G_MAXINT8
# define G_MAXINT8 ((gint8)0x7f)
#endif /* not G_MAXINT8 */
#ifndef G_MAXUINT8
# define G_MAXUINT8 ((guint8)0xff)
#endif /* not G_MAXUINT8 */
#ifndef G_MININT16
# define G_MININT16 ((gint16)0x8000)
#endif /* not G_MININT16 */
#ifndef G_MAXINT16
# define G_MAXINT16 ((gint16)0x7fff)
#endif /* not G_MAXINT16 */
#ifndef G_MAXUINT16
# define G_MAXUINT16 ((guint16)0xffff)
#endif /* not G_MAXUINT16 */
#ifndef G_MININT32
# define G_MININT32 ((gint32)0x80000000)
#endif /* not G_MININT32 */
#ifndef G_MAXINT32
# define G_MAXINT32 ((gint32)0x7fffffff)
#endif /* not G_MAXINT32 */
#ifndef G_MAXUINT32
# define G_MAXUINT32 ((guint32)0xffffffff)
#endif /* not G_MAXUINT32 */
#ifndef G_MININT64
# define G_MININT64 ((gint64)G_GINT64_CONSTANT(0x8000000000000000))
#endif /* not G_MININT64 */
#ifndef G_MAXINT64
# define G_MAXINT64 G_GINT64_CONSTANT(0x7fffffffffffffff)
#endif /* not G_MAXINT64 */
#ifndef G_MAXUINT64
# define G_MAXUINT64 G_GUINT64_CONSTANT(0xffffffffffffffff)
#endif /* not G_MAXUINT64 */
#if defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64)
# ifndef G_MAXSIZE
#  define G_MAXSIZE G_MAXUINT64
# endif /* not G_MAXSIZE */
# ifndef G_MINSSIZE
#  define G_MINSSIZE G_MININT64
# endif /* not G_MINSSIZE */
# ifndef G_MAXSSIZE
#  define G_MAXSSIZE G_MAXINT64
# endif /* not G_MAXSSIZE */
#else /* not defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64) */
# ifndef G_MAXSIZE
#  define G_MAXSIZE G_MAXUINT32
# endif /* not G_MAXSIZE */
# ifndef G_MINSSIZE
#  define G_MINSSIZE G_MININT32
# endif /* not G_MINSSIZE */
# ifndef G_MAXSSIZE
#  define G_MAXSSIZE G_MAXINT32
# endif /* not G_MAXSSIZE */
#endif /* not defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64) */
#ifndef G_MINOFFSET
# define G_MINOFFSET G_MININT64
#endif /* not G_MINOFFSET */
#ifndef G_MAXOFFSET
# define G_MAXOFFSET G_MAXINT64
#endif /* not G_MAXOFFSET */
#ifndef G_MINFLOAT
# define G_MINFLOAT FLT_MIN
#endif /* not G_MINFLOAT */
#ifndef G_MAXFLOAT
# define G_MAXFLOAT FLT_MAX
#endif /* not G_MAXFLOAT */
#ifndef G_MINDOUBLE
# define G_MINDOUBLE DBL_MIN
#endif /* not G_MINDOUBLE */
#ifndef G_MAXDOUBLE
# define G_MAXDOUBLE DBL_MAX
#endif /* not G_MAXDOUBLE */


/******************************************************************************
* Standard Macros                                                             *
******************************************************************************/
#ifdef USE_GTK_EMULATE
# ifdef _MSC_VER
#  define G_OS_WIN32
# else /* not _MSC_VER */
#  define G_OS_UNIX
# endif /* not _MSC_VER */
#endif /* USE_GTK_EMULATE */
#ifdef G_OS_WIN32
# ifndef G_DIR_SEPARATOR
#  define G_DIR_SEPARATOR '\\'
# endif /* not G_DIR_SEPARATOR */
# ifndef G_DIR_SEPARATOR_S
#  define G_DIR_SEPARATOR_S "\\"
# endif /* not G_DIR_SEPARATOR_S */
# ifndef G_IS_DIR_SEPARATOR
#  define G_IS_DIR_SEPARATOR(c) ((c)==G_DIR_SEPARATOR||(c)=='/')
# endif /* not G_IS_DIR_SEPARATOR */
# ifndef G_SEARCHPATH_SEPARATOR
#  define G_SEARCHPATH_SEPARATOR ';'
# endif /* not G_SEARCHPATH_SEPARATOR */
# ifndef G_SEARCHPATH_SEPARATOR_S
#  define G_SEARCHPATH_SEPARATOR_S ";"
# endif /* not G_SEARCHPATH_SEPARATOR_S */
#else /* not G_OS_WIN32 */
# ifndef G_DIR_SEPARATOR
#  define G_DIR_SEPARATOR '/'
# endif /* not G_DIR_SEPARATOR */
# ifndef G_DIR_SEPARATOR_S
#  define G_DIR_SEPARATOR_S "/"
# endif /* not G_DIR_SEPARATOR_S */
# ifndef G_IS_DIR_SEPARATOR
#  define G_IS_DIR_SEPARATOR(c) ((c)==G_DIR_SEPARATOR)
# endif /* not G_IS_DIR_SEPARATOR */
# ifndef G_SEARCHPATH_SEPARATOR
#  define G_SEARCHPATH_SEPARATOR ':'
# endif /* not G_SEARCHPATH_SEPARATOR */
# ifndef G_SEARCHPATH_SEPARATOR_S
#  define G_SEARCHPATH_SEPARATOR_S ":"
# endif /* not G_SEARCHPATH_SEPARATOR_S */
#endif /* not G_OS_WIN32 */
#ifndef TRUE
# define TRUE true
#endif /* not TRUE */
#ifndef FALSE
# define FALSE false
#endif /* not FALSE */
#ifndef NULL
# define NULL 0
#endif /* not NULL */
#ifndef MIN
# define MIN(a,b) (((a)<(b))?(a):(b))
#endif /* not MIN */
#ifndef MAX
# define MAX(a,b) (((a)>(b))?(a):(b))
#endif /* not MAX */
#ifndef ABS
# define ABS(a) (((a)<0)?-(a):(a))
#endif /* not ABS */
#ifndef CLAMP
# define CLAMP(x,low,high) (((x)>(high))?(high):(((x)<(low))?(low):(x)))
#endif /* not CLAMP */
#ifndef G_STRUCT_MEMBER
# define G_STRUCT_MEMBER(member_type,struct_p,struct_offset) \
                (*(member_type *)G_STRUCT_MEMBER_P((struct_p),(struct_offset)))
#endif /* not G_STRUCT_MEMBER */
#ifndef G_STRUCT_MEMBER_P
# define G_STRUCT_MEMBER_P(struct_p,struct_offset) \
                    ((gpointer)((guint8 *)(struct_p)+(glong)(struct_offset)))
#endif /* not G_STRUCT_MEMBER_P */
#ifndef G_STRUCT_OFFSET
# define G_STRUCT_OFFSET(struct_type,member) ((glong)((guint8 *)&((struct_type*)0)->member))
#endif /* not G_STRUCT_OFFSET */
#ifndef G_MEM_ALIGN
# define G_MEM_ALIGN sizeof(gpointer)
#endif /* not G_MEM_ALIGN */
#ifndef G_CONST_RETURN
# define G_CONST_RETURN const
#endif /* not G_CONST_RETURN */


/******************************************************************************
* Type Conversion Macros                                                      *
******************************************************************************/
#ifndef GINT_TO_POINTER
# define GINT_TO_POINTER(i) ((gpointer)(gint)(i))
#endif /* not GINT_TO_POINTER */
#ifndef GPOINTER_TO_INT
# define GPOINTER_TO_INT(p) ((gint)(gint)(p))
#endif /* not GPOINTER_TO_INT */
#ifndef GUINT_TO_POINTER
# define GUINT_TO_POINTER(u) ((gpointer)(guint)(u))
#endif /* not GUINT_TO_POINTER */
#ifndef GPOINTER_TO_UINT
# define GPOINTER_TO_UINT(p) ((guint)(guint)(p))
#endif /* not GPOINTER_TO_UINT */
#ifndef GSIZE_TO_POINTER
# define GSIZE_TO_POINTER(s) ((gpointer)(gsize)(s))
#endif /* not GSIZE_TO_POINTER */
#ifndef GPOINTER_TO_SIZE
# define GPOINTER_TO_SIZE(p) ((gsize)(p))
#endif /* not GPOINTER_TO_SIZE */


/******************************************************************************
* Byte Order Macros                                                           *
******************************************************************************/
#ifndef G_LITTLE_ENDIAN
# define G_LITTLE_ENDIAN 1234
#endif /* not G_LITTLE_ENDIAN */
#ifndef G_BIG_ENDIAN
# define G_BIG_ENDIAN 4321
#endif /* not G_BIG_ENDIAN */
#ifndef G_PDP_ENDIAN
# define G_PDP_ENDIAN 3412
#endif /* not G_PDP_ENDIAN */
#ifndef GINT_SWAP_LE_BE
# define GINT_SWAP_LE_BE(val)    GINT32_SWAP_LE_BE(val)
#endif /* not GINT_SWAP_LE_BE */
#ifndef GUINT_SWAP_LE_BE
# define GUINT_SWAP_LE_BE(val)   GUINT32_SWAP_LE_BE(val)
#endif /* not GUINT_SWAP_LE_BE */
#ifndef GLONG_SWAP_LE_BE
# define GLONG_SWAP_LE_BE(val)   GINT32_SWAP_LE_BE(val)
#endif /* not GLONG_SWAP_LE_BE */
#ifndef GULONG_SWAP_LE_BE
# define GULONG_SWAP_LE_BE(val)  GUINT32_SWAP_LE_BE(val)
#endif /* not GULONG_SWAP_LE_BE */
#ifndef GSIZE_SWAP_LE_BE
# define GSIZE_SWAP_LE_BE(val)   GINT32_SWAP_LE_BE(val)
#endif /* not GSIZE_SWAP_LE_BE */
#ifndef GSSIZE_SWAP_LE_BE
# define GSSIZE_SWAP_LE_BE(val)  GUINT32_SWAP_LE_BE(val)
#endif /* not GSSIZE_SWAP_LE_BE */
#ifndef GINT16_SWAP_LE_BE
# define GINT16_SWAP_LE_BE(val)  ((gint16)(GUINT16_SWAP_LE_BE(val)))
#endif /* not GINT16_SWAP_LE_BE */
#ifndef GUINT16_SWAP_LE_BE
# define GUINT16_SWAP_LE_BE(val) gcommon_swap_16(val)
guint16 gcommon_swap_16 (const guint16 val);
#endif /* not GUINT16_SWAP_LE_BE */
#ifndef GINT32_SWAP_LE_BE
# define GINT32_SWAP_LE_BE(val)  ((gint32)(GUINT32_SWAP_LE_BE(val)))
#endif /* not GINT32_SWAP_LE_BE */
#ifndef GUINT32_SWAP_LE_BE
# define GUINT32_SWAP_LE_BE(val) gcommon_swap_32(val)
guint32 gcommon_swap_32 (const guint32 val);
#endif /* not GUINT32_SWAP_LE_BE */
#ifndef GINT64_SWAP_LE_BE
# define GINT64_SWAP_LE_BE(val)  ((gint64)(GUINT64_SWAP_LE_BE(val)))
#endif /* not GINT64_SWAP_LE_BE */
#ifndef GUINT64_SWAP_LE_BE
# define GUINT64_SWAP_LE_BE(val) gcommon_swap_64(val)
guint64 gcommon_swap_64 (const guint64 val);
#endif /* not GUINT64_SWAP_LE_BE */
#ifdef WORDS_BIGENDIAN
# ifndef G_BYTE_ORDER
#  define G_BYTE_ORDER G_BIG_ENDIAN
# endif /* not G_BYTE_ORDER */
# ifndef GINT_TO_BE
#  define GINT_TO_BE(val)      ((gint)(val))
# endif /* not GINT_TO_BE */
# ifndef GINT_TO_LE
#  define GINT_TO_LE(val)      (GINT_SWAP_LE_BE(val))
# endif /* not GINT_TO_LE */
# ifndef GUINT_TO_BE
#  define GUINT_TO_BE(val)     ((guint)(val))
# endif /* not GUINT_TO_BE */
# ifndef GUINT_TO_LE
#  define GUINT_TO_LE(val)     (GUINT_SWAP_LE_BE(val))
# endif /* not GUINT_TO_LE */
# ifndef GLONG_TO_BE
#  define GLONG_TO_BE(val)     ((glong)(val))
# endif /* not GLONG_TO_BE */
# ifndef GLONG_TO_LE
#  define GLONG_TO_LE(val)     (GLONG_SWAP_LE_BE(val))
# endif /* not GLONG_TO_LE */
# ifndef GULONG_TO_BE
#  define GULONG_TO_BE(val)    ((gulong)(val))
# endif /* not GULONG_TO_BE */
# ifndef GULONG_TO_LE
#  define GULONG_TO_LE(val)    (GULONG_SWAP_LE_BE(val))
# endif /* not GULONG_TO_LE */
# ifndef GSIZE_TO_BE
#  define GSIZE_TO_BE(val)     ((gsize)(val))
# endif /* not GSIZE_TO_BE */
# ifndef GSIZE_TO_LE
#  define GSIZE_TO_LE(val)     (GSIZE_SWAP_LE_BE(val))
# endif /* not GSIZE_TO_LE */
# ifndef GSSIZE_TO_BE
#  define GSSIZE_TO_BE(val)    ((gssize)(val))
# endif /* not GSSIZE_TO_BE */
# ifndef GSSIZE_TO_LE
#  define GSSIZE_TO_LE(val)    (GSSIZE_SWAP_LE_BE(val))
# endif /* not GSSIZE_TO_LE */
# ifndef GINT16_TO_BE
#  define GINT16_TO_BE(val)    ((gint16)(val))
# endif /* not GINT16_TO_BE */
# ifndef GINT16_TO_LE
#  define GINT16_TO_LE(val)    (GINT16_SWAP_LE_BE(val))
# endif /* not GINT16_TO_LE */
# ifndef GUINT16_TO_BE
#  define GUINT16_TO_BE(val)   ((guint16)(val))
# endif /* not GUINT16_TO_BE */
# ifndef GUINT16_TO_LE
#  define GUINT16_TO_LE(val)   (GUINT16_SWAP_LE_BE(val))
# endif /* not GUINT16_TO_LE */
# ifndef GINT32_TO_BE
#  define GINT32_TO_BE(val)    ((gint32)(val))
# endif /* not GINT32_TO_BE */
# ifndef GINT32_TO_LE
#  define GINT32_TO_LE(val)    (GINT32_SWAP_LE_BE(val))
# endif /* not GINT32_TO_LE */
# ifndef GUINT32_TO_BE
#  define GUINT32_TO_BE(val)   ((guint32)(val))
# endif /* not GUINT32_TO_BE */
# ifndef GUINT32_TO_LE
#  define GUINT32_TO_LE(val)   (GUINT32_SWAP_LE_BE(val))
# endif /* not GUINT32_TO_LE */
# ifndef GINT64_TO_BE
#  define GINT64_TO_BE(val)    ((gint64)(val))
# endif /* not GINT64_TO_BE */
# ifndef GINT64_TO_LE
#  define GINT64_TO_LE(val)    (GINT642_SWAP_LE_BE(val))
# endif /* not GINT64_TO_LE */
# ifndef GUINT64_TO_BE
#  define GUINT64_TO_BE(val)   ((guint64)(val))
# endif /* not GUINT64_TO_BE */
# ifndef GUINT64_TO_LE
#  define GUINT64_TO_LE(val)   (GUINT64_SWAP_LE_BE(val))
# endif /* not GUINT64_TO_LE */
# ifndef GINT_FROM_BE
#  define GINT_FROM_BE(val)    ((gint)(val))
# endif /* not GINT_FROM_BE */
# ifndef GINT_FROM_LE
#  define GINT_FROM_LE(val)    (GINT_SWAP_LE_BE(val))
# endif /* not GINT_FROM_LE */
# ifndef GUINT_FROM_BE
#  define GUINT_FROM_BE(val)   ((guint)(val))
# endif /* not GUINT_FROM_BE */
# ifndef GUINT_FROM_LE
#  define GUINT_FROM_LE(val)   (GUINT_SWAP_LE_BE(val))
# endif /* not GUINT_FROM_LE */
# ifndef GLONG_FROM_BE
#  define GLONG_FROM_BE(val)   ((glong)(val))
# endif /* not GLONG_FROM_BE */
# ifndef GLONG_FROM_LE
#  define GLONG_FROM_LE(val)   (GLONG_SWAP_LE_BE(val))
# endif /* not GLONG_FROM_LE */
# ifndef GULONG_FROM_BE
#  define GULONG_FROM_BE(val)  ((gulong)(val))
# endif /* not GULONG_FROM_BE */
# ifndef GULONG_FROM_LE
#  define GULONG_FROM_LE(val)  (GULONG_SWAP_LE_BE(val))
# endif /* not GULONG_FROM_LE */
# ifndef GSIZE_FROM_BE
#  define GSIZE_FROM_BE(val)   ((gsize)(val))
# endif /* not GSIZE_FROM_BE */
# ifndef GSIZE_FROM_LE
#  define GSIZE_FROM_LE(val)   (GSIZE_SWAP_LE_BE(val))
# endif /* not GSIZE_FROM_LE */
# ifndef GSSIZE_FROM_BE
#  define GSSIZE_FROM_BE(val)  ((gssize)(val))
# endif /* not GSSIZE_FROM_BE */
# ifndef GSSIZE_FROM_LE
#  define GSSIZE_FROM_LE(val)  (GSSIZE_SWAP_LE_BE(val))
# endif /* not GSSIZE_FROM_LE */
# ifndef GINT16_FROM_BE
#  define GINT16_FROM_BE(val)  ((gint)(val))
# endif /* not GINT16_FROM_BE */
# ifndef GINT16_FROM_LE
#  define GINT16_FROM_LE(val)  (GINT16_SWAP_LE_BE(val))
# endif /* not GINT16_FROM_LE */
# ifndef GUINT16_FROM_BE
#  define GUINT16_FROM_BE(val) ((guint16)(val))
# endif /* not GUINT16_FROM_BE */
# ifndef GUINT16_FROM_LE
#  define GUINT16_FROM_LE(val) (GUINT16_SWAP_LE_BE(val))
# endif /* not GUINT16_FROM_LE */
# ifndef GINT32_FROM_BE
#  define GINT32_FROM_BE(val)  ((gint32)(val))
# endif /* not GINT32_FROM_BE */
# ifndef GINT32_FROM_LE
#  define GINT32_FROM_LE(val)  (GINT32_SWAP_LE_BE(val))
# endif /* not GINT32_FROM_LE */
# ifndef GUINT32_FROM_BE
#  define GUINT32_FROM_BE(val) ((guint32)(val))
# endif /* not GUINT32_FROM_BE */
# ifndef GUINT32_FROM_LE
#  define GUINT32_FROM_LE(val) (GUINT32_SWAP_LE_BE(val))
# endif /* not GUINT32_FROM_LE */
# ifndef GINT64_FROM_BE
#  define GINT64_FROM_BE(val)  ((gint64)(val))
# endif /* not GINT64_FROM_BE */
# ifndef GINT64_FROM_LE
#  define GINT64_FROM_LE(val)  (GINT64_SWAP_LE_BE(val))
# endif /* not GINT64_FROM_LE */
# ifndef GUINT64_FROM_BE
#  define GUINT64_FROM_BE(val) ((guint64)(val))
# endif /* not GUINT64_FROM_BE */
# ifndef GUINT64_FROM_LE
#  define GUINT64_FROM_LE(val) (GUINT64_SWAP_LE_BE(val))
# endif /* not GUINT64_FROM_LE */
#else /* not WORDS_BIGENDIAN */
# ifndef G_BYTE_ORDER
#  define G_BYTE_ORDER G_LITTLE_ENDIAN
# endif /* not not G_BYTE_ORDER */
# ifndef GINT_TO_BE
#  define GINT_TO_BE(val)      (GINT_SWAP_LE_BE(val))
# endif /* not GINT_TO_BE */
# ifndef GINT_TO_LE
#  define GINT_TO_LE(val)      ((gint)(val))
# endif /* not GINT_TO_LE */
# ifndef GUINT_TO_BE
#  define GUINT_TO_BE(val)     (GUINT_SWAP_LE_BE(val))
# endif /* not GUINT_TO_BE */
# ifndef GUINT_TO_LE
#  define GUINT_TO_LE(val)     ((guint)(val))
# endif /* not GUINT_TO_LE */
# ifndef GLONG_TO_BE
#  define GLONG_TO_BE(val)     (GLONG_SWAP_LE_BE(val))
# endif /* not GLONG_TO_BE */
# ifndef GLONG_TO_LE
#  define GLONG_TO_LE(val)     ((glong)(val))
# endif /* not GLONG_TO_LE */
# ifndef GULONG_TO_BE
#  define GULONG_TO_BE(val)    (GULONG_SWAP_LE_BE(val))
# endif /* not GULONG_TO_BE */
# ifndef GULONG_TO_LE
#  define GULONG_TO_LE(val)    ((gulong)(val))
# endif /* not GULONG_TO_LE */
# ifndef GSIZE_TO_BE
#  define GSIZE_TO_BE(val)     (GSIZE_SWAP_LE_BE(val))
# endif /* not GSIZE_TO_BE */
# ifndef GSIZE_TO_LE
#  define GSIZE_TO_LE(val)     ((gsize)(val))
# endif /* not GSIZE_TO_LE */
# ifndef GSSIZE_TO_BE
#  define GSSIZE_TO_BE(val)    (GSSIZE_SWAP_LE_BE(val))
# endif /* not GSSIZE_TO_BE */
# ifndef GSSIZE_TO_LE
#  define GSSIZE_TO_LE(val)    ((gsize)(val))
# endif /* not GSSIZE_TO_LE */
# ifndef GINT16_TO_BE
#  define GINT16_TO_BE(val)    (GINT16_SWAP_LE_BE(val))
# endif /* not GINT16_TO_BE */
# ifndef GINT16_TO_LE
#  define GINT16_TO_LE(val)    ((gint16)(val))
# endif /* not GINT16_TO_LE */
# ifndef GUINT16_TO_BE
#  define GUINT16_TO_BE(val)   (GUINT16_SWAP_LE_BE(val))
# endif /* not GUINT16_TO_BE */
# ifndef GUINT16_TO_LE
#  define GUINT16_TO_LE(val)   ((guint16)(val))
# endif /* not GUINT16_TO_LE */
# ifndef GINT32_TO_BE
#  define GINT32_TO_BE(val)    (GINT32_SWAP_LE_BE(val))
# endif /* not GINT32_TO_BE */
# ifndef GINT32_TO_LE
#  define GINT32_TO_LE(val)    ((gint32)(val))
# endif /* not GINT32_TO_LE */
# ifndef GUINT32_TO_BE
#  define GUINT32_TO_BE(val)   (GUINT32_SWAP_LE_BE(val))
# endif /* not GUINT32_TO_BE */
# ifndef GUINT32_TO_LE
#  define GUINT32_TO_LE(val)   ((guint32)(val))
# endif /* not GUINT32_TO_LE */
# ifndef GINT64_TO_BE
#  define GINT64_TO_BE(val)    (GINT64_SWAP_LE_BE(val))
# endif /* not GINT64_TO_BE */
# ifndef GINT64_TO_LE
#  define GINT64_TO_LE(val)    ((gint64)(val))
# endif /* not GINT64_TO_LE */
# ifndef GUINT64_TO_BE
#  define GUINT64_TO_BE(val)   (GUINT64_SWAP_LE_BE(val))
# endif /* not GUINT64_TO_BE */
# ifndef GUINT64_TO_LE
#  define GUINT64_TO_LE(val)   ((guint64)(val))
# endif /* not GUINT64_TO_LE */
# ifndef GINT_FROM_BE
#  define GINT_FROM_BE(val)    (GINT_SWAP_LE_BE(val))
# endif /* not GINT_FROM_BE */
# ifndef GINT_FROM_LE
#  define GINT_FROM_LE(val)    ((gint)(val))
# endif /* not GINT_FROM_LE */
# ifndef GUINT_FROM_BE
#  define GUINT_FROM_BE(val)   (GUINT_SWAP_LE_BE(val))
# endif /* not GUINT_FROM_BE */
# ifndef GUINT_FROM_LE
#  define GUINT_FROM_LE(val)   ((guint)(val))
# endif /* not GUINT_FROM_LE */
# ifndef GLONG_FROM_BE
#  define GLONG_FROM_BE(val)   (GLONG_SWAP_LE_BE(val))
# endif /* not GLONG_FROM_BE */
# ifndef GLONG_FROM_LE
#  define GLONG_FROM_LE(val)   ((glong)(val))
# endif /* not GLONG_FROM_LE */
# ifndef GULONG_FROM_BE
#  define GULONG_FROM_BE(val)  (GULONG_SWAP_LE_BE(val))
# endif /* not GULONG_FROM_BE */
# ifndef GULONG_FROM_LE
#  define GULONG_FROM_LE(val)  ((gulong)(val))
# endif /* not GULONG_FROM_LE */
# ifndef GSIZE_FROM_BE
#  define GSIZE_FROM_BE(val)   (GSIZE_SWAP_LE_BE(val))
# endif /* not GSIZE_FROM_BE */
# ifndef GSIZE_FROM_LE
#  define GSIZE_FROM_LE(val)   ((gsize)(val))
# endif /* not GSIZE_FROM_LE */
# ifndef GSSIZE_FROM_BE
#  define GSSIZE_FROM_BE(val)  (GSSIZE_SWAP_LE_BE(val))
# endif /* not GSSIZE_FROM_BE */
# ifndef GSSIZE_FROM_LE
#  define GSSIZE_FROM_LE(val)  ((gssize)(val))
# endif /* not GSSIZE_FROM_LE */
# ifndef GINT16_FROM_BE
#  define GINT16_FROM_BE(val)  (GINT16_SWAP_LE_BE(val))
# endif /* not GINT16_FROM_BE */
# ifndef GINT16_FROM_LE
#  define GINT16_FROM_LE(val)  ((gint16)(val))
# endif /* not GINT16_FROM_LE */
# ifndef GUINT16_FROM_BE
#  define GUINT16_FROM_BE(val) (GUINT16_SWAP_LE_BE(val))
# endif /* not GUINT16_FROM_BE */
# ifndef GUINT16_FROM_LE
#  define GUINT16_FROM_LE(val) ((guint16)(val))
# endif /* not GUINT16_FROM_LE */
# ifndef GINT32_FROM_BE
#  define GINT32_FROM_BE(val)  (GINT32_SWAP_LE_BE(val))
# endif /* not GINT32_FROM_BE */
# ifndef GINT32_FROM_LE
#  define GINT32_FROM_LE(val)  ((gint32)(val))
# endif /* not GINT32_FROM_LE */
# ifndef GUINT32_FROM_BE
#  define GUINT32_FROM_BE(val) (GUINT32_SWAP_LE_BE(val))
# endif /* not GUINT32_FROM_BE */
# ifndef GUINT32_FROM_LE
#  define GUINT32_FROM_LE(val) ((guint32)(val))
# endif /* not GUINT32_FROM_LE */
# ifndef GINT64_FROM_BE
#  define GINT64_FROM_BE(val)  (GINT64_SWAP_LE_BE(val))
# endif /* not GINT64_FROM_BE */
# ifndef GINT64_FROM_LE
#  define GINT64_FROM_LE(val)  ((gint64)(val))
# endif /* not GINT64_FROM_LE */
# ifndef GUINT64_FROM_BE
#  define GUINT64_FROM_BE(val) (GUINT64_SWAP_LE_BE(val))
# endif /* not GUINT64_FROM_BE */
# ifndef GUINT64_FROM_LE
#  define GUINT64_FROM_LE(val) ((guint64)(val))
# endif /* not GUINT64_FROM_LE */
#endif /* not WORDS_BIGENDIAN */


/******************************************************************************
* Numerical Definitions                                                       *
******************************************************************************/
#ifndef G_IEEE754_FLOAT_BIAS
# define G_IEEE754_FLOAT_BIAS (127)
#endif /* not G_IEEE754_FLOAT_BIAS */
#ifndef G_IEEE754_DOUBLE_BIAS
# define G_IEEE754_DOUBLE_BIAS (1023)
#endif /* not G_IEEE754_DOUBLE_BIAS */
#ifndef G_E
# define G_E             2.7182818284590452353602874713526624977572470937000
#endif /* not G_E */
#ifndef G_LN2
# define G_LN2           0.69314718055994530941723212145817656807550013436026
#endif /* not G_LN2 */
#ifndef G_LN10
# define G_LN10          2.3025850929940456840179914546843642076011014886288
#endif /* not G_LN10 */
#ifndef G_PI
# define G_PI            3.1415926535897932384626433832795028841971693993751
#endif /* not G_PI */
#ifndef G_PI_2
# define G_PI_2          1.5707963267948966192313216916397514420985846996876
#endif /* not G_PI_2 */
#ifndef G_PI_4
# define G_PI_4          0.78539816339744830961566084581987572104929234984378
#endif /* not G_PI_4 */
#ifndef G_SQRT2
# define G_SQRT2         1.4142135623730950488016887242096980785696718753769
#endif /* not G_SQRT2 */
#ifndef G_LOG_2_BASE_10
# define G_LOG_2_BASE_10 0.30102999566398119521
#endif /* not G_LOG_2_BASE_10 */


/******************************************************************************
* Miscellaneous Macros                                                        *
******************************************************************************/
#ifndef G_INLINE_FUNC
# define G_INLINE_FUNC
#endif /* not G_INLINE_FUNC */
#ifndef G_STMT_START
# define G_STMT_START do
#endif /* not G_STMT_START */
#ifndef G_STMT_END
# define G_STMT_END while (0)
#endif /* not G_STMT_END */
#ifdef __cplusplus
# ifndef G_BEGIN_DECLS
#  define G_BEGIN_DECLS  extern "C" {
# endif /* not G_BEGIN_DECLS */
# ifndef G_END_DECLS
#  define G_END_DECLS    }
# endif /* not G_END_DECLS */
#else /* not __cplusplus */
# ifndef G_BEGIN_DECLS
#  define G_BEGIN_DECLS
# endif /* not G_BEGIN_DECLS */
# ifndef G_END_DECLS
#  define G_END_DECLS
# endif /* not G_END_DECLS */
#endif /* not __cplusplus */
#ifndef G_N_ELEMENTS
# define G_N_ELEMENTS(arr) (sizeof(arr)/sizeof((arr)[0]))
#endif /* not G_N_ELEMENTS */
#ifndef G_VA_COPY
# if defined (__GNUC__) && defined (__PPC__) && (defined (_CALL_SYSV) || defined (_WIN32))
#  define G_VA_COPY(ap1,ap2) (*(ap1)=*(ap2))
# elif defined (G_VA_COPY_AS_ARRAY)
#  define G_VA_COPY(ap1,ap2) g_memmove((ap1),(ap2),sizeof(va_list))
# else
#  define G_VA_COPY(ap1,ap2) ((ap1)=(ap2))
# endif
#endif /* not G_VA_COPY */
#ifndef G_STRINGIFY_ARG
# define G_STRINGIFY_ARG(contents) #contents
#endif /* not G_STRINGIFY_ARG */
#ifndef G_STRINGIFY
# define G_STRINGIFY(macro_or_string) G_STRINGIFY_ARG(macro_or_string)
#endif /* not G_STRINGIFY */
#ifndef G_PASTE
# define G_PASTE(identifier1,identifier2) G_PASTE_ARGS(identifier1,identifier2)
#endif /* not G_PASTE */
#ifndef G_PASTE_ARGS
# define G_PASTE_ARGS(identifier1,identifier2) identifier1##identifier2
#endif /* not G_PASTE_ARGS */
#ifndef G_STATIC_ASSERT
# define G_STATIC_ASSERT(expr) typedef struct { char Compile_Time_Assertion[(expr) ? 1 : -1]; } G_PASTE (_GStaticAssert_, __LINE__)
#endif /* not G_STATIC_ASSERT */
#ifndef G_GNUC_EXTENSION
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 8)
#  define G_GNUC_EXTENSION __extension__
# else
#  define G_GNUC_EXTENSION
# endif
#endif /* not G_GNUC_EXTENSION */
#ifndef G_GNUC_CONST
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#  define G_GNUC_CONST __attribute__((__const__))
# else
#  define G_GNUC_CONST
# endif
#endif /* not G_GNUC_CONST */
#ifndef G_GNUC_PURE
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 96)
#  define G_GNUC_PURE __attribute__((__pure__))
# else
#  define G_GNUC_PURE
# endif
#endif /* not G_GNUC_PURE */
#ifndef G_GNUC_MALLOC
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 96)
#  define G_GNUC_MALLOC __attribute__((__malloc__))
# else
#  define G_GNUC_MALLOC
# endif
#endif /* not G_GNUC_MALLOC */
#ifndef G_GNUC_ALLOC_SIZE
# if (__GNUC__ > 4) || (__GNUC__ == 4 && __GNUC_MINOR__ >= 3)
#  define G_GNUC_ALLOC_SIZE(x) __attribute__((__alloc_size__(x)))
# else
#  define G_GNUC_ALLOC_SIZE(x)
# endif
#endif /* not G_GNUC_ALLOC_SIZE */
#ifndef G_GNUC_ALLOC_SIZE2
# if (__GNUC__ > 4) || (__GNUC__ == 4 && __GNUC_MINOR__ >= 3)
#  define G_GNUC_ALLOC_SIZE2(x,y) __attribute__((__alloc_size__(x,y)))
# else
#  define G_GNUC_ALLOC_SIZE2(x,y)
# endif
#endif /* not G_GNUC_ALLOC_SIZE2 */
#ifndef G_GNUC_DEPRECATED
# if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1)
#  define G_GNUC_DEPRECATED __attribute__((__deprecated__))
# else
#  define G_GNUC_DEPRECATED
# endif
#endif /* not G_GNUC_DEPRECATED */
#ifndef G_GNUC_NORETURN
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#  define G_GNUC_NORETURN __attribute__((__noreturn__))
# else
#  define G_GNUC_NORETURN
# endif
#endif /* not G_GNUC_NORETURN */
#ifndef G_GNUC_UNUSED
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#  define G_GNUC_UNUSED __attribute__((__unused__))
# else
#  define G_GNUC_UNUSED
# endif
#endif /* not G_GNUC_UNUSED */
#ifndef G_GNUC_PRINTF
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#  define G_GNUC_PRINTF(format_idx,arg_idx) __attribute__((__format__(__printf__,format_idx,arg_idx)))
# else
#  define G_GNUC_PRINTF(format_idx,arg_idx)
# endif
#endif /* not G_GNUC_PRINTF */
#ifndef G_GNUC_SCANF
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#  define G_GNUC_SCANF(format_idx,arg_idx) __attribute__((__format__(__scanf__,format_idx,arg_idx)))
# else
#  define G_GNUC_SCANF(format_idx,arg_idx)
# endif
#endif /* not G_GNUC_SCANF */
#ifndef G_GNUC_FORMAT
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#  define G_GNUC_FORMAT(arg_idx) __attribute__((__format_arg__(arg_idx)))
# else
#  define G_GNUC_FORMAT(arg_idx)
# endif
#endif /* not G_GNUC_FORMAT */
#ifndef G_GNUC_NULL_TERMINATED
# if __GNUC__ >= 4
#  define G_GNUC_NULL_TERMINATED __attribute__((__sentinel__))
# else
#  define G_GNUC_NULL_TERMINATED
# endif
#endif /* not G_GNUC_NULL_TERMINATED */
#ifndef G_GNUC_WARN_UNUSED_RESULT
# if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  define G_GNUC_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define G_GNUC_WARN_UNUSED_RESULT
# endif
#endif /* not G_GNUC_WARN_UNUSED_RESULT */
#ifndef G_GNUC_NO_INSTRUMENT
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#  define G_GNUC_NO_INSTRUMENT __attribute__((__no_instrument_function__))
# else
#  define G_GNUC_NO_INSTRUMENT
# endif
#endif /* not G_GNUC_NO_INSTRUMENT */
#ifndef G_GNUC_INTERNAL
# if defined (__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#  define G_GNUC_INTERNAL __attribute__((visibility("hidden")))
# elif defined (__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#  define G_GNUC_INTERNAL __hidden
# elif defined (__GNUC__) && defined (G_HAVE_GNUC_VISIBILITY)
#  define G_GNUC_INTERNAL __attribute__((visibility("hidden")))
# else
#  define G_GNUC_INTERNAL
# endif 
#endif /* not G_GNUC_INTERNAL */
#ifndef G_GNUC_MAY_ALIAS
# if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 3)
#  define G_GNUC_MAY_ALIAS __attribute__((may_alias))
# else
#  define G_GNUC_MAY_ALIAS
# endif
#endif /* not G_GNUC_MAY_ALIAS */
#if ! defined (G_LIKELY) || ! defined (G_UNLIKELY)
# if defined (__GNUC__) && __GNUC__ > 2 && defined (__OPTIMIZE__)
#  define _G_BOOLEAN_EXPR(expr) \
   __extension__ ({             \
     int _g_boolean_var_;       \
     if (expr)                  \
       _g_boolean_var_ = 1;     \
     else                       \
       _g_boolean_var_ = 0;     \
     _g_boolean_var_;           \
   })
#  ifndef G_LIKELY
#   define G_LIKELY(expr) (__builtin_expect(_G_BOOLEAN_EXPR(expr),1))
#  endif /* not G_LIKELY */
#  ifndef G_UNLIKELY
#   define G_UNLIKELY(expr) (__builtin_expect(_G_BOOLEAN_EXPR(expr),0))
#  endif /* not G_UNLIKELY */
# else /* not defined (__GNUC__) && __GNUC__ > 2 && defined (__OPTIMIZE__) */
#  ifndef G_LIKELY
#   define G_LIKELY(expr) (expr)
#  endif /* not G_LIKELY */
#  ifndef G_UNLIKELY
#   define G_UNLIKELY(expr) (expr)
#  endif /* not G_UNLIKELY */
# endif /* not defined (__GNUC__) && __GNUC__ > 2 && defined (__OPTIMIZE__) */
#endif /* ! defined (G_LIKELY) || ! defined (G_UNLIKELY) */
#ifndef G_STRLOC
# if defined (__GNUC__) && (__GNUC__ < 3) && ! defined (__cplusplus)
#  define G_STRLOC __FILE__ ":" G_STRINGIFY (__LINE__) ":" __PRETTY_FUNCTION__ "()"
# else
#  define G_STRLOC __FILE__ ":" G_STRINGIFY (__LINE__)
# endif
#endif /* not G_STRLOC */
#ifndef G_STRFUNC
# if defined (__GNUC__)
#  define G_STRFUNC ((const char*) (__PRETTY_FUNCTION__))
# elif defined (G_HAVE_ISO_VARARGS)
#  define G_STRFUNC ((const char*) (__func__))
# else
#  define G_STRFUNC ((const char*) ("???"))
# endif
#endif /* not G_STRFUNC */
#ifndef G_GINT16_MODIFIER
# define G_GINT16_MODIFIER "h"
#endif /* not G_GINT16_MODIFIER */
#ifndef G_GINT16_FORMAT
# define G_GINT16_FORMAT "hi"
#endif /* not G_GINT16_FORMAT */
#ifndef G_GUINT16_FORMAT
# define G_GUINT16_FORMAT "hu"
#endif /* not G_GUINT16_FORMAT */
#ifndef G_GINT32_MODIFIER
# define G_GINT32_MODIFIER ""
#endif /* not G_GINT32_MODIFIER */
#ifndef G_GINT32_FORMAT
# define G_GINT32_FORMAT "i"
#endif /* not G_GINT32_FORMAT */
#ifndef G_GUINT32_FORMAT
# define G_GUINT32_FORMAT "u"
#endif /* not G_GUINT32_FORMAT */
#ifndef G_GINT64_MODIFIER
# define G_GINT64_MODIFIER "I64"
#endif /* not G_GINT64_MODIFIER */
#ifndef G_GINT64_FORMAT
# define G_GINT64_FORMAT "I64i"
#endif /* not G_GINT64_FORMAT */
#ifndef G_GUINT64_FORMAT
# define G_GUINT64_FORMAT "I64u"
#endif /* not G_GUINT64_FORMAT */
#if defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64)
# ifndef G_GSIZE_MODIFIER
#  define G_GSIZE_MODIFIER G_GINT64_MODIFIER
# endif /* not G_GSIZE_MODIFIER */
# ifndef G_GSIZE_FORMAT
#  define G_GSIZE_FORMAT G_GUINT64_FORMAT
# endif /* not G_GSIZE_FORMAT */
# ifndef G_GSSIZE_FORMAT
#  define G_GSSIZE_FORMAT G_GINT64_FORMAT
# endif /* not G_GSSIZE_FORMAT */
#else /* not defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64) */
# ifndef G_GSIZE_MODIFIER
#  define G_GSIZE_MODIFIER G_GINT32_MODIFIER
# endif /* not G_GSIZE_MODIFIER */
# ifndef G_GSIZE_FORMAT
#  define G_GSIZE_FORMAT G_GUINT32_FORMAT
# endif /* not G_GSIZE_FORMAT */
# ifndef G_GSSIZE_FORMAT
#  define G_GSSIZE_FORMAT G_GINT32_FORMAT
# endif /* not G_GSSIZE_FORMAT */
#endif /* not defined (_WIN64) || defined (_M_X64) || defined (_M_AMD_64) */
#ifndef G_GOFFSET_MODIFIER
# define G_GOFFSET_MODIFIER G_GINT64_MODIFIER
#endif /* not G_GOFFSET_MODIFIER */
#ifndef G_GOFFSET_FORMAT
# define G_GOFFSET_FORMAT G_GINT64_FORMAT
#endif /* not G_GOFFSET_FORMAT */
#ifdef _WIN64
# ifndef G_GINTPTR_MODIFIER
#  define G_GINTPTR_MODIFIER G_GINT64_MODIFIER
# endif /* not G_GINTPTR_MODIFIER */
# ifndef G_GINTPTR_FORMAT
#  define G_GINTPTR_FORMAT G_GINT64_FORMAT
# endif /* not G_GINTPTR_FORMAT */
# ifndef G_GUINTPTR_FORMAT
#  define G_GUINTPTR_FORMAT G_GUINT64_FORMAT
# endif /* not G_GUINTPTR_FORMAT */
#else /* not _WIN64 */
# ifndef G_GINTPTR_MODIFIER
#  define G_GINTPTR_MODIFIER G_GINT32_MODIFIER
# endif /* not G_GINTPTR_MODIFIER */
# ifndef G_GINTPTR_FORMAT
#  define G_GINTPTR_FORMAT G_GINT32_FORMAT
# endif /* not G_GINTPTR_FORMAT */
# ifndef G_GUINTPTR_FORMAT
#  define G_GUINTPTR_FORMAT G_GUINT32_FORMAT
# endif /* not G_GUINTPTR_FORMAT */
#endif /* not _WIN64 */


/******************************************************************************
* Memory Allocation                                                           *
******************************************************************************/
#ifdef USE_GTK_EMULATE
gpointer g_malloc (gsize n_bytes);
gpointer g_malloc0 (gsize n_bytes);
gpointer g_realloc (gpointer mem, gsize n_bytes);
gpointer g_try_malloc (gsize n_bytes);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,8,0)
gpointer g_try_malloc0 (gsize n_bytes);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
#ifdef USE_GTK_EMULATE
gpointer g_try_realloc (gpointer mem, gsize n_bytes);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,24,0)
gpointer g_malloc_n (gsize n_blocks, gsize n_block_bytes);
gpointer g_malloc0_n (gsize n_blocks, gsize n_block_bytes);
gpointer g_realloc_n (gpointer mem, gsize n_blocks, gsize n_block_bytes);
gpointer g_try_malloc_n (gsize n_blocks, gsize n_block_bytes);
gpointer g_try_malloc0_n (gsize n_blocks, gsize n_block_bytes);
gpointer g_try_realloc_n (gpointer mem, gsize n_blocks, gsize n_block_bytes);
#endif /* not GLIB_CHECK_VERSION(2,24,0) */
#ifdef USE_GTK_EMULATE
void g_free (gpointer mem);
gpointer g_memmove (gpointer dest, gconstpointer src, gsize len);
gpointer g_memdup (gconstpointer mem, guint byte_size);
#endif /* USE_GTK_EMULATE */


/******************************************************************************
* Quarks                                                                      *
******************************************************************************/
#ifdef USE_GTK_EMULATE
typedef guint32 GQuark;
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,10,0)
# define g_intern_string(s) (s)
# define g_intern_static_string(s) (s)
#endif /* not GLIB_CHECK_VERSION(2,10,0) */


/******************************************************************************
* Error Reporting                                                             *
******************************************************************************/
#ifdef USE_GTK_EMULATE
typedef struct _GError {
  GQuark domain;
  gint code;
  gchar *message;
} GError;
#endif /* USE_GTK_EMULATE */


/******************************************************************************
* Message Output and Debugging Functions                                      *
******************************************************************************/
#ifdef USE_GTK_EMULATE
# define g_print printf
#endif /* USE_GTK_EMULATE */


/******************************************************************************
* String Utility Functions                                                    *
******************************************************************************/
#if GLIB_CHECK_VERSION(2,2,0)
# include <glib/gprintf.h>
#endif /* GLIB_CHECK_VERSION(2,2,0) */


#ifdef USE_GTK_EMULATE
gchar *g_strdup (const gchar *str);
gchar *g_strndup (const gchar *str, gsize n);
gchar **g_strdupv (gchar **str_array);
gchar *g_strnfill (gsize length, gchar fill_char);
gchar *g_stpcpy (gchar *dest, const gchar *src);
gchar *g_strstr_len (const gchar *haystack, gssize haystack_len, const gchar *needle);
gchar *g_strrstr (const gchar *haystack, const gchar *needle);
gchar *g_strrstr_len (const gchar *haystack, gssize haystack_len, const gchar *needle);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,2,0)
gboolean g_str_has_prefix (const gchar *str, const gchar *prefix);
gboolean g_str_has_suffix (const gchar *str, const gchar *suffix);
#endif /* GLIB_CHECK_VERSION(2,2,0) */
#if ! GLIB_CHECK_VERSION(2,16,0)
int g_strcmp0 (const char *str1, const char *str2);
#endif /* GLIB_CHECK_VERSION(2,16,0) */
#ifdef USE_GTK_EMULATE
gsize g_strlcpy (gchar *dest, const gchar *src, gsize dest_size);
gsize g_strlcat (gchar *dest, const gchar *src, gsize dest_size);
gchar *g_strdup_printf (const gchar *format, ...);
gchar *g_strdup_vprintf (const char *format, va_list args);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,2,0)
# define g_printf printf
# define g_vprintf vprintf
# define g_fprintf fprintf
# define g_vfprintf vfprintf
# define g_sprintf sprintf
# define g_vsprintf vsprintf
#endif /* GLIB_CHECK_VERSION(2,2,0) */
#if ! GLIB_CHECK_VERSION(2,4,0)
gint g_vasprintf (gchar **string, gchar const *format, va_list args);
#endif /* GLIB_CHECK_VERSION(2,4,0) */
#ifdef USE_GTK_EMULATE
gsize g_printf_string_upper_bound (const gchar *format, va_list args);
# define g_ascii_isalnum(c) isalnum(c)
# define g_ascii_isalpha(c) isalpha(c)
# define g_ascii_iscntrl(c) iscntrl(c)
# define g_ascii_isdigit(c) isdigit(c)
# define g_ascii_isgraph(c) isgraph(c)
# define g_ascii_islower(c) islower(c)
# define g_ascii_isprint(c) isprint(c)
# define g_ascii_ispunct(c) ispunct(c)
# define g_ascii_isspace(c) isspace(c)
# define g_ascii_isupper(c) isupper(c)
# define g_ascii_isxdigit(c) isxdigit(c)
gint g_ascii_digit_value (gchar c);
gint g_ascii_xdigit_value (gchar c);
gint g_ascii_strcasecmp (const gchar *s1, const gchar *s2);
gint g_ascii_strncasecmp (const gchar *s1, const gchar *s2, gsize n);
gchar *g_ascii_strup (const gchar *str, gssize len);
gchar *g_ascii_strdown (const gchar *str, gssize len);
# define g_ascii_tolower(c) tolower(c)
# define g_ascii_toupper(c) toupper(c)
gchar *g_strreverse (gchar *string);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,12,0)
gint64 g_ascii_strtoll (const gchar *nptr, gchar **endptr, guint base);
#endif /* not GLIB_CHECK_VERSION(2,12,0) */
#if ! GLIB_CHECK_VERSION(2,2,0)
guint64 g_ascii_strtoull (const gchar *nptr, gchar **endptr, guint base);
#endif /* not GLIB_CHECK_VERSION(2,2,0) */
#ifdef USE_GTK_EMULATE
gchar *g_strchug (gchar *string);
gchar *g_strchomp (gchar *string);
# define g_strstrip(string) g_strchomp(g_strchug(string))
gchar *g_strescape (const gchar *source, const gchar *exceptions);
gchar *g_strcompress (const gchar *source);
gchar **g_strsplit (const gchar *string, const gchar *delimiter, gint max_tokens);
void g_strfreev (gchar **str_array);
gchar *g_strconcat (const gchar *str, ...);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,6,0)
guint g_strv_length (gchar **str_array);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */


/******************************************************************************
* Character Set Conversion                                                    *
******************************************************************************/
#ifdef USE_GTK_EMULATE
gchar *g_locale_to_utf8 (const gchar *opsysstring, gssize len, gsize *bytes_read, gsize *bytes_written, GError **error);
gchar *g_locale_from_utf8 (const gchar *utf8string, gssize len, gsize *bytes_read, gsize *bytes_written, GError **error);
gchar *g_filename_to_utf8 (const gchar *opsysstring, gssize len, gsize *bytes_read, gsize *bytes_written, GError **error);
gchar *g_filename_from_utf8 (const gchar *utf8string, gssize len, gsize *bytes_read, gsize *bytes_written, GError **error);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,6,0)
gchar *g_filename_display_name (const gchar *filename);
gchar *g_filename_display_basename (const gchar *filename);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */


/******************************************************************************
* Unicode Manipulation                                                        *
******************************************************************************/
#ifdef USE_GTK_EMULATE
# define g_unichar_validate(c) (0x00 <= (c) && (c) <= 0xff)
# define g_unichar_isalnum(c) g_ascii_isalnum(c)
# define g_unichar_isalpha(c) g_ascii_isalpha(c)
# define g_unichar_iscntrl(c) g_ascii_iscntrl(c)
# define g_unichar_isdefined(c) g_unichar_validate(c)
# define g_unichar_isdigit(c) g_ascii_isdigit(c)
# define g_unichar_isgraph(c) g_ascii_isgraph(c)
# define g_unichar_islower(c) g_ascii_islower(c)
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,14,0)
# define g_unichar_ismark(c) FALSE
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
#ifdef USE_GTK_EMULATE
# define g_unichar_isprint(c) g_ascii_isprint(c)
# define g_unichar_ispunct(c) g_ascii_ispunct(c)
# define g_unichar_isspace(c) g_ascii_isspace(c)
# define g_unichar_istitle(c) FALSE
# define g_unichar_isupper(c) g_ascii_isupper(c)
# define g_unichar_isxdigit(c) g_ascii_isxdigit(c)
# define g_unichar_iswide(c) FALSE
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,12,0)
# define g_unichar_iswide_cjk(c) FALSE
#endif /* not GLIB_CHECK_VERSION(2,12,0) */
#if ! GLIB_CHECK_VERSION(2,14,0)
# define g_unichar_iszerowidth(c) FALSE
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
#ifdef USE_GTK_EMULATE
# define g_unichar_toupper(c) g_ascii_toupper(c)
# define g_unichar_tolower(c) g_ascii_tolower(c)
# define g_unichar_totitle(c) (c)
# define g_unichar_digit_value(c) g_ascii_digit_value(c)
# define g_unichar_xdigit_value(c) g_ascii_xdigit_value(c)
gchar *g_utf8_next_char (const gchar *p);
gunichar g_utf8_get_char_validated (const gchar *p, gssize max_len);
gchar *g_utf8_strup (const gchar *str, gssize len);
gchar *g_utf8_strdown (const gchar *str, gssize len);
gunichar2 *g_utf8_to_utf16 (const gchar *str, glong len, glong *items_read, glong *items_written, GError **error);
gchar *g_utf16_to_utf8 (const gunichar2 *str, glong len, glong *items_read, glong *items_written, GError **error);
gint g_unichar_to_utf8 (gunichar c, gchar *outbuf);
#endif /* USE_GTK_EMULATE */


/******************************************************************************
* Data Checksums                                                              *
******************************************************************************/
#if ! GLIB_CHECK_VERSION(2,16,0)
typedef enum {
  G_CHECKSUM_MD5,
  G_CHECKSUM_SHA1,
  G_CHECKSUM_SHA256
} GChecksumType;
typedef struct _GChecksum GChecksum;


gssize g_checksum_type_get_length (GChecksumType checksum_type);
GChecksum *g_checksum_new (GChecksumType checksum_type);
GChecksum *g_checksum_copy (const GChecksum *checksum);
void g_checksum_free (GChecksum *checksum);
void g_checksum_reset (GChecksum *checksum);
void g_checksum_update (GChecksum *checksum, const guchar *data, gssize length);
const gchar *g_checksum_get_string (GChecksum *checksum);
void g_checksum_get_digest (GChecksum *checksum, guint8 *buffer, gsize *digest_len);
gchar *g_compute_checksum_for_data (GChecksumType  checksum_type, const guchar *data, gsize length);
gchar *g_compute_checksum_for_string (GChecksumType checksum_type, const gchar *str, gssize length);
#endif /* not GLIB_CHECK_VERSION(2,16,0) */


/******************************************************************************
* Internationalization                                                        *
******************************************************************************/
#if GLIB_CHECK_VERSION(2,4,0)
# include <glib/gi18n.h>
#else /* not GLIB_CHECK_VERSION(2,4,0) */
# ifdef ENABLE_NLS
#  include <libintl.h>
#  define _(String) dgettext(PACKAGE,String)
#  ifdef gettext_noop
#   define N_(String) gettext_noop(String)
#  else /* not gettext_noop */
#   define N_(String) (String)
#  endif /* not gettext_noop */
#  define Q_(String) g_strip_context((String),gettext(String))
# else /* not ENABLE_NLS */
#  define _(String) (String)
#  define N_(String) (String)
#  define Q_(String) (String)
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,String) (String)
#  define dcgettext(Domain,String,Type) (String)
#  define bindtextdomain(Domain,Directory) (Domain)
# endif /* not ENABLE_NLS */
#endif /* not GLIB_CHECK_VERSION(2,4,0) */


/******************************************************************************
* Date and Time Functions                                                     *
******************************************************************************/
#ifndef G_USEC_PER_SEC
# define G_USEC_PER_SEC 1000000
#endif /* not G_USEC_PER_SEC */
#ifdef USE_GTK_EMULATE
typedef struct _GTimeVal
{
  glong tv_sec;
  glong tv_usec;
} GTimeVal;


void g_get_current_time (GTimeVal *result);
void g_usleep (gulong microseconds);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,28,0)
gint64 g_get_monotonic_time (void);
gint64 g_get_real_time (void);
#endif /* not GLIB_CHECK_VERSION(2,28,0) */


/******************************************************************************
* GDateTime                                                                   *
******************************************************************************/
#ifndef G_TIME_SPAN_DAY
# define G_TIME_SPAN_DAY         (G_GINT64_CONSTANT (86400000000))
#endif /* not G_TIME_SPAN_DAY */
#ifndef G_TIME_SPAN_HOUR
# define G_TIME_SPAN_HOUR        (G_GINT64_CONSTANT (3600000000))
#endif /* not G_TIME_SPAN_HOUR */
#ifndef G_TIME_SPAN_MINUTE
# define G_TIME_SPAN_MINUTE      (G_GINT64_CONSTANT (60000000))
#endif /* not G_TIME_SPAN_MINUTE */
#ifndef G_TIME_SPAN_SECOND
# define G_TIME_SPAN_SECOND      (G_GINT64_CONSTANT (1000000))
#endif /* not G_TIME_SPAN_SECOND */
#ifndef G_TIME_SPAN_MILLISECOND
# define G_TIME_SPAN_MILLISECOND (G_GINT64_CONSTANT (1000))
#endif /* not G_TIME_SPAN_MILLISECOND */
#if ! GLIB_CHECK_VERSION(2,26,0)
typedef gint64 GTimeSpan;
typedef struct _GDateTime GDateTime;


void g_date_time_unref (GDateTime *datetime);
GDateTime *g_date_time_ref (GDateTime *datetime);
GDateTime *g_date_time_new_now_utc (void);
GDateTime *g_date_time_new_from_unix_utc (gint64 t);
GDateTime *g_date_time_new_from_timeval_utc (const GTimeVal *tv);
GDateTime *g_date_time_new_utc (gint year, gint month, gint day, gint hour, gint minute, gdouble seconds);
GDateTime *g_date_time_add (GDateTime *datetime, GTimeSpan timespan);
GDateTime *g_date_time_add_years (GDateTime *datetime, gint years);
GDateTime *g_date_time_add_months (GDateTime *datetime, gint months);
GDateTime *g_date_time_add_weeks (GDateTime *datetime, gint weeks);
GDateTime *g_date_time_add_days (GDateTime *datetime, gint days);
GDateTime *g_date_time_add_hours (GDateTime *datetime, gint hours);
GDateTime *g_date_time_add_minutes (GDateTime *datetime, gint minutes);
GDateTime *g_date_time_add_seconds (GDateTime *datetime, gdouble seconds);
GDateTime *g_date_time_add_full (GDateTime *datetime, gint years, gint months, gint days, gint hours, gint minutes, gdouble seconds);
gint g_date_time_compare (gconstpointer dt1, gconstpointer dt2);
GTimeSpan g_date_time_difference (GDateTime *end, GDateTime *begin);
guint g_date_time_hash (gconstpointer datetime);
gboolean g_date_time_equal (gconstpointer dt1, gconstpointer dt2);
void g_date_time_get_ymd (GDateTime *datetime, gint *year, gint *month, gint *day);
gint g_date_time_get_year (GDateTime *datetime);
gint g_date_time_get_month (GDateTime *datetime);
gint g_date_time_get_day_of_month (GDateTime *datetime);
gint g_date_time_get_hour (GDateTime *datetime);
gint g_date_time_get_minute (GDateTime *datetime);
gint g_date_time_get_second (GDateTime *datetime);
gint g_date_time_get_microsecond (GDateTime *datetime);
gdouble g_date_time_get_seconds (GDateTime *datetime);
gint64 g_date_time_to_unix (GDateTime *datetime);
gboolean g_date_time_to_timeval (GDateTime *datetime, GTimeVal *tv);
#endif /* not GLIB_CHECK_VERSION(2,26,0) */


/******************************************************************************
* Miscellaneous Utility Functions                                             *
******************************************************************************/
#ifdef USE_GTK_EMULATE
gchar *g_get_prgname (void);
void g_set_prgname (const gchar *prgname);
const gchar *g_getenv (const gchar *variable);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,4,0)
gboolean g_setenv (const gchar *variable, const gchar *value, gboolean overwrite);
void g_unsetenv (const gchar *variable);
#endif /* not GLIB_CHECK_VERSION(2,4,0) */
#ifdef USE_GTK_EMULATE
const gchar *g_get_user_name (void);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,6,0)
const gchar *g_get_user_cache_dir (void);
const gchar *g_get_user_data_dir (void);
const gchar *g_get_user_config_dir (void);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
#ifdef USE_GTK_EMULATE
const gchar *g_get_home_dir (void);
const gchar *g_get_tmp_dir (void);
gchar *g_get_current_dir (void);
gboolean g_path_is_absolute (const gchar *file);
gchar *g_path_get_basename (const gchar *file);
gchar *g_path_get_dirname (const gchar *file);
gchar *g_build_filename (const gchar *first_element, ...);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,8,0)
gchar *g_build_filenamev (gchar **args);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
#ifdef USE_GTK_EMULATE
gchar *g_build_path (const gchar *separator, const gchar *first_element, ...);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,8,0)
gchar *g_build_pathv (const gchar *separator, gchar **args);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */


/******************************************************************************
* File Utilities                                                              *
******************************************************************************/
#if GLIB_CHECK_VERSION(2,6,0)
# include <glib/gstdio.h>
#endif /* GLIB_CHECK_VERSION(2,6,0) */


#ifdef USE_GTK_EMULATE
typedef enum _GFileTest
{
  G_FILE_TEST_IS_REGULAR    = 1 << 0,
  G_FILE_TEST_IS_SYMLINK    = 1 << 1,
  G_FILE_TEST_IS_DIR        = 1 << 2,
  G_FILE_TEST_IS_EXECUTABLE = 1 << 3,
  G_FILE_TEST_EXISTS        = 1 << 4
} GFileTest;


gboolean g_file_test (const gchar *file, GFileTest test);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,26,0)
typedef struct stat GStatBuf;
#endif /* not GLIB_CHECK_VERSION(2,26,0) */


#if ! GLIB_CHECK_VERSION(2,26,0)
gchar *g_mkdtemp (gchar *tmpl);
gchar *g_mkdtemp_full (gchar *tmpl, gint mode);
#endif /* not GLIB_CHECK_VERSION(2,26,0) */
#if ! GLIB_CHECK_VERSION(2,30,0)
gchar *g_dir_make_tmp (const gchar *tmpl, GError **error);
#endif /* not GLIB_CHECK_VERSION(2,30,0) */
#if ! GLIB_CHECK_VERSION(2,22,0)
# define g_mapped_file_unref(file) g_mapped_file_free(file)
#endif /* not GLIB_CHECK_VERSION(2,22,0) */
#if ! GLIB_CHECK_VERSION(2,6,0)
# define g_open open
# define g_rename rename
# ifdef G_OS_WIN32
gint g_mkdir (const gchar *filename, gint mode);
# else /* not G_OS_WIN32 */
#  define g_mkdir mkdir
# endif /* not G_OS_WIN32 */
# define g_stat stat
# ifdef HAVE_LSTAT
#  define g_lstat lstat
# else /* not HAVE_LSTAT */
#  define g_lstat stat
# endif /* not HAVE_LSTAT */
# define g_unlink unlink
# define g_remove remove
# define g_rmdir rmdir
# define g_fopen fopen
# define g_freopen freopen
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
#if ! GLIB_CHECK_VERSION(2,8,0)
# ifdef G_OS_WIN32
gint g_chmod (const gchar *filename, gint mode);
gint g_access (const gchar *filename, gint mode);
gint g_creat (const gchar *filename, gint mode);
gint g_chdir (const gchar *path);
# else /* not G_OS_WIN32 */
#  define g_chmod chmod
#  define g_access access
#  define g_creat creat
#  define g_chdir chdir
# endif /* not G_OS_WIN32 */
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
#if ! GLIB_CHECK_VERSION(2,18,0)
# ifdef G_OS_WIN32
# include <sys/utime.h>
# endif /* G_OS_WIN32 */
# ifdef HAVE_UTIME_H
# include <utime.h>
# endif /* HAVE_UTIME_H */
gint g_utime (const gchar *filename, struct utimbuf *utb);
#endif /* not GLIB_CHECK_VERSION(2,18,0) */


/******************************************************************************
* Directory Utilities                                                         *
******************************************************************************/
#ifdef USE_GTK_EMULATE
typedef struct _GDir GDir;


GDir *g_dir_open (const gchar *path, guint flags, GError **error);
const gchar *g_dir_read_name (GDir *dir);
void g_dir_close (GDir *dir);
#endif /* USE_GTK_EMULATE */


/******************************************************************************
* URI Utilities                                                               *
******************************************************************************/
#ifndef G_URI_RESERVED_CHARS_GENERIC_DELIMITERS
# define G_URI_RESERVED_CHARS_GENERIC_DELIMITERS ":/?#[]@"
#endif /* not G_URI_RESERVED_CHARS_GENERIC_DELIMITERS */
#ifndef G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS
# define G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS "!$&'()*+,;="
#endif /* not G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS */
#ifndef G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT
# define G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS ":@"
#endif /* not G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT */
#ifndef G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS
# define G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT "/"
#endif /* not G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS */
#ifndef G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS
# define G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS ":"
#endif /* not G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS */
#if ! GLIB_CHECK_VERSION(2,16,0)
gchar *g_uri_parse_scheme (const gchar *uri);
gchar *g_uri_escape_string (const gchar *unescaped, const gchar *reserved_chars_allowed, gboolean allow_utf8);
gchar *g_uri_unescape_string (const gchar *escaped_string, const gchar *illegal_characters);
gchar *g_uri_unescape_segment (const gchar *escaped_string, const gchar *escaped_string_end, const gchar *illegal_characters);
#endif /* not GLIB_CHECK_VERSION(2,16,0) */


/******************************************************************************
* Windows Compatibility Functions                                             *
******************************************************************************/
#ifdef G_OS_WIN32
# ifndef MAXPATHLEN
#  define MAXPATHLEN 1024
# endif /* not MAXPATHLEN */
# ifndef G_WIN32_HAVE_WIDECHAR_API
#  define G_WIN32_HAVE_WIDECHAR_API() TRUE
# endif /* not G_WIN32_HAVE_WIDECHAR_API */
# ifndef G_WIN32_IS_NT_BASED
#  define G_WIN32_IS_NT_BASED() TRUE
# endif /* not G_WIN32_IS_NT_BASED */


# if ! GLIB_CHECK_VERSION(2,8,0)
gchar *g_win32_locale_filename_from_utf8 (const gchar *utf8filename);
# endif /* not GLIB_CHECK_VERSION(2,8,0) */
#endif /* G_OS_WIN32 */


/******************************************************************************
* Doubly-Linked Lists                                                         *
******************************************************************************/
#ifdef USE_GTK_EMULATE
typedef struct _GList {
  gpointer data;
  struct _GList *prev;
  struct _GList *next;
} GList;
typedef gint (*GCompareDataFunc) (gconstpointer a, gconstpointer b, gpointer user_data);
typedef gint (*GCompareFunc) (gconstpointer a, gconstpointer b);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,4,0)
typedef gpointer (*GCopyFunc) (gconstpointer src, gpointer data);
#endif /* not GLIB_CHECK_VERSION(2,4,0) */
#ifdef USE_GTK_EMULATE
typedef void (*GDestroyNotify) (gpointer data);
typedef void (*GFunc) (gpointer data, gpointer user_data);


GList *g_list_append (GList *list, gpointer data);
GList *g_list_prepend (GList *glist, gpointer  data);
GList *g_list_insert (GList *glist, gpointer data, gint position);
GList *g_list_insert_before (GList *glist, GList *sibling, gpointer data);
GList *g_list_insert_sorted (GList *glist, gpointer data, GCompareFunc compare);
GList *g_list_remove (GList *glist, gconstpointer data);
GList *g_list_remove_link (GList *glist, GList *glink);
GList *g_list_delete_link (GList *glist, GList *glink);
GList *g_list_remove_all (GList *glist, gconstpointer data);
void g_list_free (GList *glist);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,28,0)
void g_list_free_full (GList *glist, GDestroyNotify destroy);
#endif /* not GLIB_CHECK_VERSION(2,28,0) */
#ifdef USE_GTK_EMULATE
GList *g_list_alloc (void);
void g_list_free_1 (GList *glist);
# define g_list_free1 g_list_free_1
guint g_list_length (GList *glist);
GList *g_list_copy (GList *glist);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,34,0)
GList *g_list_copy_deep (GList *glist, GCopyFunc func, gpointer user_data);
#endif /* not GLIB_CHECK_VERSION(2,34,0) */
#ifdef USE_GTK_EMULATE
GList *g_list_reverse (GList *glist);
GList *g_list_sort (GList *glist, GCompareFunc compare_func);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,10,0)
GList *g_list_insert_sorted_with_data (GList *glist, gpointer data, GCompareDataFunc func, gpointer user_data);
#endif /* not GLIB_CHECK_VERSION(2,10,0) */
#ifdef USE_GTK_EMULATE
GList *g_list_sort_with_data (GList *glist, GCompareDataFunc compare_func, gpointer user_data);
GList *g_list_concat (GList *glist1, GList *glist2);
void g_list_foreach (GList *glist, GFunc func, gpointer user_data);
GList *g_list_first (GList *glist);
GList *g_list_last (GList *glist);
# define g_list_previous(glist) ((glist)?((GList *)(glist))->prev:NULL)
# define g_list_next(glist) ((glist)?((GList *)(glist))->next:NULL)
GList *g_list_nth (GList *glist, guint n);
gpointer g_list_nth_data (GList *glist, guint n);
GList *g_list_nth_prev (GList *glist, guint n);
GList *g_list_find (GList *glist, gconstpointer data);
GList *g_list_find_custom (GList *glist, gconstpointer data, GCompareFunc compare);
gint g_list_position (GList *glist, GList *llink);
gint g_list_index (GList *glist, gconstpointer data);
#endif /* USE_GTK_EMULATE */


/******************************************************************************
* Hash Tables                                                                 *
******************************************************************************/
#ifdef USE_GTK_EMULATE
typedef struct _GHashTable GHashTable;
typedef guint (*GHashFunc) (gconstpointer key);
typedef gboolean (*GEqualFunc) (gconstpointer a, gconstpointer b);
typedef void (*GHFunc) (gpointer key, gpointer value, gpointer user_data);
typedef gboolean (*GHRFunc) (gpointer key, gpointer value, gpointer user_data);


GHashTable *g_hash_table_new (GHashFunc hash_func, GEqualFunc key_equal_func);
GHashTable *g_hash_table_new_full (GHashFunc hash_func, GEqualFunc key_equal_func, GDestroyNotify key_destroy_func, GDestroyNotify value_destroy_func);
void g_hash_table_insert (GHashTable *hash_table, gpointer key, gpointer value);
guint g_hash_table_size (GHashTable *hash_table);
gpointer g_hash_table_lookup (GHashTable *hash_table, gconstpointer key);
void g_hash_table_foreach (GHashTable *hash_table, GHFunc func, gpointer user_data);
gboolean g_hash_table_remove (GHashTable *hash_table, gconstpointer key);
guint g_hash_table_foreach_remove (GHashTable *hash_table, GHRFunc func, gpointer user_data);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,14,0)
GList *g_hash_table_get_keys (GHashTable *hash_table);
GList *g_hash_table_get_values (GHashTable *hash_table);
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
#ifdef USE_GTK_EMULATE
void g_hash_table_destroy (GHashTable *hash_table);
gboolean g_direct_equal (gconstpointer v1, gconstpointer v2);
guint g_direct_hash (gconstpointer v);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,22,0)
gboolean g_int64_equal (gconstpointer v1, gconstpointer v2);
guint g_int64_hash (gconstpointer v);
gboolean g_double_equal (gconstpointer v1, gconstpointer v2);
guint g_double_hash (gconstpointer v);
#endif /* not GLIB_CHECK_VERSION(2,22,0) */
#ifdef USE_GTK_EMULATE
gboolean g_str_equal (gconstpointer v1, gconstpointer v2);
guint g_str_hash (gconstpointer v);
#endif /* USE_GTK_EMULATE */


/******************************************************************************
* Type Information                                                            *
******************************************************************************/
#ifndef G_DEFINE_TYPE
# define G_DEFINE_TYPE(TypeName,type_name,TYPE_PARENT)                         G_DEFINE_TYPE_EXTENDED(TypeName,type_name,TYPE_PARENT,0,{})
#endif /* not G_DEFINE_TYPE */
#ifndef G_DEFINE_TYPE_WITH_CODE
# define G_DEFINE_TYPE_WITH_CODE(TypeName,type_name,TYPE_PARENT,CODE)          _G_DEFINE_TYPE_EXTENDED_BEGIN(TypeName,type_name,TYPE_PARENT,0) {CODE;} _G_DEFINE_TYPE_EXTENDED_END()
#endif /* not G_DEFINE_TYPE_WITH_CODE */
#ifndef G_DEFINE_ABSTRACT_TYPE
# define G_DEFINE_ABSTRACT_TYPE(TypeName,type_name,TYPE_PARENT)                G_DEFINE_TYPE_EXTENDED(TypeName,type_name,TYPE_PARENT,G_TYPE_FLAG_ABSTRACT,{})
#endif /* not G_DEFINE_ABSTRACT_TYPE */
#ifndef G_DEFINE_ABSTRACT_TYPE_WITH_CODE
# define G_DEFINE_ABSTRACT_TYPE_WITH_CODE(TypeName,type_name,TYPE_PARENT,CODE) _G_DEFINE_TYPE_EXTENDED_BEGIN(TypeName,type_name,TYPE_PARENT,G_TYPE_FLAG_ABSTRACT) {CODE;} _G_DEFINE_TYPE_EXTENDED_END()
#endif /* not G_DEFINE_ABSTRACT_TYPE_WITH_CODE */
#ifndef G_DEFINE_TYPE_EXTENDED
# define G_DEFINE_TYPE_EXTENDED(TypeName,type_name,TYPE_PARENT,flags,CODE)     _G_DEFINE_TYPE_EXTENDED_BEGIN(TypeName,type_name,TYPE_PARENT,flags) {CODE;} _G_DEFINE_TYPE_EXTENDED_END()
#endif /* not G_DEFINE_TYPE_EXTENDED */
#ifndef G_IMPLEMENT_INTERFACE
# define G_IMPLEMENT_INTERFACE(TYPE_IFACE,iface_init) \
  { \
    const GInterfaceInfo g_implement_interface_info = { \
      (GInterfaceInitFunc) iface_init, NULL, NULL \
    }; \
    g_type_add_interface_static (g_define_type_id, TYPE_IFACE, &g_implement_interface_info); \
  }
#endif /* not G_IMPLEMENT_INTERFACE */
#ifndef _G_DEFINE_TYPE_EXTENDED_BEGIN
# define _G_DEFINE_TYPE_EXTENDED_BEGIN(TypeName,type_name,TYPE_PARENT,flags) \
                                                                             \
static void     type_name##_init              (TypeName        *self);       \
static void     type_name##_class_init        (TypeName##Class *klass);      \
static gpointer type_name##_parent_class = NULL;                             \
static void     type_name##_class_intern_init (gpointer klass)               \
{                                                                            \
  type_name##_parent_class = g_type_class_peek_parent (klass);               \
  type_name##_class_init ((TypeName##Class*) klass);                         \
}                                                                            \
                                                                             \
GType                                                                        \
type_name##_get_type (void)                                                  \
{                                                                            \
  static GType g_define_type_id = 0;                                         \
  if (G_UNLIKELY (g_define_type_id == 0))                                    \
    {                                                                        \
      static const GTypeInfo g_define_type_info = {                          \
        sizeof (TypeName##Class),                                            \
        NULL,                                                                \
        NULL,                                                                \
        (GClassInitFunc) type_name##_class_intern_init,                      \
        NULL,                                                                \
        NULL,                                                                \
        sizeof (TypeName),                                                   \
        0,                                                                   \
        (GInstanceInitFunc) type_name##_init,                                \
        NULL                                                                 \
      };                                                                     \
                                                                             \
      g_define_type_id = g_type_register_static (TYPE_PARENT,                \
                                        g_intern_static_string (#TypeName),  \
                                        &g_define_type_info,                 \
                                        (GTypeFlags)flags);                  \
      {
#endif /* not _G_DEFINE_TYPE_EXTENDED_BEGIN */
#ifndef _G_DEFINE_TYPE_EXTENDED_END
# define _G_DEFINE_TYPE_EXTENDED_END()                                       \
      }                                                                      \
    }                                                                        \
  return g_define_type_id;                                                   \
}
#endif /* not _G_DEFINE_TYPE_EXTENDED_END */


/******************************************************************************
* Version Information                                                         *
******************************************************************************/
#ifndef GTK_MAJOR_VERSION
# define GTK_MAJOR_VERSION 2
#endif /* not GTK_MAJOR_VERSION */
#ifndef GTK_MINOR_VERSION
# define GTK_MINOR_VERSION 0
#endif /* not GTK_MINOR_VERSION */
#ifndef GTK_MICRO_VERSION
# define GTK_MICRO_VERSION 0
#endif /* not GTK_MICRO_VERSION */
#ifndef GTK_CHECK_VERSION
# define GTK_CHECK_VERSION(major,minor,micro)                        \
    (GTK_MAJOR_VERSION > (major) ||                                  \
    (GTK_MAJOR_VERSION == (major) && GTK_MINOR_VERSION > (minor)) || \
    (GTK_MAJOR_VERSION == (major) && GTK_MINOR_VERSION == (minor) && \
     GTK_MICRO_VERSION >= (micro)))
#endif /* not GTK_CHECK_VERSION */


/******************************************************************************
* Main loop and Events                                                        *
******************************************************************************/
#ifdef USE_GTK_EMULATE
gchar *gtk_set_locale (void);
void gtk_init (int *argc, char ***argv);
#endif /* USE_GTK_EMULATE */


/******************************************************************************
* Selections                                                                  *
******************************************************************************/
#ifndef USE_GTK_EMULATE
# if ! GTK_CHECK_VERSION(2,16,0)
GdkAtom gtk_selection_data_get_selection (GtkSelectionData *selection_data);
# endif /* not GTK_CHECK_VERSION(2,16,0) */
# if ! GTK_CHECK_VERSION(2,14,0)
const guchar *gtk_selection_data_get_data (GtkSelectionData *selection_data);
gint gtk_selection_data_get_length (GtkSelectionData *selection_data);
GdkAtom gtk_selection_data_get_data_type (GtkSelectionData *selection_data);
GdkDisplay *gtk_selection_data_get_display (GtkSelectionData *selection_data);
gint gtk_selection_data_get_format (GtkSelectionData *selection_data);
GdkAtom gtk_selection_data_get_target (GtkSelectionData *selection_data);
# endif /* not GTK_CHECK_VERSION(2,1,0) */
#endif /* not USE_GTK_EMULATE */


/******************************************************************************
* Signals                                                                     *
******************************************************************************/
#if ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,16,0)
GdkAtom gtk_selection_data_get_selection (GtkSelectionData *selection_data);
#endif /* ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,16,0) */


/******************************************************************************
* GtkDialog                                                                   *
******************************************************************************/
#if ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,14,0)
GtkWidget *gtk_dialog_get_action_area (GtkDialog *dialog);
GtkWidget *gtk_dialog_get_content_area (GtkDialog *dialog);
#endif /* ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,14,0) */


/******************************************************************************
* GtkColorSelectionDialog                                                     *
******************************************************************************/
#if ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,14,0)
GtkWidget *gtk_color_selection_dialog_get_color_selection (GtkColorSelectionDialog *colorsel);
#endif /* ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,14,0) */


/******************************************************************************
* GtkAdjustment                                                               *
******************************************************************************/
#if ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,14,0)
gdouble gtk_adjustment_get_lower (GtkAdjustment *adjustment);
void gtk_adjustment_set_lower (GtkAdjustment *adjustment, gdouble lower);
gdouble gtk_adjustment_get_upper (GtkAdjustment *adjustment);
void gtk_adjustment_set_upper (GtkAdjustment *adjustment, gdouble upper);
gdouble gtk_adjustment_get_step_increment (GtkAdjustment *adjustment);
void gtk_adjustment_set_step_increment (GtkAdjustment *adjustment, gdouble step_increment);
gdouble gtk_adjustment_get_page_increment (GtkAdjustment *adjustment);
void gtk_adjustment_set_page_increment (GtkAdjustment *adjustment, gdouble page_increment);
gdouble gtk_adjustment_get_page_size (GtkAdjustment *adjustment);
void gtk_adjustment_set_page_size (GtkAdjustment *adjustment, gdouble page_size);
#endif /* ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,14,0) */


/******************************************************************************
* GtkWidget                                                                   *
******************************************************************************/
#ifndef USE_GTK_EMULATE
# if ! GTK_CHECK_VERSION(2,14,0)
GdkWindow *gtk_widget_get_window (GtkWidget *widget);
# endif /* not GTK_CHECK_VERSION(2,14,0) */
# if ! GTK_CHECK_VERSION(2,18,0)
void gtk_widget_get_allocation (GtkWidget *widget, GtkAllocation *allocation);
void gtk_widget_set_allocation (GtkWidget *widget, const GtkAllocation *allocation);
GtkStateType gtk_widget_get_state (GtkWidget *widget);
gboolean gtk_widget_is_toplevel (GtkWidget *widget);
gboolean gtk_widget_get_has_window (GtkWidget *widget);
void gtk_widget_set_has_window (GtkWidget *widget, gboolean has_window);
# endif /* not GTK_CHECK_VERSION(2,18,0) */
# if ! GTK_CHECK_VERSION(2,20,0)
gboolean gtk_widget_get_realized (GtkWidget *widget);
void gtk_widget_set_realized (GtkWidget *widget, gboolean realized);
gboolean gtk_widget_get_mapped (GtkWidget *widget);
void gtk_widget_set_mapped (GtkWidget *widget, gboolean mapped);
# endif /* not GTK_CHECK_VERSION(2,20,0) */
# if ! GTK_CHECK_VERSION(2,18,0)
gboolean gtk_widget_get_visible (GtkWidget *widget);
void gtk_widget_set_visible (GtkWidget *widget, gboolean visible);
gboolean gtk_widget_is_drawable (GtkWidget *widget);
gboolean gtk_widget_get_sensitive (GtkWidget *widget);
gboolean gtk_widget_is_sensitive (GtkWidget *widget);
gboolean gtk_widget_get_can_focus (GtkWidget *widget);
void gtk_widget_set_can_focus (GtkWidget *widget, gboolean can_focus);
gboolean gtk_widget_has_focus (GtkWidget *widget);
gboolean gtk_widget_get_can_default (GtkWidget *widget);
void gtk_widget_set_can_default (GtkWidget *widget, gboolean can_default);
gboolean gtk_widget_get_receives_default (GtkWidget *widget);
void gtk_widget_set_receives_default (GtkWidget *widget, gboolean receives_default);
gboolean gtk_widget_has_default (GtkWidget *widget);
# endif /* not GTK_CHECK_VERSION(2,18,0) */
# if ! GTK_CHECK_VERSION(2,20,0)
gboolean gtk_widget_has_rc_style (GtkWidget *widget);
# endif /* not GTK_CHECK_VERSION(2,20,0) */
# if ! GTK_CHECK_VERSION(2,18,0)
gboolean gtk_widget_get_app_paintable (GtkWidget *widget);
gboolean gtk_widget_get_double_buffered (GtkWidget *widget);
# endif /* not GTK_CHECK_VERSION(2,18,0) */
#endif /* not USE_GTK_EMULATE */


/******************************************************************************
* Extended                                                                    *
******************************************************************************/
#ifndef G_MINLONGLONG
# define G_MINLONGLONG G_MININT64
#endif /* not G_MINLONGLONG */
#ifndef G_MAXLONGLONG
# define G_MAXLONGLONG G_MAXINT64
#endif /* not G_MAXLONGLONG */
#ifndef G_MAXULONGLONG
# define G_MAXULONGLONG G_MAXUINT64
#endif /* not G_MAXULONGLONG */
#ifndef G_GLONGLONG_MODIFIER
# define G_GLONGLONG_MODIFIER "ll"
#endif /* not G_GLONGLONG_MODIFIER */
#ifndef G_GLONGLONG_FORMAT
# define G_GLONGLONG_FORMAT "li"
#endif /* not G_GLONGLONG_FORMAT */
#ifndef G_GULONGLONG_FORMAT
# define G_GULONGLONG_FORMAT "lu"
#endif /* not G_GULONGLONG_FORMAT */


typedef gint64 glonglong;
typedef guint64 gulonglong;


gchar *g_strcpy (gchar *dest, const gchar *src);
gchar *g_strncpy (gchar *dest, const gchar *src, const gsize n);
gchar *g_strcat (gchar *dest, const gchar *src);
gchar *g_strncat (gchar *dest, const gchar *src, const gsize n);
gint g_strcmp (const gchar *s1, const gchar *s2);
gint g_strncmp (const gchar *s1, const gchar *s2, const gsize n);
gchar *g_strchr (const gchar *s, const gint c);
gchar *g_strrchr (const gchar *s, const gint c);
gsize g_strspn (const gchar *s, const gchar *accept);
gsize g_strcspn (const gchar *s, const gchar *reject);
gchar *g_strpbrk (const gchar *s, const gchar *accept);
gchar *g_strstr (const gchar *haystack, const gchar *needle);
gsize g_strlen (const gchar *s);
gchar *g_strtok (gchar *str, const gchar *delim);
glong g_strtol (const gchar *nptr, gchar **endptr, gint base);
gulong g_strtoul (const gchar *nptr, gchar **endptr, gint base);
gint g_memcmp (gconstpointer s1, gconstpointer s2, const gsize n);
gpointer g_memchr (gconstpointer s, const gint c, const gsize n);
gpointer g_memset (gpointer s, const gint c, const gsize n);
gint g_asprintf (gchar **string, gchar const *format, ...);
#ifdef G_OS_WIN32
# define g_strfilecmp g_ascii_strcasecmp
# define g_strfilencmp g_ascii_strncasecmp
#else /* not G_OS_WIN32 */
# define g_strfilecmp g_strcmp
# define g_strfilencmp g_strncmp
#endif /* not G_OS_WIN32 */


#ifndef SPACING
# define SPACING 5
#endif /* not SPACING */
#if defined (USE_THREAD) && ! defined (G_THREADS_ENABLED)
# undef USE_THREAD
#endif /* defined (USE_THREAD) && ! defined (G_THREADS_ENABLED) */


/******************************************************************************
* Key-value file parser                                                       *
******************************************************************************/
#include "profile.h"


/******************************************************************************
* Key Values                                                                  *
******************************************************************************/
#ifndef USE_GTK_EMULATE
# include <gdk/gdkkeysyms.h>
# include "gkeysyms.h"
#endif /* not USE_GTK_EMULATE */


#endif /* __GCOMMON_H__ */
