/*
    Text maid
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "tmaid.h"
#ifdef G_OS_WIN32
# include <windows.h>
#endif /* G_OS_WIN32 */
#include "abort.h"
#include "file.h"
#include "find.h"
#include "general.h"
#include "icons.h"
#include "jump.h"
#include "keyfile.h"
#include "menu.h"
#include "panel.h"
#include "print.h"
#include "repinfo.h"
#include "replace.h"
#include "sigfile.h"
#include "sigmain.h"
#include "misc/argument.h"
#include "misc/gnugpl.h"
#include "misc/license.h"
#include "misc/misc.h"
#include "orz/orzaccel.h"
#include "orz/orzcomm.h"
#include "orz/orzhistory.h"
#include "orz/orzmdi.h"
#include "orz/orzwinmenu.h"


gboolean caret = FALSE;             /* ja:キャレットの形 */
gboolean ins = TRUE;                /* ja:TRUE:挿入,FALSE:上書き */
gboolean newfile = FALSE;           /* ja:TRUE:新規ファイル,FALSE:なし */
gboolean second = FALSE;            /* ja:TRUE:新規,FALSE:既存 */
gchar *open_path = NULL;            /* ja:開くのパス */
gchar *save_path = NULL;            /* ja:名前を付けて保存のパス */
gchar *clipboard_text = NULL;       /* ja:クリップボードのテキスト */
gint def_width, def_height;         /* ja:デフォルトのウインドウのサイズ */
gint ftnum = 0;                     /* ja:ファイルタイプの数 */
#if GTK_CHECK_VERSION(2,4,0) || defined (G_OS_WIN32)
gint findex = 0;                    /* ja:ファイルタイプのフィルタ */
#endif /* GTK_CHECK_VERSION(2,4,0) || defined (G_OS_WIN32) */
gint license = -1;                  /* ja:ライセンス */
gint tcount = 0;                    /* ja:ファイルタイプのカウンタ */
guint timer_id = 0;                 /* ja:タイマID */
FileType *ftype = NULL;             /* ja:ファイルタイプ */
GObject *history;                   /* ja:ファイルの履歴 */
GdkAtom atom_targets;               /* ja:ターゲット */
GdkAtom atom_text;                  /* ja:テキスト */
GdkAtom atom_compound;              /* ja:コンパウンド */
GdkAtom atom_utf8;                  /* ja:UTF-8 */
GtkPositionType n_pos = GTK_POS_TOP;/* ja:ノートブックの位置 */
GtkWidget *window;                  /* ja:ウインドウ */
GtkWidget *mdi;                     /* en:MDI */
GtkWidget *status;                  /* ja:ステータスウインドウ */
GtkWidget *label_cursor;            /* ja:カーソル座標 */
GtkWidget *main_box;                /* ja:メインボックス */
PangoFontDescription *system_font = NULL;
GdkColor system_color[12] = {
    {0, 0x0000, 0x0000, 0x0000}, {0, 0xffff, 0xffff, 0xffff},
    {0, 0x8000, 0x8000, 0x8000}, {0, 0x8000, 0x8000, 0x8000},
    {0, 0x8000, 0x8000, 0x8000}, {0, 0x8000, 0x8000, 0x8000},
    {0, 0x8000, 0x8000, 0x8000}, {0, 0xa000, 0xa000, 0xa000},
    {0, 0xffff, 0xffff, 0xffff}, {0, 0x0000, 0x0000, 0x8000},
    {0, 0x0000, 0x0000, 0x0000}, {0, 0xffff, 0xffff, 0xffff}};
GtkTargetEntry targets[4] = {       /* ja:Text maidが提供可能なセレクション */
    {"STRING",        0, TARGET_STRING},
    {"TEXT",          0, TARGET_TEXT},
    {"COMPOUND_TEXT", 0, TARGET_COMPOUND_TEXT},
    {"UTF8_STRING",   0, TARGET_UTF8}};


/******************************************************************************
*                                                                             *
* ja:メイン関数                                                               *
*                                                                             *
******************************************************************************/
int
main (int   argc,
      char *argv[])
{
  gboolean *arg_files, success[12];
  gchar *file;
  gint i, count = 0, init_line = 0;
  GList *glist;
  GObject *accel, *winmenu;
  GtkAccelGroup *accel_group;
  GtkStyle *style;
  GtkWidget *frame, *handle, *label, *table, *vbox;
  /* en:Drag and Drop */
  GtkTargetEntry drag_types[1] = {{"text/uri-list", 0, 0}};
  /* ja:コマンドライン */
  gint array[2], def[2];
  ArgumentBool arg_n, arg_p, arg_x;
  ArgumentValue arg_h, arg_l;
  ArgumentArray arg_s;
  ArgumentExit arg_g, arg_v;
  ArgumentHelp arg_q;
  ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),                    ARGUMENT_TYPE_VALUE, &arg_h},
{"line",    'l',  "NUM",          N_("Caret Position"),             ARGUMENT_TYPE_VALUE, &arg_l},
{"new",     'n',  "ON/OFF",       N_("New File"),                   ARGUMENT_TYPE_BOOL,  &arg_n},
{"profile", 'p',  "ON/OFF",       N_("Profile"),                    ARGUMENT_TYPE_BOOL,  &arg_p},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"),                ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"),                ARGUMENT_TYPE_BOOL,  &arg_x},
{"license", 'g',  NULL,           N_("GNU GENERAL PUBLIC LICENSE"), ARGUMENT_TYPE_EXIT,  &arg_g},
{"version", 'v',  NULL,           N_("About"),                      ARGUMENT_TYPE_EXIT,  &arg_v},
{"help",    '?',  NULL,           N_("Help"),                       ARGUMENT_TYPE_HELP,  &arg_q},
{NULL,      '\0', NULL,           NULL,                             0,                   NULL}};

  /* ja:初期化 */
#ifdef G_OS_WIN32
  SetErrorMode (SetErrorMode (0) | SEM_FAILCRITICALERRORS);
#endif /* G_OS_WIN32 */
  setlocale (LC_ALL, "");
#if ! GTK_CHECK_VERSION(2,24,0)
  gtk_set_locale ();
#endif /* not GTK_CHECK_VERSION(2,24,0) */
  gtk_init (&argc, &argv);
  file = misc_spec_locale (argv[0]);
  bindtextdomain (PACKAGE, file);
  g_free (file);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);

  g_memset (find_text, 0, FIND_TEXT * sizeof (gchar *));
  g_memset (replace_text, 0, REPLACE_TEXT * sizeof (gchar *));

  def_width = gdk_screen_width () * 2 / 3;
  def_height = gdk_screen_height () * 2 / 3;

  /* ja:ファイルの履歴 */
  history = orz_history_new ();

  /* ja:キーファイルから読み込む */
  file = misc_spec_config ("maid.org", "tmaid", "main");
  keyfile_read (file);

  if (license_hash (gnugpl) != license)
    license = license_dialog (gnugpl);
  if (license < 0)
    return 0;

  /* ja:コマンドライン */
  /* ja:ファイルの履歴 */
  arg_h.val = orz_history_get_num (ORZ_HISTORY (history));
  arg_h.def = ORZ_HISTORY_NUM_DEF;
  /* ja:初期のキャレット位置 */
  arg_l.val = init_line;
  arg_l.def = 0;
  /* ja:新規ファイル */
  arg_n.flag = newfile;
  arg_n.def = FALSE;
  /* ja:レジストリ */
  arg_p.flag = TRUE;
  arg_p.def = TRUE;
  /* ja:ウインドウサイズ */
  array[0] = def_width;
  array[1] = def_height;
  def[0] = gdk_screen_width () * 2 / 3;
  def[1] = gdk_screen_height () * 2 / 3;
  arg_s.leng = 2;
  arg_s.array = array;
  arg_s.def = def;
  /* ja:新規ウインドウ */
  arg_x.flag = second;
  arg_x.def = FALSE;
  /* ja:ライセンス */
  arg_g.str = gnugpl;
  /* ja:バージョン */
  arg_v.str =
TMAID_VERSION_NOTICE"\n"
TMAID_COPYRIGHT_NOTICE"\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
  /* ja:ヘルプ */
  arg_q.str = TMAID_COPYRIGHT_NOTICE"\n\n";
  /* ja:コマンドラインの解析 */
  arg_files = arg_analyse (argv, arg_opts);
  /* ja:ファイルの履歴 */
  orz_history_set_num (ORZ_HISTORY (history), arg_h.val);
  /* ja:初期のキャレット位置 */
  if (arg_l.val >= 0)
    init_line = arg_l.val;
  /* ja:新規ファイル */
  newfile = arg_n.flag;
  /* ja:レジストリ */
  if (!arg_p.flag)
    {
      g_free (file);
      file = NULL;
    }
  /* ja:ウインドウサイズ */
  def_width = array[0];
  def_height = array[1];
  /* ja:新規ウインドウ */
  second = arg_x.flag;

  /* ja:メインウインドウ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Text maid");
  gtk_window_set_default_size (GTK_WINDOW (window), def_width, def_height);
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  glist = g_list_append (NULL, gdk_pixbuf_new_from_xpm_data (tmaid16_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (tmaid24_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (tmaid32_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (tmaid48_xpm));
  gtk_window_set_default_icon_list (glist);
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 0)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 1)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 2)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 3)));
  g_list_free (glist);
  g_signal_connect (G_OBJECT(window), "delete-event",
                                            G_CALLBACK (signal_delete), NULL);
  g_signal_connect (G_OBJECT (window), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  gtk_widget_realize (window);
  /* en:Drag and Drop */
  gtk_drag_dest_set (window, GTK_DEST_DEFAULT_ALL,
                    drag_types, G_N_ELEMENTS (drag_types), GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (window), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
  /* ja:クリップボード */
  atom_targets = gdk_atom_intern ("TARGETS", FALSE);
  atom_compound = gdk_atom_intern ("COMPOUND_TEXT", FALSE);
  atom_text = gdk_atom_intern ("TEXT", FALSE);
  atom_utf8 = gdk_atom_intern ("UTF8_STRING", FALSE);
  gtk_selection_add_targets (window, GDK_SELECTION_PRIMARY,
                                            targets, G_N_ELEMENTS (targets));
  gtk_selection_add_targets (window, GDK_SELECTION_CLIPBOARD,
                                            targets, G_N_ELEMENTS (targets));
  g_signal_connect (G_OBJECT (window), "selection-clear-event",
                                    G_CALLBACK (signal_selection_clear), NULL);
  g_signal_connect (G_OBJECT (window), "selection-get",
                                    G_CALLBACK (signal_selection_get), NULL);
  g_signal_connect (G_OBJECT (window), "selection-received",
                                G_CALLBACK (signal_selection_received), NULL);
  /* en:MDI */
  mdi = orz_mdi_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (mdi), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (mdi), n_pos);
  gtk_drag_dest_set (mdi, GTK_DEST_DEFAULT_ALL,
                    drag_types, G_N_ELEMENTS (drag_types), GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (mdi), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
  g_signal_connect (G_OBJECT (mdi), "close-window",
                                G_CALLBACK (signal_close_window), NULL);
  g_signal_connect (G_OBJECT (mdi), "switch-window",
                                G_CALLBACK (signal_switch_window), NULL);
  g_signal_connect (G_OBJECT (mdi), "destroy",
                                G_CALLBACK (signal_destroy_mdi), NULL);
  /* ja:ポップアップ */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (popup_entries, accel_group);
  /* ja:メニュー */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (menu_entries, accel_group);
  /* ja:ファイルの履歴 */
  for (i = 0; menu_entries[i].path; i++)
    if (g_str_has_prefix (menu_entries[i].path, "/file/"))
      count++;
  orz_history_set_menu (ORZ_HISTORY (history),
                        misc_find_menu (menu_entries, "/file/"), count - 3);
  g_signal_connect (ORZ_HISTORY (history), "activate",
                            G_CALLBACK (signal_activate_menu_history), NULL);
  /* ja:ウインドウメニュー */
  winmenu = orz_winmenu_new ();
  orz_winmenu_set_mdi (ORZ_WINMENU (winmenu), ORZ_MDI (mdi));
  orz_winmenu_set_menu (ORZ_WINMENU (winmenu),
                                misc_find_menu (menu_entries, "/window/"), 0);
  /* ja:アクセルグループ */
  accel = orz_accel_new ();
  orz_accel_set_window (ORZ_ACCEL (accel), GTK_WINDOW (window));
  orz_accel_add_accel_group (ORZ_ACCEL (accel), accel_group);
  /* ja:メインボックス */
  main_box = gtk_vbox_new (FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_find_menu (menu_entries, "/"));
  gtk_box_pack_start (GTK_BOX (main_box), handle, FALSE, FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_create_toolbar (toolbar_entries));
  gtk_box_pack_start (GTK_BOX (main_box), handle, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), mdi, TRUE, TRUE, 0);

  /* ja:ステータスバー */
  status = gtk_statusbar_new ();
  /* ja:カーソル座標 */
  label_cursor = gtk_label_new ("");
  gtk_label_set_justify (GTK_LABEL (label_cursor), GTK_JUSTIFY_CENTER);
  frame = gtk_frame_new (NULL);
  gtk_container_add (GTK_CONTAINER (frame), label_cursor);
  /* ja:テーブル */
  table = gtk_table_new (1, 5, FALSE);
  gtk_table_attach (GTK_TABLE (table), frame, 0, 1, 0, 1,
            GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach (GTK_TABLE (table), status, 1, 5, 0, 1,
            GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
  /* ja:テキスト */
  label = gtk_label_new ("");
  g_signal_connect (G_OBJECT (label), "style-set",
                                        G_CALLBACK (signal_style_set), NULL);
  /* ja:垂直ボックス */
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), main_box, TRUE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), table, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), find_box_get_widget (), FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox),
                                repinfo_box_get_widget (), FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), abort_box_get_widget (), FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), label, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  /* ja:タイマ */
  timer_id = g_timeout_add (500, signal_timeout, NULL);

  /* ja:メニュー表示 */
  set_menu_bar (NULL);

  /* ja:既に起動しているかチェックする */
  if (!second)
    {
      GObject *comm;

      comm = orz_comm_new (window, "Text maid InterProcess communication");
      if (!orz_comm_is_first (ORZ_COMM (comm)))
        {
          orz_comm_send_with_files (ORZ_COMM (comm), argc, argv, arg_files);
          return 0;
        }
      g_signal_connect (G_OBJECT (comm), "recv",
                                    G_CALLBACK (signal_selection_recv), NULL);
    }

  /* ja:表示 */
  gtk_widget_show_all (window);
  gtk_widget_hide (abort_box);
  gtk_widget_hide (find_box);
  gtk_widget_hide (repinfo_box);
  gtk_widget_hide (label);

  /* ja:システム色 */
  style = gtk_widget_get_style (label);
  system_color[0] = style->text[0];
  system_color[1] = style->base[0];
  system_color[2] = style->dark[0];
  system_color[3] = style->dark[0];
  system_color[4] = style->dark[0];
  system_color[5] = style->dark[0];
  system_color[6] = style->dark[0];
  system_color[7] = style->mid[0];
  system_color[8] = style->fg[3];
  system_color[9] = style->bg[3];
#if ! GTK_CHECK_VERSION(3,0,0)
  gdk_colormap_alloc_colors (gdk_colormap_get_system (),
                                    system_color, 12, FALSE, TRUE, success);
#endif /* not GTK_CHECK_VERSION(3,0,0) */
  /* ja:システムフォント */
  system_font = pango_font_description_copy
                                    (pango_context_get_font_description
                                    (gtk_widget_get_pango_context (label)));

  /* ja:新規ウインドウ */
  count = 0;
  for (i = 1; i < argc; i++)
    if (arg_files[i])
      {
        TmaidWindow *tmaid;

        tmaid = file_open_edit (argv[i]);
        if (init_line != 0)/* ja:指定行に移動 */
          jump_operation (tmaid, init_line);
        count++;
      }
  g_free (arg_files);
  if (newfile && count <= 0)
    file_open_edit (NULL);

  gtk_main ();

  /* ja:キーファイルに書き込む */
  keyfile_write (file);
  g_free (file);

  pango_font_description_free (system_font);
  g_free (clipboard_text);
  g_free (open_path);
  g_free (save_path);
#ifdef G_OS_UNIX
  g_free (printer.printer);
#endif /* G_OS_UNIX */
#ifndef G_OS_WIN32
  g_free (printer.file);
#endif /* not G_OS_WIN32 */
  for (i = 0; i < FIND_TEXT; i++)
    g_free (find_text[i]);
  for (i = 0; i < REPLACE_TEXT; i++)
    g_free (replace_text[i]);
  for (i = 0; i < ftnum; i++)
    {
      g_free (ftype[i].text);
      g_free (ftype[i].ext);
      g_free (ftype[i].font_name);
    }
  g_free (ftype);
  return 0;
}
