/*
    imectrl
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <tchar.h>
#include "imectrl.h"
#include <ime.h>


/******************************************************************************
*                                                                             *
* ja:IME֐                                                              *
*                                                                             *
******************************************************************************/
static HINSTANCE hLib = NULL;
static FARPROC lpSendIMEMessageEx = NULL;


/*  ja:IME                                                      */
VOID
InitIme (VOID)
{
  if (!hLib && (hLib = LoadLibrary (_T("USER32.DLL"))))
#ifdef UNICODE
    lpSendIMEMessageEx = GetProcAddress (hLib, "SendIMEMessageExW");
#else /* not UNICODE */
    lpSendIMEMessageEx = GetProcAddress (hLib, "SendIMEMessageExA");
#endif /* not UNICODE */
}


/*  ja:IMEI                                                        */
VOID
ExitIme (VOID)
{
  if (hLib)
    FreeLibrary (hLib);
  lpSendIMEMessageEx = NULL;
  hLib = NULL;
}


/*  ja:IMËʒuݒ肷
    hWnd,EChE
       x,xW
       y,yW
     RET,TRUE:I,FALSE:G[                                         */
BOOL
SetImePos (HWND      hWnd,
           const int x,
           const int y)
{
  HGLOBAL hGlobal;
  LPIMESTRUCT lpIme;

  if (!lpSendIMEMessageEx)
    return TRUE;
  hGlobal = GlobalAlloc (GMEM_MOVEABLE | GMEM_SHARE, sizeof (IMESTRUCT));
  if (!hGlobal)
    return FALSE;
  lpIme = GlobalLock (hGlobal);
  if (!lpIme)
    {
      GlobalFree (hGlobal);
      return FALSE;
    }
  lpIme->fnc = IME_SETCONVERSIONWINDOW;
  lpIme->wParam = y < 0 ? MCW_DEFAULT : MCW_WINDOW;
  lpIme->lParam1 = MAKELPARAM (x, y);
  GlobalUnlock (hGlobal);
  if (!lpSendIMEMessageEx (hWnd, (LPARAM)hGlobal))
    {
      GlobalFree (hGlobal);
      return FALSE;
    }
  return !GlobalFree (hGlobal);
}


/*  IMẼtHgݒ肷
    hWnd,EChE
      lf,tHg
     RET,TRUE:I,FALSE:G[                                         */
BOOL
SetImeFont (HWND hWnd,
            LPLOGFONT lf)
{
  HGLOBAL hGlobal0, hGlobal1;
  LPIMESTRUCT lpIme;
  LPLOGFONT logfont;

  if (!lpSendIMEMessageEx)
    return TRUE;
  hGlobal0 = GlobalAlloc (GMEM_MOVEABLE | GMEM_SHARE, sizeof (IMESTRUCT));
  if (!hGlobal0)
    return FALSE;
  lpIme = GlobalLock (hGlobal0);
  if (!lpIme)
    {
      GlobalFree (hGlobal0);
      return FALSE;
    }
  hGlobal1 = GlobalAlloc (GMEM_MOVEABLE | GMEM_SHARE, sizeof (LOGFONT));
  if (!hGlobal1)
    {
      GlobalUnlock (hGlobal0);
      GlobalFree (hGlobal0);
      return FALSE;
    }
  logfont = GlobalLock (hGlobal1);
  if (!logfont)
    {
      GlobalUnlock (hGlobal0);
      GlobalFree (hGlobal0);
      GlobalFree (hGlobal1);
      return FALSE;
    }
  *logfont = *lf;
  GlobalUnlock (hGlobal1);
  lpIme->fnc = IME_SETCONVERSIONFONTEX;
  lpIme->lParam1 = (LPARAM)hGlobal1;
  GlobalUnlock (hGlobal0);
  if (!lpSendIMEMessageEx (hWnd, (LPARAM)hGlobal0))
    {
      GlobalFree (hGlobal0);
      GlobalFree (hGlobal1);
      return FALSE;
    }
  return !GlobalFree (hGlobal0) & !GlobalFree (hGlobal1);
}
