/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "repinfo.h"
#include <limits.h>
#include "other.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:u_CAOQ                                                     *
*                                                                             *
******************************************************************************/
BOOL CALLBACK RepinfoDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
  static POINT ptDlg = {INT_MIN, INT_MIN};/* ja:_CAO̕\ʒu */

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          TCHAR szText[64];

          if (ptDlg.x != INT_MIN && ptDlg.y != INT_MIN && !SetWindowPos (hDlg,
                        0, ptDlg.x, ptDlg.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER))
            {
              MessageBox (hDlg, _T("SetWindowPos"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          wsprintf (szText, LoadText (hInst, IDS_REPINFO_SELECT),
                                            ((LPREPINFO)lParam)->ptStart.x + 1,
                                            ((LPREPINFO)lParam)->ptStart.y + 1,
                                            ((LPREPINFO)lParam)->ptEnd.x + 1,
                                            ((LPREPINFO)lParam)->ptEnd.y + 1);
          if (!SetDlgItemText (hDlg, IDC_STATICA1, ((LPREPINFO)lParam)->szSrc)
                || !SetDlgItemText (hDlg, IDC_STATICA2,
                                                    ((LPREPINFO)lParam)->szDst)
                || !SetDlgItemText (hDlg, IDC_STATICA3, szText)
                || !SetDlgItemText (hDlg, IDC_STATICA4,
                                        ((LPREPINFO)lParam)->bCase
                                        ? LoadText (hInst, IDS_REPINFO_BS0)
                                        : LoadText (hInst, IDS_REPINFO_BS1))
                || !SetDlgItemText (hDlg, IDC_STATICA5,
                                        ((LPREPINFO)lParam)->bWidth
                                        ? LoadText (hInst, IDS_REPINFO_FH0)
                                        : LoadText (hInst, IDS_REPINFO_FH1))
                || !SetDlgItemText (hDlg, IDC_STATICA6,
                                        ((LPREPINFO)lParam)->bArrow
                                        ? LoadText (hInst, IDS_REPINFO_UD0)
                                        : LoadText (hInst, IDS_REPINFO_UD1)))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDC_PUSHBUTTONA1:
            case IDYES:
            case IDNO:
            case IDCANCEL:
              {
                RECT rc;

                if (GetWindowRect (hDlg, &rc))
                  {
                    ptDlg.x = rc.left;
                    ptDlg.y = rc.top;
                  }
                else
                  {
                    MessageBox (hDlg, _T("GetWindowRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  }
                if (!EndDialog (hDlg, LOWORD (wParam)))
                  MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              }
          }
        return TRUE;
    }
  return FALSE;
}
