/*
    Text maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#include "common.h"
#include "intl.h"


#ifdef USE_GDKPIXBUF
#define MENUFILE 12
#else
#define MENUFILE 10
#endif


typedef struct FileType_Tag {
	gint ft_id;					/* ե륿פID */
	gboolean autoindent;		/* TRUE:ư */
	gboolean associate;			/* TRUE:ϢŤ */
	gboolean code;				/* TRUE:֤Υɤɽ */
	gboolean crlf;				/* TRUE:ԥɤɽ */
	gboolean eof;				/* TRUE:1Ahե˽񤭲ä */
	gboolean limit;				/* TRUE:ޡޤ֤ */
	gboolean overwrite;			/* TRUE:ե񤭤Ȥ˳ǧ */
	gboolean space;				/* TRUE:ڡ򳥿λͳѤɽ */
	gboolean syscol;			/* TRUE:ƥ࿧Ȥ */
	gboolean gline;				/* TRUE:åɽ */
	gboolean mline;				/* TRUE:ޡɽ */
	gboolean uline;				/* TRUE:ֲɽ */
	gboolean vline;				/* TRUE:ֽɽ */
	gchar *text,*ext;			/* ̾,ĥ */
	gchar *font_name;			/* ե̾ */
	gint margin;				/* ޡο */
	gint tab;					/* ֤ο */
	GdkColor color[12];			/*  */
} FileType;
typedef struct TmaidHistory_Tag {
	gboolean caret;
	gchar *text;
	gint length;				/* ʸ */
	GdkPoint cursor,select;
	struct TmaidHistory_Tag *next;
} TmaidHistory;
typedef struct LineBuffer_Tag {
	gboolean margin;			/* TRUE:ޡ,FALSE:̾β */
	gchar *text;
	gint length;				/* ʸ */
	struct LineBuffer_Tag *prev,*next;
} LineBuffer;
typedef struct TmaidWindow_Tag {
	gboolean create;			/* TRUE:,FALSE:¸ե */
	gboolean edit;				/* TRUE:ԽѤ,FALSE:̤Խ */
	gboolean autoindent;		/* TRUE:ư */
	gboolean code;				/* TRUE:֤Υɤɽ */
	gboolean crlf;				/* TRUE:ԥɤɽ */
	gboolean eof;				/* TRUE:1Ahե˽񤭲ä */
	gboolean limit;				/* TRUE:ޡޤ֤ */
	gboolean overwrite;			/* TRUE:ե񤭤Ȥ˳ǧ */
	gboolean space;				/* TRUE:ڡ򳥿λͳѤɽ */
	gboolean syscol;			/* TRUE:ƥ࿧Ȥ */
	gboolean gline;				/* TRUE:åɽ */
	gboolean mline;				/* TRUE:ޡɽ */
	gboolean uline;				/* TRUE:ֲɽ */
	gboolean vline;				/* TRUE:ֽɽ */
	gchar *file;				/* ե̾ */
	gchar *font_name;			/* ե̾ */
	gint ft_id;					/* ե륿פID(-1:̵°) */
	gint font_width;			/* եȤβ */
	gint font_height;			/* եȤι⤵ */
	gint font_ascent;			/* եȤΥȤι⤵ */
	gint margin;				/* ޡο */
	gint max;					/* Կ */
	gint off;					/* startȤ */
	gint same;					/* -1:ʣʤ,0:ֹ */
	gint tab;					/* ֤ο */
	guint timer_id;				/* ѥ */
	LineBuffer *start;			/* ꥹ */
	TmaidHistory *undo,*redo;	/* Խ */
	GdkColor color[12];			/*  */
	GdkFont *font;				/* ե */
	GdkIC *ic;					/* XIM */
	GdkICAttr *ic_attr;			/* XIM° */
	GdkPoint top;				/* ɥƬ */
	GdkPoint cursor;			/* åȤΰ */
	GdkPoint select;			/* 򳫻ϰ,-1:ʤ */
	GtkWidget *drawing;			/* ΰ */
	GtkWidget *hscroll;			/* ʿС */
	GtkWidget *vscroll;			/* ľС */
	GtkWidget *label;			/* ֤Υ٥ */
	GtkWidget *menu_item;		/* ˥塼Υɥι */
} TmaidWindow;


enum {
	TARGET_STRING,
	TARGET_TEXT,
	TARGET_COMPOUND_TEXT
};


extern gboolean caret;					/* åȤη */
extern gboolean ins;					/* TRUE:,FALSE: */
extern gboolean newfile;				/* TRUE:ե,FALSE:ʤ */
extern gboolean second;					/* TRUE:,FALSE:¸ */
extern gchar *history_files[10];		/* ե */
extern gchar *open_path;				/* Υѥ */
extern gchar *save_path;				/* ̾դ¸Υѥ */
extern gchar *clipboard_text;			/* åץܡɤΥƥ */
extern gchar *arg_text;					/* ץ̿ѿ */
extern gint def_width,def_height;		/* ǥեȤΥɥΥ */
extern gint ftnum;						/* ե륿פο */
extern gint history;					/* ե */
extern gint init_line;					/* ΥåȰ */
extern gint instance;					/* ץ̿ѿ */
extern gint tcount;						/* ե륿פΥ */
extern guint timer_id;					/* ID */
extern FileType *ftype;					/* ե륿 */
extern GdkAtom atom_clipboard;			/* åץܡ */
extern GdkAtom atom_targets;			/* å */
extern GdkAtom atom_compound;			/* ѥ */
extern GdkAtom atom_text;				/* ƥ */
extern GdkAtom atom_textmaid0;			/* ץ̿ѥȥ */
extern GdkAtom atom_textmaid1;			/* ץ̿ѥȥ */
extern GtkWidget *window;				/* ɥ */
extern GtkWidget *notebook;				/* Ρȥ֥å */
extern GtkWidget *status;				/* ơɥ */
extern GtkPositionType n_pos;			/* Ρȥ֥åΰ */
extern GtkItemFactory *item_factory_menu;	/* ˥塼 */
extern GtkItemFactory *item_factory_popup;	/* ݥåץå */
extern GdkFont *system_font;
extern GdkColor system_color[12];
extern GtkTargetEntry targets[3];		/* Text maid󶡲ǽʥ쥯 */


#endif
/*
ɽ
 0,ʸ
 1,ط
 2,ȥ륳
 3,ѥڡ
 4,ԥ
 5,ֲ
 6,ޡ
 7,å
 8,򤵤줿ʸ
 9,򤵤줿ط
10,ʸ()
11,ȥ륳()
*/
