/*
    Text maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "abort.h"
#include "charset.h"
#include "edit.h"
#include "find.h"
#include "general.h"
#include "signal.h"
#include "misc/misc.h"


gboolean find_arrow=TRUE;					/*  */
gboolean find_ignorecase=FALSE;				/*  */
gchar *find_text[32];						/* ʸ */
gint find_num=0;							/* ϿƤ븡ʸ */


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	ʸμ
	  type,ʸ°ǼХåե
	  text,ʸ
	length,ǡ														*/
static void make_char_type(gint *type,const gchar *text,const gint length)
{
	gint i=0,j;

	while (i<length)
		if (i+charset->length[(gint)(guchar)text[i]]<=length) {
			for (j=0;j<charset->length[(gint)(guchar)text[i]];j++)
				type[i+j]=j+1;
			i+=charset->length[(gint)(guchar)text[i]];
		} else {
			type[i++]=1;
		}
}


/*	
	     tmaid,TXTɥ
	     start,ϰ
	       end,ϰ(x=-1ʤϰϤʤ)
	      find,ʸ
	     arrow,TRUE:,FALSE:
	ignorecase,TRUE:ʸʸ̤,FALSE:ʸʸ̤ʤ	*/
void find_operation(TmaidWindow *tmaid,GdkPoint *start,GdkPoint *end,
			const gchar *find,const gboolean arrow,const gboolean ignorecase)
{
	gboolean result;			/* Ӥη,TRUE:Ʊ,FALSE:ۤʤ */
	gchar *text;
	gint i,max=0,sx,sy;
	gint length0,length1=0;		/* ʸ(Хñ) */
	gint *buf=NULL,*type=NULL;
	LineBuffer *p,*q;
	GdkPoint cursor,select,top,st,ed,data;
	GtkWidget *dialog;

	st=*start;
	ed=*end;
	cursor=tmaid->cursor;
	tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
	length0=g_strlen(find);
	for (i=0;i<256;i++)
		if (charset->length[i]>max)
			max=charset->length[i];
	text=g_malloc((length0+max)*sizeof(gchar));
	buf=g_malloc((length0+max)*sizeof(gint));
	if (tmaid->select.x>=0) {
		/* ϰϤ */
		select=tmaid->select;
		tmaid->select.x=-1;
		clear_sel(tmaid,&select,&tmaid->cursor);
	}
	if (ed.x>=0) {
		/* ̤ˤΤȤˤ̵ */
		i=edit_get_sel_bytes(tmaid,&st,&ed);
		if (i<=length0) {
			edit_cpy_sel_mem(tmaid,&st,&ed,text);
			text[i]='\0';
			if (ignorecase)	/* ʸ/ʸ̤ */
				result=g_strcmp(find,text)==0;
			else			/* ʸ/ʸ̤ʤ */
				result=g_strcasecmp(find,text)==0;
			if (result)
				ed.x=-1;
		}
	}
	if (ed.x<0) {
		if (arrow) {
			ed.x=edit_get_width(tmaid,tmaid->max-1);
			ed.y=tmaid->max-1;/*  */
		} else {
			ed.x=ed.y=0;/*  */
		}
	}
	if ((arrow && (ed.y<st.y || (st.y==ed.y && ed.x<=st.x)))
					|| (!arrow && (st.y<ed.y || (st.y==ed.y && st.x<=ed.x))))
		return;/* ϰϤ̷⤹Ȥ */
	/* ܥå */
	userbreak=TRUE;
	dialog=abort_dialog(_("Finding"));
	gtk_grab_add(dialog);
	ed.x=edit_get_data_pos(tmaid,ed.x,ed.y,FALSE);
	st.x=edit_get_data_pos(tmaid,st.x,st.y,FALSE);
	p=edit_get_line_buf(&tmaid->start,&tmaid->off,st.y);
	/* ƱʸӤ뤿ʸ */
	q=p;
	data=st;
	if (st.y<ed.y || (st.y==ed.y && st.x<ed.x)) {
		/* 夫鲼 */
		while (st.y<ed.y || (st.y==ed.y && st.x<ed.x)) {
			/* ХåեκǸʸä */
			while (length1<length0
						&& (data.y<ed.y || (data.y==ed.y && data.x<ed.x))) {
				if (data.x<q->length) {
					/* ʸ */
					if (data.x+charset->length[(gint)(guchar)q->text[data.x]]
																<=q->length) {
						g_memmove(text+length1,q->text+data.x,
								charset->length[(gint)(guchar)q->text[data.x]]
															*sizeof(gchar));
						for (i=0;
							i<charset->length[(gint)(guchar)q->text[data.x]];
																		i++)
							buf[i+length1]=charset->length[(gint)(guchar)
															q->text[data.x]];
						length1
							+=charset->length[(gint)(guchar)q->text[data.x]];
						data.x
							+=charset->length[(gint)(guchar)q->text[data.x]];
					} else {
						text[length1]=q->text[data.x];
						buf[length1]=1;
						length1++;
						data.x++;
					}
				} else {
					/*  */
					while (gtk_events_pending())
						gtk_main_iteration();
					if (!userbreak)
						goto loop;
					if (!q->margin) {
						text[length1]='\n';
						buf[length1]=1;
						length1++;
					}
					data.x=0;
					data.y++;
					q=q->next;
				}
			}
			text[length1]='\0';
			/*  */
			if (ignorecase)	/* ʸ/ʸ̤ */
				result=g_strcmp(find,text)==0;
			else			/* ʸ/ʸ̤ʤ */
				result=g_strcasecmp(find,text)==0;
			if (result) {
				/* פȤ */
				if (p->margin && p->length<=st.x) {
					/* ޡΤȤˤϼιԤƬ */
					st.x=0;
					st.y++;
				}
				tmaid->select.x=edit_get_screen_pos(tmaid,st.x,st.y);
				tmaid->select.y=st.y;
				if (q->margin && q->length<=data.x) {
					/* ޡΤȤˤϼιԤƬ */
					data.x=0;
					data.y++;
				}
				tmaid->cursor.x=edit_get_screen_pos(tmaid,data.x,data.y);
				tmaid->cursor.y=data.y;
				break;
			}
			/* ХåեƬʸ˴ */
			if (st.x<p->length) {
				st.x+=buf[0];
			} else {
				st.x=p->margin?buf[0]:0;
				st.y++;
				p=p->next;
			}
			length1-=buf[0];
			g_memmove(text,text+buf[0],length1*sizeof(gchar));
			g_memmove(buf,buf+buf[0],length1*sizeof(gint));
		}
	} else {
		/*  */
		if (p->length>0) {
			type=g_malloc(p->length*sizeof(gint));
			make_char_type(type,p->text,p->length);
		}
		while (ed.y<st.y || (st.y==ed.y && ed.x<st.x)) {
			/* Хåեκǽʸä */
			while (length1<length0
						&& (ed.y<data.y || (data.y==ed.y && ed.x<data.x))) {
				if (0<data.x) {
					/* ʸ */
					g_memmove(text+type[data.x-1],text,length1*sizeof(gchar));
					g_memmove(buf+type[data.x-1],buf,length1*sizeof(gint));
					g_memmove(text,q->text+data.x-type[data.x-1],
												type[data.x-1]*sizeof(gchar));
					for (i=0;i<type[data.x-1];i++)
						buf[i]=i+1;
					length1+=type[data.x-1];
					data.x-=type[data.x-1];
				} else {
					/*  */
					while (gtk_events_pending())
						gtk_main_iteration();
					if (!userbreak)
						goto loop;
					q=q->prev;
					type=g_realloc(type,q->length*sizeof(gint));
					make_char_type(type,q->text,q->length);
					if (!q->margin) {
						g_memmove(text+1,text,length1*sizeof(gchar));
						g_memmove(buf+1,buf,length1*sizeof(gint));
						text[0]='\n';
						buf[0]=1;
						length1++;
					}
					data.x=q->length;
					data.y--;
				}
			}
			text[length1]='\0';
			/*  */
			if (ignorecase)	/* ʸ/ʸ̤ */
				result=g_strcmp(find,text)==0;
			else			/* ʸ/ʸ̤ʤ */
				result=g_strcasecmp(find,text)==0;
			if (result) {
				/* פȤ */
				if (p->margin && p->length<=st.x) {
					/* ޡΤȤˤϼιԤƬ */
					st.x=0;
					st.y++;
				}
				tmaid->select.x=edit_get_screen_pos(tmaid,st.x,st.y);
				tmaid->select.y=st.y;
				if (q->margin && q->length<=data.x) {
					/* ޡΤȤˤϼιԤƬ */
					data.x=0;
					data.y++;
				}
				tmaid->cursor.x=edit_get_screen_pos(tmaid,data.x,data.y);
				tmaid->cursor.y=data.y;
				break;
			}
			/* ХåեκǸʸ˴ */
			if (st.x>0) {
				st.x-=buf[length1-1];
			} else {
				p=p->prev;
				st.x=p->length-(p->margin?buf[length1-1]:0);
				st.y--;
			}
			length1-=buf[length1-1];
		}
	}
	loop:
	g_free(type);
	/* λ */
	gtk_grab_remove(dialog);
    gtk_widget_destroy(dialog);
	if (tmaid->select.x>=0) {
		top=tmaid->top;
		sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
		sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
		if (tmaid->cursor.x<tmaid->top.x)
			tmaid->top.x=tmaid->cursor.x;
		else if (tmaid->cursor.x-sx+1>tmaid->top.x)
			tmaid->top.x=tmaid->cursor.x-sx+1;
		if (tmaid->cursor.y<tmaid->top.y)
			tmaid->top.y=tmaid->cursor.y;
		else if (tmaid->cursor.y-sy+1>tmaid->top.y)
			tmaid->top.y=tmaid->cursor.y-sy+1;
		move_edit_window(tmaid,&top);
		misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,tmaid,
								0,edit_get_width_max(tmaid)+1,sx,tmaid->top.x);
		misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,tmaid,
								0,tmaid->max,sy,tmaid->top.y);
		clear_sel(tmaid,&tmaid->select,&tmaid->cursor);
		draw_caret(tmaid,&cursor);
		gtk_selection_owner_set(tmaid->drawing,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
	}
}


/******************************************************************************
*                                                                             *
*                                                             *
*                                                                             *
******************************************************************************/
static gboolean find_clicked_ok;
static GtkWidget *dialog,*check,*combo,*radio1;


/* OKܥ󤬲줿 */
static void find_dialog_clicked(GtkWidget *widget,FindString *fd)
{
	fd->text=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry)));
	fd->ignorecase=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
	fd->arrow=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1));
	gtk_widget_destroy(dialog);
	find_clicked_ok=TRUE;
}


/* ȥ꡼ǥ꥿󤬲줿 */
static void find_dialog_activate(GtkWidget *widget,FindString *fd)
{
	if (g_strlen(gtk_entry_get_text(GTK_ENTRY(widget)))>0)
		find_dialog_clicked(widget,fd);
}


/* ȥ꡼ѹ줿 */
static void find_dialog_changed(GtkWidget *widget,GtkWidget *button)
{
	gtk_widget_set_sensitive(button,
							g_strlen(gtk_entry_get_text(GTK_ENTRY(widget)))>0);
}


/* ESC줿 */
static gboolean find_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean find_dialog(FindString *fd)
{
	gint i;
	guint key;
	GList *glist=NULL;
	GtkAccelGroup *accel;
	GtkWidget *radio0,*button0,*button1,*frame0,*frame1,*hbox,*tbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Find"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(find_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ܥ */
	button0=gtk_button_new_with_label(NULL);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button0)->child),_("_Find"));
	gtk_widget_add_accelerator(button0,"clicked",accel,key,GDK_MOD1_MASK,0);
	button1=gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",find_dialog_clicked,fd);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* åܥ */
	check=gtk_check_button_new_with_label(NULL);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(check)->child),
															_("Enable _Case"));
	gtk_widget_add_accelerator(check,"clicked",accel,key,GDK_MOD1_MASK,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),fd->ignorecase);
	/* ܥܥå */
	for (i=0;i<find_num;i++)
		glist=g_list_append(glist,find_text[i]);
	combo=gtk_combo_new();
	if (find_num>0) {
		gtk_combo_set_popdown_strings(GTK_COMBO(combo),glist);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),find_text[0]);
		gtk_editable_select_region(GTK_EDITABLE(GTK_COMBO(combo)->entry),0,-1);
	}
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry),"activate",
												find_dialog_activate,fd);
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry),"changed",
												find_dialog_changed,button0);
	/* 饸ܥ */
	radio0=gtk_radio_button_new_with_label(NULL,NULL);
	radio1=gtk_radio_button_new_with_label_from_widget(
												GTK_RADIO_BUTTON(radio0),NULL);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio0)->child),_("_Up"));
	gtk_widget_add_accelerator(radio0,"clicked",accel,key,GDK_MOD1_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio1)->child),_("_Down"));
	gtk_widget_add_accelerator(radio1,"clicked",accel,key,GDK_MOD1_MASK,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fd->arrow?radio1:radio0),
																		TRUE);
	/* ե졼ȥܥå */
	tbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(tbox),8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("Find String")),FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),combo,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,0);
	frame0=gtk_frame_new(_("Option"));
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),check,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame0),vbox);
	frame1=gtk_frame_new(_("Direction"));
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),radio0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),radio1,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame1),vbox);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),frame0,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox),frame1,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(tbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),tbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,
		g_strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry)))>0);
	gtk_widget_grab_focus(GTK_COMBO(combo)->entry);
	find_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return find_clicked_ok;
}
