/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "argument.h"
#include "charset.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ϴؿ                                                              *
*                                                                             *
******************************************************************************/
/*	Ϥ
	argv,
	boot,TRUE:ưν
	 RET,ե														*/
gboolean *arg_analyse(gchar **argv,const gboolean boot)
{
	gboolean *arg_files;
	gchar *arg,*text;
	gint i,j,k,l,m,opt,leng,value;
	GList *glist;
	GtkWidget *menu_shell;
	/* ޥɥ饤  */
	const struct {
		const char *name;
		const int key;
		const char *arg;
		const char *doc;
	} arg_opts[]={
	{"encoding",'c',"CHARSET",     N_("Character Encoding")},
	{"history", 'h',"NUM",         N_("History")},
	{"line",    'l',"NUM",         N_("Caret Position")},
	{"new",     'n',"ON/OFF",      N_("New File")},
	{"size",    's',"WIDTH,HEIGHT",N_("Window Size")},
	{"second",  'x',"ON/OFF",      N_("Open Window")},
	{"version", 'v',NULL,          N_("About")},
	{"help",    '?',NULL,          N_("Help")},
	{NULL,      0,  NULL,          NULL}};

	for (i=1;argv[i]!=NULL;i++);
	arg_files=g_malloc0(i*sizeof(gboolean));
	i=1;/* i:Υץ,j:iʸ,k:iʹߤarg */
	while (argv[i]!=NULL)
		if ((argv[i])[0]=='-') {/* ץ */
			j=1;
			k=i;
			while ((argv[i])[j]!='\0' && (argv[i])[j]!='=') {
				if ((argv[i])[1]=='-') {	/* Ĺץ */
					opt=0;
					for (l=0;arg_opts[l].name!=NULL;l++) {
						leng=g_strlen(arg_opts[l].name);
						if (g_strncasecmp(argv[i]+2,arg_opts[l].name,leng)==0
											&& ((argv[i])[leng+2]=='\0'
												|| (argv[i])[leng+2]=='=')) {
							opt=arg_opts[l].key;
							j=leng+2;
							break;
						}
					}
				} else {					/* ûץ */
					opt=g_ascii_tolower((argv[i])[j++]);
				}
				arg=NULL;
				for (l=0;arg_opts[l].name!=NULL;l++)
					if (arg_opts[l].key==opt && arg_opts[l].arg!=NULL) {
						if (i==k) {
							for (m=2;(argv[i])[m]!='\0' && (argv[i])[m]!='=';
																		m++);
							arg=(argv[i])[m]=='\0'?argv[++k]:argv[i]+m+1;
							k++;
						} else {
							arg=argv[k++];
						}
						if (arg==NULL || *arg=='\0')
							opt=0;
						break;
					}
				switch (opt) {
					case 'c':
						if (boot)
							charset_set(arg);
						break;
					case 'h':
						misc_str_to_val(&history,arg,10,TRUE);
						if (history<0)
							history=0;
						else if (history>10)
							history=10;
						if (!boot) {
							/*  */
							menu_shell = gtk_item_factory_get_widget
											(item_factory_menu, "<main>/File");
							glist = gtk_container_children
												(GTK_CONTAINER (menu_shell));
							for (l=g_list_length(glist)-3;
										l>history-(history==0)+MENUFILE-2;l--)
								gtk_container_remove (GTK_CONTAINER
									(menu_shell), g_list_nth_data (glist, l));
							g_list_free(glist);
						}
						break;
					case 'l':
						misc_str_to_val(&init_line,arg,10,TRUE);
						break;
					case 'n':
						newfile=g_strcasecmp(arg,"OK")==0
												|| g_strcasecmp(arg,"ON")==0
												|| g_strcasecmp(arg,"TRUE")==0
												|| g_strcasecmp(arg,"YES")==0;
						break;
					case 's':
						text=g_strdup(arg);
						for (l=0;g_ascii_isdigit(text[l]);l++);
						if (text[l]!='\0') {
							text[l]='\0';
							if (misc_str_to_val(&value,text,10,TRUE)
																	&& value>0)
								def_width=value;
							if (misc_str_to_val(&value,text+l+1,10,TRUE)
																	&& value>0)
								def_height=value;
						}
						g_free(text);
						break;
					case 'x':
						second=g_strcasecmp(arg,"OK")==0
												|| g_strcasecmp(arg,"ON")==0
												|| g_strcasecmp(arg,"TRUE")==0
												|| g_strcasecmp(arg,"YES")==0;
						break;
					case 'v':
						if (boot) {
							g_print(
TMAID_VERSION_NOTICE"\n"
TMAID_COPYRIGHT_NOTICE"\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
							);
							g_free(arg_files);
							gtk_exit(0);
						}
						break;
					default:
						if (boot) {
							g_print(
TMAID_COPYRIGHT_NOTICE"\n\n"
"Usage: %s [OPTION...] [FILE...]\n\n",argv[0]);
							for (i=0;arg_opts[i].name;i++) {
								if (arg_opts[i].arg!=NULL)
									text=g_strdup_printf("  -%c, --%s=%s",
											arg_opts[i].key,arg_opts[i].name,
															arg_opts[i].arg);
								else
									text=g_strdup_printf("  -%c, --%s",
											arg_opts[i].key, arg_opts[i].name);
								g_print("%-26s %s\n",
												text,gettext(arg_opts[i].doc));
								g_free(text);
							}
							g_print("\n");
							g_free(arg_files);
							gtk_exit(0);
						}
				}
			}
			i=i<k?k:i+1;
		} else {/* ե */
			arg_files[i++]=TRUE;
		}
	return arg_files;
}
