/*
    Text maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "ftype.h"


/******************************************************************************
*                                                                             *
* ե륿פؿ                                                  *
*                                                                             *
******************************************************************************/
/* ꥹȥܥå */
static void ftype_dialog_select_row(GtkWidget *widget,
				gint row,gint column,GdkEventButton *event,GtkWidget *button)
{
	*(gint *)gtk_object_get_user_data(GTK_OBJECT(widget))=row;
	gtk_widget_set_sensitive(button,TRUE);
}


/* ꥹȥܥå */
static void ftype_dialog_unselect_row(GtkWidget *widget,
				gint row,gint column,GdkEventButton *event,GtkWidget *button)
{
	*(gint *)gtk_object_get_user_data(GTK_OBJECT(widget))=-1;
	gtk_widget_set_sensitive(button,FALSE);
}


/* OKܥ󤬲줿 */
static void ftype_dialog_clicked(GtkWidget *widget,GtkWidget *dialog)
{
	*(gboolean *)gtk_object_get_user_data(GTK_OBJECT(dialog))=TRUE;
    gtk_widget_destroy(dialog);
}


/* ESC줿 */
static gboolean ftype_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean ftype_dialog(gint *pos)
{
	gboolean result=FALSE;
	gchar *text=N_("Independent File Type");
	gint i,ftpos=-1;
	GtkWidget *dialog,*clist,*scroll,*hbox,*vbox,*button0,*button1;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Associating File Type"));
	gtk_window_set_default_size(GTK_WINDOW(dialog),320,240);
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(ftype_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	gtk_object_set_user_data(GTK_OBJECT(dialog),&result);
	/* ܥ */
	button0=gtk_button_new_with_label(_("OK"));
	button1=gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
												ftype_dialog_clicked,dialog);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ꥹȥܥå */
	clist=gtk_clist_new(1);
	gtk_clist_set_column_title(GTK_CLIST(clist),0,_("Registered File Type"));
	gtk_clist_column_titles_show(GTK_CLIST(clist));
	gtk_clist_column_titles_passive(GTK_CLIST(clist));
	for (i=0;i<ftnum;i++)
		gtk_clist_append(GTK_CLIST(clist),&ftype[i].text);
	gtk_clist_append(GTK_CLIST(clist),&text);
	gtk_clist_set_column_width(GTK_CLIST(clist),0,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),0));
	gtk_signal_connect(GTK_OBJECT(clist),"select-row",
											ftype_dialog_select_row,button0);
	gtk_signal_connect(GTK_OBJECT(clist),"unselect-row",
											ftype_dialog_unselect_row,button0);
	gtk_object_set_user_data(GTK_OBJECT(clist),&ftpos);
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scroll),clist);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
										GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
	/* ܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_grab_focus(button1);

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	if (result)
		*pos=ftpos<ftnum?ftpos:-1;
	return result;
}
