/*
    Text maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "repinfo.h"
#include "replace.h"


/******************************************************************************
*                                                                             *
* ִ                                                        *
*                                                                             *
******************************************************************************/
/* ܥ󤬲줿 */
static void repinfo_dialog_clicked(GtkWidget *widget,GtkWidget *dialog)
{
	*(gint *)gtk_object_get_user_data(GTK_OBJECT(dialog))
						=(gint)gtk_object_get_user_data(GTK_OBJECT(widget));
	gtk_widget_destroy(dialog);
}


/* ESC줿 */
static gboolean repinfo_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gint repinfo_dialog(ReplaceInfo *ri)
{
	gchar *text;
	gint result=REPLACE_CANCEL;
	guint key;
	GtkAccelGroup *accel;
	GtkWidget *dialog,*button0,*button1,*button2,*button3;
	GtkWidget *frame0,*frame1,*hbox,*tbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Replace Information"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
							GTK_SIGNAL_FUNC(repinfo_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	gtk_object_set_user_data(GTK_OBJECT(dialog),&result);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ܥ */
	button0=gtk_button_new_with_label(NULL);
	button1=gtk_button_new_with_label(NULL);
	button2=gtk_button_new_with_label(NULL);
	button3=gtk_button_new_with_label(_("Cancel"));
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button0)->child),
																_("_Replace"));
	gtk_widget_add_accelerator(button0,"clicked",accel,key,GDK_MOD1_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button1)->child),_("_Next"));
	gtk_widget_add_accelerator(button1,"clicked",accel,key,GDK_MOD1_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button2)->child),_("_All"));
	gtk_widget_add_accelerator(button2,"clicked",accel,'A',GDK_MOD1_MASK,0);
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
										repinfo_dialog_clicked,dialog);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
										repinfo_dialog_clicked,dialog);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
										repinfo_dialog_clicked,dialog);
	gtk_signal_connect_object(GTK_OBJECT(button3),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	gtk_object_set_user_data(GTK_OBJECT(button0),(gpointer)REPLACE_OK);
	gtk_object_set_user_data(GTK_OBJECT(button1),(gpointer)REPLACE_NEXT);
	gtk_object_set_user_data(GTK_OBJECT(button2),(gpointer)REPLACE_ALL);
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button3,GTK_CAN_DEFAULT);
	/* ե졼ȥܥå */
	tbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(tbox),8);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("Find String")),FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new(ri->src),TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),
							gtk_label_new(_("Replace String")),FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new(ri->dst),TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),
							gtk_label_new(_("Replace Range")),FALSE,FALSE,0);
	text=g_strdup_printf(_("(%d,%d)-(%d,%d)"),
						ri->start.x+1,ri->start.y+1,ri->end.x+1,ri->end.y+1);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new(text),TRUE,TRUE,0);
	g_free(text);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,0);

	frame0=gtk_frame_new(_("Option"));
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),gtk_label_new(ri->ignorecase
							?_("Enable Case"):_("Ignore Case")),FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame0),vbox);

	frame1=gtk_frame_new(_("Direction"));
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),
					gtk_label_new(ri->arrow?_("Up"):_("Down")),FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame1),vbox);

	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),frame0,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox),frame1,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button3,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button2,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(tbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),tbox);

	/* ɽ */
	gtk_widget_grab_focus(button1);

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return result;
}
