/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "charset.h"
#include "valchr.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ʸϴؿ                                                        *
*                                                                             *
******************************************************************************/
static gboolean valchr_clicked_ok;
static gchar valchr_default=' ';
static guint valchr_base=16;
static GtkWidget *dialog,*button0,*entry;


/* OKܥɽ/ɽȽ */
static void valchr_dialog_changed(GtkWidget *widget,gpointer user_data)
{
	gint value;

	misc_str_to_val(&value,gtk_entry_get_text(GTK_ENTRY(widget)),
															valchr_base,FALSE);
	gtk_widget_set_sensitive (button0, 0 <= value && value <= 255
											&& charset_length (value) == 1);
}


/* 饸ܥ󤬲줿 */
static void valchr_dialog_clicked_radio(GtkWidget *widget,guint base)
{
	gchar *text;
	gint value;

	misc_str_to_val(&value,gtk_entry_get_text(GTK_ENTRY(entry)),
															valchr_base,FALSE);
	valchr_base=base;
	text=misc_str_from_val(value,valchr_base,0,FALSE);
	gtk_entry_set_text(GTK_ENTRY(entry),text);
	g_free(text);
}


/* OKܥ󤬲줿 */
static void valchr_dialog_clicked_ok(GtkWidget *widget,gchar *valchr)
{
	gint value;

	misc_str_to_val(&value,gtk_entry_get_text(GTK_ENTRY(entry)),
															valchr_base,FALSE);
	*valchr = valchr_default = value;
	gtk_widget_destroy(dialog);
	valchr_clicked_ok=TRUE;
}


/* ȥ꡼ǥ꥿󤬲줿 */
static void valchr_dialog_activate(GtkWidget *widget,gchar *valchr)
{
	gint value;

	misc_str_to_val(&value,gtk_entry_get_text(GTK_ENTRY(widget)),
															valchr_base,FALSE);
	if (0 <= value && value <= 255 && charset_length (value) == 1)
		valchr_dialog_clicked_ok(widget,valchr);
}


/* ESC줿 */
static gboolean valchr_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean valchr_dialog(gchar *valchr)
{
	gchar *text;
	guint key;
	GtkAccelGroup *accel;
	GtkWidget *button1,*radio0,*radio1,*radio2,*frame,*hbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Character by Value"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(valchr_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ܥ */
	button0=gtk_button_new_with_label(_("OK"));
	button1=gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
										valchr_dialog_clicked_ok,valchr);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ȥ꡼ */
	entry=gtk_entry_new_with_max_length(4);
	text=misc_str_from_val(valchr_default,valchr_base,0,FALSE);
	gtk_entry_set_text(GTK_ENTRY(entry),text);
	g_free(text);
	gtk_signal_connect(GTK_OBJECT(entry),"activate",
												valchr_dialog_activate,valchr);
	gtk_signal_connect(GTK_OBJECT(entry),"changed",valchr_dialog_changed,NULL);
	/* 饸ܥ */
	radio0=gtk_radio_button_new_with_label(NULL,NULL);
	radio1=gtk_radio_button_new_with_label_from_widget(
												GTK_RADIO_BUTTON(radio0),NULL);
	radio2=gtk_radio_button_new_with_label_from_widget(
												GTK_RADIO_BUTTON(radio1),NULL);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio0)->child),
															_("_Hexadecimal"));
	gtk_widget_add_accelerator(radio0,"clicked",accel,key,GDK_MOD1_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio1)->child),_("_Decimal"));
	gtk_widget_add_accelerator(radio1,"clicked",accel,key,GDK_MOD1_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio2)->child),_("_Octal"));
	gtk_widget_add_accelerator(radio2,"clicked",accel,key,GDK_MOD1_MASK,0);
	switch (valchr_base) {
	case 16:gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio0),TRUE);break;
	case 10:gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio1),TRUE);break;
	case  8:gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio2),TRUE);
	}
	gtk_signal_connect(GTK_OBJECT(radio0),"clicked",
									valchr_dialog_clicked_radio,(gpointer)16);
	gtk_signal_connect(GTK_OBJECT(radio1),"clicked",
									valchr_dialog_clicked_radio,(gpointer)10);
	gtk_signal_connect(GTK_OBJECT(radio2),"clicked",
									valchr_dialog_clicked_radio,(gpointer)8);
	/* ե졼ȥܥå */
	frame=gtk_frame_new(_("Base"));
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),radio0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),radio1,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),radio2,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame),vbox);

	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),entry,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	valchr_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return valchr_clicked_ok;
}
