/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __CHARSET_H__
#define __CHARSET_H__


#include "tmaid.h"


#define charset_length(ch) (charset_leng[(gint)(guchar)(ch)])
#define charset_type(text, leng) (charset_length (*text) == (leng)			\
							? 1 << g_unichar_type (g_utf8_get_char (text)) : 0)


extern gsize charset_leng[];
extern guchar charset_space[];


/*	եȤȹ⤵
	  layout,쥤
	   width,
	  height,⤵
	font_buf,Хåե														*/
void
charset_size (PangoLayout *layout, gint *width, gint *height,
															guint8 *font_buf);


/*	ɽȾñ̤ʸ
	  layout,쥤
	    text,ʸ
	   width,
	font_buf,Хåե
	     RET,Ⱦñ														*/
gint
charset_width (PangoLayout *layout, const gchar *text,
										const gint width, guint8 *font_buf);


#endif
