/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "charset.h"
#include "edit.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* Խؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	饤Хåե
	start,饤Хåե
	  off,ߤyɸ
	    y,yɸ
	  RET,饤Хåե													*/
LineBuffer *edit_get_line_buf(LineBuffer **start,gint *off,const gint y)
{
	while (y<*off && (*start)->prev!=NULL) {
		*start=(*start)->prev;
		(*off)--;
	}
	while (*off<y && (*start)->next!=NULL) {
		*start=(*start)->next;
		(*off)++;
	}
	return *off==y?*start:NULL;
}


/*	
	tmaid,TXTɥ
	    y,
	  RET,																*/
gint edit_get_width(TmaidWindow *tmaid,const gint y)
{
	gint data_pos=0,width=0;
	LineBuffer *p;

	p=edit_get_line_buf(&tmaid->start,&tmaid->off,y);
	if (p->margin)
		while (data_pos<p->length-1)
			if (p->text[data_pos]=='\t') {
				width=(width/tmaid->ft.tab+1)*tmaid->ft.tab;
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])<=p->length) {
				if (data_pos+charset_length(p->text[data_pos])==p->length)
					break;
				width += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
				data_pos+=charset_length(p->text[data_pos]);
			} else {
				width++;
				data_pos++;
			}
	else
		while (data_pos<p->length)
			if (p->text[data_pos]=='\t') {
				width=(width/tmaid->ft.tab+1)*tmaid->ft.tab;
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])<=p->length) {
				width += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
				data_pos+=charset_length(p->text[data_pos]);
			} else {
				width++;
				data_pos++;
			}
	return width;
}


/*	
	tmaid,TXTɥ
	  RET,																*/
gint edit_get_width_max(TmaidWindow *tmaid)
{
	gint y,data_pos,width,max=0;
	LineBuffer *p;

	for (y=0,p=edit_get_line_buf(&tmaid->start,&tmaid->off,tmaid->top.y);
								y<tmaid->drawing->allocation.height && p!=NULL;
											y+=tmaid->font_height,p=p->next) {
		width=0;
		data_pos=0;
		while (data_pos<p->length)
			if (p->text[data_pos]=='\t') {
				width=(width/tmaid->ft.tab+1)*tmaid->ft.tab;
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])<=p->length) {
				width += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
				data_pos+=charset_length(p->text[data_pos]);
			} else {
				width++;
				data_pos++;
			}
		if (width>max)
			max=width;
	}
	return max;
}


/*	åȤΥ饤Ȥ줿xɸ
	tmaid,TXTɥ
	    x,xɸ
	    y,yɸ
	align,TRUE:˴󤻤,FALSE:˴󤻤
	  RET,ɸ																*/
gint edit_get_align_pos(TmaidWindow *tmaid,const gint x,const gint y,
														const gboolean align)
{
	gint data_pos=0,screen_pos=0;
	LineBuffer *p;

	p=edit_get_line_buf(&tmaid->start,&tmaid->off,y);
	if (p->margin)
		while (screen_pos<x && data_pos<p->length-1)
			if (p->text[data_pos]=='\t') {
				if (x<(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab)
					return align?(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab
																:screen_pos;
				screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])>p->length) {
				screen_pos++;
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])==p->length) {
				break;
			} else if (x < screen_pos + charset_width (tmaid->layout,
					p->text + data_pos, tmaid->font_width, tmaid->font_buf)) {
				return align ? screen_pos + charset_width (tmaid->layout,
						p->text + data_pos, tmaid->font_width, tmaid->font_buf)
																: screen_pos;
			} else {
				screen_pos += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
				data_pos+=charset_length(p->text[data_pos]);
			}
	else
		while (screen_pos<x && data_pos<p->length)
			if (p->text[data_pos]=='\t') {
				if (x<(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab)
					return align?(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab
																:screen_pos;
				screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])>p->length) {
				screen_pos++;
				data_pos++;
			} else if (x < screen_pos + charset_width (tmaid->layout,
					p->text + data_pos, tmaid->font_width, tmaid->font_buf)) {
				return align ? screen_pos + charset_width (tmaid->layout,
						p->text + data_pos, tmaid->font_width, tmaid->font_buf)
																: screen_pos;
			} else {
				screen_pos += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
				data_pos+=charset_length(p->text[data_pos]);
			}
	return screen_pos;
}


/*	̾κɸ饤ХåեΥɥ쥹
	tmaid,TXTɥ
	    x,xɸ
	    y,yɸ
	align,TRUE:˴󤻤,FALSE:˴󤻤
	  RET,ɥ쥹															*/
gint edit_get_data_pos(TmaidWindow *tmaid,const gint x,const gint y,
														const gboolean align)
{
	gint data_pos=0,screen_pos=0;
	LineBuffer *p;

	p=edit_get_line_buf(&tmaid->start,&tmaid->off,y);
	while (screen_pos<x && data_pos<p->length)
		if (p->text[data_pos]=='\t') {
			screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
			if (x<screen_pos)
				return align?data_pos+1:data_pos;
			data_pos++;
		} else if (data_pos+charset_length(p->text[data_pos])>p->length) {
			screen_pos++;
			data_pos++;
		} else if (x < screen_pos + charset_width (tmaid->layout,
					p->text + data_pos, tmaid->font_width, tmaid->font_buf)) {
			return align?data_pos+charset_length(p->text[data_pos]):data_pos;
		} else {
			screen_pos += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
			data_pos+=charset_length(p->text[data_pos]);
		}
	return MIN(data_pos,p->length);
}


/*	饤ХåեΥɥ쥹̾κɸ
	tmaid,TXTɥ
	    x,xɸ
	    y,yɸ
	  RET,ɸ																*/
gint edit_get_screen_pos(TmaidWindow *tmaid,const gint x,const gint y)
{
	gint data_pos=0,screen_pos=0;
	LineBuffer *p;

	p=edit_get_line_buf(&tmaid->start,&tmaid->off,y);
	while (data_pos<x)
		if (p->text[data_pos]=='\t') {
			screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
			data_pos++;
		} else if (data_pos+charset_length(p->text[data_pos])<=x) {
			screen_pos += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
			data_pos+=charset_length(p->text[data_pos]);
		} else {
			break;
		}
	return screen_pos;
}


/*	ʸʬ
	  text,ʸ
	length,ʸ
	   RET,ʬ																*/
guint edit_get_char_type(const gchar *text,const gint length)
{
	return charset_type (text, length);
}


/*	ڤ
	tmaid,TXTɥ
	    x,xɸ
	    y,yɸ
	 move,TRUE:˰ư,FALSE:˰ư
	  RET,ɸ																*/
gint edit_get_move_pos(TmaidWindow *tmaid,const gint x,const gint y,
														const gboolean move)
{
	gint i,j,data_pos,length,*type;/* 1ʸΥХȿ */
	guint ct,ctype;
	LineBuffer *p;

	p=edit_get_line_buf(&tmaid->start,&tmaid->off,y);
	if (move) {
		/* ذư */
		data_pos=edit_get_data_pos(tmaid,x,y,FALSE);
		length=data_pos+charset_length(p->text[data_pos])<=p->length
										?charset_length(p->text[data_pos]):1;
		ctype=edit_get_char_type(p->text+data_pos,length);
		data_pos+=length;
		while (data_pos<p->length) {
			length=data_pos+charset_length(p->text[data_pos])<=p->length
										?charset_length(p->text[data_pos]):1;
			ct=edit_get_char_type(p->text+data_pos,length);
			if ((ctype&ct)==0) {
				if (ct!=0)
					break;
				ctype=0;
			}
			data_pos+=length;
		}
	} else {
		/* ذư */
		data_pos=edit_get_data_pos(tmaid,x,y,FALSE);
		if (data_pos<=0)
			return 0;
		type=g_malloc(data_pos*sizeof(gint));
		i=0;
		while (i<data_pos)
			if (i+charset_length(p->text[i])<=data_pos) {
				for (j=0;j<charset_length(p->text[i]);j++)
					type[i+j]=j+1;
				i+=charset_length(p->text[i]);
			} else {
				type[i++]=1;
			}
		length=type[data_pos-1];
		data_pos-=length;
		ctype=edit_get_char_type(p->text+data_pos,length);
		while (data_pos>0 && (data_pos-=length=type[data_pos-1])>=0) {
			ct=edit_get_char_type(p->text+data_pos,length);
			if ((ctype&ct)==0) {
				if (ctype!=0) {
					data_pos+=length;
					break;
				}
				ctype=ct;
			}
		}
		g_free(type);
	}
	return edit_get_screen_pos(tmaid,data_pos,y);
}


/*	ϰϤΥХȿ
	   tmaid,TXTɥ
	 start_p,ϰ
	   end_p,ϰ
	     RET,Хȿ														*/
gint edit_get_sel_bytes(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p)
{
	gint i,st_pos,ed_pos,length;
	GdkPoint st,ed;
	LineBuffer *p;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	st_pos=edit_get_data_pos(tmaid,st.x,st.y,FALSE);
	ed_pos=edit_get_data_pos(tmaid,ed.x,ed.y,FALSE);
	if (st.y==ed.y) {
		/* Ʊ */
		length=ed_pos-st_pos;
	} else {
		/* 㤦 */
		p=edit_get_line_buf(&tmaid->start,&tmaid->off,st.y);
		length=p->length-st_pos+ed_pos+(p->margin?0:1);
		for (i=st.y+1,p=p->next;i<ed.y && p!=NULL;i++,p=p->next)
			length+=p->length+(p->margin?0:1);
	}
	return length;
}


/*	ϰϤ˥ԡ
	  tmaid,TXTɥ
	start_p,ϰ
	  end_p,ϰ
	   text,															*/
void edit_cpy_sel_mem(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p,
																gchar *text)
{
	gint i,st_pos,ed_pos,length;
	GdkPoint st,ed;
	LineBuffer *p;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	st_pos=edit_get_data_pos(tmaid,st.x,st.y,FALSE);
	ed_pos=edit_get_data_pos(tmaid,ed.x,ed.y,FALSE);
	p=edit_get_line_buf(&tmaid->start,&tmaid->off,st.y);
	if (st.y==ed.y) {
		/* Ʊ */
		g_memmove(text,p->text+st_pos,(ed_pos-st_pos)*sizeof(gchar));
	} else {
		/* 㤦 */
		length=p->length-st_pos;
		g_memmove(text,p->text+st_pos,length*sizeof(gchar));
		if (!p->margin) {
			g_memmove(text+length,"\n",sizeof(gchar));
			length++;
		}
		for (i=st.y+1,p=p->next;i<ed.y && p!=NULL;i++,p=p->next) {
			g_memmove(text+length,p->text,p->length*sizeof(gchar));
			length+=p->length;
			if (!p->margin) {
				/*  */
				g_memmove(text+length,"\n",sizeof(gchar));
				length++;
			}
		}
		g_memmove(text+length,p->text,ed_pos*sizeof(gchar));
	}
}


/*	ƤŽդ
	 tmaid,TXTɥ
	   put,Žդɸ
	   new,ɸ
	  text,
	length,Хȿ
	   RET,줿Կ													*/
gint edit_put_mem(TmaidWindow *tmaid,GdkPoint *put,GdkPoint *new,
										const gchar *text,const gint length)
{
	gchar *temp;
	gint i=0,temp_leng,insert=0,data_pos,screen_pos;
	LineBuffer *p,*q;

	data_pos=edit_get_data_pos(tmaid,put->x,put->y,FALSE);
	p=edit_get_line_buf(&tmaid->start,&tmaid->off,put->y);
	if (data_pos<=0 && p->prev!=NULL && p->prev->margin && length>=1
									&& g_memcmp(text,"\n",sizeof(gchar))==0) {
		/* ƬؤιԤޤ֤ƤꡢʸԤΤȤ */
		p=p->prev;
		data_pos=p->length;
		put->x=edit_get_screen_pos(tmaid,p->length,--put->y);
		/* ιԤαüذư */
	}
	if (data_pos<p->length) {
		/* ְʹߤʸХåե¸ */
		temp_leng=p->length-data_pos;
		temp=g_malloc(temp_leng*sizeof(gchar));
		g_memmove(temp,p->text+data_pos,temp_leng*sizeof(gchar));
		p->length=data_pos;
	} else {
		temp_leng=0;
		temp=NULL;
	}
	if (tmaid->ft.limit) {
		/* ޡޤ֤ */
		screen_pos=0;
		for (data_pos=0;data_pos<p->length;data_pos++)
			if (p->text[data_pos]=='\t')
				screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
			else if (data_pos+charset_length(text[data_pos])<=length)
				screen_pos += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
			else
				screen_pos++;
		while (i<length) {
			data_pos=i;
			while (data_pos<length && text[data_pos]!='\n')
				if (text[data_pos]=='\t') {
					screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos++;
				} else if (data_pos+charset_length(text[data_pos])<=length) {
					screen_pos += charset_width (tmaid->layout,
										p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos+=charset_length(text[data_pos]);
				} else {
					screen_pos++;
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos++;
				}
			if (p->length>0 || i!=data_pos)
				p->text=g_realloc(p->text,
										(p->length+data_pos-i)*sizeof(gchar));
			g_memmove(p->text+p->length,text+i,(data_pos-i)*sizeof(gchar));
			p->length+=data_pos-i;
			if (length<=data_pos) {
				i=data_pos;
			} else {
				q=g_malloc(sizeof(LineBuffer));
				q->length=0;
				q->margin=p->margin;
				q->text=NULL;
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				if (data_pos<=length-1 && text[data_pos]=='\n') {
					/*  */
					i=data_pos+1;
					p->margin=FALSE;
				} else {
					/*  */
					i=data_pos;
					p->margin=TRUE;
				}
				p=q;
				screen_pos=0;
				insert++;
			}
		}
	} else {
		/* ޡޤ֤ʤ */
		while (i<length) {
			for (data_pos=i;data_pos<length && text[data_pos]!='\n';
																data_pos++);
			if (p->length>0 || i!=data_pos)
				p->text=g_realloc(p->text,
										(p->length+data_pos-i)*sizeof(gchar));
			g_memmove(p->text+p->length,text+i,(data_pos-i)*sizeof(gchar));
			p->length+=data_pos-i;
			if (length<=data_pos) {
				i=data_pos;
			} else {
				i=data_pos+1;
				q=g_malloc(sizeof(LineBuffer));
				q->length=0;
				q->margin=FALSE;
				q->text=NULL;
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				p=q;
				insert++;
			}
		}
	}
	if (new!=NULL) {
		new->x=0;
		data_pos=0;
		while (data_pos<p->length)
			if (p->text[data_pos]=='\t') {
				new->x=(new->x/tmaid->ft.tab+1)*tmaid->ft.tab;
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])<=p->length) {
				new->x += charset_width (tmaid->layout, p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
				data_pos+=charset_length(p->text[data_pos]);
			} else {
				new->x++;
				data_pos++;
			}
		new->y=put->y+insert;
		if (tmaid->ft.limit && p->margin && (tmaid->ft.margin <= new->x
				|| (temp != NULL && tmaid->ft.margin <= new->x
										+ charset_width (tmaid->layout, temp,
										tmaid->font_width, tmaid->font_buf))))
		  {
			new->x = 0;
			new->y++;
		  }
	}
	if (temp!=NULL) {
		/* ְʹߤʸ᤹ */
		p->text=g_realloc(p->text,(p->length+temp_leng)*sizeof(gchar));
		g_memmove(p->text+p->length,temp,temp_leng*sizeof(gchar));
		p->length+=temp_leng;
		g_free(temp);
	}
	if (tmaid->ft.limit)
		/* ޡޤ֤ */
		while (p!=NULL) {
			data_pos=screen_pos=0;
			while (data_pos<p->length)
				if (p->text[data_pos]=='\t') {
					screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos++;
				} else if (data_pos+charset_length(text[data_pos])<=length) {
					screen_pos += charset_width (tmaid->layout,
						text + data_pos, tmaid->font_width, tmaid->font_buf);
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos+=charset_length(text[data_pos]);
				} else {
					screen_pos++;
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos++;
				}
			if (tmaid->ft.margin<screen_pos) {
				/* ޡĶƤȤԤ */
				q=g_malloc(sizeof(LineBuffer));
				q->length=p->length-data_pos;
				q->margin=p->margin;
				q->text=g_malloc(q->length*sizeof(gchar));
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				g_memmove(q->text,p->text+data_pos,q->length*sizeof(gchar));
				p->length=data_pos;
				p->margin=TRUE;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				p=q;
				insert++;
			} else if (screen_pos<tmaid->ft.margin
											&& p->margin && p->next!=NULL) {
				/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
				data_pos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				g_memmove(p->text+data_pos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				insert--;
			} else {
				break;
			}
		}
	return insert;
}


/*	ϰϤ
	  tmaid,TXTɥ
	start_p,ϰ
	  end_p,ϰ
	    RET,줿Կ													*/
gint edit_del_sel_mem(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p)
{
	gint i,st_pos,ed_pos,result,data_pos,screen_pos;
	GdkPoint st,ed;
	LineBuffer *p,*q,*r;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	st_pos=edit_get_data_pos(tmaid,st.x,st.y,FALSE);
	ed_pos=edit_get_data_pos(tmaid,ed.x,ed.y,FALSE);
	p=edit_get_line_buf(&tmaid->start,&tmaid->off,st.y);
	if (st.y==ed.y) {
		/* Ʊ */
		g_memmove(p->text+st_pos,p->text+ed_pos,
											(p->length-ed_pos)*sizeof(gchar));
		p->length-=ed_pos-st_pos;
		p->text=g_realloc(p->text,p->length);
		result=0;
	} else {
		/* 㤦 */
		for (i=st.y+1,q=p->next;i<ed.y && q!=NULL;i++,q=r) {
			g_free(q->text);
			r=q->next;
			g_free(q);
		}
		if (q->next!=NULL)
			q->next->prev=p;
		p->next=q->next;
		p->length=st_pos+q->length-ed_pos;
		p->margin=q->margin;
		p->text=g_realloc(p->text,p->length);
		g_memmove(p->text+st_pos,q->text+ed_pos,
											(q->length-ed_pos)*sizeof(gchar));
		g_free(q->text);
		g_free(q);
		result=ed.y-st.y;
	}
	q=p->prev;
	if (q!=NULL && q->margin && st.x<=0) {
		/* ιԤԤǺϤƬΤȤ */
		if (p->length>0) {
			data_pos=screen_pos=0;
			while (data_pos<q->length)
				if (q->text[data_pos]=='\t') {
					screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
					data_pos++;
				} else if (data_pos+charset_length(q->text[data_pos])
																<=q->length) {
					screen_pos += charset_width (tmaid->layout, 
										q->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
					data_pos+=charset_length(q->text[data_pos]);
				} else {
					screen_pos++;
					data_pos++;
				}
			if (p->text[0]=='\t')
				screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
			else if (charset_length(p->text[0])<=p->length)
				screen_pos += charset_width (tmaid->layout, p->text,
										tmaid->font_width, tmaid->font_buf);
			else
				screen_pos++;
		} else {
			screen_pos=0;
		}
		if (p->length<=0 || screen_pos<=tmaid->ft.margin) {
			/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
			data_pos=q->length;
			if (p->next!=NULL)
				p->next->prev=q;
			q->next=p->next;
			q->length+=p->length;
			q->margin=p->margin;
			q->text=g_realloc(q->text,q->length*sizeof(gchar));
			g_memmove(q->text+data_pos,p->text,p->length*sizeof(gchar));
			g_free(p->text);
			g_free(p);
			result++;
			p=q;
			if (start_p->y<end_p->y
							|| (start_p->y==end_p->y && start_p->x<end_p->x)) {
				start_p->x=screen_pos;
				start_p->y--;
			} else {
				end_p->x=screen_pos;
				end_p->y--;
			}
		}
	}
	if (tmaid->ft.limit)/* ޡޤ֤ */
		while (p!=NULL) {
			data_pos=screen_pos=0;
			while (data_pos<p->length)
				if (p->text[data_pos]=='\t') {
					screen_pos=(screen_pos/tmaid->ft.tab+1)*tmaid->ft.tab;
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos++;
				} else if (data_pos+charset_length(p->text[data_pos])
																<=p->length) {
					screen_pos += charset_width (tmaid->layout,
										p->text + data_pos,
										tmaid->font_width, tmaid->font_buf);
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos+=charset_length(p->text[data_pos]);
				} else {
					screen_pos++;
					if (tmaid->ft.margin<screen_pos)
						break;
					data_pos++;
				}
			if (tmaid->ft.margin<screen_pos) {
				/* ޡĶƤȤԤ */
				q=g_malloc(sizeof(LineBuffer));
				q->length=p->length-data_pos;
				q->margin=p->margin;
				q->text=g_malloc(q->length*sizeof(gchar));
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				g_memmove(q->text,p->text+data_pos,q->length*sizeof(gchar));
				p->length=data_pos;
				p->margin=TRUE;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				p=q;
				result--;
			} else if (screen_pos<tmaid->ft.margin
											&& p->margin && p->next!=NULL) {
				/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
				data_pos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				g_memmove(p->text+data_pos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				result++;
			} else if (!p->margin) {
				break;
			} else {
				p=p->next;
			}
		}
	return result;
}
