/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "ftype.h"


/******************************************************************************
*                                                                             *
* ե륿פؿ                                                  *
*                                                                             *
******************************************************************************/
static GtkListStore *store;


/* ꥹȥܥå */
static void
ftype_dialog_changed (GtkTreeSelection *select, GtkWidget *button)
{
	gint i, row = -1;
	GtkTreeIter iter;

	for (i = 0; gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
														&iter, NULL, i); i++)
		if (gtk_tree_selection_iter_is_selected (select, &iter))
		  {
			row = i;
			break;
  		  }
	*(gint *)g_object_get_data (G_OBJECT (select), "user_data") = row;
	gtk_widget_set_sensitive (button, row >= 0);
}


/* OKܥ󤬲줿 */
static void ftype_dialog_clicked(GtkWidget *widget,GtkWidget *dialog)
{
	*(gboolean *)g_object_get_data (G_OBJECT (dialog), "user_data") = TRUE;
    gtk_widget_destroy(dialog);
}


/* ESC줿 */
static gboolean ftype_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean ftype_dialog(gint *pos)
{
	gboolean result=FALSE;
	gint i,ftpos=-1;
	GtkCellRenderer *renderer;
	GtkTreeIter iter;
	GtkTreeSelection *select;
	GtkTreeViewColumn *column;
	GtkWidget *dialog,*tview,*scroll,*hbox,*vbox,*button0,*button1;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Associating File Type"));
	gtk_window_set_default_size(GTK_WINDOW(dialog),320,240);
	g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
									G_CALLBACK (ftype_dialog_key_press), NULL);
	g_signal_connect (G_OBJECT (dialog), "destroy",
											G_CALLBACK (gtk_main_quit), NULL);
	g_object_set_data (G_OBJECT (dialog), "user_data", &result);
	/* ܥ */
	button0=gtk_button_new_with_label(_("OK"));
	button1=gtk_button_new_with_label(_("Cancel"));
	g_signal_connect (G_OBJECT (button0), "clicked",
									G_CALLBACK (ftype_dialog_clicked), dialog);
	g_signal_connect_swapped (G_OBJECT (button1), "clicked",
						G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ꥹȥܥå */
	store = gtk_list_store_new (1, G_TYPE_STRING);
	tview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes
						(_("Registered File Type"), renderer, "text", 0, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
	g_signal_connect (G_OBJECT (select), "changed",
								G_CALLBACK (ftype_dialog_changed), button0);
	g_object_set_data (G_OBJECT (select), "user_data", &ftpos);
	for (i = 0; i < ftnum; i++)
	  {
		gtk_list_store_append (store, &iter);
		gtk_list_store_set (store, &iter, 0, ftype[i].text, -1);
	  }
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, _("Independent File Type"), -1);
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add (GTK_CONTAINER (scroll), tview);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
										GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
	/* ܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_grab_focus(button1);

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	if (result)
		*pos=ftpos<ftnum?ftpos:-1;
	return result;
}
