/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#include "common.h"


#define TMAID_VERSION_NOTICE "Text maid "VERSION" ("TMAID_BUILD_ENVIRONMENT")"
#define TMAID_COPYRIGHT_NOTICE "Copyright (C) 1998-2003 Kazuki IWAMOTO"

#define MENUFILE 12


typedef struct FileType_Tag {
	gint ft_id;					/* ե륿פID(-1:̵°) */
	gint crlf;					/* 0:CR+LF,1:CR,2:LF,3:ư */
	gint margin;				/* ޡο */
	gint tab;					/* ֤ο */
	gint writemode;				/* 0:Abort,1:'?',2:HTML,3:Escape */
	gboolean autoindent;		/* TRUE:ư */
	gboolean associate;			/* TRUE:ϢŤ */
	gboolean code;				/* TRUE:֤Υɤɽ */
	gboolean eof;				/* TRUE:1Ahե˽񤭲ä */
	gboolean hexcase;			/* TRUE:ʸ,FALSE:ʸ */
	gboolean html;				/* TRUE:HTMLʸȤѴ */
	gboolean esc;				/* TRUE:ץ󥹤Ѵ */
	gboolean limit;				/* TRUE:ޡޤ֤ */
	gboolean overwrite;			/* TRUE:ե񤭤Ȥ˳ǧ */
	gboolean space;				/* TRUE:ڡ򳥿λͳѤɽ */
	gboolean syscol;			/* TRUE:ƥ࿧Ȥ */
	gboolean gline;				/* TRUE:åɽ */
	gboolean mline;				/* TRUE:ޡɽ */
	gboolean nline;				/* TRUE:ԥɤɽ */
	gboolean uline;				/* TRUE:ֲɽ */
	gboolean vline;				/* TRUE:ֽɽ */
	gchar *charset;				/* 饯å */
	gchar *font_name;			/* ե̾ */
	gchar *text,*ext;			/* ̾,ĥ */
	GdkColor color[12];			/*  */
} FileType;
typedef struct TmaidHistory_Tag {
	gboolean caret;
	gchar *text;
	gint length;				/* ʸ */
	GdkPoint cursor,select;
	struct TmaidHistory_Tag *next;
} TmaidHistory;
typedef struct LineBuffer_Tag {
	gboolean margin;			/* TRUE:ޡ,FALSE:̾β */
	gchar *text;
	gint length;				/* ʸ */
	struct LineBuffer_Tag *prev,*next;
} LineBuffer;
typedef struct TmaidWindow_Tag {
	gboolean create;			/* TRUE:,FALSE:¸ե */
	gboolean edit;				/* TRUE:ԽѤ,FALSE:̤Խ */
	gchar *file;				/* ե̾ */
	gint font_width;			/* եȤβ */
	gint font_height;			/* եȤι⤵ */
	gint max;					/* Կ */
	gint off;					/* startȤ */
	gint same;					/* -1:ʣʤ,0:ֹ */
	guint timer_id;				/* ѥ */
	guint8 font_buf[65536];		/* ʸΥХåե */
	FileType ft;				/* ե륿 */
	LineBuffer *start;			/* ꥹ */
	PangoLayout *layout;		/* 쥤 */
	TmaidHistory *undo,*redo;	/* Խ */
	GdkPoint top;				/* ɥƬ */
	GdkPoint cursor;			/* åȤΰ */
	GdkPoint select;			/* 򳫻ϰ,-1:ʤ */
	GtkWidget *drawing;			/* ΰ */
	GtkWidget *hscroll;			/* ʿС */
	GtkWidget *vscroll;			/* ľС */
	GtkWidget *label;			/* ֤Υ٥ */
	GtkWidget *mark;			/* ֤ԽѤߥޡ */
	GtkWidget *menu_item;		/* ˥塼Υɥι */
	GtkIMContext *im_context;	/* Input Method */
	GtkWidget *preedit;			/* ΰ(̤ʸ) */
} TmaidWindow;


enum {
	TARGET_STRING,
	TARGET_TEXT,
	TARGET_COMPOUND_TEXT,
	TARGET_UTF8
};


extern gboolean caret;					/* åȤη */
extern gboolean ins;					/* TRUE:,FALSE: */
extern gboolean newfile;				/* TRUE:ե,FALSE:ʤ */
extern gboolean second;					/* TRUE:,FALSE:¸ */
extern gchar *history_files[10];		/* ե */
extern gchar *open_path;				/* Υѥ */
extern gchar *save_path;				/* ̾դ¸Υѥ */
extern gchar *clipboard_text;			/* åץܡɤΥƥ */
extern gchar *arg_text;					/* ץ̿ѿ */
extern gint def_width,def_height;		/* ǥեȤΥɥΥ */
extern gint ftnum;						/* ե륿פο */
extern gint history;					/* ե */
extern gint init_line;					/* ΥåȰ */
extern gint instance;					/* ץ̿ѿ */
extern gint tcount;						/* ե륿פΥ */
extern guint timer_id;					/* ID */
extern FileType *ftype;					/* ե륿 */
extern GdkAtom atom_clipboard;			/* åץܡ */
extern GdkAtom atom_targets;			/* å */
extern GdkAtom atom_text;				/* ƥ */
extern GdkAtom atom_compound;			/* ѥ */
extern GdkAtom atom_utf8;				/* UTF-8 */
extern GdkAtom atom_textmaid0;			/* ץ̿ѥȥ */
extern GdkAtom atom_textmaid1;			/* ץ̿ѥȥ */
extern GtkWidget *window;				/* ɥ */
extern GtkWidget *notebook;				/* Ρȥ֥å */
extern GtkWidget *status;				/* ơɥ */
extern GtkWidget *label_cursor;			/* ɸ */
extern GtkPositionType n_pos;			/* Ρȥ֥åΰ */
extern GtkItemFactory *item_factory_menu;	/* ˥塼 */
extern GtkItemFactory *item_factory_popup;	/* ݥåץå */
extern PangoFontDescription *system_font;
extern GdkColor system_color[12];
extern GtkTargetEntry targets[4];		/* Text maid󶡲ǽʥ쥯 */


#endif
/*
ɽ
 0,ʸ
 1,ط
 2,ȥ륳
 3,ѥڡ
 4,ԥ
 5,ֲ
 6,ޡ
 7,å
 8,򤵤줿ʸ
 9,򤵤줿ط
10,ʸ()
11,ȥ륳()
*/
