/*
    dialog
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "dialog.h"
#include "common.h"


/******************************************************************************
*                                                                             *
* ja:_CAO̊֐                                                         *
*                                                                             *
******************************************************************************/
/*  ja:_CAO{bNX̃Rg[̕\Ԃݒ肷
        hDlg,_CAO{bNX
         nID,Rg[ID
    nCmdShow,\@
         RET,TRUE:I,FALSE:G[                                     */
BOOL WINAPI
ShowDlgItem (HWND hDlg,
             int  nID,
             int  nCmdShow)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  if (!hWnd)
    return FALSE;
  ShowWindow (hWnd, nCmdShow);
  return TRUE;
}


/*  ja:_CAO{bNX̃Rg[L܂͖
       hDlg,_CAO{bNX
        nID,Rg[ID
    fEnable,TRUE:L,FALSE:
        RET,TRUE:I,FALSE:G[                                      */
BOOL WINAPI
EnableDlgItem (HWND hDlg,
               int  nID,
               BOOL fEnable)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  if (!hWnd)
    return FALSE;
  EnableWindow (hWnd, fEnable);
  return TRUE;
}


/*  ja:_CAO{bNX̃Rg[̈ʒu
            hDlg,_CAO{bNX
    lpDlgItemPos,_CAO
          nCount,Rg[̐
             RET,TRUE:I,FALSE:G[                                 */
BOOL WINAPI
InitDlgItemPosition (HWND              hDlg,
                     LPDLGITEMPOSITION lpDlgItemPos,
                     int               nCount)
{
  int i;
  RECT rcClient;

  /* ja:NCAg̈̃TCY */
  if (!GetClientRect (hDlg, &rcClient))
    return FALSE;
  for (i = 0; i < nCount; i++)
    {
      HWND hWnd;
      RECT rc;

      hWnd = GetDlgItem (hDlg, lpDlgItemPos[i].nID);
      if (!hWnd || !GetWindowRect (hWnd, &rc)
                || !ScreenToClient (hDlg, (LPPOINT)&rc)
                || !ScreenToClient (hDlg, (LPPOINT)&rc + 1))
        return FALSE;
      lpDlgItemPos[i].nLeft = rc.left;
      lpDlgItemPos[i].nTop = rc.top;
      lpDlgItemPos[i].nRight = rcClient.right - rc.right;
      lpDlgItemPos[i].nBottom = rcClient.bottom - rc.bottom;
      lpDlgItemPos[i].nWidth = rc.right - rc.left;
      lpDlgItemPos[i].nHeight = rc.bottom - rc.top;
    }
  return TRUE;
}


/*  ja:_CAO{bNX̃Rg[̈ʒuݒ肷
            hDlg,_CAO{bNX
    lpDlgItemPos,_CAO
          nCount,Rg[̐
             RET,TRUE:I,FALSE:G[                                 */
BOOL WINAPI
SetDlgItemPosition (HWND              hDlg,
                    LPDLGITEMPOSITION lpDlgItemPos,
                    int               nCount)
{
  int i;
  HWND hWnd;
  RECT rcClient;

  /* ja:NCAg̈̃TCY */
  if (!GetClientRect (hDlg, &rcClient))
    return FALSE;
  for (i = 0; i < nCount; i++)
    if (!(hWnd = GetDlgItem (hDlg, lpDlgItemPos[i].nID))
      || !MoveWindow (hWnd,
      lpDlgItemPos[i].fLeft ? lpDlgItemPos[i].nLeft
        : rcClient.right - lpDlgItemPos[i].nWidth - lpDlgItemPos[i].nRight,
      lpDlgItemPos[i].fTop ? lpDlgItemPos[i].nTop
        : rcClient.bottom - lpDlgItemPos[i].nHeight - lpDlgItemPos[i].nBottom,
      lpDlgItemPos[i].fLeft && lpDlgItemPos[i].fRight
        ? rcClient.right - lpDlgItemPos[i].nLeft - lpDlgItemPos[i].nRight
                                                    : lpDlgItemPos[i].nWidth,
      lpDlgItemPos[i].fTop && lpDlgItemPos[i].fBottom
        ? rcClient.bottom - lpDlgItemPos[i].nTop - lpDlgItemPos[i].nBottom
                                                    : lpDlgItemPos[i].nHeight,
                                                                        TRUE))
      return FALSE;
  return TRUE;
}


static LPDLGTEMPLATE WINAPI
MakeDlgGUIFont (HINSTANCE hInstance,
                LPCTSTR   lpTemplate)
{
  int i, nLogPixel;
  DWORD dwSize;
  HDC hDC;
  HGLOBAL hGlobal;
  HRSRC hRes;
  LPVOID p, q;
  LPDLGTEMPLATE lpDialogTemplate, lpMemory;
  SHORT sPoint = 0;
  TCHAR szFont[1024];
  WCHAR wFont[1024];

  wFont[0] = '\0';
  /* ja:tHg */
  hDC = CreateCompatibleDC (NULL);
  if (!hDC)
    return NULL;
  nLogPixel = GetDeviceCaps (hDC, LOGPIXELSY);
  for (i = 0; i < 6; i++)
    {
      HFONT hFont;
      TEXTMETRIC tm;
      static int nObject[6] = {DEFAULT_GUI_FONT, ANSI_VAR_FONT, SYSTEM_FONT,
                        ANSI_FIXED_FONT, SYSTEM_FIXED_FONT, OEM_FIXED_FONT};

      hFont = GetStockObject (nObject[i]);
      if (!hFont)
        continue;
      hFont = SelectObject (hDC, hFont);
      if (!GetTextMetrics (hDC, &tm))
        {
          hFont = SelectObject (hDC, hFont);
          continue;
        }
      sPoint = MulDiv (tm.tmHeight, 72, nLogPixel);
      if (GetTextFace (hDC, 1024, szFont) <= 0)
        sPoint = 0;
      hFont = SelectObject (hDC, hFont);
      if (sPoint > 0)
        break;
    }
  if (!DeleteDC (hDC))
    return NULL;
  if (sPoint > 0)
#ifdef UNICODE
    lstrcpy (wFont, szFont);
#else /* not UNICODE */
    MultiByteToWideChar (CP_ACP, 0, szFont, -1, wFont, 1024);
#endif /* not UNICODE */
  if (!(hRes = FindResource (hInstance, lpTemplate, RT_DIALOG))
            || (dwSize = SizeofResource (hInstance, hRes)) == 0
            || !(hGlobal = LoadResource (hInstance, hRes))
            || !(lpMemory = LockResource (hGlobal))
            || !(lpDialogTemplate = MemoryAlloc (dwSize
                +(lstrlenW (wFont) + 1) * sizeof (WCHAR) + sizeof (SHORT))))
    return NULL;
  p = lpDialogTemplate;
  q = lpMemory;
  /* ja:\̂Rs[ */
  *lpDialogTemplate = *lpMemory;
  dwSize -= sizeof (DLGTEMPLATE);
  ((LPDLGTEMPLATE)p)++;
  ((LPDLGTEMPLATE)q)++;
  for (i = 0; i < 3; i++)
    if (((LPBYTE)q)[0] == 0xff && ((LPBYTE)q)[1] == 0xff)
      {
        *((LPDWORD)p) = *((LPDWORD)q);
        ((LPDWORD)p)++;
        ((LPDWORD)q)++;
        dwSize -= sizeof (DWORD);
      }
    else
      {
        int nLength;

        nLength = (lstrlenW (q) + 1) * sizeof (WCHAR);
        MemoryCopy (p, q, nLength);
        (LPBYTE)p += nLength;
        (LPBYTE)q += nLength;
        dwSize -= nLength;
      }
  if (sPoint > 0)
    {
      /* ja:tHg̒ */
      int nLength;

      sPoint = min (GetSystemMetrics (SM_CXSCREEN) * 576
                                / (lpDialogTemplate->cx * nLogPixel), sPoint);
      sPoint = min (GetSystemMetrics (SM_CYSCREEN) * 576
                                / (lpDialogTemplate->cy * nLogPixel), sPoint);
      if (sPoint < 1)
        sPoint = 1;
      /* ja:tHgݒ肷 */
      lpDialogTemplate->style |= DS_SETFONT;
      *(SHORT *)p = sPoint;
      ((SHORT *)p)++;
      nLength = (lstrlenW (wFont) + 1) * sizeof (WCHAR);
      MemoryCopy (p, wFont, nLength);
      (LPBYTE)p += nLength;
      /* ja:̃tHgj */
      if (((LPDLGTEMPLATE)lpMemory)->style & DS_SETFONT)
        {
          ((SHORT *)q)++;
          dwSize -= sizeof (SHORT);
          if (((LPBYTE)q)[0] == 0xff && ((LPBYTE)q)[1] == 0xff)
            {
              ((LPDWORD)q)++;
              dwSize -= sizeof (DWORD);
            }
          else
            {
              nLength = (lstrlenW (q) + 1) * sizeof (WCHAR);
              (LPBYTE)q += nLength;
              dwSize -= nLength;
            }
        }
    }
  /* ja:cRs[ */
  MemoryCopy (p, q, dwSize);
  return lpDialogTemplate;
}


/*  ja:[hX_CAO{bNX쐬
       hInstance,W[̃nh
      lpTemplate,_CAO{bNXev[g̖O
      hWndParent,I[i[EBhẼnh
    lpDialogFunc,_CAO{bNXvV[W
          lParam,l
             RET,_CAO{bNX̃nh                               */
HWND WINAPI
CreateDialogParamGUI (HINSTANCE hInstance,
                      LPCTSTR   lpTemplate,
                      HWND      hWndParent,
                      DLGPROC   lpDialogFunc,
                      LPARAM    lParam)
{
  HWND hDlg;
  LPDLGTEMPLATE lpDialogTemplate;

  lpDialogTemplate = MakeDlgGUIFont (hInstance, lpTemplate);
  if (!lpDialogTemplate)
    return NULL;
  hDlg = CreateDialogIndirectParam (hInstance, lpDialogTemplate,
                                            hWndParent, lpDialogFunc, lParam);
  MemoryFree (lpDialogTemplate);
  return hDlg;
}


/*  ja:[__CAO{bNX쐬
       hInstance,W[̃nh
      lpTemplate,_CAO{bNXev[g̖O
      hWndParent,I[i[EBhẼnh
    lpDialogFunc,_CAO{bNXvV[W
          lParam,l
             RET,_CAO{bNX̃nh                               */
INT_PTR WINAPI
DialogBoxParamGUI (HINSTANCE hInstance,
                   LPCTSTR   lpTemplate,
                   HWND      hWndParent,
                   DLGPROC   lpDialogFunc,
                   LPARAM    lParam)
{
  INT_PTR nResult;
  LPDLGTEMPLATE lpDialogTemplate;

  lpDialogTemplate = MakeDlgGUIFont (hInstance, lpTemplate);
  if (!lpDialogTemplate)
    return -1;
  nResult = DialogBoxIndirectParam (hInstance, lpDialogTemplate,
                                            hWndParent, lpDialogFunc, lParam);
  MemoryFree (lpDialogTemplate);
  return nResult;
}
