/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "tmaid.h"
#include <limits.h>
#include <commctrl.h>
#include <shlobj.h>
#include <shlwapi.h>
#include "common.h"
#include "dialog.h"
#include "file.h"
#include "find.h"
#include "fndir.h"
#include "jump.h"
#include "license.h"
#include "other.h"
#include "replace.h"
#include "resource.h"
#include "valchr.h"
#include "wndmain.h"
#include "wndtext.h"


/* ja:VXeϐ */
int nFileCount = 0;             /* ja:VK쐬ꂽt@C̐ */
int nTypeCount = 0;             /* ja:VK쐬ꂽt@C^Cv̐ */
BOOL fClipBoard = FALSE;        /* ja:TRUE:Nbv{[hɂ,FALSE:Ȃ */
BOOL fZoomed = FALSE;           /* ja:TRUE:ő剻,FALSE:ʏ */
UINT uDlMsg;                    /* hbOXg̃bZ[W */
UINT uIns=0;                    /* Lbg̏(0:},1:㏑) */


/* ja:t@C^Cv */
int nFileType = 0;              /* ja:o^Ăt@C^Cv */
LPFILETYPE lpFileType = NULL;   /* ja:t@C^Cv */


/* ja:Ŝɑ΂ݒ(_CAOŕύX\) */
int nHistory = 4;               /* ja:t@C̗̍ő吔(0...9) */
int nRegStat = REG_STAT_READ | REG_STAT_WRITE;/* ja:WXgread/write */
DWORD dwFilter = 0;             /* ja:tB^ */
TCHAR szOpenPath[MAX_PATH];     /* ja:Ōɓǂݍ񂾃t@C̃pX */
TCHAR szSavePath[MAX_PATH];     /* ja:Ōɏ񂾃t@C̃pX */
TCHAR szHelpFile[MAX_PATH];     /* ja:wṽt@C */


/* ja:F */
COLORREF crWindowText;          /* ja:EChE̕(W:) */
COLORREF crGrayText;            /* ja:DF̕(W:DF) */
COLORREF crHighLightText;       /* ja:Iꂽ(W:) */
HBRUSH hBrushWindow = NULL;     /* ja:wi */
HBRUSH hBrushGray = NULL;       /* ja:SpXy[X,s */
HBRUSH hBrushHighLight = NULL;  /* ja:Iꂽwi */
HPEN hPenGray = NULL;           /* ja:^u,E}[W */
HPEN hPenGrid = NULL;           /* ja:Obg */
HPEN hPenNull;                  /* ja:̃y */


HACCEL hAccel;                  /* ja:ANZ[^L[ */
HINSTANCE hInst;
HMENU hMenuPopup = NULL;
HWND hDlgCancel;                /* ja:f_CAO{bNX */
HWND hWndMain;                  /* ja:CEChE */
HWND hWndClient;                /* ja:MDINCAgEChE */
HWND hWndTool;                  /* ja:CEChẼc[o[ */
HWND hWndStat;                  /* ja:CEChẼXe[^Xo[ */


CHAR cCRLF[2] = {0x0d, 0x0a};
LPSTR lpszCode[256];


/******************************************************************************
*                                                                             *
* ja:C֐Q                                                             *
*                                                                             *
******************************************************************************/
int WINAPI
_tWinMain  (HINSTANCE hInstance,
            HINSTANCE hPrevInstance,
            LPTSTR    lpszCmdLine,
            int       nCmdShow)
{
  int i, nInitLine = 0;
  int nLeft = CW_USEDEFAULT, nTop = CW_USEDEFAULT;
  int nRight = CW_USEDEFAULT, nBottom = CW_USEDEFAULT;
  BOOL fLicense = FALSE, fNewFile = FALSE, fSecondWindow = FALSE;
  COLORREF crBtnFace, crHighLight, crWindow;
  HKEY hKey;
  HMENU hMenu;
  LPITEMIDLIST pid;
  MSG msg;
  TCHAR **plpszArgv, szHistory[9][MAX_PATH + 3];
  WNDCLASS wc;

  InitCommonControls ();
  /* ja:ϐ̏ */
  hInst = hInstance;
  if (SHGetSpecialFolderLocation (NULL, CSIDL_PERSONAL, &pid) == NOERROR)
    {
      if (!SHGetPathFromIDList (pid, szOpenPath))
        {
          MessageBox (NULL, _T("SHGetPathFromIDList"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      CoTaskMemFree (pid);
    }
  else
    {
      szOpenPath[0] = '\0';
    }
  lstrcpy (szSavePath, szOpenPath);
  i = GetModuleFileName (hInstance, szHelpFile, MAX_PATH);
  if (0 < i && i < MAX_PATH)
    {
      LPTSTR lpszExt;

      lpszExt = PathFindExtension (szHelpFile);
      if (lpszExt)
        lstrcpy (lpszExt, _T(".chm"));
      else
        lstrcat (szHelpFile, _T(".chm"));
    }
  crBtnFace = GetSysColor (COLOR_BTNFACE);
  crGrayText = GetSysColor (COLOR_GRAYTEXT);
  crHighLight = GetSysColor (COLOR_HIGHLIGHT);
  crHighLightText = GetSysColor (COLOR_HIGHLIGHTTEXT);
  crWindow = GetSysColor (COLOR_WINDOW);
  crWindowText = GetSysColor (COLOR_WINDOWTEXT);
  for (i = 0; i < 256; i++)
    {
#ifdef UNICODE
      LPWSTR lpszText;

      lpszText = LoadText (hInstance, IDS_CODE00 + i);
      lpszCode[i] = StringWideCharToMultiByte (lpszText);
      MemoryFree (lpszText);
#else /* not UNICODE */
      lpszCode[i] = LoadText (hInstance, IDS_CODE00 + i);
#endif /* not UNICODE */
    }

  /* ja:R}hC̉ */
  plpszArgv = MakeArgument (lpszCmdLine);
  if (!plpszArgv)
    {
      MessageBox (NULL, _T("MakeArgument"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  /* ja:WXg̈R}hC擾 */
  for (i = 0; plpszArgv[i]; i++)
    if (((plpszArgv[i])[0] == '-' || (plpszArgv[i])[0] == '/')
                        && (int)CharUpper ((LPTSTR)(plpszArgv[i])[1]) == 'Q')
      nRegStat = IsCharNumeric ((plpszArgv[i])[2]) && (plpszArgv[i])[3] == '\0'
                                                ? (plpszArgv[i])[2] - '0' : 3;

  for (i = 0; i < 9; i++)
    szHistory[i][0] = '\0';
  if (nRegStat & REG_STAT_READ)
    {
      RECT rc0;

      rc0.left = LONG_MIN;
      if (RegOpenKeyEx (HKEY_CURRENT_USER,
                                    _T("Software\\maid.org\\Text maid"),
                                    0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS)
        {
          /* ja:WXgǂݏo */
          HKEY hKeySub;

          RegGetValueEx (hKey, _T("CodeDef"), &nCodeDef, sizeof (int));
          RegGetValueEx (hKey, _T("Filter"), &dwFilter, sizeof (DWORD));
          RegGetValueEx (hKey, _T("History"), &nHistory, sizeof (int));
          RegGetValueEx (hKey, _T("NewFile"), &fNewFile, sizeof (BOOL));
          RegGetValueEx (hKey, _T("Second"), &fSecondWindow, sizeof (BOOL));
          RegGetValueEx (hKey, _T("Zoomed"), &fZoomed, sizeof (BOOL));
          RegGetValueEx (hKey, _T("OpenPath"),
                                        szOpenPath, MAX_PATH * sizeof (TCHAR));
          RegGetValueEx (hKey, _T("SavePath"),
                                        szSavePath, MAX_PATH * sizeof (TCHAR));
          RegGetValueEx (hKey, _T("Rect"), &rc0, sizeof (RECT));
          /* ja:t@C^Cv */
          RegGetValueEx (hKey, _T("FileType"), &nFileType, sizeof (int));
          lpFileType = MemoryAlloc (nFileType * sizeof (FILETYPE));
          for (i = 0; i < nFileType; i++)
            {
              DWORD dwData;
              LONG lResult;
              LPTSTR lpszName;

              wasprintf (&lpszName, _T("FileType%04d"), i);
              lResult = RegOpenKeyEx (hKey, lpszName, 0, KEY_ALL_ACCESS,
                                                                    &hKeySub);
              MemoryFree (lpszName);
              if (lResult != ERROR_SUCCESS)
                break;
              lpFileType[i].nID = nTypeCount++;
              RegGetValueEx (hKeySub, _T("Text"),
                            lpFileType[i].szText, MAX_PATH * sizeof (TCHAR));
              RegGetValueEx (hKeySub, _T("Ext"),
                            lpFileType[i].szExt, MAX_PATH * sizeof (TCHAR));
              RegGetValueEx (hKeySub, _T("Margin"),
                            &lpFileType[i].nMargin, sizeof (int));
              RegGetValueEx (hKeySub, _T("Tab"),
                            &lpFileType[i].nTab, sizeof (int));
              if (RegQueryValueEx (hKeySub, _T("LogFont"), NULL, NULL,
                                            NULL, &dwData) == ERROR_SUCCESS)
                if (dwData == sizeof (LOGFONT))
                  {
                    RegGetValueEx (hKeySub, _T("LogFont"),
                                        &lpFileType[i].lf, sizeof (LOGFONT));
                  }
#ifdef UNICODE
                else if (dwData == sizeof (LOGFONTA))
                  {
                    LOGFONTA lfa;

                    RegGetValueEx (hKeySub, _T("LogFont"),
                                                    &lfa, sizeof (LOGFONTA));
                    MemoryCopy (&lpFileType[i].lf, &lfa,
                            sizeof (LOGFONTA) - LF_FACESIZE * sizeof (CHAR));
                    MultiByteToWideChar (CP_ACP, 0, lfa.lfFaceName, -1,
                                    lpFileType[i].lf.lfFaceName, LF_FACESIZE);
                  }
#else /* not UNICODE */
                else if (dwData == sizeof (LOGFONTW))
                  {
                    LOGFONTA lfw;

                    RegGetValueEx (hKeySub, _T("LogFont"),
                                                    &lfw, sizeof (LOGFONTW));
                    MemoryCopy (&lpFileType[i].lf, &lfw,
                            sizeof (LOGFONTA) - LF_FACESIZE * sizeof (WCHAR));
                    WideCharToMultiByte (CP_ACP, 0, lfw.lfFaceName, -1,
                        lpFileType[i].lf.lfFaceName, LF_FACESIZE, NULL, NULL);
                  }
#endif /* not UNICODE */
              RegGetValueEx (hKeySub, _T("Color"),
                                lpFileType[i].crColor, sizeof (COLORREF) * 12);
              RegGetValueEx (hKeySub, _T("Associate"),
                                &lpFileType[i].fAssociate, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("AutoIndent"),
                                &lpFileType[i].fAutoIndent, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Code"),
                                &lpFileType[i].fCode, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("CRLF"), 
                                &lpFileType[i].fCRLF, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("EOF"),
                                &lpFileType[i].fEOF, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Limit"),
                                &lpFileType[i].fLimit, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("OverWrite"),
                                &lpFileType[i].fOverWrite, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Recycle"),
                                &lpFileType[i].fRecycle, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Space"),
                                &lpFileType[i].fSpace, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("SysColor"),
                                &lpFileType[i].fSysColor, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("TabConv"),
                                &lpFileType[i].fTabConv, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Gline"),
                                &lpFileType[i].fGline, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Mline"),
                                &lpFileType[i].fMline, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Uline"),
                                &lpFileType[i].fUline, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Vline"),
                                &lpFileType[i].fVline, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("RetCode"),
                                &lpFileType[i].uRetCode, sizeof (UINT));
              if (RegQueryValueEx (hKeySub, _T("Negotiate"), NULL, NULL,
                                                NULL, &dwData) == ERROR_SUCCESS
                                                    && dwData == sizeof (BOOL))
                {
                  RegGetValueEx (hKeySub, _T("Negotiate"),
                                &lpFileType[i].fNegotiate, sizeof (BOOL));
                  RegGetValueEx (hKeySub, _T("CharSet"),
                                &lpFileType[i].dwCharSet, sizeof (DWORD));
                }
              else
                {
                  UINT uCharSet;

                  lpFileType[i].fNegotiate = lpFileType[i].uRetCode == 0;
                  if (!lpFileType[i].fNegotiate)
                    lpFileType[i].uRetCode--;
                  RegGetValueEx (hKeySub, _T("Auto"),
                                    &lpFileType[i].dwCharSet, sizeof (DWORD));
                  RegGetValueEx (hKeySub, _T("CharSet"),
                                    &uCharSet, sizeof (UINT));
                  if (lpFileType[i].dwCharSet == 0)
                    lpFileType[i].dwCharSet = uCharSet;
                }
              if (lpFileType[i].dwCharSet == 0)
                lpFileType[i].dwCharSet = 0x2135467;
              if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
                {
                  MessageBox (NULL, _T("RegCloseKey"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  RegCloseKey (hKey);
                  return 0;
                }
            }
          nFileType = i;
          /* ja: */
          RegGetValueEx (hKey, _T("FindNum"), &nFind, sizeof (int));
          RegGetValueEx (hKey, _T("FindArrow"), &bFindArrow, sizeof (BOOL));
          RegGetValueEx (hKey, _T("FindCase"), &bFindCase, sizeof (BOOL));
          RegGetValueEx (hKey, _T("FindWidth"), &bFindWidth, sizeof (BOOL));
          if (nFind > 0 && RegOpenKeyEx (hKey, _T("Find"),
                                0, KEY_ALL_ACCESS, &hKeySub) == ERROR_SUCCESS)
            {
              for (i = 0; i < nFind; i++)
                {
                  LONG lResult;
                  LPTSTR lpszName;

                  lpszFind[i] = MemoryAlloc (MAXFIND * sizeof (TCHAR));
                  wasprintf (&lpszName, _T("Find%02d"), i);
                  lResult = RegGetValueEx (hKeySub, lpszName,
                                                        lpszFind[i], MAXFIND);
                  MemoryFree (lpszName);
                  if (lResult != ERROR_SUCCESS || *lpszFind[i] == '\0')
                    {
                      MemoryFree (lpszFind[i]);
                      break;
                    }
                  lpszFind[i] = MemoryReAlloc (lpszFind[i],
                                (lstrlen (lpszFind[i]) + 1) * sizeof (TCHAR));
                }
              nFind = i;
              if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
                {
                  MessageBox (NULL, _T("RegCloseKey"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
                  RegCloseKey (hKey);
                  return 0;
                }
            }
          /* ja:u */
          RegGetValueEx (hKey, _T("ReplaceNum"),  &nReplace, sizeof (int));
          RegGetValueEx (hKey, _T("ReplaceArrow"),
                                                &bReplaceArrow, sizeof (BOOL));
          RegGetValueEx (hKey, _T("ReplaceCase"),
                                                &bReplaceCase, sizeof (BOOL));
          RegGetValueEx (hKey, _T("ReplaceWidth"),
                                                &bReplaceWidth, sizeof (BOOL));
          if (nReplace > 0 && RegOpenKeyEx (hKey, _T("Replace"),
                                0, KEY_ALL_ACCESS, &hKeySub) == ERROR_SUCCESS)
            {
              for (i = 0; i < nReplace; i++)
                {
                  LONG lResult;
                  LPTSTR lpszName;

                  lpszReplace[i] = MemoryAlloc (MAXFIND * sizeof (TCHAR));
                  wasprintf (&lpszName, _T("Replace%02d"), i);
                  lResult = RegGetValueEx (hKeySub, lpszName,
                                                    lpszReplace[i], MAXFIND);
                  MemoryFree (lpszName);
                  if (lResult != ERROR_SUCCESS || *lpszReplace[i] == '\0')
                    {
                      MemoryFree (lpszReplace[i]);
                      break;
                    }
                  lpszReplace[i] = MemoryReAlloc (lpszReplace[i],
                            (lstrlen (lpszReplace[i]) + 1) * sizeof (TCHAR));
                }
              nReplace = i;
              if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
                {
                  MessageBox (NULL, _T("RegCloseKey"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  RegCloseKey (hKey);
                  return 0;
                }
            }
          for (i = 0; i <nHistory; i++)
            {
              LONG lResult;
              LPTSTR lpszName;

              wasprintf (&lpszName, _T("History%d"), i);
              lResult = RegGetValueEx (hKey, lpszName, &szHistory[i][3],
                                                    MAX_PATH * sizeof (TCHAR));
              MemoryFree (lpszName);
              if (lResult != ERROR_SUCCESS || szHistory[i][3] == '\0')
                break;
              szHistory[i][0] = '&';
              szHistory[i][1] = i + '1';
              szHistory[i][2] = ' ';
            }
          if (RegCloseKey (hKey) != ERROR_SUCCESS)
            {
              MessageBox (NULL, _T("RegCloseKey"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              return 0;
            }
          fLicense = TRUE;
        }
      else if (RegOpenKeyEx (HKEY_CURRENT_USER,
                                    _T("Software\\IwamotoKazuki\\Text maid"),
                                    0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS)
        {
          /* ja:WXgǂݏo */
          DWORD dwStat;
          HKEY hKeySub;

          RegGetValueEx (hKey, _T("code"), &nCodeDef, sizeof (int));
          RegGetValueEx (hKey, _T("filter"), &dwFilter, sizeof (DWORD));
          RegGetValueEx (hKey, _T("findstat"), &dwStat, sizeof (DWORD));
          RegGetValueEx (hKey, _T("history"), &nHistory, sizeof (int));
          RegGetValueEx (hKey, _T("newfile"), &fNewFile, sizeof (BOOL));
          RegGetValueEx (hKey, _T("prev"), &fSecondWindow, sizeof (BOOL));
          RegGetValueEx (hKey, _T("zoomed"), &fZoomed, sizeof (BOOL));
          RegGetValueEx (hKey, _T("openpath"),
                                        szOpenPath, MAX_PATH * sizeof (TCHAR));
          RegGetValueEx (hKey, _T("savepath"),
                                        szSavePath, MAX_PATH * sizeof (TCHAR));
          RegGetValueEx (hKey, _T("rect"), &rc0, sizeof (RECT));
          bFindArrow = !(dwStat & 4);
          bFindCase = dwStat & 1;
          bFindWidth = dwStat & 2;
          bReplaceArrow = !(dwStat & 32);
          bReplaceCase = dwStat & 8;
          bReplaceWidth = dwStat & 16;
          /* ja:t@C^Cv */
          RegGetValueEx (hKey, _T("ftnum"), &nFileType, sizeof (int));
          lpFileType = MemoryAlloc (nFileType * sizeof (FILETYPE));
          for (i = 0; i < nFileType; i++)
            {
              DWORD dwData;
              LONG lResult;
              LPTSTR lpszName;

              wasprintf (&lpszName, _T("FILETYPE%d"), i);
              lResult = RegOpenKeyEx (hKey, lpszName, 0, KEY_ALL_ACCESS,
                                                                    &hKeySub);
              MemoryFree (lpszName);
              if (lResult != ERROR_SUCCESS)
                break;
              lpFileType[i].nID = nTypeCount++;
              RegGetValueEx (hKeySub, _T("text"),
                            lpFileType[i].szText, MAX_PATH * sizeof (TCHAR));
              RegGetValueEx (hKeySub, _T("ext"),
                            lpFileType[i].szExt, MAX_PATH * sizeof (TCHAR));
              RegGetValueEx (hKeySub, _T("margin"),
                                &lpFileType[i].nMargin, sizeof (int));
              RegGetValueEx (hKeySub, _T("tab"),
                                &lpFileType[i].nTab, sizeof (int));
              RegGetValueEx (hKeySub, _T("auto"),
                                &lpFileType[i].dwCharSet, sizeof (DWORD));
              RegGetValueEx (hKeySub, _T("view"),
                                &dwStat, sizeof (DWORD));
              if (RegQueryValueEx (hKeySub, _T("logfont"), NULL, NULL,
                                            NULL, &dwData) == ERROR_SUCCESS)
                if (dwData == sizeof (LOGFONT))
                  {
                    RegGetValueEx (hKeySub, _T("logfont"),
                                        &lpFileType[i].lf, sizeof (LOGFONT));
                  }
#ifdef UNICODE
                else if (dwData == sizeof (LOGFONTA))
                  {
                    LOGFONTA lfa;

                    RegGetValueEx (hKeySub, _T("logfont"),
                                                    &lfa, sizeof (LOGFONTA));
                    MemoryCopy (&lpFileType[i].lf, &lfa,
                            sizeof (LOGFONTA) - LF_FACESIZE * sizeof (CHAR));
                    MultiByteToWideChar (CP_ACP, 0, lfa.lfFaceName, -1,
                                    lpFileType[i].lf.lfFaceName, LF_FACESIZE);
                  }
#else /* not UNICODE */
                else if (dwData == sizeof (LOGFONTW))
                  {
                    LOGFONTA lfw;

                    RegGetValueEx (hKeySub, _T("logfont"),
                                                    &lfw, sizeof (LOGFONTW));
                    MemoryCopy (&lpFileType[i].lf, &lfw,
                            sizeof (LOGFONTA) - LF_FACESIZE * sizeof (WCHAR));
                    WideCharToMultiByte (CP_ACP, 0, lfw.lfFaceName, -1,
                        lpFileType[i].lf.lfFaceName, LF_FACESIZE, NULL, NULL);
                  }
#endif /* not UNICODE */
              RegGetValueEx (hKeySub, _T("color"),
                                lpFileType[i].crColor, sizeof (COLORREF) * 12);
              if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
                {
                  MessageBox (NULL, _T("RegCloseKey"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  RegCloseKey (hKey);
                  return 0;
                }
              lpFileType[i].fAssociate = dwStat & 64;
              lpFileType[i].fAutoIndent = dwStat & 2048;
              lpFileType[i].fCode = dwStat & 16;
              lpFileType[i].fCRLF = dwStat & 4;
              lpFileType[i].fEOF = dwStat & 128;
              lpFileType[i].fLimit = dwStat & 1024;
              lpFileType[i].fOverWrite = dwStat & 4096;
              lpFileType[i].fRecycle = dwStat & 256;
              lpFileType[i].fSpace = dwStat & 2;
              lpFileType[i].fSysColor = dwStat & 512;
              lpFileType[i].fTabConv = dwStat & 524288;
              lpFileType[i].fGline = dwStat & 1;
              lpFileType[i].fMline = dwStat & 8;
              lpFileType[i].fUline = dwStat & 32;
              lpFileType[i].fVline = dwStat & 8192;
              lpFileType[i].uRetCode = dwStat >> 14 & 3;
              lpFileType[i].fNegotiate = lpFileType[i].uRetCode == 0;
              if (!lpFileType[i].fNegotiate)
                lpFileType[i].uRetCode--;
              if (lpFileType[i].dwCharSet == 0)
                {
                  UINT uCharSet;

                  uCharSet = dwStat >> 16 & 7;
                  lpFileType[i].dwCharSet = uCharSet != 0
                                                        ? uCharSet : 0x2135467;
                }
            }
          nFileType = i;
          /* ja: */
          RegGetValueEx (hKey, _T("findnum"), &nFind, sizeof (int));
          if (nFind > 0 && RegOpenKeyEx (hKey, _T("find"), 0, KEY_ALL_ACCESS,
                                                    &hKeySub) == ERROR_SUCCESS)
            {
              for (i = 0; i < nFind; i++)
                {
                  LONG lResult;
                  LPTSTR lpszName;

                  lpszFind[i] = MemoryAlloc (MAXFIND * sizeof (TCHAR));
                  wasprintf (&lpszName, _T("findstr%02d"), i);
                  lResult = RegGetValueEx (hKeySub, lpszName,
                                                        lpszFind[i], MAXFIND);
                  MemoryFree (lpszName);
                  if (lResult != ERROR_SUCCESS || *lpszFind[i] == '\0')
                    {
                      MemoryFree (lpszFind[i]);
                      break;
                    }
                  lpszFind[i] = MemoryReAlloc (lpszFind[i],
                                (lstrlen (lpszFind[i]) + 1) * sizeof (TCHAR));
                }
              nFind = i;
              if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
                {
                  MessageBox (NULL, _T("RegCloseKey"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
                  RegCloseKey (hKey);
                  return 0;
                }
            }
          /* ja:u */
          RegGetValueEx (hKey, _T("repnum"), &nReplace, sizeof (int));
          if (nReplace > 0 && RegOpenKeyEx (hKey, _T("replace"),
                                0, KEY_ALL_ACCESS, &hKeySub) == ERROR_SUCCESS)
            {
              for (i = 0; i < nReplace; i++)
                {
                  LONG lResult;
                  LPTSTR lpszName;

                  lpszReplace[i] = MemoryAlloc (MAXFIND * sizeof (TCHAR));
                  wasprintf (&lpszName, _T("repstr%02d"), i);
                  lResult = RegGetValueEx (hKeySub, lpszName,
                                                    lpszReplace[i], MAXFIND);
                  MemoryFree (lpszName);
                  if (lResult != ERROR_SUCCESS || *lpszReplace[i] == '\0')
                    {
                      MemoryFree (lpszReplace[i]);
                      break;
                    }
                  lpszReplace[i] = MemoryReAlloc (lpszReplace[i],
                            (lstrlen (lpszReplace[i]) + 1) * sizeof (TCHAR));
                }
              nReplace = i;
              if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
                {
                  MessageBox (NULL, _T("RegCloseKey"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  RegCloseKey (hKey);
                  return 0;
                }
            }
          for (i = 0; i <nHistory; i++)
            {
              LONG lResult;
              LPTSTR lpszName;

              wasprintf (&lpszName, _T("history%d"), i);
              lResult = RegGetValueEx (hKey, lpszName, &szHistory[i][3],
                                                    MAX_PATH * sizeof (TCHAR));
              MemoryFree (lpszName);
              if (lResult != ERROR_SUCCESS || szHistory[i][3] == '\0')
                break;
              szHistory[i][0] = '&';
              szHistory[i][1] = i + '1';
              szHistory[i][2] = ' ';
            }
          if (RegCloseKey (hKey) != ERROR_SUCCESS)
            {
              MessageBox (NULL, _T("RegCloseKey"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              return 0;
            }
          fLicense = TRUE;
        }
      if (rc0.left != LONG_MIN)
        {
          RECT rc1, rc2;

          rc1.left = rc1.top = 0;
          rc1.right = GetSystemMetrics (SM_CXSCREEN);
          rc1.bottom = GetSystemMetrics (SM_CYSCREEN);
          if (IntersectRect (&rc2, &rc0, &rc1)
                            && rc2.left < rc2.right && rc2.top < rc2.bottom)
            {
              nLeft = rc2.left;
              nTop = rc2.top;
              nRight = rc2.right - nLeft;
              nBottom = rc2.bottom - nTop;
            }
          else
            {
              nLeft = nTop = nRight = nBottom = CW_USEDEFAULT;
            }
        }
    }
  if (!fLicense && DialogBoxParamGUI (hInstance, MAKEINTRESOURCE (DIALOG_1),
                            NULL, LicenseDlgProc, (LPARAM)hInstance) != IDOK)
    {
      /* ja:CZXւ̓ӂȂAI */
      return 0;
    }

  /* ja:R}hC */
  for (i = 0; plpszArgv[i]; i++)
    if ((plpszArgv[i])[0] == '-' || (plpszArgv[i])[0] == '/')
      switch ((int)CharUpper ((LPTSTR)(plpszArgv[i])[1]))
        {
          case 'C':
            if ((plpszArgv[i])[2] == '\0')
              nCodeDef = ' ';
            else
              StrVal (&nCodeDef, plpszArgv[i] + 2, 10);
            break;
          case 'F':
            if ((plpszArgv[i])[2] == '\0')
              dwFilter = 0;
            else
              StrVal (&dwFilter, plpszArgv[i] + 2, 10);
            break;
          case 'H':
            nHistory = IsCharNumeric ((plpszArgv[i])[2])
                    && (plpszArgv[i])[3] == '\0' ? (plpszArgv[i])[2] - '0' : 4;
            break;
          case 'L':
            StrVal (&nInitLine, plpszArgv[i] + 2, 10);
            break;
          case 'N':
            fNewFile = (plpszArgv[i])[2] - '0';
            break;
          case 'Q':
            break;
          case 'S':
            if ((plpszArgv[i])[2] == '\0')
              {
                bFindArrow = TRUE;
                bFindCase = FALSE;
                bFindWidth=FALSE;
                bReplaceArrow = TRUE;
                bReplaceCase = FALSE;
                bReplaceWidth = FALSE;
              }
            else
              {
                DWORD dwStat;

                StrVal (&dwStat, plpszArgv[i] + 2, 10);
                bFindArrow = !(dwStat & 4);
                bFindCase = dwStat & 1;
                bFindWidth = dwStat & 2;
                bReplaceArrow = !(dwStat & 32);
                bReplaceCase = dwStat & 8;
                bReplaceWidth = dwStat & 16;
              }
            break;
          case 'W':
            if ((plpszArgv[i])[2] == '\0')
              {
                nLeft = nTop = nRight = nBottom = CW_USEDEFAULT;
              }
            else
              {
                TCHAR **plpszArray;

                plpszArray = StringSplitDelimiter (plpszArgv[i] + 2, _T(","));
                if (plpszArray)
                  {
                    int j;

                    for (j = 0; plpszArray[j]; j++);
                    if (j == 4)
                      {
                        StrVal (&nLeft, plpszArray[0], 10);
                        StrVal (&nTop, plpszArray[1], 10);
                        StrVal (&nRight, plpszArray[2], 10);
                        StrVal (&nBottom, plpszArray[3], 10);
                      }
                    MemoryFree (plpszArray);
                  }
              }
            break;
          case 'X':
            fSecondWindow = (plpszArgv[i])[2] - '0';
            break;
          case 'Z':
            fZoomed = (plpszArgv[i])[2] - '0';
            break;
          default:
            {
              LPTSTR lpszText;

              lpszText = LoadText (hInst, IDS_OTHER_COMMAND);
              MessageBox (NULL, lpszText,
                                APPLICATION, MB_OK | MB_ICONSTOP);
              MemoryFree (lpszText);
            }
            return 0;
        }

  if (!fSecondWindow && (hWndMain = FindWindow (MAINCLASS, NULL)))
    {
      ATOM atom;

      if (IsIconic (hWndMain))
        ShowWindow (hWndMain, SW_RESTORE);
      else
        SetForegroundWindow (hWndMain);
      atom = GlobalAddAtom (_T("-L0"));
      if (atom == 0)
        {
          MessageBox (NULL, _T("GlobalAddAtom"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      SendMessage (hWndMain, WM_USER, atom, 0);
      if (GlobalDeleteAtom (atom) != 0)
        {
          MessageBox (NULL, _T("GlobalDeleteAtom"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      for (i = 0; plpszArgv[i]; i++)
        if ((plpszArgv[i])[0] == '-' || (plpszArgv[i])[0] == '/')
          {
            atom = GlobalAddAtom (plpszArgv[i]);
            if (atom == 0)
              {
                MessageBox (NULL, _T("GlobalAddAtom"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                return 0;
              }
            SendMessage (hWndMain, WM_USER, atom, 0);
            if (GlobalDeleteAtom (atom) != 0)
              {
                MessageBox (NULL, _T("GlobalDeleteAtom"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                return 0;
              }
          }
      for (i = 0; plpszArgv[i]; i++)
        if ((plpszArgv[i])[0] != '-' && (plpszArgv[i])[0] != '/')
          {
            TCHAR szFile[MAX_PATH];

            GetLongFile (szFile, plpszArgv[i]);
            atom = GlobalAddAtom (szFile);
            if (atom == 0)
              {
                MessageBox (NULL, _T("GlobalAddAtom"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                return 0;
              }
            SendMessage (hWndMain, WM_USER, atom, 0);
            if (GlobalDeleteAtom (atom) != 0)
              {
                MessageBox (NULL, _T("GlobalDeleteAtom"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                return 0;
              }
          }
      return 0;
    }

  if (nFileType <= 0)
    {
      HDC hDC;
      LPTSTR lpszText;

      nFileType = 1;
      lpFileType = MemoryAlloc (nFileType * sizeof (FILETYPE));
      lpFileType[0].nID = nTypeCount++;
      lpszText = LoadText (hInst, IDS_OTHER_FILTER);
      lstrcpy (lpFileType[0].szText, lpszText);
      MemoryFree (lpszText);
      lstrcpy (lpFileType[0].szExt, _T("*"));
      lpFileType[0].nMargin = 80;
      lpFileType[0].nTab = 8;
      lpFileType[0].fAssociate = TRUE;
      lpFileType[0].fSysColor = TRUE;
      lpFileType[0].fNegotiate = TRUE;
      lpFileType[0].dwCharSet = 0x2135467;
      /* ja:tHg */
      hDC = CreateCompatibleDC (NULL);
      if (!hDC)
        {
          MessageBox (NULL, _T("CreateCompatibleDC"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      for (i = 0; i < 6; i++)
        {
          const int nObject[6] = {DEFAULT_GUI_FONT, ANSI_VAR_FONT,
            SYSTEM_FONT, ANSI_FIXED_FONT, SYSTEM_FIXED_FONT, OEM_FIXED_FONT};
          HFONT hFont;

          hFont = GetStockObject (nObject[i]);
          if (hFont)
            {
              BOOL fFont;
              TEXTMETRIC tm;

              hFont = SelectObject (hDC, hFont);
              fFont = GetTextMetrics (hDC, &tm) && GetTextFace (hDC,
                                LF_FACESIZE, lpFileType[0].lf.lfFaceName) > 0;
              hFont = SelectObject (hDC,hFont);
              if (fFont)
                {
                  lpFileType[0].lf.lfHeight = tm.tmHeight;
                  lpFileType[0].lf.lfWidth = tm.tmAveCharWidth;
                  lpFileType[0].lf.lfEscapement =
                  lpFileType[0].lf.lfOrientation = 0;
                  lpFileType[0].lf.lfWeight = tm.tmWeight;
                  lpFileType[0].lf.lfItalic = tm.tmItalic;
                  lpFileType[0].lf.lfUnderline = tm.tmUnderlined;
                  lpFileType[0].lf.lfStrikeOut = tm.tmStruckOut;
                  lpFileType[0].lf.lfCharSet = tm.tmCharSet;
                  lpFileType[0].lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
                  lpFileType[0].lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
                  lpFileType[0].lf.lfQuality = DEFAULT_QUALITY;
                  lpFileType[0].lf.lfPitchAndFamily = tm.tmPitchAndFamily;
                  break;
                }
            }
        }
      if (!DeleteDC (hDC))
        {
          MessageBox (NULL, _T("DeleteDC"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      if (i >= 6 && !SystemParametersInfo (SPI_GETICONTITLELOGFONT,
                    sizeof (LOGFONT), &lpFileType[0].lf, SPIF_UPDATEINIFILE))
        {
          MessageBox (NULL, _T("SystemParametersInfo"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      lpFileType[0].lf.lfPitchAndFamily
                    = lpFileType[0].lf.lfPitchAndFamily & ~15 | FIXED_PITCH;
      lpFileType[0].crColor[ 0] = crWindowText;
      lpFileType[0].crColor[ 1] = crWindow;
      lpFileType[0].crColor[ 2] =
      lpFileType[0].crColor[ 3] =
      lpFileType[0].crColor[ 4] =
      lpFileType[0].crColor[ 5] =
      lpFileType[0].crColor[ 6] = crGrayText;
      lpFileType[0].crColor[ 7] = crBtnFace;
      lpFileType[0].crColor[ 8] = crHighLightText;
      lpFileType[0].crColor[ 9] = crHighLight;
      lpFileType[0].crColor[10] = RGB (  0,   0,   0);
      lpFileType[0].crColor[11] = RGB (128, 128, 128);
    }

  wc.style         = 0;
  wc.lpfnWndProc   = WndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE (ICON_1));
  wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE + 1);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = MAINCLASS;
  if (RegisterClass (&wc) == 0)
    {
      MessageBox (NULL, _T("RegisterClass"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  wc.style         = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
  wc.cbClsExtra    = 0;
  wc.lpfnWndProc   = TextWndProc;
  wc.cbWndExtra    = sizeof (LPTEXTWND);
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE (ICON_1));
  wc.hCursor       = LoadCursor (NULL, IDC_IBEAM);
  wc.hbrBackground = NULL;
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = TEXTCLASS;
  if (RegisterClass (&wc) == 0)
    {
      MessageBox (NULL, _T("RegisterClass"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  hWndMain = CreateWindowEx (WS_EX_ACCEPTFILES, MAINCLASS,
                            APPLICATION, WS_CLIPCHILDREN |WS_OVERLAPPEDWINDOW,
                            nLeft, nTop, nRight, nBottom, NULL,
                            LoadMenu (hInstance, MAKEINTRESOURCE (MENU_1)),
                                                            hInstance, NULL);
  if (!hWndMain)
    {
      MessageBox (NULL, _T("CreateWindowEx"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  hAccel = LoadAccelerators (hInstance, MAKEINTRESOURCE (MENU_1));
  if (!hAccel)
    {
      MessageBox (hWndMain, _T("LoadAccelerators"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }

  ShowWindow (hWndMain, nCmdShow);
  if (!UpdateWindow (hWndMain))
    {
      MessageBox (hWndMain, _T("UpdateWindow"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }

  hMenu = GetMenu (hWndMain);
  if (!hMenu)
    {
      MessageBox (hWndMain, _T("GetMenu"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }
  hMenu = GetSubMenu (hMenu, 0);
  if (!hMenu)
    {
      MessageBox (hWndMain, _T("GetSubMenu"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }
  if (nRegStat & REG_STAT_READ)
    for (i = 0; i <nHistory; i++)
      {
        if (szHistory[i][0] == '\0')
          break;
        if (!InsertMenu (hMenu, i + MENUFILE - 1,
                                    MF_BYPOSITION, i + 200, &szHistory[i][0]))
          {
            MessageBox (hWndMain, _T("InsertMenu"),
                                  APPLICATION, MB_OK | MB_ICONSTOP);
            DestroyWindow (hWndMain);
            return 0;
          }
      }
  if (i != 0 && !InsertMenu (hMenu, i + MENUFILE - 1,
                                        MF_BYPOSITION | MF_SEPARATOR, 0, NULL))
    {
      MessageBox (hWndMain, _T("InsertMenu"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }
  if (!DrawMenuBar (hWndMain))
    {
      MessageBox (hWndMain, _T("DrawMenuBar"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }

  for (i = 0; plpszArgv[i]; i++)
    if ((plpszArgv[i])[0] != '-' && (plpszArgv[i])[0] != '/')
      {
        HWND hWnd;

        fNewFile = FALSE;
        hWnd = OpenEditFile (plpszArgv[i]);
        if (!hWnd || nInitLine != 0 && !JumpOperation (hWnd, nInitLine))
          {
            MessageBox (hWndMain, plpszArgv[i],
                                    APPLICATION, MB_OK | MB_ICONSTOP);
            break;
          }
      }
  if (fNewFile)
    OpenEditFile (NULL);

  MemoryFree (plpszArgv);

  while (GetMessage (&msg, NULL, 0, 0))
    if (!TranslateMDISysAccel (hWndClient, &msg)
                            && !TranslateAccelerator (hWndMain, hAccel, &msg))
      {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
      }
  return 0;
}
