/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WFILE_H__
#define __WFILE_H__


#include "wcommon.h"
#include <shlobj.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:ロングファイル名を取得する
    lpszShortName,ファイル名
              RET,ロングファイル名,NULL:エラー                              */
LPWSTR WINAPI
GetLongFileNewW (LPCWSTR lpszShortName);


/*  ja:ロングファイル名を取得する
    lpszShortName,ファイル名
              RET,ロングファイル名,NULL:エラー                              */
LPSTR WINAPI
GetLongFileNewA (LPCSTR lpszShortName);


/*  ja:特定のフォルダを取得する
    rfid,KNOWNFOLDERID
     RET,パス,NULL:エラー                                                   */
LPWSTR WINAPI
GetSpecificFolderPathW (REFKNOWNFOLDERID rfid);


/*  ja:特定のフォルダを取得する
    rfid,KNOWNFOLDERID
     RET,パス,NULL:エラー                                                   */
LPSTR WINAPI
GetSpecificFolderPathA (REFKNOWNFOLDERID rfid);


/*  ja:モジュールのファイル名を取得する
    hModule,モジュールのハンドル
        RET,ファイル名,NULL:エラー                                          */
LPWSTR WINAPI
GetModuleFileNameNewW (HMODULE hModule);


/*  ja:モジュールのファイル名を取得する
    hModule,モジュールのハンドル
        RET,ファイル名,NULL:エラー                                          */
LPSTR WINAPI
GetModuleFileNameNewA (HMODULE hModule);


/*  ja:パスの拡張子を変更する
    lpszPath,パス
     lpszExt,新たな拡張子(NULL:拡張子削除)
         RET,パス,NULL:エラー                                               */
LPWSTR WINAPI
PathRenameExtensionNewW (LPCWSTR lpszPath,
                         LPCWSTR lpszExt);


/*  ja:パスの拡張子を変更する
    lpszPath,パス
     lpszExt,新たな拡張子(NULL:拡張子削除)
         RET,パス,NULL:エラー                                               */
LPSTR WINAPI
PathRenameExtensionNewA (LPCSTR lpszPath,
                         LPCSTR lpszExt);


#ifdef UNICODE
# define GetLongFileNew GetLongFileNewW
# define GetSpecificFolderPath GetSpecificFolderPathW
# define GetModuleFileNameNew GetModuleFileNameNewW
# define PathRenameExtensionNew PathRenameExtensionNewW
#else /* not UNICODE */
# define GetLongFileNew GetLongFileNewA
# define GetSpecificFolderPath GetSpecificFolderPathA
# define GetModuleFileNameNew GetModuleFileNameNewA
# define PathRenameExtensionNew PathRenameExtensionNewA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ファイルをメモリに読み込む
    lpszFile,ファイル名
    lpdwSize,ファイルサイズ
         RET,メモリ                                                         */
LPVOID WINAPI
LoadFileW (LPCWSTR lpszFile,
           LPDWORD lpdwSize);


/*  ファイルをメモリに読み込む
    lpszFile,ファイル名
    lpdwSize,ファイルサイズ
         RET,メモリ                                                         */
LPVOID WINAPI
LoadFileA (LPCSTR  lpszFile,
           LPDWORD lpdwSize);


/*  メモリをファイルに書き込む
    lpszFile,ファイル名
    lpBuffer,メモリ
      nSize,バイト数(負:NULL終端文字列)
         RET,TRUE:正常終了,FALSE:エラー                                     */
BOOL WINAPI
SaveFileW (LPCWSTR lpszFile,
           LPCVOID lpBuffer,
           SSIZE_T nSize);


/*  メモリをファイルに書き込む
    lpszFile,ファイル名
    lpBuffer,メモリ
      nSize,バイト数(負:NULL終端文字列)
         RET,TRUE:正常終了,FALSE:エラー                                     */
BOOL WINAPI
SaveFileA (LPCSTR  lpszFile,
           LPCVOID lpBuffer,
           SSIZE_T nSize);


#ifdef UNICODE
# define LoadFile LoadFileW
# define SaveFile SaveFileW
#else /* not UNICODE */
# define LoadFile LoadFileA
# define SaveFile SaveFileA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WFILE_H__ */
