/*
copyright (c) 2017-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include <windows.h>
#include <tchar.h>
#include <imagehlp.h>
#include <string.h>


#define FILE_ALIGNMENT 512


typedef struct _PESEC
{
  int nData;
  LPVOID pData;
  IMAGE_SECTION_HEADER ish;
} PESEC, *PPESEC, *LPPESEC;
typedef struct _RANGE
{
  DWORD dwAddress;
  DWORD dwSize;
} RANGE, *PRANGE, *LPRANGE;


static DWORD
FileAlignment (DWORD dwSize)
{
  return (dwSize + FILE_ALIGNMENT - 1) / FILE_ALIGNMENT * FILE_ALIGNMENT;
}


static LPVOID
PeSection (PPESEC pPeSec,
           int    n,
           DWORD  dwAddress,
           DWORD  dwSize)
{
  int i;

  for (i = 0; i < n; i++)
    if (pPeSec[i].ish.VirtualAddress <= dwAddress
            && dwAddress + dwSize
            <= pPeSec[i].ish.VirtualAddress + pPeSec[i].ish.Misc.VirtualSize)
      return (LPBYTE)pPeSec[i].pData + dwAddress
                   - pPeSec[i].ish.VirtualAddress;
  return NULL;
}


int
_tmain (int     argc,
        _TCHAR *argv[])
{
  int nResult = -1;
  DWORD dwImage, dwSection;
  HANDLE hFile, hHeap;
  LPVOID lpImage = NULL;
  IMAGE_NT_HEADERS32 inth;
  PPESEC pPeSec = NULL;

  hHeap = GetProcessHeap ();
  hFile = CreateFile (argv[1], GENERIC_READ, FILE_SHARE_READ,
                            NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if (hFile != INVALID_HANDLE_VALUE)
    {
      DWORD dwRead;
      IMAGE_DOS_HEADER idh;

      if (ReadFile (hFile, &idh, sizeof (IMAGE_DOS_HEADER), &dwRead, NULL)
        && dwRead == sizeof (IMAGE_DOS_HEADER)
        && idh.e_magic == IMAGE_DOS_SIGNATURE
        && SetFilePointer (hFile, idh.e_lfanew, NULL, FILE_BEGIN)
                                                    != INVALID_SET_FILE_POINTER
        && ReadFile (hFile, &inth, sizeof (IMAGE_NT_HEADERS32), &dwRead, NULL)
        && dwRead == sizeof (IMAGE_NT_HEADERS32)
        && inth.Signature == IMAGE_NT_SIGNATURE
        && inth.FileHeader.Machine == IMAGE_FILE_MACHINE_I386
        && inth.FileHeader.SizeOfOptionalHeader
                                            == sizeof (IMAGE_OPTIONAL_HEADER32)
        && inth.OptionalHeader.Magic == IMAGE_NT_OPTIONAL_HDR32_MAGIC)
        {
          int i;

          pPeSec = HeapAlloc (hHeap, HEAP_ZERO_MEMORY,
                            inth.FileHeader.NumberOfSections * sizeof (PESEC));
          for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
            if (!ReadFile (hFile, &pPeSec[i].ish, sizeof (IMAGE_SECTION_HEADER),
                    &dwRead, NULL) || dwRead != sizeof (IMAGE_SECTION_HEADER))
              break;
          if (i >= inth.FileHeader.NumberOfSections)
            for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
              if (pPeSec[i].ish.SizeOfRawData > 0)
                {
                  pPeSec[i].pData = HeapAlloc (hHeap, 0,
                                                pPeSec[i].ish.SizeOfRawData);
                  if (SetFilePointer (hFile, pPeSec[i].ish.PointerToRawData,
                                NULL, FILE_BEGIN) == INVALID_SET_FILE_POINTER
                        || !ReadFile (hFile, pPeSec[i].pData,
                                    pPeSec[i].ish.SizeOfRawData, &dwRead, NULL)
                                    || dwRead != pPeSec[i].ish.SizeOfRawData)
                    break;
                }
          if (i < inth.FileHeader.NumberOfSections)
            {
              for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
                if (pPeSec[i].pData)
                  HeapFree (hHeap, 0, pPeSec[i].pData);
              HeapFree (hHeap, 0, pPeSec);
              pPeSec = NULL;
            }
        }
      CloseHandle (hFile);
    }
  if (pPeSec)
    {
      int i, n = 2;
      DWORD dwHeader, dwCheckSum;
      LPBYTE p;
      PIMAGE_IMPORT_DESCRIPTOR piid;
      PIMAGE_NT_HEADERS32 pinth;
      PRANGE pRange;

      piid = inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].Size > 0 ? PeSection (pPeSec, inth.FileHeader.NumberOfSections, inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress, inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_DEBUG].Size) : NULL;
      if (piid)
        for (i = 0; piid[i].OriginalFirstThunk != 0; i++)
          if (piid[i].OriginalFirstThunk != piid[i].FirstThunk)
            n++;
      pRange = HeapAlloc (hHeap, HEAP_ZERO_MEMORY, n * sizeof (RANGE));
      n = 0;
      if (piid)
        for (i = 0; piid[i].OriginalFirstThunk != 0; i++)
          if (piid[i].OriginalFirstThunk != piid[i].FirstThunk)
            {
              LPDWORD lpdwThunk;

              pRange[n].dwAddress = piid[i].OriginalFirstThunk;
              lpdwThunk = PeSection (pPeSec, inth.FileHeader.NumberOfSections, pRange[n].dwAddress, 0);
              while (lpdwThunk[pRange[n].dwSize] != 0)
                pRange[n].dwSize++;
              pRange[n].dwSize *= sizeof (DWORD);
              piid[i].OriginalFirstThunk = piid[i].FirstThunk;
              n++;
            }
      if (inth.OptionalHeader.DataDirectory
                                        [IMAGE_DIRECTORY_ENTRY_DEBUG].Size > 0)
        {
          PIMAGE_DEBUG_DIRECTORY pidd;

          pidd = PeSection (pPeSec, inth.FileHeader.NumberOfSections, inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_DEBUG].VirtualAddress, inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_DEBUG].Size);
          if (pidd)
            {
              pRange[n].dwAddress = inth.OptionalHeader.DataDirectory
                                [IMAGE_DIRECTORY_ENTRY_DEBUG].VirtualAddress;
              pRange[n].dwSize = inth.OptionalHeader.DataDirectory
                                [IMAGE_DIRECTORY_ENTRY_DEBUG].Size;
              n++;
              pRange[n].dwAddress = pidd->AddressOfRawData;
              pRange[n].dwSize = pidd->SizeOfData;
              n++;
            }
        }
      while (TRUE)
        {
          int j;

          i = 0;
          for (j = 1; j < n; j++)
            if (pRange[j].dwAddress > pRange[i].dwAddress)
              i = j;
          if (pRange[i].dwAddress == 0)
            break;
          for (j = 0; j < inth.FileHeader.NumberOfSections; j++)
            if (pRange[i].dwAddress + pRange[i].dwSize == pPeSec[j].ish.VirtualAddress + pPeSec[j].ish.Misc.VirtualSize)
              {
                pPeSec[j].ish.Misc.VirtualSize -= pRange[i].dwSize;
                pRange[i].dwAddress = 0;
              }
          if (pRange[i].dwAddress != 0)
            {
              p = PeSection (pPeSec, inth.FileHeader.NumberOfSections, pRange[i].dwAddress, pRange[i].dwSize);
              if (p)
                memset (p, 0, pRange[i].dwSize);
              pRange[i].dwAddress = 0;
            }
        }
      HeapFree (hHeap, 0, pRange);
      dwImage = dwHeader = FileAlignment (sizeof (IMAGE_DOS_HEADER)
                                            + sizeof (IMAGE_NT_HEADERS32)
                                            + inth.FileHeader.NumberOfSections
                                            * sizeof (IMAGE_SECTION_HEADER));
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        {
          if (pPeSec[i].ish.SizeOfRawData > pPeSec[i].ish.Misc.VirtualSize)
            pPeSec[i].ish.SizeOfRawData = pPeSec[i].ish.Misc.VirtualSize;
          for (pPeSec[i].nData = pPeSec[i].ish.SizeOfRawData - 1;
                                        pPeSec[i].nData >= 0; pPeSec[i].nData--)
            if (((LPBYTE)pPeSec[i].pData)[pPeSec[i].nData] != 0)
              break;
          pPeSec[i].nData++;
          pPeSec[i].ish.SizeOfRawData = FileAlignment (pPeSec[i].nData);
          pPeSec[i].ish.PointerToRawData = pPeSec[i].nData > 0 ? dwImage : 0;
          dwImage += pPeSec[i].ish.SizeOfRawData;
        }
      inth.OptionalHeader.FileAlignment = FILE_ALIGNMENT;
      inth.OptionalHeader.SizeOfHeaders = dwHeader;
      inth.OptionalHeader.CheckSum = 0;
      inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_DEBUG]
                                                        .VirtualAddress = 0;
      inth.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_DEBUG]
                                                        .Size = 0;
      p = lpImage = HeapAlloc (hHeap, HEAP_ZERO_MEMORY, dwImage);
      ((PIMAGE_DOS_HEADER)p)->e_magic = IMAGE_DOS_SIGNATURE;
      ((PIMAGE_DOS_HEADER)p)->e_lfanew = sizeof (IMAGE_DOS_HEADER);
      p += sizeof (IMAGE_DOS_HEADER);
      memmove (p, &inth, sizeof (IMAGE_NT_HEADERS32));
      p += sizeof (IMAGE_NT_HEADERS32);
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        {
          memmove (p, &pPeSec[i].ish, sizeof (IMAGE_SECTION_HEADER));
          p += sizeof (IMAGE_SECTION_HEADER);
        }
      p = (LPBYTE)lpImage + dwHeader;
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        {
          memmove (p, pPeSec[i].pData, pPeSec[i].nData);
          p += pPeSec[i].ish.SizeOfRawData;
        }
      for (i = 0; i < inth.FileHeader.NumberOfSections; i++)
        if (pPeSec[i].pData)
          HeapFree (hHeap, 0, pPeSec[i].pData);
      HeapFree (hHeap, 0, pPeSec);
      pinth = CheckSumMappedFile (lpImage, dwImage, &dwHeader, &dwCheckSum);
      if (pinth)
        {
          pinth->OptionalHeader.CheckSum = dwCheckSum;
        }
      else
        {
          HeapFree (hHeap, 0, lpImage);
          lpImage = NULL;
        }
    }
  if (lpImage)
    {
      hFile = CreateFile (argv[2] ? argv[2] : argv[1],
                            GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ,
                            NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
      if (hFile != INVALID_HANDLE_VALUE)
        {
          DWORD dwWrite;

          if (WriteFile (hFile, lpImage, dwImage, &dwWrite, NULL)
                                                        && dwWrite == dwImage)
            nResult = 0;
        }
      CloseHandle (hFile);
      HeapFree (hHeap, 0, lpImage);
    }
  return nResult;
}
