/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "property.h"
#include <commctrl.h>
#include <windowsx.h>
#include "associate.h"
#include "auto.h"
#include "resource.h"
#include "wcommon.h"


/******************************************************************************
*                                                                             *
* ja:プロパティ関数群                                                         *
*                                                                             *
******************************************************************************/
typedef struct _PROPERTYDLG
{
  int nID;
  DWORD dwCharSet;
  LOGFONT LogFont;
  LPFILETYPE lpFType;
  HINSTANCE hInstance;
} PROPERTYDLG, *PPROPERTYDLG, *LPPROPERTYDLG;


BOOL CALLBACK
PropertyDlgProc (HWND   hDlg,
                 UINT   uMsg,
                 WPARAM wParam,
                 LPARAM lParam)
{
  static LPPROPERTYDLG lpDlg;
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          LPTSTR lpszText, *ppszArray;
          LPPROPERTYDLG lpDlg;

          lpDlg = MemoryAlloc (sizeof (PROPERTYDLG));
          SetWindowLongPtr (hDlg, DWLP_USER, (LONG_PTR)lpDlg);
          lpDlg->lpFType = (LPFILETYPE)lParam;
          lpDlg->LogFont = lpDlg->lpFType->LogFont;
          lpDlg->hInstance = GetModuleHandle (NULL);
          /* ja:チェックボックスの設定 */
          CheckDlgButton (hDlg, IDC_CHECKBOX51,
                    lpDlg->lpFType->fGline ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX52,
                    lpDlg->lpFType->fSpace ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX53,
                    lpDlg->lpFType->fCRLF ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX54,
                    lpDlg->lpFType->fMline ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX55,
                    lpDlg->lpFType->fLimit ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX56,
                    lpDlg->lpFType->fCode ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX57,
                    lpDlg->lpFType->fUline ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX58,
                    lpDlg->lpFType->fVline ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX59,
                    lpDlg->lpFType->fAutoIndent ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX5A,
                    lpDlg->lpFType->fTabConv ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX5B,
                    lpDlg->lpFType->fEOF ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX5C,
                    lpDlg->lpFType->fRecycle ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX5D,
                    lpDlg->lpFType->fOverWrite ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX5E,
                    lpDlg->lpFType->fSysColor ? BST_CHECKED : BST_UNCHECKED);
          /* ja:コンボボックスの設定 */
          lpszText = LoadText (lpDlg->hInstance, IDS_FTYPE_CRLF);
          ppszArray = StringSplitDelimiter (lpszText, _T(","));
          MemoryFree (lpszText);
          for (i = 0; ppszArray[i]; i++)
            ComboBoxItem_AddString (hDlg, IDC_COMBOBOX51, ppszArray[i]);
          MemoryFree (ppszArray);
          ComboBoxItem_SetCurSel (hDlg, IDC_COMBOBOX51,
                                                    lpDlg->lpFType->uRetCode);
          /* ja:エディトコントロールの設定 */
          SetDlgItemInt (hDlg, IDC_EDIT51, lpDlg->lpFType->nMargin, TRUE);
          SetDlgItemInt (hDlg, IDC_EDIT52, lpDlg->lpFType->nTab, TRUE);
          /* ja:リストボックスの設定 */
          lpszText = LoadText (lpDlg->hInstance, IDS_FTYPE_COLOR);
          ppszArray = StringSplitDelimiter (lpszText, _T(","));
          MemoryFree (lpszText);
          ListBoxItem_ResetContext (hDlg, IDC_LISTBOX51);
          for (i = 0; ppszArray[i]; i++)
            ListBoxItem_SetItemData (hDlg, IDC_LISTBOX51,
                    ListBoxItem_AddString (hDlg, IDC_LISTBOX51, ppszArray[i]),
                                                lpDlg->lpFType->crColor[i]);
          MemoryFree (ppszArray);
          /* ja:アップダウンコントロールの設定 */
          UpDownItem_SetRange (hDlg, IDC_UPDOWN51, 1, UD_MAXVAL);
          UpDownItem_SetRange (hDlg, IDC_UPDOWN52, 1, UD_MAXVAL);
          if (GetDlgItem (hDlg, IDC_STATIC51))
            {
              lpDlg->nID = lpDlg->lpFType->nID;
              /* ja:コンボボックスの設定 */
              lpszText = LoadText (lpDlg->hInstance, IDS_FTYPE_CHARSET);
              ppszArray = StringSplitDelimiter (lpszText, _T(","));
              MemoryFree (lpszText);
              for (i = 0; ppszArray[i]; i++)
                ComboBoxItem_AddString (hDlg, IDC_COMBOBOX52, ppszArray[i]);
              MemoryFree (ppszArray);
              ComboBoxItem_SetCurSel (hDlg, IDC_COMBOBOX52,
                                                    lpDlg->lpFType->uCharSet);
              /* ja:スタティックの設定 */
              if (lpDlg->lpFType->nID >= 0)
                {
                  /* ja:ファイルタイプあり */
                  for (i = 0; i < nFileType; i++)
                    if (lpDlg->lpFType->nID == lpFileType[i].nID)
                      {
                        lpszText = StringDuplicate (lpFileType[i].lpszText);
                        break;
                      }
                  if (i >= nFileType)
                    lpszText = LoadText (lpDlg->hInstance, IDS_FTYPE_UNKNOW);
                }
              else
                {
                  /* ja:ファイルタイプなし */
                  lpszText = LoadText (lpDlg->hInstance, IDS_FTYPE_NOTYPE);
                }
              SetDlgItemText (hDlg, IDC_STATIC51, lpszText);
              MemoryFree (lpszText);
            }
          else
            {
              lpDlg->dwCharSet = lpDlg->lpFType->dwCharSet;
              /* ja:チェックボックスの設定 */
              CheckDlgButton (hDlg, IDC_CHECKBOXD1,
                    lpDlg->lpFType->fNegotiate ? BST_CHECKED : BST_UNCHECKED);
              CheckDlgButton (hDlg, IDC_CHECKBOXD2,
                    lpDlg->lpFType->fAssociate ? BST_CHECKED : BST_UNCHECKED);
              /* ja:エディトコントロールの設定 */
              SetDlgItemText (hDlg, IDC_EDITD1, lpDlg->lpFType->lpszText);
              SetDlgItemText (hDlg, IDC_EDITD2, lpDlg->lpFType->lpszExt);
            }
          /* ja:コントロールの表示状態 */
          EnableDlgItem (hDlg, IDC_LISTBOX51, !lpDlg->lpFType->fSysColor);
          EnableDlgItem (hDlg, IDOK, FALSE);
        }
        return TRUE;
      case WM_MEASUREITEM:
        {
          HWND hWnd;
          HDC hDC;
          SIZE Size;
          LPTSTR lpszText;
          LPMEASUREITEMSTRUCT lpMeasure;

          lpMeasure = (LPMEASUREITEMSTRUCT)lParam;
          hWnd = GetDlgItem (hDlg, lpMeasure->CtlID);
          hDC = GetDC (hWnd);
          lpszText = ListBox_GetTextNew (hWnd, lpMeasure->itemID);
          GetTextExtentPoint32 (hDC, lpszText, lstrlen (lpszText), &Size);
          MemoryFree (lpszText);
          ReleaseDC (hWnd, hDC);
          lpMeasure->itemWidth = Size.cx + Size.cy / 2 * 3;
          lpMeasure->itemHeight = Size.cy;
        }
        return TRUE;
      case WM_DRAWITEM:
        if (((LPDRAWITEMSTRUCT)lParam)->itemID == -1)
          break;
        switch (((LPDRAWITEMSTRUCT)lParam)->itemAction)
          {
            case ODA_SELECT:
            case ODA_DRAWENTIRE:
              {
                int nBkMode, nWidth;
                COLORREF crText, crWindow;
                HBRUSH hBrush;
                RECT rc;
                LPTSTR lpszText;
                LPDRAWITEMSTRUCT lpDraw;
                LPPROPERTYDLG lpDlg;

                lpDlg = (LPPROPERTYDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                lpDraw = (LPDRAWITEMSTRUCT)lParam;
                nBkMode = SetBkMode(lpDraw->hDC, TRANSPARENT);
                if (lpDraw->itemState & ODS_DISABLED)
                  {
                    crWindow = ListBox_GetItemData (lpDraw->hwndItem,
                                                            lpDraw->itemID);
                    crWindow= RGB(
                        (GetRValue (crWindow) + GetRValue (crGrayText)) / 2,
                        (GetGValue (crWindow) + GetGValue (crGrayText)) / 2,
                        (GetBValue (crWindow) + GetBValue (crGrayText)) / 2);
                    crText = SetTextColor (lpDraw->hDC, crGrayText);
                    EnableScrollBar (lpDraw->hwndItem,
                                                    SB_VERT, ESB_DISABLE_BOTH);
                  }
                else
                  {
                    crWindow = ListBox_GetItemData (lpDraw->hwndItem,
                                                            lpDraw->itemID);
                    crText = SetTextColor (lpDraw->hDC,
                                            lpDraw->itemState & ODS_SELECTED
                                            ? crHighLightText : crWindowText);
                    EnableScrollBar (lpDraw->hwndItem,
                                                    SB_VERT, ESB_ENABLE_BOTH);
                  }
                FillRect (lpDraw->hDC, &lpDraw->rcItem,
                                            lpDraw->itemState & ODS_SELECTED
                                            ? hBrushHighLight : hBrushWindow);
                hBrush = CreateSolidBrush (crWindow);
                nWidth = (lpDraw->rcItem.bottom - lpDraw->rcItem.top + 1)
                                                                    / 2 * 3;
                rc.left = lpDraw->rcItem.left + 1;
                rc.top = lpDraw->rcItem.top + 1;
                rc.right = rc.left + nWidth - 2;
                rc.bottom = lpDraw->rcItem.bottom - 1;
                FillRect (lpDraw->hDC, &rc, hBrush);
                DeleteObject (hBrush);
                lpszText = ListBox_GetTextNew (lpDraw->hwndItem,
                                                            lpDraw->itemID);
                TextOut (lpDraw->hDC,
                            lpDraw->rcItem.left + nWidth,
                            lpDraw->rcItem.top, lpszText, lstrlen (lpszText));
                MemoryFree (lpszText);
                SetBkMode (lpDraw->hDC, nBkMode);
                SetTextColor (lpDraw->hDC, crText);
              }
              break;
            case ODA_FOCUS:
              DrawFocusRect (((LPDRAWITEMSTRUCT)lParam)->hDC,
                                        &((LPDRAWITEMSTRUCT)lParam)->rcItem);
          }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int i;
                LPPROPERTYDLG lpDlg;

                lpDlg = (LPPROPERTYDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                lpDlg->lpFType->nMargin
                                = GetDlgItemInt (hDlg, IDC_EDIT51, NULL, TRUE);
                lpDlg->lpFType->nTab
                                = GetDlgItemInt (hDlg, IDC_EDIT52, NULL, TRUE);
                lpDlg->lpFType->fGline
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX51) == BST_CHECKED;
                lpDlg->lpFType->fSpace
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX52) == BST_CHECKED;
                lpDlg->lpFType->fCRLF
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX53) == BST_CHECKED;
                lpDlg->lpFType->fMline
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX54) == BST_CHECKED;
                lpDlg->lpFType->fLimit
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX55) == BST_CHECKED;
                lpDlg->lpFType->fCode
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX56) == BST_CHECKED;
                lpDlg->lpFType->fUline
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX57) == BST_CHECKED;
                lpDlg->lpFType->fVline
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX58) == BST_CHECKED;
                lpDlg->lpFType->fAutoIndent
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX59) == BST_CHECKED;
                lpDlg->lpFType->fTabConv
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5A) == BST_CHECKED;
                lpDlg->lpFType->fEOF
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5B) == BST_CHECKED;
                lpDlg->lpFType->fRecycle
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5C) == BST_CHECKED;
                lpDlg->lpFType->fOverWrite
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5D) == BST_CHECKED;
                lpDlg->lpFType->fSysColor
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5E) == BST_CHECKED;
                lpDlg->lpFType->uRetCode
                            = ComboBoxItem_GetCurSel (hDlg, IDC_COMBOBOX51);
                for (i = 0; i < 12; i++)
                  lpDlg->lpFType->crColor[i]
                            = ListBoxItem_GetItemData (hDlg, IDC_LISTBOX51, i);
                lpDlg->lpFType->LogFont = lpDlg->LogFont;
                if (GetDlgItem (hDlg, IDC_STATIC51))
                  {
                    lpDlg->lpFType->nID = lpDlg->nID;
                    lpDlg->lpFType->uCharSet
                            = ComboBoxItem_GetCurSel (hDlg, IDC_COMBOBOX52);
                  }
                else
                  {
                    lpDlg->lpFType->dwCharSet = lpDlg->dwCharSet;
                    lpDlg->lpFType->fNegotiate = IsDlgButtonChecked
                                        (hDlg, IDC_CHECKBOXD1) == BST_CHECKED;
                    lpDlg->lpFType->fAssociate = IsDlgButtonChecked
                                        (hDlg, IDC_CHECKBOXD2) == BST_CHECKED;
                    MemoryFree (lpDlg->lpFType->lpszText);
                    lpDlg->lpFType->lpszText
                                        = GetDlgItemTextNew (hDlg, IDC_EDITD1);
                    MemoryFree (lpDlg->lpFType->lpszExt);
                    lpDlg->lpFType->lpszExt
                                        = GetDlgItemTextNew (hDlg, IDC_EDITD2);
                  }
              }
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              break;
            case IDC_COMBOBOX51:
            case IDC_COMBOBOX52:
              if (HIWORD (wParam) == CBN_SELCHANGE)
                goto loop;
              break;
            case IDC_CHECKBOX5E:
              ListBoxItem_SetSel (hDlg, IDC_LISTBOX51, FALSE, -1);
              /* ja:コントロールの表示状態 */
              EnableDlgItem (hDlg, IDC_LISTBOX51,
                    IsDlgButtonChecked (hDlg, IDC_CHECKBOX5E) != BST_CHECKED);
              EnableDlgItem (hDlg, IDC_PUSHBUTTON51, FALSE);
              goto loop;
            case IDC_EDIT51:
            case IDC_EDIT52:
            case IDC_EDITD1:
            case IDC_EDITD2:
              if (HIWORD (wParam) == EN_CHANGE)
                goto loop;
              break;
            case IDC_LISTBOX51:
              /* ja:コントロールの表示状態 */
              if (HIWORD (wParam) == LBN_SELCHANGE)
                EnableDlgItem (hDlg, IDC_PUSHBUTTON51,
                            ListBoxItem_GetSelCount (hDlg, IDC_LISTBOX51) > 0);
              break;
            case IDC_PUSHBUTTON51:
              {
                int nItems;
                CHOOSECOLOR cc;
                INT list[12];
                static COLORREF rgbCustColors[16] = {
                                    RGB ( 64,  64,  64), RGB (  0, 128, 255),
                                    RGB (  0, 255, 128), RGB (128,   0, 255),
                                    RGB (128, 255,   0), RGB (255,   0, 128),
                                    RGB (255, 128,   0), RGB (128, 128, 255),
                                    RGB (128, 255, 128), RGB (255, 128, 128),
                                    RGB (128, 255, 255), RGB (255, 128, 255),
                                    RGB (255, 255, 128), RGB (192, 255, 255),
                                    RGB (255, 192, 255), RGB (255, 255, 192)};

                nItems = ListBoxItem_GetSelItems (hDlg, IDC_LISTBOX51,
                                                    n_elements (list), list);
                cc.lStructSize = sizeof (CHOOSECOLOR);
                cc.hwndOwner = hDlg;
                cc.rgbResult = ListBoxItem_GetItemData (hDlg, IDC_LISTBOX51,
                                                                    list[0]);
                cc.lpCustColors = rgbCustColors;
                cc.Flags = CC_RGBINIT;
                if (ChooseColor (&cc))
                  {
                    int i;
                    HWND hWnd;

                    for (i = 0; i < nItems; i++)
                      ListBoxItem_SetItemData (hDlg, IDC_LISTBOX51,
                                                        list[i], cc.rgbResult);
                    hWnd = GetDlgItem (hDlg, IDC_LISTBOX51);
                    if (hWnd)
                      InvalidateRect (hWnd, NULL, TRUE);
                    goto loop;
                  }
              }
              break;
            case IDC_PUSHBUTTON52:
              {
                CHOOSEFONT cf;
                LPPROPERTYDLG lpDlg;

                lpDlg = (LPPROPERTYDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                cf.lStructSize = sizeof (CHOOSEFONT);
                cf.hwndOwner = hDlg;
                cf.lpLogFont = &lpDlg->LogFont;
                cf.Flags = CF_FORCEFONTEXIST | CF_FIXEDPITCHONLY
                                    | CF_INITTOLOGFONTSTRUCT | CF_SCREENFONTS;
                if (ChooseFont (&cf))
                  {
                    lpDlg->LogFont.lfPitchAndFamily = (BYTE)
                        (lpDlg->LogFont.lfPitchAndFamily & ~15 | FIXED_PITCH);
                    goto loop;
                  }
              }
              break;
            case IDC_PUSHBUTTON53:
              {
                int nPos;
                LPPROPERTYDLG lpDlg;

                lpDlg = (LPPROPERTYDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                for (nPos = 0; nPos < nFileType; nPos++)
                  if (lpFileType[nPos].nID == lpDlg->nID)
                    break;
                if (DialogBoxParamGUI (lpDlg->hInstance,
                                    MAKEINTRESOURCE (DIALOG_4), hDlg,
                                    AssociateDlgProc, (LPARAM)&nPos) == IDOK)
                  {
                    if (nPos >= 0)
                      {
                        /* ja:ファイルタイプあり */
                        int i;
                        HWND hWnd;

                        lpDlg->nID = lpFileType[nPos].nID;
                        lpDlg->LogFont = lpFileType[nPos].LogFont;
                        /* ja:スタティックの設定 */
                        SetDlgItemText (hDlg, IDC_STATIC51,
                                                    lpFileType[nPos].lpszText);
                        /* ja:チェックボックスの設定 */
                        CheckDlgButton (hDlg, IDC_CHECKBOX51,
                            lpFileType[nPos].fGline
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX52,
                            lpFileType[nPos].fSpace
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX53,
                            lpFileType[nPos].fCRLF
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX54,
                            lpFileType[nPos].fMline
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX55,
                            lpFileType[nPos].fLimit
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX56,
                            lpFileType[nPos].fCode
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX57,
                            lpFileType[nPos].fUline
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX58,
                            lpFileType[nPos].fVline
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX59,
                            lpFileType[nPos].fAutoIndent
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX5A,
                            lpFileType[nPos].fTabConv
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX5B,
                            lpFileType[nPos].fEOF
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX5C,
                            lpFileType[nPos].fRecycle
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX5D,
                            lpFileType[nPos].fOverWrite
                                                ? BST_CHECKED : BST_UNCHECKED);
                        CheckDlgButton (hDlg, IDC_CHECKBOX5E,
                            lpFileType[nPos].fSysColor
                                                ? BST_CHECKED : BST_UNCHECKED);
                        /* ja:エディトコントロールの設定 */
                        SetDlgItemInt (hDlg, IDC_EDIT51,
                                            lpFileType[nPos].nMargin, TRUE);
                        SetDlgItemInt (hDlg, IDC_EDIT52,
                                            lpFileType[nPos].nTab, TRUE);
                        /* ja:リストボックスの設定 */
                        hWnd = GetDlgItem (hDlg, IDC_LISTBOX51);
                        if (hWnd)
                          InvalidateRect (hWnd, NULL, TRUE);
                        /* ja:コントロールの表示状態 */
                        EnableDlgItem (hDlg, IDC_LISTBOX51,
                                                !lpFileType[nPos].fSysColor);
                      }
                    else
                      {
                        /* ja:ファイルタイプなし */
                        LPTSTR lpszText;

                        lpDlg->nID = -1;
                        lpszText = LoadText (lpDlg->hInstance,
                                                            IDS_FTYPE_NOTYPE);
                        SetDlgItemText (hDlg, IDC_STATIC51, lpszText);
                        MemoryFree (lpszText);
                      }
                    goto loop;
                  }
              }
              break;
            case IDC_PUSHBUTTOND1:
              {
                LPPROPERTYDLG lpDlg;

                lpDlg = (LPPROPERTYDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                if (DialogBoxParamGUI (lpDlg->hInstance,
                            MAKEINTRESOURCE (DIALOG_C), hDlg,
                            AutoDlgProc, (LPARAM)&lpDlg->dwCharSet) == IDOK)
                  goto loop;
              }
              break;
            case IDC_CHECKBOX51:
            case IDC_CHECKBOX52:
            case IDC_CHECKBOX53:
            case IDC_CHECKBOX54:
            case IDC_CHECKBOX55:
            case IDC_CHECKBOX56:
            case IDC_CHECKBOX57:
            case IDC_CHECKBOX58:
            case IDC_CHECKBOX59:
            case IDC_CHECKBOX5A:
            case IDC_CHECKBOX5B:
            case IDC_CHECKBOX5C:
            case IDC_CHECKBOX5D:
            case IDC_CHECKBOXD1:
            case IDC_CHECKBOXD2:
            loop:
              /* ja:コントロールの表示状態 */
              EnableDlgItem (hDlg, IDOK,
                           GetDlgItemInt (hDlg, IDC_EDIT51, NULL, TRUE) > 0
                        && GetDlgItemInt (hDlg, IDC_EDIT52, NULL, TRUE) > 0);
          }
        return TRUE;
      case WM_DESTROY:
        {
          LPPROPERTYDLG lpDlg;

          lpDlg = (LPPROPERTYDLG)GetWindowLongPtr (hDlg, DWLP_USER);
          MemoryFree (lpDlg);
        }
    }
  return FALSE;
}
