;copyright (c) 2019 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org
;
;Permission is hereby granted, free of charge, to any person obtaining
;a copy of this software and associated documentation files (the
;"Software"), to deal in the Software without restriction, including
;without limitation the rights to use, copy, modify, merge, publish,
;distribute, sublicense, and/or sell copies of the Software, and to
;permit persons to whom the Software is furnished to do so, subject to
;the following conditions:
;
;The above copyright notice and this permission notice shall be included
;in all copies or substantial portions of the Software.
;
;THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
;CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
;TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
;SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

.xmm
.model flat, c

.const

_NaN            dd 0FFFFFFFFh
_onehalf        dd 3FC00000h
_Int32ToUInt32  dq 0, 41F0000000000000h

.code

public _dtoui3
_dtoui3 proc near
        local       dqTemp:qword
        movsd       [dqTemp], xmm0
        mov         eax, dword ptr [dqTemp]
        mov         edx, dword ptr [dqTemp+4]
        btr         edx, 1Fh
        jc          short @@1
        cmp         edx, 41F00000h
        jae         short @@2
        test        eax, 1FFFFFh
        jz          short @@0
        cvttss2si   ecx, _onehalf
@@0:    shrd        eax, edx, 15h
        bts         eax, 1Fh
        jmp         short @@3
@@1:    cmp         edx, 3FF00000h
        jae         short @@2
        cvttsd2si   eax, xmm0
        xor         eax, eax
        jmp         short @@3
@@2:    cvttss2si   ecx, _NaN
        xor         eax, eax
        dec         eax
@@3:    retn
_dtoui3 endp

public _dtol3
_dtol3 proc near
        local       dqTemp:qword
        movsd       [dqTemp], xmm0
        mov         eax, dword ptr [dqTemp]
        mov         edx, dword ptr [dqTemp+4]
        btr         edx, 1Fh
        sbb         ecx, ecx
        cmp         edx, 43E00000h
        ja          short @@3
        je          short @@2
        push        ecx
        mov         ecx, edx
        bts         edx, 14h
        shr         ecx, 14h
        and         edx, 1FFFFFh
        sub         ecx, 433h
        jge         short @@1
        neg         ecx
        push        ebx
        xor         ebx, ebx
        shrd        ebx, eax, cl
        jz          short @@0
        cvttss2si   ebx, _onehalf
@@0:    pop         ebx
        shrd        eax, edx, cl
        shr         edx, cl
        pop         ecx
        jmp         short @@5
@@1:    shld        edx, eax, cl
        shl         eax, cl
        pop         ecx
        jecxz       short @@5
        neg         eax
        adc         edx, 0
        neg         edx
        jmp         short @@5
@@2:    jecxz       short @@3
        or          eax, eax
        jz          short @@4
@@3:    cvttss2si   ecx, _NaN
        xor         eax, eax
@@4:    mov         edx, 80000000h
@@5:    ret
_dtol3 endp

public _dtoul3
_dtoul3 proc near
        local       dqTemp:qword
        movsd       [dqTemp], xmm0
        mov         eax, dword ptr [dqTemp]
        mov         edx, dword ptr [dqTemp+4]
        btr         edx, 1Fh
        jc          short @@2
        mov         ecx, edx
        bts         edx, 14h
        shr         ecx, 14h
        and         edx, 1FFFFFh
        sub         ecx, 433h
        jge         short @@1
        neg         ecx
        push        ebx
        xor         ebx, ebx
        shrd        ebx, eax, cl
        jz          short @@0
        cvttss2si   ebx, _onehalf
@@0:    pop         ebx
        shrd        eax, edx, cl
        shr         edx, cl
        jmp         short @@5
@@1:    cmp         ecx, 0Ch
        jae         short @@3
        shld        edx, eax, cl
        shl         eax, cl
        jmp         short @@5
@@2:    cmp         edx, 3FF00000h
        jae         short @@3
        cvttsd2si   eax, xmm0
        xor         eax, eax
        jmp         short @@4
@@3:    cvttss2si   ecx, _NaN
        xor         eax, eax
        dec         eax
@@4:    cdq
@@5:    retn
_dtoul3 endp

public _ltod3
_ltod3 proc near
        xorps       xmm0, xmm0
        xorps       xmm1, xmm1
        cvtsi2sd    xmm0, ecx
        cvtsi2sd    xmm1, edx
        shr         ecx, 1Fh
        mulsd       xmm1, _Int32ToUInt32[8]
        addsd       xmm0, _Int32ToUInt32[ecx*8]
        addsd       xmm0, xmm1
        retn
_ltod3 endp

public _ultod3
_ultod3 proc near
        xorps       xmm1, xmm1
        xorps       xmm0, xmm0
        cvtsi2sd    xmm1, edx
        cvtsi2sd    xmm0, ecx
        shr         edx, 1Fh
        shr         ecx, 1Fh
        addsd       xmm1, _Int32ToUInt32[edx*8]
        addsd       xmm0, _Int32ToUInt32[ecx*8]
        mulsd       xmm1, _Int32ToUInt32[8]
        addsd       xmm0, xmm1
        retn
_ultod3 endp

end

