/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "associate.h"
#include "resource.h"
#include "wcommon.h"


/******************************************************************************
*                                                                             *
* ja:ファイルタイプの選択関数群                                               *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
AssociateDlgProc (HWND   hDlg,
                  UINT   uMsg,
                  WPARAM wParam,
                  LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i, *lpnPos;
          LPTSTR lpszText;

          SetWindowLongPtr (hDlg, DWLP_USER, lParam);
          lpnPos = (int *)lParam;
          if (*lpnPos > nFileType)
            *lpnPos = 0;
          for (i = 0; i < nFileType; i++)
            ListBoxItem_AddString (hDlg, IDC_LISTBOX41,
                                                    lpFileType[i].lpszText);
          lpszText = LoadText (GetModuleHandle (NULL), IDS_FTYPE_NOTYPE);
          ListBoxItem_AddString (hDlg, IDC_LISTBOX41, lpszText);
          MemoryFree (lpszText);
          ListBoxItem_SetCurSel (hDlg, IDC_LISTBOX41, *lpnPos);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDC_LISTBOX41:
              if (HIWORD (wParam) == LBN_SELCHANGE)
                {
                  /* ja:コントロールの表示状態 */
                  int n, *lpnPos;

                  lpnPos = (int *)GetWindowLongPtr (hDlg, DWLP_USER);
                  n = ListBoxItem_GetCurSel (hDlg, IDC_LISTBOX41);
                  EnableDlgItem (hDlg, IDOK, n != LB_ERR && n != *lpnPos);
                }
              if (HIWORD (wParam) != LBN_DBLCLK)
                return TRUE;
            case IDOK:
              {
                int *lpnPos;

                lpnPos = (int *)GetWindowLongPtr (hDlg, DWLP_USER);
                *lpnPos = ListBoxItem_GetCurSel (hDlg, IDC_LISTBOX41);
                if (*lpnPos != LB_ERR)
                  {
                    if (*lpnPos >= nFileType)
                      *lpnPos = -1;
                    EndDialog (hDlg, IDOK);
                    return TRUE;
                  }
              }
            case IDCANCEL:
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
          }
    }
  return FALSE;
}
