/*
    Profile
    copyright (c) 2002-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __PROFILE_H__
#define __PROFILE_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif


#define PROFILE_DATA_TYPE_UNKNOW 0
#define PROFILE_DATA_TYPE_SPACE 1
#define PROFILE_DATA_TYPE_COMMENT 2
#define PROFILE_DATA_TYPE_SECTION 3
#define PROFILE_DATA_TYPE_KEY 4
#define PROFILE_VALUE_TYPE_BOOL 0
#define PROFILE_VALUE_TYPE_INT 1
#define PROFILE_VALUE_TYPE_STRING 2
#define PROFILE_VALUE_TYPE_ARRAY 3


typedef struct ProfileList_Tag {
	gchar *data,*section,*key,*value;
	guint type;
	struct ProfileList_Tag *prev,*next;
} ProfileList;
typedef struct Profile_Tag {
	gboolean edit;
	gchar *file;
	ProfileList *list, *sublist;
} Profile;


/*	ե򳫤
	file,ե̾
	 RET,ץե														*/
Profile *
profile_open (const gchar *file);


/*	եĤ
	profile,ץե
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean profile_close(Profile *profile);


/*	ե뤫ʸ
	profile,ץե
	section,
	    key,
	    RET,ʸ,NULL:顼												*/
gchar *profile_get_string(Profile *profile,
										const gchar *section,const gchar *key);


/*  ja:ե뤫ͤΥ
    profile,ץե
    section,
        key,
       type,
        RET,Хȿ,0:顼                                               */
gint
profile_get_size (Profile     *profile,
                  const gchar *section,
                  const gchar *key,
                  const guint  type);


/*  ja:ե뤫ͤ
    profile,ץե
    section,
        key,
      value,ͤХåե
       size,ͤХåեΥ
       type,
        RET,TRUE:ｪλ,FALSE:顼                                      */
gboolean
profile_get_value (Profile     *profile,
                   const gchar *section,
                   const gchar *key,
                   gpointer     value,
                   const gint   size,
                   const guint  type);


/*	եͤꤹ
	profile,ץե
	section,
	    key,
	  value,ͤäƤХåե
	   size,ͤäƤХåեΥ
	   type,
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean profile_set_value(Profile *profile,
					const gchar *section,const gchar *key,
					gconstpointer value,const gint size,const guint type);


/*	եΥ
	profile,ץե
	section,
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean profile_delete_section(Profile *profile,const gchar *section);


/*	եΥ
	profile,ץե
	section,
	    key,
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean profile_delete_key(Profile *profile,
										const gchar *section,const gchar *key);


/*	եΥ󤹤
	profile,ץե
	    RET,Υꥹ,NULL:顼									*/
GList *
profile_enum_section (Profile *profile);


/*	եΥ󤹤
	profile,ץե
	section,
	    RET,Υꥹ,NULL:顼									*/
GList *
profile_enum_key (Profile *profile, const gchar *section);


#ifdef __cplusplus
}
#endif
#endif
