/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "charlist.h"
#include "format.h"
#include "general.h"
#include "prop.h"


/******************************************************************************
*                                                                             *
* ファイルタイプ関数群                                                        *
*                                                                             *
******************************************************************************/
static gint ftpos;
static GtkListStore *store;
static GtkWidget *button0,*button1,*button2,*button3,*button4;


/* リストボックスの選択 */
static void
format_dialog_changed (GtkTreeSelection *select, gpointer user_data)
{
    gint i;
    GtkTreeIter iter;

    ftpos = -1;
    for (i = 0; gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, i); i++)
        if (gtk_tree_selection_iter_is_selected (select, &iter))
          {
            ftpos = i;
            break;
          }
    if (ftpos >= 0)
      {
        gtk_widget_set_sensitive (button0, TRUE);
        gtk_widget_set_sensitive (button1, ftnum > 1);
        gtk_widget_set_sensitive (button2, ftpos > 0);
        gtk_widget_set_sensitive (button3, ftpos < ftnum - 1);
        gtk_widget_set_sensitive (button4, TRUE);
      }
    else
      {
        gtk_widget_set_sensitive (button0, FALSE);
        gtk_widget_set_sensitive (button1, FALSE);
        gtk_widget_set_sensitive (button2, FALSE);
        gtk_widget_set_sensitive (button3, FALSE);
        gtk_widget_set_sensitive (button4, FALSE);
      }
}


/* 新規 */
static void
format_dialog_clicked_new (GtkWidget *widget, gpointer user_data)
{
    GtkTreeIter iter;

    ftype = g_realloc (ftype, ++ftnum * sizeof (FileType));
    g_memmove (ftype + ftpos + 2, ftype + ftpos + 1,
                                    (ftnum - ftpos - 2) * sizeof (FileType));
    ftype[ftpos + 1] = ftype[ftpos];
    ftype[ftpos + 1].ft_id = tcount++;
    ftype[ftpos + 1].text = g_strdup (ftype[ftpos].text);
    ftype[ftpos + 1].ext = g_strdup (ftype[ftpos].ext);
    ftype[ftpos + 1].charset = g_strdup (ftype[ftpos].charset);
    ftype[ftpos + 1].font_name = ftype[ftpos].font_name != NULL
                                    ? g_strdup (ftype[ftpos].font_name) : NULL;
    gtk_list_store_insert (store, &iter, ftpos + 1);
    gtk_list_store_set (store, &iter, 0, ftype[ftpos + 1].text, -1);
}


/* 削除 */
static void
format_dialog_clicked_remove (GtkWidget *widget, gpointer user_data)
{
    GtkTreeIter iter;

    g_free (ftype[ftpos].text);
    g_free (ftype[ftpos].ext);
    g_free (ftype[ftpos].font_name);
    ftnum--;
    g_memmove (ftype + ftpos, ftype + ftpos + 1,
                                        (ftnum - ftpos) * sizeof (FileType));
    ftype = g_realloc (ftype, ftnum * sizeof (FileType));
    if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, ftpos))
        gtk_list_store_remove (store, &iter);
}


/* 上へ */
static void
format_dialog_clicked_up (GtkWidget *widget, GtkTreeSelection *select)
{
    FileType ft;
    GtkTreeIter iter;

    ft = ftype[ftpos];
    ftype[ftpos] = ftype[ftpos - 1];
    ftype[ftpos - 1] = ft;
    if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, ftpos))
        gtk_list_store_set (store, &iter, 0, ftype[ftpos].text, -1);
    if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, --ftpos))
      {
        gtk_list_store_set (store, &iter, 0, ftype[ftpos].text, -1);
        gtk_tree_selection_select_iter (select, &iter);
      }
}


/* 下へ */
static void
format_dialog_clicked_down (GtkWidget *widget, GtkTreeSelection *select)
{
    FileType ft;
    GtkTreeIter iter;

    ft = ftype[ftpos];
    ftype[ftpos] = ftype[ftpos + 1];
    ftype[ftpos + 1] = ft;
    if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, ftpos))
        gtk_list_store_set (store, &iter, 0, ftype[ftpos].text, -1);
    if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, ++ftpos))
      {
        gtk_list_store_set (store, &iter, 0, ftype[ftpos].text, -1);
        gtk_tree_selection_select_iter (select, &iter);
      }
}


/* 編集 */
static void
format_dialog_clicked_edit (GtkWidget *widget, gpointer user_data)
{
    gint i;
    GList *glist;
    GtkTreeIter iter;
    TmaidWindow *tmaid;

    if (property_dialog (ftype + ftpos))
      {
        if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, ftpos))
            gtk_list_store_set (store, &iter, 0, ftype[ftpos].text, -1);
        /* 同一ファイルタイプをすべて変更 */
        glist = gtk_container_children (GTK_CONTAINER (notebook));
        for (i = g_list_length (glist) - 1; i >= 0; i--)
          {
            tmaid = g_object_get_data (G_OBJECT (g_list_nth_data (glist, i)),
                                                                "user_data");
            if (tmaid->ft.ft_id == ftype[ftpos].ft_id)
                property_change (tmaid, ftype + ftpos);
          }
        g_list_free (glist);
        charlist_renewal_all (ftype[ftpos].charset, -1);
      }
}


/* ESCが押された */
static gboolean format_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
                                                            gpointer user_data)
{
    if (event->keyval==GDK_Escape)
        gtk_widget_destroy(widget);
    return FALSE;
}


void format_dialog(void)
{
    gint i;
    GtkCellRenderer *renderer;
    GtkTreeIter iter;
    GtkTreeSelection *select;
    GtkTreeViewColumn *column;
    GtkWidget *dialog,*button5,*tview,*scroll,*hbox,*vbox;

    /* メインウインドウ */
    dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(dialog),_("File Type"));
    gtk_window_set_default_size(GTK_WINDOW(dialog),320,240);
    g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (format_dialog_key_press), NULL);
    g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
    /* リストボックス */
    store = gtk_list_store_new (1, G_TYPE_STRING);
    tview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
    gtk_tree_view_set_enable_search (GTK_TREE_VIEW (tview), FALSE);
    renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes
                        (_("Registered File Type"), renderer, "text", 0, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
    select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
    g_signal_connect (G_OBJECT (select), "changed",
                                    G_CALLBACK (format_dialog_changed), NULL);
    for (i = 0; i < ftnum; i++)
      {
        gtk_list_store_append (store, &iter);
        gtk_list_store_set (store, &iter, 0, ftype[i].text, -1);
      }
    /* スクロールウインドウ */
    scroll=gtk_scrolled_window_new(NULL,NULL);
    gtk_container_add (GTK_CONTAINER (scroll), tview);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
                                        GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
    /* ボタン */
    button0 = gtk_button_new_with_mnemonic (_("_New"));
    button1 = gtk_button_new_with_mnemonic (_("De_lete"));
    button2 = gtk_button_new_with_mnemonic (_("_Up"));
    button3 = gtk_button_new_with_mnemonic (_("_Down"));
    button4 = gtk_button_new_with_mnemonic (_("_Edit"));
    button5=gtk_button_new_with_label(_("Close"));
    g_signal_connect (G_OBJECT (button0), "clicked",
                        G_CALLBACK (format_dialog_clicked_new), NULL);
    g_signal_connect (G_OBJECT (button1), "clicked",
                        G_CALLBACK (format_dialog_clicked_remove), NULL);
    g_signal_connect (G_OBJECT (button2), "clicked",
                        G_CALLBACK (format_dialog_clicked_up), select);
    g_signal_connect (G_OBJECT (button3), "clicked",
                        G_CALLBACK (format_dialog_clicked_down), select);
    g_signal_connect (G_OBJECT (button4), "clicked",
                        G_CALLBACK (format_dialog_clicked_edit), NULL);
    g_signal_connect_swapped (G_OBJECT (button5), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
    GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button3,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button4,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button5,GTK_CAN_DEFAULT);
    /* ボックス */
    vbox = gtk_vbox_new (FALSE, SPACING);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
    gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,0);
    hbox = gtk_hbox_new (FALSE, SPACING);
    gtk_box_pack_start(GTK_BOX(hbox),button0,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox),button1,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox),button2,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox),button3,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox),button4,FALSE,FALSE,0);
    gtk_box_pack_end(GTK_BOX(hbox),button5,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
    gtk_container_add(GTK_CONTAINER(dialog),vbox);

    /* 表示 */
    gtk_widget_set_sensitive(button0,FALSE);
    gtk_widget_set_sensitive(button1,FALSE);
    gtk_widget_set_sensitive(button2,FALSE);
    gtk_widget_set_sensitive(button3,FALSE);
    gtk_widget_set_sensitive(button4,FALSE);
    gtk_widget_grab_focus(button5);
    ftpos=-1;

    gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
    gtk_grab_add(dialog);
    gtk_widget_show_all(dialog);
    gtk_main();
}
