/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#include "common.h"


#define TMAID_VERSION_NOTICE "Text maid "VERSION" ("TMAID_BUILD_ENVIRONMENT")"
#define TMAID_COPYRIGHT_NOTICE "Copyright (C) 1998-2004 Kazuki IWAMOTO"

#define MENUFILE 12


typedef struct FileType_Tag {
    gint ft_id;                 /* ファイルタイプのID(-1:無所属) */
    gint crlf;                  /* 0:CR+LF,1:CR,2:LF,3:自動 */
    gint margin;                /* 右マージンの数 */
    gint tab;                   /* タブの数 */
    gint writemode;             /* 0:Abort,1:'?',2:HTML,3:Escape */
    gboolean autoindent;        /* TRUE:自動字下げ */
    gboolean associate;         /* TRUE:関連づける */
    gboolean code;              /* TRUE:タブのコードを表示する */
    gboolean eof;               /* TRUE:1Ahをファイルの末尾に書き加える */
    gboolean hexcase;           /* TRUE:大文字,FALSE:小文字 */
    gboolean html;              /* TRUE:HTML数値文字参照を変換する */
    gboolean esc;               /* TRUE:エスケープシーケンスを変換する */
    gboolean limit;             /* TRUE:右マージンで折り返す */
    gboolean overwrite;         /* TRUE:ファイルを上書きするときに確認する */
    gboolean space;             /* TRUE:スペースを灰色の四角で表示 */
    gboolean syscol;            /* TRUE:システム色を使う */
    gboolean tabconv;           /* TRUE:タブをスペースに変換する */
    gboolean gline;             /* TRUE:グリッド線表示 */
    gboolean mline;             /* TRUE:右マージンを表示 */
    gboolean nline;             /* TRUE:改行コードを表示する */
    gboolean uline;             /* TRUE:タブ下線表示 */
    gboolean vline;             /* TRUE:タブ縦線表示 */
    gchar *charset;             /* キャラクターセット */
    gchar *font_name;           /* フォント名 */
    gchar *text,*ext;           /* 名前,拡張子 */
    GdkColor color[12];         /* 色 */
} FileType;
typedef struct TmaidHistory_Tag {
    gboolean caret;
    gchar *text;
    gint length;                /* 文字数 */
    GdkPoint cursor,select;
    struct TmaidHistory_Tag *next;
} TmaidHistory;
typedef struct LineBuffer_Tag {
    gboolean margin;            /* TRUE:右マージン,FALSE:通常の改行 */
    gchar *text;
    gint length;                /* 文字数 */
    struct LineBuffer_Tag *prev,*next;
} LineBuffer;
typedef struct TmaidWindow_Tag {
    gboolean create;            /* TRUE:新規作成,FALSE:既存ファイル */
    gboolean edit;              /* TRUE:編集済み,FALSE:未編集 */
    gchar *file;                /* ファイル名 */
    gint font_width;            /* フォントの横幅 */
    gint font_height;           /* フォントの高さ */
    gint max;                   /* 行数 */
    gint off;                   /* startが参照する行 */
    gint same;                  /* -1:重複なし,0〜:番号 */
    guint timer_id;             /* スクロール用タイマ */
    guint8 font_buf[65536];     /* 文字幅のバッファ */
    FileType ft;                /* ファイルタイプ */
    LineBuffer *start;          /* 線形リスト */
    PangoLayout *layout;        /* レイアウト */
    TmaidHistory *undo,*redo;   /* 編集履歴 */
    GdkPoint top;               /* ウインドウの先頭 */
    GdkPoint cursor;            /* キャレットの位置 */
    GdkPoint select;            /* 選択開始位置,-1:選択なし */
    GtkWidget *drawing;         /* 描画領域 */
    GtkWidget *hscroll;         /* 水平スクロールバー */
    GtkWidget *vscroll;         /* 垂直スクロールバー */
    GtkWidget *label;           /* タブのラベル */
    GtkWidget *mark;            /* タブの編集済みマーク */
    GtkWidget *menu_item;       /* メニューのウインドウの項目 */
    GtkIMContext *im_context;   /* Input Method */
    GtkWidget *preedit;         /* 描画領域(未確定文字列) */
} TmaidWindow;


enum {
    TARGET_STRING,
    TARGET_TEXT,
    TARGET_COMPOUND_TEXT,
    TARGET_UTF8
};


extern gboolean caret;                  /* キャレットの形 */
extern gboolean ins;                    /* TRUE:挿入,FALSE:上書き */
extern gboolean newfile;                /* TRUE:新規ファイル,FALSE:なし */
extern gboolean second;                 /* TRUE:新規,FALSE:既存 */
extern gchar *history_files[10];        /* ファイルの履歴 */
extern gchar *open_path;                /* 開くのパス */
extern gchar *save_path;                /* 名前を付けて保存のパス */
extern gchar *clipboard_text;           /* クリップボードのテキスト */
extern gchar *arg_text;                 /* プロセス間通信用変数 */
extern gint def_width,def_height;       /* デフォルトのウインドウのサイズ */
extern gint ftnum;                      /* ファイルタイプの数 */
extern gint history;                    /* ファイルの履歴 */
extern gint instance;                   /* プロセス間通信用変数 */
extern gint tcount;                     /* ファイルタイプのカウンタ */
extern guint timer_id;                  /* タイマID */
extern FileType *ftype;                 /* ファイルタイプ */
extern GdkAtom atom_targets;            /* ターゲット */
extern GdkAtom atom_text;               /* テキスト */
extern GdkAtom atom_compound;           /* コンパウンド */
extern GdkAtom atom_utf8;               /* UTF-8 */
extern GdkAtom atom_textmaid0;          /* プロセス間通信用アトム */
extern GdkAtom atom_textmaid1;          /* プロセス間通信用アトム */
extern GtkWidget *window;               /* ウインドウ */
extern GtkWidget *notebook;             /* ノートブック */
extern GtkWidget *status;               /* ステータスウインドウ */
extern GtkWidget *label_cursor;         /* カーソル座標 */
extern GtkPositionType n_pos;           /* ノートブックの位置 */
extern GtkItemFactory *ifactory_menu;   /* メニュー */
extern GtkItemFactory *ifactory_popup;  /* ポップアップ */
extern PangoFontDescription *system_font;
extern GdkColor system_color[12];
extern GtkTargetEntry targets[4];       /* Text maidが提供可能なセレクション */


#endif
/*
表示色
 0,文字
 1,背景
 2,コントロールコード
 3,全角スペース
 4,改行コード
 5,タブ下線
 6,右マージン
 7,グリッド
 8,選択された文字
 9,選択された背景
10,文字(印刷)
11,コントロールコード(印刷)
*/
