/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jp.sourceforge.tmdmaker.editpart.AbstractTMDEditPart;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.command.ModelAddCommand;
import jp.sourceforge.tmdmaker.model.command.ModelConstraintChangeCommand;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class DiagramEditPart
extends AbstractTMDEditPart {
    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_children")) {
            this.refreshChildren();
        }
    }

    protected List<ModelElement> getModelChildren() {
        return ((Diagram)this.getModel()).getChildren();
    }

    @Override
    protected void onDoubleClicked() {
    }

    private class DiagramEditPolicy
    extends XYLayoutEditPolicy {
        private DiagramEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            logger.debug(((Object)((Object)this)).getClass() + "#createChildEditPolicy()");
            return new NonResizableEditPolicy();
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            logger.debug(((Object)((Object)this)).getClass() + "#createChangeConstraintCommand()");
            ModelConstraintChangeCommand command = new ModelConstraintChangeCommand((ModelElement)child.getModel(), (Rectangle)constraint);
            return command;
        }

        protected Command getCreateCommand(CreateRequest request) {
            logger.debug(((Object)((Object)this)).getClass() + "#getCreateCommand()");
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            constraint.width = -1;
            constraint.height = -1;
            Entity entity = (Entity)request.getNewObject();
            entity.setConstraint(constraint);
            return new ModelAddCommand((Diagram)DiagramEditPart.this.getModel(), constraint.x, constraint.y);
        }
    }
}

