/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.figure;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;

public class EntityFigure
extends Figure {
    private Label name = new Label();
    private Label type;
    private EntityTitleCompartmentFigure titleCompartmentFigure;
    private EntityLayoutCompartmentFigure compartmentFigure;
    private CompartmentFigure identifierCompartmentFigure;
    private CompartmentFigure attributeCompartmentFigure;

    public EntityFigure() {
        this(false);
    }

    public EntityFigure(boolean notImplement) {
        this.name.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        this.type = new Label();
        this.titleCompartmentFigure = new EntityTitleCompartmentFigure();
        this.compartmentFigure = new EntityLayoutCompartmentFigure();
        this.identifierCompartmentFigure = new CompartmentFigure();
        this.attributeCompartmentFigure = new CompartmentFigure();
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new EntityFigureBorder(notImplement));
        this.setOpaque(true);
        this.titleCompartmentFigure.setEntityName((Figure)this.name);
        this.titleCompartmentFigure.setEntityType((Figure)this.type);
        this.add((IFigure)this.titleCompartmentFigure);
        this.add((IFigure)this.compartmentFigure);
        this.identifierCompartmentFigure.setBorder((Border)new IdentifierCompartmentFigureBorder());
        this.attributeCompartmentFigure.setBorder((Border)new AttributeCompartmentFigureBorder());
        this.attributeCompartmentFigure.setLayoutManager((LayoutManager)new GridLayout());
        this.compartmentFigure.add((IFigure)this.identifierCompartmentFigure);
        this.compartmentFigure.add((IFigure)this.attributeCompartmentFigure);
    }

    public CompartmentFigure getAttributeCompartmentFigure() {
        return this.attributeCompartmentFigure;
    }

    public void setEntityName(String entityName) {
        this.name.setText(entityName);
    }

    public void setEntityType(String entityType) {
        this.type.setText(entityType);
    }

    private Label createAttributeLabel(String name) {
        Label tmp = new Label(name);
        tmp.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        return tmp;
    }

    public void setIdentifier(String identifier) {
        this.identifierCompartmentFigure.add((IFigure)this.createAttributeLabel(identifier));
    }

    public void addRelationship(String relationship) {
        this.identifierCompartmentFigure.add((IFigure)this.createAttributeLabel(String.valueOf(relationship) + "(R)"));
    }

    public void removeAllRelationship() {
        this.identifierCompartmentFigure.removeAll();
    }

    public void addAttribute(String attribute) {
        this.attributeCompartmentFigure.add((IFigure)this.createAttributeLabel(attribute));
    }

    public void removeAllAttributes() {
        this.attributeCompartmentFigure.removeAll();
    }

    public void setNotImplement(boolean notImplement) {
        this.setBorder((Border)new EntityFigureBorder(notImplement));
    }

    private static class AttributeCompartmentFigureBorder
    extends AbstractBorder {
        private AttributeCompartmentFigureBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0, 1, 0, 1);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.drawLine(AttributeCompartmentFigureBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), tempRect.getBottomLeft());
        }
    }

    private static class CompartmentFigure
    extends Figure {
        public CompartmentFigure() {
            ToolbarLayout layout = new ToolbarLayout();
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(0);
            this.setLayoutManager((LayoutManager)layout);
        }
    }

    private static class EntityFigureBorder
    extends LineBorder {
        private boolean notImplement;

        public EntityFigureBorder(boolean notImplement) {
            this.notImplement = notImplement;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            super.paint(figure, graphics, insets);
            if (this.notImplement) {
                graphics.drawLine(tempRect.getTopLeft(), tempRect.getBottomRight());
                graphics.drawLine(tempRect.getBottomLeft(), tempRect.getTopRight());
            }
        }
    }

    private static class EntityLayoutCompartmentFigure
    extends Figure {
        public EntityLayoutCompartmentFigure() {
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(true);
            layout.setSpacing(0);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new EntityLayoutCompartmentFigureBorder());
        }
    }

    private static class EntityLayoutCompartmentFigureBorder
    extends AbstractBorder {
        private EntityLayoutCompartmentFigureBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0, 1, 0, 1);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.drawLine(EntityLayoutCompartmentFigureBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), tempRect.getTopRight());
        }
    }

    private static class EntityTitleCompartmentFigure
    extends Figure {
        public EntityTitleCompartmentFigure() {
            this.setLayoutManager((LayoutManager)new BorderLayout());
        }

        public void setEntityName(Figure name) {
            this.add((IFigure)name);
            this.getLayoutManager().setConstraint((IFigure)name, (Object)BorderLayout.CENTER);
        }

        public void setEntityType(Figure type) {
            this.add((IFigure)type);
            this.getLayoutManager().setConstraint((IFigure)type, (Object)BorderLayout.RIGHT);
        }
    }

    private static class IdentifierCompartmentFigureBorder
    extends AbstractBorder {
        private IdentifierCompartmentFigureBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0, 1, 0, 1);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.drawLine(IdentifierCompartmentFigureBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopRight(), tempRect.getBottomRight());
        }
    }
}

