/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.Cardinality;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.MultivalueOrEntity;
import jp.sourceforge.tmdmaker.model.TransfarReuseKeysToTargetRelationship;

public class MultivalueOrRelationship
extends TransfarReuseKeysToTargetRelationship {
    private MultivalueOrEntity table;

    public MultivalueOrRelationship(AbstractEntityModel source, String typeName) {
        this.setSource(source);
        MultivalueOrEntity target = new MultivalueOrEntity();
        target.setConstraint(source.getConstraint().getTranslated(50, 0));
        target.setName(String.valueOf(source.getName()) + "." + typeName);
        Attribute attribute = new Attribute();
        attribute.setName(String.valueOf(typeName) + "\u30b3\u30fc\u30c9");
        target.addAttribute(attribute);
        target.setEntityType(source.getEntityType());
        this.setTargetCardinality(Cardinality.MANY);
        this.setTarget(target);
        this.table = target;
    }

    @Override
    public void connect() {
        Diagram diagram = this.getSource().getDiagram();
        diagram.addChild(this.getTarget());
        super.connect();
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.getSource().getDiagram().removeChild(this.table);
    }

    @Override
    public boolean isDeletable() {
        return this.getTarget().isDeletable();
    }
}

