/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.Event2EventRelationship;
import jp.sourceforge.tmdmaker.model.RecursiveRelationship;
import jp.sourceforge.tmdmaker.model.Resource2ResourceRelationship;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.TransfarReuseKeysToTargetRelationship;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipRule {
    private static Logger logger = LoggerFactory.getLogger(RelationshipRule.class);

    public static AbstractRelationship createRelationship(AbstractEntityModel source, AbstractEntityModel target) {
        AbstractRelationship relationship = null;
        if (RelationshipRule.isRecursive(source, target)) {
            logger.debug("Recursive");
            relationship = new RecursiveRelationship(source);
        } else if (RelationshipRule.isR2E(source, target)) {
            logger.debug("RESOURCE:EVENT");
            relationship = new TransfarReuseKeysToTargetRelationship(source, target);
        } else if (RelationshipRule.isR2R(source, target) && !RelationshipRule.isSameOriginal(source, target)) {
            logger.debug("RESOURCE:RESOURCE");
            relationship = new Resource2ResourceRelationship(source, target);
        } else if (RelationshipRule.isE2E(source, target) && !RelationshipRule.isSameOriginal(source, target)) {
            logger.debug("EVENT:EVENT");
            relationship = new Event2EventRelationship(source, target);
        }
        return relationship;
    }

    private static boolean isRecursive(AbstractEntityModel source, AbstractEntityModel target) {
        return source == target;
    }

    private static boolean isR2R(AbstractEntityModel source, AbstractEntityModel target) {
        return EntityTypeRule.isResource(source) && EntityTypeRule.isResource(target);
    }

    private static boolean isSameOriginal(AbstractEntityModel source, AbstractEntityModel target) {
        if (source instanceof SubsetEntity && target instanceof SubsetEntity) {
            SubsetEntity sourceSubset = (SubsetEntity)source;
            SubsetEntity targetSubset = (SubsetEntity)target;
            return sourceSubset.getSuperset().equals(targetSubset.getSuperset());
        }
        return false;
    }

    private static boolean isR2E(AbstractEntityModel source, AbstractEntityModel target) {
        return EntityTypeRule.isEvent(source) && EntityTypeRule.isResource(target) || EntityTypeRule.isResource(source) && EntityTypeRule.isEvent(target);
    }

    private static boolean isE2E(AbstractEntityModel source, AbstractEntityModel target) {
        return EntityTypeRule.isEvent(source) && EntityTypeRule.isEvent(target);
    }
}

