/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.BaseLocale;
import com.ibm.icu.impl.locale.LocaleExtensions;
import com.ibm.icu.impl.locale.LocaleSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class LanguageTag {
    private String _languageTag = "";
    private String _grandfathered = "";
    private String _privateuse = "";
    private String _language = "";
    private String[] _extlang;
    private String _script = "";
    private String _region = "";
    private TreeSet _variants;
    private TreeSet _extensions;
    private static final int MINLEN = 2;
    private static final String SEP = "-";
    private static final char SEPCHAR = '-';
    private static final String PRIVATEUSE = "x";
    public static String UNDETERMINED = "und";
    private static final HashMap GRANDFATHERED = new HashMap();
    private static final String[][] DEPRECATEDLANGS;
    private static final int LANG = 1;
    private static final int EXTL = 2;
    private static final int SCRT = 4;
    private static final int REGN = 8;
    private static final int VART = 16;
    private static final int EXTS = 32;
    private static final int EXTV = 64;
    private static final int PRIV = 128;

    static {
        String[][] entries = new String[][]{{"art-lojban", "jbo"}, {"cel-gaulish", ""}, {"en-GB-oed", ""}, {"i-ami", "ami"}, {"i-bnn", "bnn"}, {"i-default", ""}, {"i-enochian", ""}, {"i-hak", "hak"}, {"i-klingon", "tlh"}, {"i-lux", "lb"}, {"i-mingo", ""}, {"i-navajo", "nv"}, {"i-pwn", "pwn"}, {"i-tao", "tao"}, {"i-tay", "tay"}, {"i-tsu", "tsu"}, {"no-bok", "nb"}, {"no-nyn", "nn"}, {"sgn-BE-FR", "sfb"}, {"sgn-BE-NL", "vgt"}, {"sgn-CH-DE", "sgg"}, {"zh-guoyu", "cmn"}, {"zh-hakka", "hak"}, {"zh-min", ""}, {"zh-min-nan", "nan"}, {"zh-xiang", "hsn"}};
        int i = 0;
        while (i < entries.length) {
            String[] e = entries[i];
            GRANDFATHERED.put(e[0], e[1]);
            ++i;
        }
        DEPRECATEDLANGS = new String[][]{{"iw", "he"}, {"ji", "yi"}, {"in", "id"}};
    }

    private LanguageTag(String tag) {
        this._languageTag = tag;
    }

    public static LanguageTag parse(String langtag) throws LocaleSyntaxException {
        Extension e;
        if (langtag.length() < 2) {
            throw new LocaleSyntaxException("The specified tag '" + langtag + "' is too short");
        }
        if (langtag.endsWith(SEP)) {
            int erridx = langtag.length() - 1;
            while (erridx - 1 >= 0 && langtag.charAt(erridx - 1) != '-') {
                --erridx;
            }
            throw new LocaleSyntaxException("The specified tag '" + langtag + "' ends with " + SEP, erridx);
        }
        String tag = AsciiUtil.toLowerString(langtag);
        LanguageTag t = new LanguageTag(tag);
        if (GRANDFATHERED.containsKey(tag)) {
            t._grandfathered = tag;
            String preferred = (String)GRANDFATHERED.get(tag);
            if (preferred.length() > 0) {
                t._language = preferred;
            }
            return t;
        }
        String[] subtags = Utility.split(tag, '-');
        int idx = 0;
        int extlangIdx = 0;
        String extSingleton = null;
        StringBuffer extBuf = null;
        int next = 129;
        String errorMsg = null;
        block1: while (idx < subtags.length) {
            if ((next & 1) != 0 && LanguageTag.isLanguageSubtag(subtags[idx])) {
                t._language = subtags[idx++];
                next = 190;
                continue;
            }
            if ((next & 2) != 0 && LanguageTag.isExtlangSubtag(subtags[idx])) {
                if (extlangIdx == 0) {
                    t._extlang = new String[3];
                }
                t._extlang[extlangIdx++] = subtags[idx++];
                if (extlangIdx < 3) {
                    next = 190;
                    continue;
                }
                next = 188;
                continue;
            }
            if ((next & 4) != 0 && LanguageTag.isScriptSubtag(subtags[idx])) {
                t._script = subtags[idx++];
                next = 184;
                continue;
            }
            if ((next & 8) != 0 && LanguageTag.isRegionSubtag(subtags[idx])) {
                t._region = subtags[idx++];
                next = 176;
                continue;
            }
            if ((next & 0x10) != 0 && LanguageTag.isVariantSubtag(subtags[idx])) {
                if (t._variants == null) {
                    t._variants = new TreeSet();
                }
                t._variants.add(subtags[idx++]);
                next = 176;
                continue;
            }
            if ((next & 0x20) != 0 && LanguageTag.isExtensionSingleton(subtags[idx])) {
                if (extSingleton != null) {
                    if (extBuf == null) {
                        errorMsg = "The specified tag '" + tag + "' contains an incomplete extension: " + extSingleton;
                        break;
                    }
                    if (t._extensions == null) {
                        t._extensions = new TreeSet();
                    }
                    e = new Extension(extSingleton.charAt(0), extBuf.toString());
                    t._extensions.add(e);
                }
                extSingleton = subtags[idx++];
                extBuf = null;
                next = 64;
                continue;
            }
            if ((next & 0x40) != 0 && LanguageTag.isExtensionSubtag(subtags[idx])) {
                if (extBuf == null) {
                    extBuf = new StringBuffer(subtags[idx++]);
                } else {
                    extBuf.append(SEP);
                    extBuf.append(subtags[idx++]);
                }
                next = 224;
                continue;
            }
            if ((next & 0x80) != 0 && AsciiUtil.caseIgnoreMatch(PRIVATEUSE, subtags[idx])) {
                StringBuffer puBuf = new StringBuffer();
                ++idx;
                boolean bFirst = true;
                while (idx < subtags.length) {
                    if (!LanguageTag.isPrivateuseValueSubtag(subtags[idx])) {
                        errorMsg = "The specified tag '" + langtag + "' contains an illegal private use subtag: " + (subtags[idx].length() == 0 ? "<empty>" : subtags[idx]);
                        break block1;
                    }
                    if (bFirst) {
                        bFirst = false;
                    } else {
                        puBuf.append(SEP);
                    }
                    puBuf.append(subtags[idx]);
                    ++idx;
                }
                t._privateuse = puBuf.toString();
                if (t._privateuse.length() != 0) break;
                errorMsg = "The specified tag '" + langtag + "' contains an empty private use subtag";
                --idx;
                break;
            }
            errorMsg = "The specified tag '" + langtag + "' contains an illegal subtag: " + (subtags[idx].length() == 0 ? "<empty>" : subtags[idx]);
            break;
        }
        if (errorMsg == null && extSingleton != null) {
            if (extBuf == null) {
                errorMsg = "The specified tag '" + langtag + "' contains an incomplete extension: " + extSingleton;
            } else {
                if (t._extensions == null) {
                    t._extensions = new TreeSet();
                }
                e = new Extension(extSingleton.charAt(0), extBuf.toString());
                t._extensions.add(e);
            }
        }
        if (errorMsg != null) {
            int errIndex = 0;
            int i = 0;
            while (i < idx) {
                errIndex += subtags[i].length() + 1;
                ++i;
            }
            throw new LocaleSyntaxException(errorMsg, errIndex);
        }
        return t;
    }

    public String getTag() {
        return this._languageTag;
    }

    public String getLanguage() {
        return this._language;
    }

    public String getJDKLanguage() {
        String lang = this._language;
        int i = 0;
        while (i < DEPRECATEDLANGS.length) {
            String[] langMap = DEPRECATEDLANGS[i];
            if (AsciiUtil.caseIgnoreCompare(lang, langMap[1]) == 0) {
                lang = langMap[0];
                break;
            }
            ++i;
        }
        return lang;
    }

    public String getExtlang(int idx) {
        if (this._extlang != null && idx < this._extlang.length) {
            return this._extlang[idx];
        }
        return null;
    }

    public String getScript() {
        return this._script;
    }

    public String getRegion() {
        return this._region;
    }

    public String getVariant() {
        if (this._variants != null) {
            StringBuffer buf = new StringBuffer();
            Iterator itr = this._variants.iterator();
            while (itr.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(SEP);
                }
                buf.append(itr.next());
            }
            return buf.toString();
        }
        return "";
    }

    public Set getVarinats() {
        return Collections.unmodifiableSet(this._variants);
    }

    public Set getExtensions() {
        if (this._extensions != null) {
            return Collections.unmodifiableSet(this._extensions);
        }
        return null;
    }

    public String getPrivateUse() {
        return this._privateuse;
    }

    public String getGrandfathered() {
        return this._grandfathered;
    }

    public static boolean isLanguageSubtag(String s) {
        return s.length() >= 2 && s.length() <= 8 && AsciiUtil.isAlphaString(s);
    }

    public static boolean isExtlangSubtag(String s) {
        return s.length() == 3 && AsciiUtil.isAlphaString(s);
    }

    public static boolean isScriptSubtag(String s) {
        return s.length() == 4 && AsciiUtil.isAlphaString(s);
    }

    public static boolean isRegionSubtag(String s) {
        return s.length() == 2 && AsciiUtil.isAlphaString(s) || s.length() == 3 && AsciiUtil.isNumericString(s);
    }

    public static boolean isVariantSubtag(String s) {
        int len = s.length();
        if (len >= 5 && len <= 8) {
            return AsciiUtil.isAlphaNumericString(s);
        }
        if (len == 4) {
            return AsciiUtil.isNumeric(s.charAt(0)) && AsciiUtil.isAlphaNumeric(s.charAt(1)) && AsciiUtil.isAlphaNumeric(s.charAt(2)) && AsciiUtil.isAlphaNumeric(s.charAt(3));
        }
        return false;
    }

    public static boolean isExtensionSingleton(String s) {
        return s.length() == 1 && AsciiUtil.isAlphaString(s) && !AsciiUtil.caseIgnoreMatch(PRIVATEUSE, s);
    }

    public static boolean isExtensionSubtag(String s) {
        return s.length() >= 2 && s.length() <= 8 && AsciiUtil.isAlphaNumericString(s);
    }

    public static boolean isPrivateuseValueSubtag(String s) {
        return s.length() >= 1 && s.length() <= 8 && AsciiUtil.isAlphaNumericString(s);
    }

    public static String toLanguageTag(BaseLocale base, LocaleExtensions ext) {
        String exttags;
        String variant;
        String region;
        StringBuffer buf = new StringBuffer();
        String language = base.getLanguage();
        if (language.length() == 0) {
            buf.append(UNDETERMINED);
        } else if (LanguageTag.isLanguageSubtag(language)) {
            int i = 0;
            while (i < DEPRECATEDLANGS.length) {
                String[] langMap = DEPRECATEDLANGS[i];
                if (AsciiUtil.caseIgnoreCompare(language, langMap[0]) == 0) {
                    language = langMap[1];
                    break;
                }
                ++i;
            }
            buf.append(language);
        } else {
            buf.append(UNDETERMINED);
        }
        String script = base.getScript();
        if (script.length() > 0 && LanguageTag.isScriptSubtag(script)) {
            buf.append(SEP);
            buf.append(AsciiUtil.toLowerString(script));
        }
        if ((region = base.getRegion()).length() > 0 && LanguageTag.isRegionSubtag(region)) {
            buf.append(SEP);
            buf.append(AsciiUtil.toLowerString(region));
        }
        if ((variant = base.getVariant()).length() > 0) {
            String[] variants = Utility.split(variant, '_');
            TreeSet<String> validVars = new TreeSet<String>();
            int i = 0;
            while (i < variants.length) {
                String var = variants[i];
                if (LanguageTag.isVariantSubtag(var)) {
                    validVars.add(AsciiUtil.toLowerString(var));
                }
                ++i;
            }
            if (validVars.size() > 0) {
                Iterator varIt = validVars.iterator();
                while (varIt.hasNext()) {
                    buf.append(SEP);
                    buf.append(varIt.next());
                }
            }
        }
        if (ext != null && !ext.equals(LocaleExtensions.EMPTY_EXTENSIONS) && (exttags = ext.getCanonicalString()).length() > 0) {
            buf.append(SEP);
            buf.append(exttags);
        }
        return buf.toString();
    }

    public static class Extension
    implements Comparable {
        private char _singleton;
        private String _value;

        public Extension(char singleton, String value) {
            this._singleton = AsciiUtil.toLower(singleton);
            this._value = value;
        }

        public char getSingleton() {
            return this._singleton;
        }

        public String getValue() {
            return this._value;
        }

        public int compareTo(Extension other) {
            return this._singleton - other._singleton;
        }

        public int compareTo(Object obj) {
            return this.compareTo((Extension)obj);
        }
    }
}

