/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.model.EditImplementAttribute;
import jp.sourceforge.tmdmaker.dialog.model.EditSarogateKey;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.KeyModels;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.SarogateKey;
import jp.sourceforge.tmdmaker.model.SarogateKeyRef;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.model.util.ModelEditUtils;

public class EditImplementEntity {
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_ATTRIBUTES = "attributes";
    public static final String PROPERTY_SAROGATE = "sarogate";
    public static final String PROPERTY_KEYMODELS = "keymodels";
    private EditSarogateKey sarogateKey;
    private List<EditImplementAttribute> attributes = new ArrayList<EditImplementAttribute>();
    private KeyModels keyModels = new KeyModels();
    private Map<AbstractEntityModel, List<EditImplementAttribute>> otherModelAttributesMap = new HashMap<AbstractEntityModel, List<EditImplementAttribute>>();
    private String implementName;

    public EditImplementEntity(AbstractEntityModel model) {
        List<Object> list;
        Object reused;
        this.implementName = ModelEditUtils.toBlankStringIfNull(model.getImplementName());
        KeyModels originalKeyModels = model.getKeyModels();
        if (originalKeyModels != null) {
            originalKeyModels.copyTo(this.keyModels);
            SarogateKey key = originalKeyModels.getSarogateKey();
            this.sarogateKey = new EditSarogateKey(model, key);
            if (this.sarogateKey.isEnabled()) {
                this.attributes.add(this.sarogateKey);
            }
        }
        if (model instanceof Entity) {
            this.attributes.add(new EditImplementAttribute(model, ((Entity)model).getIdentifier()));
        }
        if (model instanceof Detail) {
            this.attributes.add(new EditImplementAttribute(model, ((Detail)model).getDetailIdentifier()));
        }
        if (model instanceof SubsetEntity) {
            reused = ((SubsetEntity)model).getOriginalReusedIdentifier();
            for (IdentifierRef identifierRef : ((ReusedIdentifier)reused).getIdentifires()) {
                this.attributes.add(new EditImplementAttribute(model, identifierRef));
            }
        }
        reused = model.getReusedIdentifieres();
        for (Map.Entry entry : reused.entrySet()) {
            ReusedIdentifier ri = (ReusedIdentifier)entry.getValue();
            if (ri.isSarogateKeyEnabled()) {
                System.out.println("ri.isSarogateKeyEnabled()");
                for (SarogateKeyRef s : ri.getSarogateKeys()) {
                    this.attributes.add(new EditImplementAttribute(model, s));
                }
                continue;
            }
            System.out.println("not ri.isSarogateKeyEnabled()");
            for (IdentifierRef ref : ri.getIdentifires()) {
                this.attributes.add(new EditImplementAttribute(model, ref));
            }
        }
        for (IAttribute iAttribute : model.getAttributes()) {
            this.attributes.add(new EditImplementAttribute(model, iAttribute));
        }
        for (AbstractEntityModel abstractEntityModel : ImplementRule.findNotImplementModel(model)) {
            list = new ArrayList();
            for (IAttribute a : abstractEntityModel.getAttributes()) {
                list.add(new EditImplementAttribute(abstractEntityModel, a));
            }
            this.otherModelAttributesMap.put(abstractEntityModel, list);
        }
        if (model.getImplementDerivationModels() != null) {
            for (AbstractEntityModel abstractEntityModel : model.getImplementDerivationModels()) {
                list = this.otherModelAttributesMap.get(abstractEntityModel);
                if (list == null) continue;
                this.attributes.addAll(list);
            }
        }
        this.updateEditImplementAttributes();
    }

    public void setSarogateKeyEnabled(boolean enabled) {
        this.sarogateKey.setEnabled(enabled);
        if (enabled) {
            this.addAttribute(0, this.sarogateKey);
        } else {
            this.removeAttribute(this.sarogateKey);
        }
        this.firePropertyChange(PROPERTY_ATTRIBUTES, null, this.sarogateKey);
    }

    public boolean isSarogateKeyEnabled() {
        return this.sarogateKey.isEnabled();
    }

    public String getSarogateKeyName() {
        return this.sarogateKey.getName();
    }

    public void setSarogateKeyName(String name) {
        this.sarogateKey.setName(name);
        this.firePropertyChange(PROPERTY_SAROGATE, null, this.sarogateKey);
    }

    public EditSarogateKey getSarogateKey() {
        return this.sarogateKey;
    }

    public void addAttribute(EditImplementAttribute attribute) {
        this.attributes.add(attribute);
        for (KeyModel ek : this.keyModels) {
            attribute.addKeyModel(ek);
        }
        this.firePropertyChange(PROPERTY_ATTRIBUTES, null, attribute);
    }

    public void addAttribute(int index, EditImplementAttribute attribute) {
        this.attributes.add(index, attribute);
        for (KeyModel ek : this.keyModels) {
            attribute.addKeyModel(ek);
        }
        this.firePropertyChange(PROPERTY_ATTRIBUTES, null, attribute);
    }

    public EditImplementAttribute removeAttribute(EditImplementAttribute attribute) {
        int index = this.attributes.indexOf(attribute);
        if (index >= 0) {
            EditImplementAttribute removed = this.attributes.remove(index);
            ArrayList<KeyModel> toBeRemoved = new ArrayList<KeyModel>();
            for (KeyModel ek : this.keyModels) {
                ek.getAttributes().remove(removed.getOriginalAttribute());
                if (ek.getAttributes().size() != 0) continue;
                toBeRemoved.add(ek);
            }
            for (KeyModel ek : toBeRemoved) {
                this.keyModels.remove(ek);
                for (EditImplementAttribute a : this.attributes) {
                    a.removeKeyModel(ek);
                }
            }
            return removed;
        }
        return null;
    }

    public KeyModel getKeyModel(int index) {
        if (index <= this.keyModels.size() && index >= 0) {
            return this.keyModels.get(index);
        }
        return null;
    }

    public void addKeyModel(KeyModel keyModel) {
        this.keyModels.add(keyModel);
        this.updateEditImplementAttributes();
        this.firePropertyChange(PROPERTY_KEYMODELS, null, keyModel);
    }

    public void replaceKeyModel(int index, KeyModel keyModel) {
        this.keyModels.replaceKeyModel(index, keyModel);
        this.updateEditImplementAttributes();
        this.firePropertyChange(PROPERTY_KEYMODELS, null, keyModel);
    }

    public void removeKeyModel(int index) {
        this.keyModels.remove(index);
        this.updateEditImplementAttributes();
        this.firePropertyChange(PROPERTY_KEYMODELS, null, null);
    }

    private void updateEditImplementAttributes() {
        for (EditImplementAttribute ea : this.attributes) {
            ea.removeAllKeyModel();
            for (KeyModel ek : this.keyModels) {
                ea.addKeyModel(ek);
            }
        }
    }

    public List<EditImplementAttribute> getAttributes() {
        return this.attributes;
    }

    public KeyModels getKeyModels() {
        return this.keyModels;
    }

    public Map<AbstractEntityModel, List<EditImplementAttribute>> getOtherModelAttributesMap() {
        return this.otherModelAttributesMap;
    }

    public String getImplementName() {
        return this.implementName;
    }

    public void setImplementName(String implementName) {
        this.implementName = implementName;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }
}

